/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui;

import com.choculaterie.gui.LitematicDownloaderScreen;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class NavigationState {
    private static NavigationState instance = new NavigationState();
    private int savedCurrentPage = 1;
    private int savedTotalPages = 1;
    private int savedTotalItems = 0;
    private boolean savedIsSearchMode = false;
    private String savedSearchTerm = "";
    private String savedLastSearchedTerm = "";
    private int savedScrollOffset = 0;

    private NavigationState() {
    }

    public static NavigationState getInstance() {
        return instance;
    }

    public void saveState(int currentPage, int totalPages, int totalItems, boolean isSearchMode, String searchTerm, String lastSearchedTerm, int scrollOffset) {
        this.savedCurrentPage = currentPage;
        this.savedTotalPages = totalPages;
        this.savedTotalItems = totalItems;
        this.savedIsSearchMode = isSearchMode;
        this.savedSearchTerm = searchTerm != null ? searchTerm : "";
        this.savedLastSearchedTerm = lastSearchedTerm != null ? lastSearchedTerm : "";
        this.savedScrollOffset = scrollOffset;
        System.out.println("Navigation state saved: page=" + currentPage + ", scroll=" + scrollOffset + ", searchMode=" + isSearchMode + ", searchTerm='" + searchTerm + "'");
    }

    public void restoreState(LitematicDownloaderScreen screen) {
        screen.restoreNavigationState(this.savedCurrentPage, this.savedTotalPages, this.savedTotalItems, this.savedIsSearchMode, this.savedSearchTerm, this.savedLastSearchedTerm, this.savedScrollOffset);
        System.out.println("Navigation state restored: page=" + this.savedCurrentPage + ", scroll=" + this.savedScrollOffset + ", searchMode=" + this.savedIsSearchMode + ", searchTerm='" + this.savedSearchTerm + "'");
    }

    public int getSavedCurrentPage() {
        return this.savedCurrentPage;
    }

    public int getSavedScrollOffset() {
        return this.savedScrollOffset;
    }

    public boolean isSavedSearchMode() {
        return this.savedIsSearchMode;
    }

    public String getSavedSearchTerm() {
        return this.savedSearchTerm;
    }
}

