/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class SettingsManager {
    private static final String SETTINGS_FILE = "config/litematic-downloader-settings.json";
    private static Settings settings;
    private static final Gson gson;

    public static Settings getSettings() {
        if (settings == null) {
            SettingsManager.loadSettings();
        }
        return settings;
    }

    public static void loadSettings() {
        block9: {
            try {
                File settingsFile;
                File configDir = new File(class_310.method_1551().field_1697, "config");
                if (!configDir.exists()) {
                    configDir.mkdirs();
                }
                if (!(settingsFile = new File(class_310.method_1551().field_1697, SETTINGS_FILE)).exists()) break block9;
                try (FileReader reader = new FileReader(settingsFile);){
                    settings = (Settings)gson.fromJson((Reader)reader, Settings.class);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (settings == null) {
            settings = new Settings();
        }
    }

    public static void saveSettings() {
        try {
            File configDir = new File(class_310.method_1551().field_1697, "config");
            if (!configDir.exists()) {
                configDir.mkdirs();
            }
            File settingsFile = new File(class_310.method_1551().field_1697, SETTINGS_FILE);
            try (FileWriter writer = new FileWriter(settingsFile);){
                gson.toJson((Object)settings, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getSchematicsPath() {
        Settings settings = SettingsManager.getSettings();
        if (settings.useCustomPath && !settings.customSchematicsPath.isEmpty()) {
            return settings.customSchematicsPath;
        }
        return SettingsManager.getDefaultSchematicsPath();
    }

    public static String getDefaultSchematicsPath() {
        try {
            File gameDir = class_310.method_1551().field_1697;
            if (gameDir != null) {
                return new File(gameDir, "schematics").getAbsolutePath();
            }
            boolean isDevelopment = System.getProperty("dev.env", "false").equals("true");
            String homeDir = System.getProperty("user.home");
            if (isDevelopment) {
                return homeDir + File.separator + "Downloads" + File.separator + "litematic-downloader-template-1.21.4" + File.separator + "run" + File.separator + "schematics";
            }
            return homeDir + File.separator + "AppData" + File.separator + "Roaming" + File.separator + ".minecraft" + File.separator + "schematics";
        }
        catch (Exception e) {
            e.printStackTrace();
            return System.getProperty("user.home") + File.separator + "schematics";
        }
    }

    public static void setCustomPath(String path, boolean useCustom) {
        Settings settings = SettingsManager.getSettings();
        settings.customSchematicsPath = path;
        settings.useCustomPath = useCustom;
        SettingsManager.saveSettings();
    }

    static {
        gson = new GsonBuilder().setPrettyPrinting().create();
    }

    @Environment(value=EnvType.CLIENT)
    public static class Settings {
        public String customSchematicsPath = "";
        public boolean useCustomPath = false;
    }
}

