/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui;

import com.choculaterie.config.SettingsManager;
import com.choculaterie.gui.ToastManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class SettingsScreen
extends class_437 {
    private final class_437 parentScreen;
    private final Consumer<Boolean> onSettingsChanged;
    private class_342 pathField;
    private class_4185 toggleButton;
    private class_4185 browseButton;
    private class_4185 resetButton;
    private SettingsManager.Settings settings;

    public SettingsScreen(class_437 parentScreen, Consumer<Boolean> onSettingsChanged) {
        super((class_2561)class_2561.method_43470((String)"Settings"));
        this.parentScreen = parentScreen;
        this.onSettingsChanged = onSettingsChanged;
        this.settings = SettingsManager.getSettings();
    }

    protected void method_25426() {
        int centerX = this.field_22789 / 2;
        int startY = 60;
        this.pathField = new class_342(this.field_22793, centerX - 200, startY, 400, 20, (class_2561)class_2561.method_43470((String)""));
        this.pathField.method_1880(500);
        this.pathField.method_1852(this.settings.useCustomPath ? this.settings.customSchematicsPath : SettingsManager.getDefaultSchematicsPath());
        this.pathField.method_1888(this.settings.useCustomPath);
        this.method_25429((class_364)this.pathField);
        this.toggleButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.settings.useCustomPath ? "Use Custom Path" : "Use Default Path")), button -> {
            this.settings.useCustomPath = !this.settings.useCustomPath;
            button.method_25355((class_2561)class_2561.method_43470((String)(this.settings.useCustomPath ? "Use Custom Path" : "Use Default Path")));
            this.pathField.method_1888(this.settings.useCustomPath);
            if (!this.settings.useCustomPath) {
                this.pathField.method_1852(SettingsManager.getDefaultSchematicsPath());
            }
            this.updateButtonStates();
        }).method_46434(centerX - 100, startY + 35, 200, 20).method_46431();
        this.method_37063((class_364)this.toggleButton);
        this.browseButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Browse..."), button -> this.openFolderDialog()).method_46434(centerX - 100, startY + 70, 95, 20).method_46431();
        this.method_37063((class_364)this.browseButton);
        this.resetButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reset"), button -> {
            this.settings.useCustomPath = false;
            this.pathField.method_1852(SettingsManager.getDefaultSchematicsPath());
            this.pathField.method_1888(false);
            this.toggleButton.method_25355((class_2561)class_2561.method_43470((String)"Use Default Path"));
            this.updateButtonStates();
        }).method_46434(centerX + 5, startY + 70, 95, 20).method_46431();
        this.method_37063((class_364)this.resetButton);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save"), button -> {
            String path = this.pathField.method_1882().trim();
            if (this.settings.useCustomPath) {
                if (path.isEmpty()) {
                    return;
                }
                File pathFile = new File(path);
                if (!pathFile.exists()) {
                    pathFile.mkdirs();
                }
                if (!pathFile.isDirectory()) {
                    return;
                }
                this.settings.customSchematicsPath = path;
            }
            SettingsManager.saveSettings();
            this.onSettingsChanged.accept(true);
            class_310.method_1551().method_1507(this.parentScreen);
        }).method_46434(centerX - 100, startY + 105, 95, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), button -> class_310.method_1551().method_1507(this.parentScreen)).method_46434(centerX + 5, startY + 105, 95, 20).method_46431());
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        this.browseButton.field_22763 = this.settings.useCustomPath;
        this.resetButton.field_22763 = this.settings.useCustomPath;
    }

    private void openFolderDialog() {
        try {
            if (this.tryNativeFileChooser()) {
                return;
            }
            ToastManager.addToast("Cannot open file browser in this environment. Please type the path manually.", true);
        }
        catch (Exception e) {
            e.printStackTrace();
            ToastManager.addToast("Failed to open file browser: " + e.getMessage(), true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean tryNativeFileChooser() {
        try {
            boolean bl;
            String os = System.getProperty("os.name").toLowerCase();
            String currentPath = this.pathField.method_1882().trim();
            if (currentPath.isEmpty()) {
                File gameDir = class_310.method_1551().field_1697;
                currentPath = gameDir != null ? gameDir.getAbsolutePath() : SettingsManager.getDefaultSchematicsPath();
            }
            ProcessBuilder pb = null;
            Process process = null;
            if (os.contains("win")) {
                script = String.format("Add-Type -AssemblyName System.Windows.Forms; $f = New-Object System.Windows.Forms.FolderBrowserDialog; $f.Description = 'Select Schematics Folder'; $f.SelectedPath = '%s'; $f.ShowNewFolderButton = $true; if ($f.ShowDialog() -eq 'OK') { Write-Output $f.SelectedPath }", currentPath.replace("'", "''"));
                pb = new ProcessBuilder("powershell.exe", "-Command", script);
            } else if (os.contains("mac") || os.contains("darwin")) {
                script = String.format("choose folder with prompt \"Select Schematics Folder\" default location POSIX file \"%s\"", currentPath.replace("\"", "\\\""));
                pb = new ProcessBuilder("osascript", "-e", script);
            } else {
                String tool;
                String[] tools;
                if (!os.contains("nix")) {
                    if (!os.contains("nux")) return false;
                }
                String[] stringArray = tools = new String[]{"zenity", "kdialog", "yad"};
                boolean bl2 = stringArray.length;
                for (bl = false; !(bl >= bl2 || this.isCommandAvailable(tool = stringArray[bl]) && (pb = this.createLinuxDialog(tool, currentPath)) != null); bl += 1) {
                }
                if (pb == null) {
                    return false;
                }
            }
            if (pb == null) {
                return false;
            }
            process = pb.start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String selectedPath = reader.readLine();
                int exitCode = process.waitFor();
                if (exitCode != 0) return false;
                if (selectedPath == null) return false;
                if (selectedPath.trim().isEmpty()) return false;
                if (os.contains("mac") && selectedPath.startsWith("alias ")) {
                    selectedPath = selectedPath.substring(6);
                }
                this.pathField.method_1852(selectedPath.trim());
                bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private ProcessBuilder createLinuxDialog(String tool, String currentPath) {
        switch (tool) {
            case "zenity": {
                return new ProcessBuilder("zenity", "--file-selection", "--directory", "--title=Select Schematics Folder", "--filename=" + currentPath);
            }
            case "kdialog": {
                return new ProcessBuilder("kdialog", "--getexistingdirectory", currentPath, "--title", "Select Schematics Folder");
            }
            case "yad": {
                return new ProcessBuilder("yad", "--file", "--directory", "--title=Select Schematics Folder", "--filename=" + currentPath);
            }
        }
        return null;
    }

    private boolean isCommandAvailable(String command) {
        try {
            ProcessBuilder pb = new ProcessBuilder("which", command);
            Process process = pb.start();
            return process.waitFor() == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isAnyLinuxDialogAvailable() {
        return this.isCommandAvailable("zenity") || this.isCommandAvailable("kdialog") || this.isCommandAvailable("yad");
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 20, -1);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"Schematics Path:"), this.field_22789 / 2 - 200, 48, -1);
        this.pathField.method_25394(context, mouseX, mouseY, delta);
    }
}

