/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.networking;

import com.choculaterie.config.SettingsManager;
import com.choculaterie.models.SchematicDetailInfo;
import com.choculaterie.models.SchematicInfo;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class LitematicHttpClient {
    private static final String BASE_URL = "https://choculaterie.com/api/LitematicDownloaderModAPI";
    private static final Gson gson = new Gson();
    private static final HttpClient client;

    public static PaginatedResult fetchSchematicsPaginated(int page, int pageSize) {
        try {
            JsonObject jsonResponse;
            String url = "https://choculaterie.com/api/LitematicDownloaderModAPI/GetPaginated?page=" + page + "&pageSize=" + pageSize;
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).GET().build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            System.out.println("Pagination API Response Status: " + response.statusCode());
            System.out.println("Pagination API Response Body: " + response.body());
            if (response.statusCode() != 200) {
                throw new RuntimeException("Failed to fetch schematics: " + response.statusCode());
            }
            if (response.body() == null || response.body().trim().isEmpty()) {
                System.out.println("Empty response body");
                return new PaginatedResult(new ArrayList<SchematicInfo>(), 0, 0, 0);
            }
            try {
                jsonResponse = (JsonObject)gson.fromJson(response.body(), JsonObject.class);
            }
            catch (Exception e) {
                System.err.println("Failed to parse JSON response as object: " + e.getMessage());
                System.err.println("Response body: " + response.body());
                return new PaginatedResult(new ArrayList<SchematicInfo>(), 0, 0, 0);
            }
            if (jsonResponse == null) {
                System.err.println("JsonObject is null");
                return new PaginatedResult(new ArrayList<SchematicInfo>(), 0, 0, 0);
            }
            JsonArray schematicsArray = null;
            if (jsonResponse.has("schematics")) {
                schematicsArray = jsonResponse.getAsJsonArray("schematics");
            }
            if (schematicsArray == null) {
                System.err.println("Schematics array is null or missing");
                return new PaginatedResult(new ArrayList<SchematicInfo>(), 0, 0, 0);
            }
            ArrayList<SchematicInfo> schematics = new ArrayList<SchematicInfo>();
            for (int i = 0; i < schematicsArray.size(); ++i) {
                try {
                    JsonObject json = schematicsArray.get(i).getAsJsonObject();
                    SchematicInfo schematic = new SchematicInfo(json.has("id") ? json.get("id").getAsString() : "", json.has("name") ? json.get("name").getAsString() : "Unknown", json.has("description") && !json.get("description").isJsonNull() ? json.get("description").getAsString() : "", json.has("viewCount") ? json.get("viewCount").getAsInt() : 0, json.has("downloadCount") ? json.get("downloadCount").getAsInt() : 0, json.has("username") ? json.get("username").getAsString() : "Unknown");
                    schematics.add(schematic);
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Error parsing schematic item " + i + ": " + e.getMessage());
                }
            }
            int totalPages = jsonResponse.has("totalPages") ? jsonResponse.get("totalPages").getAsInt() : 1;
            int currentPage = jsonResponse.has("currentPage") ? jsonResponse.get("currentPage").getAsInt() : 1;
            int totalCount = jsonResponse.has("totalCount") ? jsonResponse.get("totalCount").getAsInt() : schematics.size();
            return new PaginatedResult(schematics, totalPages, currentPage, totalCount);
        }
        catch (Exception e) {
            System.err.println("Error in fetchSchematicsPaginated: " + e.getMessage());
            e.printStackTrace();
            return new PaginatedResult(new ArrayList<SchematicInfo>(), 0, 0, 0);
        }
    }

    public static List<SchematicInfo> searchSchematics(String query) {
        String encodedQuery = URLEncoder.encode(query, StandardCharsets.UTF_8);
        String url = "https://choculaterie.com/api/LitematicDownloaderModAPI/Search?query=" + encodedQuery;
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).GET().build();
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
        System.out.println("Search API Response Status: " + response.statusCode());
        System.out.println("Search API Response Body: " + response.body());
        if (response.statusCode() != 200) {
            throw new RuntimeException("Failed to search schematics: " + response.statusCode());
        }
        if (response.body() == null || response.body().trim().isEmpty()) {
            System.out.println("Empty search response body");
            return new ArrayList<SchematicInfo>();
        }
        try {
            JsonObject jsonResponse = (JsonObject)gson.fromJson(response.body(), JsonObject.class);
            if (jsonResponse != null && jsonResponse.has("schematics")) {
                JsonArray schematicsArray = jsonResponse.getAsJsonArray("schematics");
                ArrayList<SchematicInfo> schematics = new ArrayList<SchematicInfo>();
                for (int i = 0; i < schematicsArray.size(); ++i) {
                    try {
                        JsonObject json = schematicsArray.get(i).getAsJsonObject();
                        SchematicInfo schematic = new SchematicInfo(json.has("id") ? json.get("id").getAsString() : "", json.has("name") ? json.get("name").getAsString() : "Unknown", json.has("description") && !json.get("description").isJsonNull() ? json.get("description").getAsString() : "", json.has("viewCount") ? json.get("viewCount").getAsInt() : 0, json.has("downloadCount") ? json.get("downloadCount").getAsInt() : 0, json.has("username") ? json.get("username").getAsString() : "Unknown");
                        schematics.add(schematic);
                        continue;
                    }
                    catch (Exception e) {
                        System.err.println("Error parsing search result item " + i + ": " + e.getMessage());
                    }
                }
                return schematics;
            }
        }
        catch (Exception e) {
            System.err.println("Failed to parse as paginated object, trying direct array: " + e.getMessage());
        }
        try {
            JsonArray jsonArray = (JsonArray)gson.fromJson(response.body(), JsonArray.class);
            if (jsonArray == null) {
                System.err.println("Search JsonArray is null");
                return new ArrayList<SchematicInfo>();
            }
            ArrayList<SchematicInfo> schematics = new ArrayList<SchematicInfo>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                try {
                    JsonObject json = jsonArray.get(i).getAsJsonObject();
                    SchematicInfo schematic = new SchematicInfo(json.has("id") ? json.get("id").getAsString() : "", json.has("name") ? json.get("name").getAsString() : "Unknown", json.has("description") && !json.get("description").isJsonNull() ? json.get("description").getAsString() : "", json.has("viewCount") ? json.get("viewCount").getAsInt() : 0, json.has("downloadCount") ? json.get("downloadCount").getAsInt() : 0, json.has("username") ? json.get("username").getAsString() : "Unknown");
                    schematics.add(schematic);
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Error parsing search result item " + i + ": " + e.getMessage());
                }
            }
            return schematics;
        }
        catch (Exception e) {
            try {
                System.err.println("Failed to parse search response as array: " + e.getMessage());
                return new ArrayList<SchematicInfo>();
            }
            catch (Exception e2) {
                System.err.println("Error in searchSchematics: " + e2.getMessage());
                e2.printStackTrace();
                return new ArrayList<SchematicInfo>();
            }
        }
    }

    @Deprecated
    public static List<SchematicInfo> fetchSchematicList() {
        PaginatedResult result = LitematicHttpClient.fetchSchematicsPaginated(1, 50);
        return result.getItems();
    }

    public static SchematicDetailInfo fetchSchematicDetail(String id) {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://choculaterie.com/api/LitematicDownloaderModAPI/Getbyid/" + id)).GET().build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new RuntimeException("Failed to fetch schematic details: " + response.statusCode());
            }
            JsonObject json = (JsonObject)gson.fromJson(response.body(), JsonObject.class);
            return new SchematicDetailInfo(json.get("id").getAsString(), json.get("name").getAsString(), json.has("description") && !json.get("description").isJsonNull() ? json.get("description").getAsString() : "", json.get("viewCount").getAsInt(), json.get("downloadCount").getAsInt(), json.has("coverPicture") && !json.get("coverPicture").isJsonNull() ? json.get("coverPicture").getAsString() : "", json.get("username").getAsString(), json.get("publishDate").getAsString());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to fetch schematic detail", e);
        }
    }

    public static String downloadSchematic(String base64Data, String fileName) {
        try {
            String savePath = SettingsManager.getSchematicsPath() + File.separator;
            File directory = new File(savePath);
            if (!directory.exists()) {
                directory.mkdirs();
            }
            String filePath = savePath + fileName + ".litematic";
            byte[] decodedData = Base64.getDecoder().decode(base64Data);
            try (FileOutputStream fos = new FileOutputStream(filePath);){
                fos.write(decodedData);
            }
            return filePath;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to download schematic: " + e.getMessage(), e);
        }
    }

    public static String fetchAndDownloadSchematic(String id, String fileName) {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://choculaterie.com/api/LitematicDownloaderModAPI/GetLitematicFiles/" + id)).GET().build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new RuntimeException("Failed to fetch schematic file: " + response.statusCode());
            }
            JsonObject json = (JsonObject)gson.fromJson(response.body(), JsonObject.class);
            if (json.has("files") && json.getAsJsonArray("files").size() > 0) {
                String base64Data = json.getAsJsonArray("files").get(0).getAsString();
                return LitematicHttpClient.downloadSchematic(base64Data, fileName);
            }
            throw new RuntimeException("No schematic file found");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to download schematic: " + e.getMessage(), e);
        }
    }

    public static void uploadLitematicFile(File file, UploadCallback callback) {
        new Thread(() -> {
            try {
                String boundary = "Boundary-" + System.currentTimeMillis();
                byte[] fileBytes = Files.readAllBytes(file.toPath());
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                baos.write(("--" + boundary + "\r\n").getBytes());
                baos.write(("Content-Disposition: form-data; name=\"file\"; filename=\"" + file.getName() + "\"\r\n").getBytes());
                baos.write("Content-Type: application/octet-stream\r\n\r\n".getBytes());
                baos.write(fileBytes);
                baos.write("\r\n".getBytes());
                baos.write(("--" + boundary + "--\r\n").getBytes());
                byte[] requestBody = baos.toByteArray();
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://choculaterie.com/api/LitematicDownloaderModAPI/upload")).header("Content-Type", "multipart/form-data; boundary=" + boundary).POST(HttpRequest.BodyPublishers.ofByteArray(requestBody)).build();
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() == 200) {
                    JsonObject json = (JsonObject)gson.fromJson(response.body(), JsonObject.class);
                    String fileUrl = json.get("fileUrl").getAsString();
                    String viewerUrl = json.get("viewerUrl").getAsString();
                    class_310.method_1551().execute(() -> {
                        class_310.method_1551().field_1774.method_1455(viewerUrl);
                        callback.onSuccess(viewerUrl);
                    });
                } else {
                    class_310.method_1551().execute(() -> callback.onError("Upload failed: " + response.statusCode() + " " + (String)response.body()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                class_310.method_1551().execute(() -> callback.onError("Upload failed: " + e.getMessage()));
            }
        }).start();
    }

    static {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            client = HttpClient.newBuilder().sslContext(sslContext).build();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize HttpClient with custom SSL context", e);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class PaginatedResult {
        private final List<SchematicInfo> items;
        private final int totalPages;
        private final int currentPage;
        private final int totalItems;

        public PaginatedResult(List<SchematicInfo> items, int totalPages, int currentPage, int totalItems) {
            this.items = items;
            this.totalPages = totalPages;
            this.currentPage = currentPage;
            this.totalItems = totalItems;
        }

        public List<SchematicInfo> getItems() {
            return this.items;
        }

        public int getTotalPages() {
            return this.totalPages;
        }

        public int getCurrentPage() {
            return this.currentPage;
        }

        public int getTotalItems() {
            return this.totalItems;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static interface UploadCallback {
        public void onSuccess(String var1);

        public void onError(String var1);
    }
}

