/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class ConfirmationDeleteScreen
extends class_437 {
    private final String directoryName;
    private final List<File> filesToDelete;
    private final Consumer<Boolean> callback;
    private int scrollOffset = 0;
    private final int itemHeight = 14;
    private final Map<File, Boolean> expanded = new HashMap<File, Boolean>();
    private final List<TreeEntry> treeEntries = new ArrayList<TreeEntry>();
    private int scrollAreaX;
    private int scrollAreaY;
    private int scrollAreaWidth;
    private int scrollAreaHeight;
    private int scrollBarX;
    private int scrollBarY;
    private int scrollBarHeight;
    private int totalContentHeight;
    private boolean isScrolling = false;
    private int lastMouseY;

    public ConfirmationDeleteScreen(String directoryName, List<File> filesToDelete, Consumer<Boolean> callback) {
        super((class_2561)class_2561.method_43470((String)"Confirm Deletion"));
        this.directoryName = directoryName;
        this.filesToDelete = filesToDelete;
        this.callback = callback;
        this.buildTreeEntries();
    }

    private void buildTreeEntries() {
        this.treeEntries.clear();
        File rootDir = this.filesToDelete.get(0);
        while (rootDir.getParentFile() != null && this.filesToDelete.contains(rootDir.getParentFile())) {
            rootDir = rootDir.getParentFile();
        }
        for (File file : this.filesToDelete) {
            if (!file.isDirectory()) continue;
            this.expanded.put(file, true);
        }
        this.buildTree(rootDir, 0);
        this.updateVisibility();
    }

    private void buildTree(File file, int depth) {
        File[] children;
        this.treeEntries.add(new TreeEntry(file, depth));
        if (file.isDirectory() && (children = file.listFiles()) != null) {
            for (File child : children) {
                if (!this.filesToDelete.contains(child)) continue;
                this.buildTree(child, depth + 1);
            }
        }
    }

    private void updateVisibility() {
        boolean parentVisible = true;
        File currentParent = null;
        int currentDepth = -1;
        for (TreeEntry entry : this.treeEntries) {
            if (entry.depth <= currentDepth) {
                parentVisible = true;
                currentParent = null;
            }
            entry.isVisible = parentVisible;
            if (!entry.file.isDirectory()) continue;
            currentParent = entry.file;
            currentDepth = entry.depth;
            if (this.expanded.getOrDefault(entry.file, false).booleanValue()) continue;
            parentVisible = false;
        }
    }

    protected void method_25426() {
        int buttonWidth = 100;
        int buttonHeight = 20;
        int spacing = 10;
        int totalButtonWidth = buttonWidth * 2 + spacing;
        int startX = (this.field_22789 - totalButtonWidth) / 2;
        int buttonY = this.field_22790 - 30;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), button -> this.callback.accept(false)).method_46434(startX + buttonWidth + spacing, buttonY, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Delete All"), button -> this.callback.accept(true)).method_46434(startX, buttonY, buttonWidth, buttonHeight).method_46431());
        int contentWidth = Math.min(600, this.field_22789 - 80);
        this.scrollAreaX = (this.field_22789 - contentWidth) / 2;
        this.scrollAreaY = 60;
        this.scrollAreaWidth = contentWidth;
        this.scrollAreaHeight = buttonY - this.scrollAreaY - 10;
        int visibleCount = 0;
        for (TreeEntry entry : this.treeEntries) {
            if (!entry.isVisible) continue;
            ++visibleCount;
        }
        this.totalContentHeight = visibleCount * 14;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, 0xFF5555);
        String warning = "The following items will be permanently deleted:";
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)warning), this.field_22789 / 2, 35, 0xFFFFFF);
        int fileCount = 0;
        int folderCount = 0;
        for (File file : this.filesToDelete) {
            if (file.isDirectory()) {
                ++folderCount;
                continue;
            }
            ++fileCount;
        }
        String summary = folderCount + " folder" + (folderCount != 1 ? "s" : "") + " and " + fileCount + " file" + (fileCount != 1 ? "s" : "");
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)summary), this.field_22789 / 2, this.scrollAreaY - 15, 0xCCCCCC);
        context.method_44379(this.scrollAreaX, this.scrollAreaY, this.scrollAreaX + this.scrollAreaWidth, this.scrollAreaY + this.scrollAreaHeight);
        int y = this.scrollAreaY - this.scrollOffset;
        for (TreeEntry entry : this.treeEntries) {
            if (!entry.isVisible) continue;
            if (y + 14 >= this.scrollAreaY && y <= this.scrollAreaY + this.scrollAreaHeight) {
                int indent = entry.depth * 10;
                if (entry.file.isDirectory()) {
                    boolean isExpanded = this.expanded.getOrDefault(entry.file, false);
                    String expandChar = isExpanded ? "\u25bc" : "\u25b6";
                    boolean isHovering = mouseX >= this.scrollAreaX + indent && mouseX <= this.scrollAreaX + indent + 10 && mouseY >= y && mouseY <= y + 14;
                    context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)expandChar), this.scrollAreaX + indent, y, isHovering ? 0xFFFFFF : 0xAAAAAA);
                }
                String icon = entry.file.isDirectory() ? "\ud83d\udcc1 " : "\ud83d\udcc4 ";
                context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)icon), this.scrollAreaX + indent + 15, y, 0xFFFFFF);
                context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)entry.file.getName()), this.scrollAreaX + indent + 30, y, 0xFFFFFF);
            }
            y += 14;
        }
        context.method_44380();
        if (this.totalContentHeight > this.scrollAreaHeight) {
            int scrollBarWidth = 6;
            this.scrollBarHeight = Math.max(20, this.scrollAreaHeight * this.scrollAreaHeight / this.totalContentHeight);
            this.scrollBarX = this.scrollAreaX + this.scrollAreaWidth;
            this.scrollBarY = this.scrollAreaY + (int)((float)this.scrollOffset / (float)(this.totalContentHeight - this.scrollAreaHeight) * (float)(this.scrollAreaHeight - this.scrollBarHeight));
            context.method_25294(this.scrollBarX, this.scrollAreaY, this.scrollBarX + scrollBarWidth, this.scrollAreaY + this.scrollAreaHeight, 0x33FFFFFF);
            boolean isHovering = mouseX >= this.scrollBarX && mouseX <= this.scrollBarX + scrollBarWidth && mouseY >= this.scrollBarY && mouseY <= this.scrollBarY + this.scrollBarHeight;
            int scrollBarColor = isHovering || this.isScrolling ? -1 : -1426063361;
            context.method_25294(this.scrollBarX, this.scrollBarY, this.scrollBarX + scrollBarWidth, this.scrollBarY + this.scrollBarHeight, scrollBarColor);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int index;
        if (button == 0 && mouseY >= (double)this.scrollAreaY && mouseY <= (double)(this.scrollAreaY + this.scrollAreaHeight) && (index = this.getVisibleIndexAtY(mouseY)) >= 0 && index < this.treeEntries.size()) {
            int indent;
            TreeEntry entry = this.treeEntries.get(index);
            if (entry.file.isDirectory() && mouseX >= (double)(this.scrollAreaX + (indent = entry.depth * 10)) && mouseX <= (double)(this.scrollAreaX + indent + 10)) {
                this.expanded.put(entry.file, this.expanded.getOrDefault(entry.file, false) == false);
                this.updateVisibility();
                int visibleCount = 0;
                for (TreeEntry e : this.treeEntries) {
                    if (!e.isVisible) continue;
                    ++visibleCount;
                }
                this.totalContentHeight = visibleCount * 14;
                return true;
            }
        }
        if (button == 0 && this.totalContentHeight > this.scrollAreaHeight) {
            if (mouseX >= (double)this.scrollBarX && mouseX <= (double)(this.scrollBarX + 6) && mouseY >= (double)this.scrollBarY && mouseY <= (double)(this.scrollBarY + this.scrollBarHeight)) {
                this.isScrolling = true;
                this.lastMouseY = (int)mouseY;
                return true;
            }
            if (mouseX >= (double)this.scrollBarX && mouseX <= (double)(this.scrollBarX + 6) && mouseY >= (double)this.scrollAreaY && mouseY <= (double)(this.scrollAreaY + this.scrollAreaHeight)) {
                float clickPercent = ((float)mouseY - (float)this.scrollAreaY) / (float)this.scrollAreaHeight;
                this.scrollOffset = (int)(clickPercent * (float)(this.totalContentHeight - this.scrollAreaHeight));
                this.scrollOffset = Math.max(0, Math.min(this.totalContentHeight - this.scrollAreaHeight, this.scrollOffset));
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private int getVisibleIndexAtY(double mouseY) {
        int y = this.scrollAreaY - this.scrollOffset;
        int visibleIndex = 0;
        for (int i = 0; i < this.treeEntries.size(); ++i) {
            if (!this.treeEntries.get((int)i).isVisible) continue;
            if (mouseY >= (double)y && mouseY < (double)(y + 14)) {
                return i;
            }
            y += 14;
            ++visibleIndex;
        }
        return -1;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isScrolling) {
            if (mouseY != (double)this.lastMouseY) {
                float dragPercentage = (float)(mouseY - (double)this.lastMouseY) / (float)(this.scrollAreaHeight - this.scrollBarHeight);
                int scrollAmount = (int)(dragPercentage * (float)(this.totalContentHeight - this.scrollAreaHeight));
                this.scrollOffset = Math.max(0, Math.min(this.totalContentHeight - this.scrollAreaHeight, this.scrollOffset + scrollAmount));
                this.lastMouseY = (int)mouseY;
            }
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isScrolling) {
            this.isScrolling = false;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (mouseX >= (double)this.scrollAreaX && mouseX <= (double)(this.scrollAreaX + this.scrollAreaWidth) && mouseY >= (double)this.scrollAreaY && mouseY <= (double)(this.scrollAreaY + this.scrollAreaHeight) && this.totalContentHeight > this.scrollAreaHeight) {
            int scrollAmount = (int)(-verticalAmount * 20.0);
            this.scrollOffset = Math.max(0, Math.min(this.totalContentHeight - this.scrollAreaHeight, this.scrollOffset + scrollAmount));
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    @Environment(value=EnvType.CLIENT)
    private static class TreeEntry {
        File file;
        int depth;
        boolean isVisible = true;

        TreeEntry(File file, int depth) {
            this.file = file;
            this.depth = depth;
        }
    }
}

