/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;

@Environment(value=EnvType.CLIENT)
public class LitematicParser {
    /*
     * Enabled aggressive exception aggregation
     */
    public static List<BlockCount> parseBlockCounts(File litematicFile) {
        HashMap<String, Integer> blockCounts = new HashMap<String, Integer>();
        try (FileInputStream fis = new FileInputStream(litematicFile);){
            class_2487 root = class_2507.method_10629((InputStream)fis, (class_2505)class_2505.method_53898());
            if (!root.method_10545("Regions")) {
                List<BlockCount> list = Collections.emptyList();
                return list;
            }
            class_2487 regions = root.method_10562("Regions").orElse(new class_2487());
            block8: for (String regionName : regions.method_10541()) {
                int paletteSize;
                int absSizeZ;
                int absSizeY;
                long[] blockStates;
                class_2487 region = regions.method_10562(regionName).orElse(new class_2487());
                if (!region.method_10545("BlockStatePalette")) continue;
                class_2499 palette = region.method_10554("BlockStatePalette").orElse(new class_2499());
                HashMap<Integer, String> indexToBlockId = new HashMap<Integer, String>();
                for (int i = 0; i < palette.size(); ++i) {
                    class_2487 blockState = palette.method_10602(i).orElse(new class_2487());
                    if (!blockState.method_10545("Name")) continue;
                    String blockId = blockState.method_10558("Name").orElse("minecraft:air");
                    indexToBlockId.put(i, blockId);
                }
                if (!region.method_10545("BlockStates") || (blockStates = region.method_10565("BlockStates").orElse(new long[0])).length == 0) continue;
                class_2487 sizeCompound = region.method_10562("Size").orElse(new class_2487());
                int sizeX = sizeCompound.method_10550("x").orElse(0);
                int sizeY = sizeCompound.method_10550("y").orElse(0);
                int sizeZ = sizeCompound.method_10550("z").orElse(0);
                int absSizeX = Math.abs(sizeX);
                int totalBlocks = absSizeX * (absSizeY = Math.abs(sizeY)) * (absSizeZ = Math.abs(sizeZ));
                if (totalBlocks == 0 || (paletteSize = palette.size()) == 0) continue;
                int bitsPerBlock = Math.max(2, (int)Math.ceil(Math.log(paletteSize) / Math.log(2.0)));
                long maxEntryValue = (1L << bitsPerBlock) - 1L;
                for (int i = 0; i < totalBlocks; ++i) {
                    String blockId;
                    long value;
                    int bitIndex = i * bitsPerBlock;
                    int arrayIndex = bitIndex / 64;
                    int bitOffset = bitIndex % 64;
                    if (arrayIndex >= blockStates.length) continue block8;
                    if (bitOffset + bitsPerBlock <= 64) {
                        value = blockStates[arrayIndex] >> bitOffset & maxEntryValue;
                    } else {
                        int bitsFromFirst = 64 - bitOffset;
                        int bitsFromSecond = bitsPerBlock - bitsFromFirst;
                        long firstPart = blockStates[arrayIndex] >> bitOffset & (1L << bitsFromFirst) - 1L;
                        long secondPart = arrayIndex + 1 < blockStates.length ? blockStates[arrayIndex + 1] & (1L << bitsFromSecond) - 1L : 0L;
                        value = firstPart | secondPart << bitsFromFirst;
                    }
                    int paletteIndex = (int)value;
                    if (paletteIndex < 0 || paletteIndex >= indexToBlockId.size() || (blockId = indexToBlockId.getOrDefault(paletteIndex, "minecraft:air")).equals("minecraft:air") || blockId.equals("minecraft:cave_air") || blockId.equals("minecraft:void_air")) continue;
                    blockCounts.put(blockId, blockCounts.getOrDefault(blockId, 0) + 1);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
        ArrayList<BlockCount> result = new ArrayList<BlockCount>();
        for (Map.Entry entry : blockCounts.entrySet()) {
            result.add(new BlockCount((String)entry.getKey(), (Integer)entry.getValue()));
        }
        result.sort((a, b) -> Integer.compare(b.count, a.count));
        return result;
    }

    public static String getSimpleBlockName(String blockId) {
        if (blockId.startsWith("minecraft:")) {
            blockId = blockId.substring("minecraft:".length());
        }
        return Arrays.stream(blockId.split("_")).map(word -> word.substring(0, 1).toUpperCase() + word.substring(1)).reduce((a, b) -> a + " " + b).orElse(blockId);
    }

    @Environment(value=EnvType.CLIENT)
    public static class BlockCount {
        public final String blockId;
        public final int count;

        public BlockCount(String blockId, int count) {
            this.blockId = blockId;
            this.count = count;
        }
    }
}

