/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui.widget;

import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;

@Environment(value=EnvType.CLIENT)
public class ToggleButton
extends class_4185 {
    private static final int TOGGLE_WIDTH = 40;
    private static final int TOGGLE_HEIGHT = 20;
    private static final int TRACK_PADDING = 2;
    private static final int TRACK_VERTICAL_PADDING = 3;
    private static final int KNOB_PADDING = 4;
    private static final int KNOB_OFFSET = 2;
    private boolean toggled;
    private final Consumer<Boolean> onToggle;

    public ToggleButton(int x, int y, boolean initialState, Consumer<Boolean> onToggle) {
        super(x, y, 40, 20, (class_2561)class_2561.method_43470((String)" "), button -> ((ToggleButton)button).toggle(), field_40754);
        this.toggled = initialState;
        this.onToggle = onToggle;
    }

    private void toggle() {
        boolean bl = this.toggled = !this.toggled;
        if (this.onToggle != null) {
            this.onToggle.accept(this.toggled);
        }
    }

    public boolean isToggled() {
        return this.toggled;
    }

    public void setToggled(boolean toggled) {
        this.toggled = toggled;
    }

    protected void method_75752(class_332 context, int mouseX, int mouseY, float delta) {
        boolean isHovered = this.isMouseOver(mouseX, mouseY);
        int trackColor = this.getTrackColor(isHovered);
        int trackY = this.method_46427() + 3;
        int trackHeight = this.method_25364() - 6;
        this.drawTrack(context, trackColor, trackY, trackHeight);
        this.drawBorder(context, trackY, trackHeight);
        this.drawKnob(context, trackY, trackHeight);
    }

    private int getTrackColor(boolean isHovered) {
        if (this.toggled) {
            return isHovered ? -10502301 : -11751600;
        }
        return isHovered ? -10855846 : -11908534;
    }

    private void drawTrack(class_332 context, int color, int trackY, int trackHeight) {
        context.method_25294(this.method_46426() + 2, trackY, this.method_46426() + this.method_25368() - 2, trackY + trackHeight, color);
    }

    private boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX >= this.method_46426() && mouseY >= this.method_46427() && mouseX < this.method_46426() + this.method_25368() && mouseY < this.method_46427() + this.method_25364();
    }

    private void drawBorder(class_332 context, int trackY, int trackHeight) {
        int x = this.method_46426();
        int width = this.method_25368();
        int borderWidth = 1;
        int borderColor = -11184811;
        context.method_25294(x, trackY, x + width, trackY + borderWidth, borderColor);
        context.method_25294(x, trackY + trackHeight - borderWidth, x + width, trackY + trackHeight, borderColor);
        context.method_25294(x, trackY, x + borderWidth, trackY + trackHeight, borderColor);
        context.method_25294(x + width - borderWidth, trackY, x + width, trackY + trackHeight, borderColor);
    }

    private void drawKnob(class_332 context, int trackY, int trackHeight) {
        int knobSize = trackHeight - 4;
        int knobX = this.toggled ? this.method_46426() + this.method_25368() - knobSize - 4 : this.method_46426() + 4;
        int knobY = trackY + 2;
        context.method_25294(knobX, knobY, knobX + knobSize, knobY + knobSize, -1);
    }
}

