/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui.widget;

import com.choculaterie.config.DownloadSettings;
import com.choculaterie.gui.widget.Toast;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class ToastManager {
    private final List<Toast> toasts = new ArrayList<Toast>();
    private final class_310 client;
    private static final int TOP_PADDING = 10;
    private static final int TOAST_MIN_HEIGHT = 70;

    public ToastManager(class_310 client) {
        this.client = client;
    }

    public void showToast(String message, Toast.Type type) {
        this.showToast(message, type, false, null);
    }

    public void showToast(String message, Toast.Type type, boolean hasCopyButton, String copyText) {
        if (!this.isToastTypeEnabled(type)) {
            return;
        }
        if (this.client.method_22683() == null) {
            return;
        }
        int screenWidth = this.client.method_22683().method_4486();
        int screenHeight = this.client.method_22683().method_4502();
        int yPosition = this.calculateToastPosition(screenHeight);
        this.toasts.add(new Toast(message, type, screenWidth, yPosition, hasCopyButton, copyText));
    }

    public void showSuccess(String message) {
        this.showToast(message, Toast.Type.SUCCESS);
    }

    public void showError(String message) {
        this.showToast(message, Toast.Type.ERROR);
    }

    public void showError(String message, String fullErrorText) {
        this.showToast(message, Toast.Type.ERROR, true, fullErrorText);
    }

    public void showInfo(String message) {
        this.showToast(message, Toast.Type.INFO);
    }

    public void showWarning(String message) {
        this.showToast(message, Toast.Type.WARNING);
    }

    public void render(class_332 context, float delta, int mouseX, int mouseY) {
        if (this.toasts.isEmpty()) {
            return;
        }
        Toast.updateMousePosition(mouseX, mouseY);
        Iterator<Toast> iterator = this.toasts.iterator();
        boolean toastRemoved = false;
        while (iterator.hasNext()) {
            Toast toast = iterator.next();
            toast.setHovered(toast.isHovering(mouseX, mouseY));
            if (!toast.render(context, this.client.field_1772)) continue;
            iterator.remove();
            toastRemoved = true;
        }
        if (toastRemoved && !this.toasts.isEmpty()) {
            this.recalculatePositions();
        }
    }

    public void clear() {
        this.toasts.clear();
    }

    public boolean hasToasts() {
        return !this.toasts.isEmpty();
    }

    public boolean isMouseOverToast(double mouseX, double mouseY) {
        for (Toast toast : this.toasts) {
            if (!toast.isHovering(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY) {
        for (Toast toast : this.toasts) {
            if (this.handleCloseButton(toast, mouseX, mouseY)) {
                return true;
            }
            if (!this.handleCopyButton(toast, mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    private boolean isToastTypeEnabled(Toast.Type type) {
        DownloadSettings settings = DownloadSettings.getInstance();
        return switch (type) {
            default -> throw new MatchException(null, null);
            case Toast.Type.SUCCESS -> settings.isSuccessToastsEnabled();
            case Toast.Type.ERROR -> settings.isErrorToastsEnabled();
            case Toast.Type.INFO -> settings.isInfoToastsEnabled();
            case Toast.Type.WARNING -> settings.isWarningToastsEnabled();
        };
    }

    private int calculateToastPosition(int screenHeight) {
        int yPosition = 10;
        for (Toast toast : this.toasts) {
            yPosition += toast.getHeight();
        }
        if (yPosition + 70 > screenHeight && !this.toasts.isEmpty()) {
            this.toasts.remove(0);
            yPosition = 10;
            for (Toast toast : this.toasts) {
                yPosition += toast.getHeight();
            }
        }
        return yPosition;
    }

    private void recalculatePositions() {
        int newY = 10;
        for (Toast toast : this.toasts) {
            toast.setTargetYPosition(newY);
            newY += toast.getHeight();
        }
    }

    private boolean handleCloseButton(Toast toast, double mouseX, double mouseY) {
        if (toast.isCloseButtonClicked(mouseX, mouseY)) {
            toast.dismiss();
            return true;
        }
        return false;
    }

    private boolean handleCopyButton(Toast toast, double mouseX, double mouseY) {
        if (toast.isCopyButtonClicked(mouseX, mouseY)) {
            String textToCopy = toast.getCopyText();
            if (this.client.field_1774 != null) {
                this.client.field_1774.method_1455(textToCopy);
                this.showSuccess("Error copied to clipboard!");
                return true;
            }
        }
        return false;
    }
}

