/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui.widget;

import com.choculaterie.gui.widget.CustomButton;
import com.choculaterie.gui.widget.CustomTextField;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import org.lwjgl.glfw.GLFW;

@Environment(value=EnvType.CLIENT)
public class TextInputPopup
implements class_4068,
class_364 {
    private static final int POPUP_WIDTH = 300;
    private static final int POPUP_HEIGHT = 120;
    private static final String[] INVALID_CHARS = new String[]{"/", "\\", ":", "*", "?", "\"", "<", ">", "|"};
    private static final String[] RESERVED_NAMES = new String[]{"CON", "PRN", "AUX", "NUL"};
    private final String title;
    private final Consumer<String> onConfirm;
    private final Runnable onCancel;
    private final String confirmButtonText;
    private final int x;
    private final int y;
    private CustomTextField textField;
    private CustomButton confirmButton;
    private CustomButton cancelButton;
    private String errorMessage = "";
    private boolean wasEscapePressed;

    public TextInputPopup(class_437 parent, String title, Consumer<String> onConfirm, Runnable onCancel) {
        this(title, "Create", onConfirm, onCancel);
    }

    public TextInputPopup(class_437 parent, String title, String confirmButtonText, Consumer<String> onConfirm, Runnable onCancel) {
        this(title, confirmButtonText, onConfirm, onCancel);
    }

    public TextInputPopup(String title, String confirmButtonText, Consumer<String> onConfirm, Runnable onCancel) {
        this.title = title;
        this.confirmButtonText = confirmButtonText;
        this.onConfirm = onConfirm;
        this.onCancel = onCancel;
        class_310 client = class_310.method_1551();
        this.x = (client.method_22683().method_4486() - 300) / 2;
        this.y = (client.method_22683().method_4502() - 120) / 2;
        this.initWidgets();
    }

    private void initWidgets() {
        class_310 client = class_310.method_1551();
        int fieldY = this.y + 30;
        this.textField = new CustomTextField(client, this.x + 10, fieldY, 280, 20, class_2561.method_30163((String)""));
        this.textField.method_47404(class_2561.method_30163((String)"Enter name..."));
        this.textField.method_25365(true);
        this.textField.setOnChanged(() -> {
            this.errorMessage = "";
        });
        this.textField.setOnEnterPressed(this::handleConfirm);
        int buttonY = this.y + 120 - 10 - 20;
        int buttonWidth = 135;
        this.cancelButton = new CustomButton(this.x + 10, buttonY, buttonWidth, 20, class_2561.method_30163((String)"Cancel"), button -> this.onCancel.run());
        this.confirmButton = new CustomButton(this.x + 20 + buttonWidth, buttonY, buttonWidth, 20, class_2561.method_30163((String)this.confirmButtonText), button -> this.handleConfirm());
    }

    public void setErrorMessage(String error) {
        this.errorMessage = error;
    }

    public void setText(String text) {
        if (this.textField != null) {
            this.textField.method_1852(text);
        }
    }

    private List<String> wrapText(String text, int maxWidth, class_310 client) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            Object testLine = currentLine.isEmpty() ? word : String.valueOf(currentLine) + " " + word;
            int width = client.field_1772.method_1727((String)testLine);
            if (width <= maxWidth) {
                if (!currentLine.isEmpty()) {
                    currentLine.append(" ");
                }
                currentLine.append(word);
                continue;
            }
            if (!currentLine.isEmpty()) {
                lines.add(currentLine.toString());
            }
            currentLine = new StringBuilder(word);
        }
        if (!currentLine.isEmpty()) {
            lines.add(currentLine.toString());
        }
        return lines.isEmpty() ? List.of(text) : lines;
    }

    private void handleConfirm() {
        String text = this.textField.method_1882().trim();
        if (text.isEmpty()) {
            this.setErrorMessage("Folder name cannot be empty");
            return;
        }
        if (this.containsInvalidChars(text)) {
            this.setErrorMessage("Invalid characters in folder name");
            return;
        }
        if (this.isReservedName(text)) {
            this.setErrorMessage("Reserved folder name");
            return;
        }
        this.onConfirm.accept(text);
    }

    private boolean containsInvalidChars(String text) {
        for (String invalidChar : INVALID_CHARS) {
            if (!text.contains(invalidChar)) continue;
            return true;
        }
        return false;
    }

    private boolean isReservedName(String text) {
        String upperText = text.toUpperCase();
        for (String reserved : RESERVED_NAMES) {
            if (!upperText.equals(reserved)) continue;
            return true;
        }
        return upperText.matches("COM[0-9]") || upperText.matches("LPT[0-9]");
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.handleEscapeKey();
        class_310 client = class_310.method_1551();
        this.drawOverlay(context, client);
        this.drawPopupBackground(context);
        this.drawTitle(context, client);
        if (this.textField != null) {
            this.textField.method_25365(true);
            this.textField.method_25394(context, mouseX, mouseY, delta);
        }
        if (!this.errorMessage.isEmpty()) {
            this.drawErrorMessage(context, client);
        }
        if (this.cancelButton != null) {
            this.cancelButton.method_25394(context, mouseX, mouseY, delta);
        }
        if (this.confirmButton != null) {
            this.confirmButton.method_25394(context, mouseX, mouseY, delta);
        }
    }

    private void handleEscapeKey() {
        long windowHandle;
        class_310 client = class_310.method_1551();
        long l = windowHandle = client.method_22683() != null ? client.method_22683().method_4490() : 0L;
        if (windowHandle != 0L) {
            boolean escapePressed;
            boolean bl = escapePressed = GLFW.glfwGetKey((long)windowHandle, (int)256) == 1;
            if (escapePressed && !this.wasEscapePressed) {
                this.onCancel.run();
            }
            this.wasEscapePressed = escapePressed;
        }
    }

    private void drawOverlay(class_332 context, class_310 client) {
        context.method_25294(0, 0, client.method_22683().method_4486(), client.method_22683().method_4502(), Integer.MIN_VALUE);
    }

    private void drawPopupBackground(class_332 context) {
        context.method_25294(this.x, this.y, this.x + 300, this.y + 120, -14013910);
        context.method_25294(this.x, this.y, this.x + 300, this.y + 1, -11184811);
        context.method_25294(this.x, this.y + 120 - 1, this.x + 300, this.y + 120, -11184811);
        context.method_25294(this.x, this.y, this.x + 1, this.y + 120, -11184811);
        context.method_25294(this.x + 300 - 1, this.y, this.x + 300, this.y + 120, -11184811);
    }

    private void drawTitle(class_332 context, class_310 client) {
        context.method_25300(client.field_1772, this.title, this.x + 150, this.y + 10, -1);
    }

    private void drawErrorMessage(class_332 context, class_310 client) {
        List<String> wrappedError = this.wrapText(this.errorMessage, 280, client);
        int errorY = this.y + 30 + 25;
        for (String line : wrappedError) {
            context.method_25300(client.field_1772, line, this.x + 150, errorY, -43691);
            errorY += 10;
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isMouseOverPopup(mouseX, mouseY)) {
            this.onCancel.run();
            return true;
        }
        if (this.isMouseOverWidget((class_364)this.textField, mouseX, mouseY)) {
            this.textField.method_25365(true);
            return true;
        }
        if (this.isMouseOverWidget((class_364)this.cancelButton, mouseX, mouseY)) {
            this.onCancel.run();
            return true;
        }
        if (this.isMouseOverWidget((class_364)this.confirmButton, mouseX, mouseY)) {
            this.handleConfirm();
            return true;
        }
        return true;
    }

    private boolean isMouseOverPopup(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX <= (double)(this.x + 300) && mouseY >= (double)this.y && mouseY <= (double)(this.y + 120);
    }

    private boolean isMouseOverWidget(class_364 widget, double mouseX, double mouseY) {
        if (widget == null) {
            return false;
        }
        class_364 class_3642 = widget;
        Objects.requireNonNull(class_3642);
        class_364 class_3643 = class_3642;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CustomTextField.class, CustomButton.class}, (Object)class_3643, n)) {
            case 0 -> {
                CustomTextField field = (CustomTextField)class_3643;
                if (mouseX >= (double)field.method_46426() && mouseX < (double)(field.method_46426() + field.method_25368()) && mouseY >= (double)field.method_46427() && mouseY < (double)(field.method_46427() + field.method_25364())) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                CustomButton button = (CustomButton)class_3643;
                if (mouseX >= (double)button.method_46426() && mouseX < (double)(button.method_46426() + button.method_25368()) && mouseY >= (double)button.method_46427() && mouseY < (double)(button.method_46427() + button.method_25364())) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public void method_25365(boolean focused) {
        if (this.textField != null) {
            this.textField.method_25365(focused);
        }
    }

    public boolean method_25370() {
        return this.textField != null && this.textField.method_25370();
    }
}

