/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui.widget;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_332;
import net.minecraft.class_4068;
import org.lwjgl.glfw.GLFW;

@Environment(value=EnvType.CLIENT)
public class ScrollBar
implements class_4068 {
    private static final int MIN_HANDLE_HEIGHT = 20;
    private final int x;
    private final int y;
    private final int height;
    private double scrollPercentage = 0.0;
    private double contentHeight = 0.0;
    private double visibleHeight = 0.0;
    private boolean isDragging = false;
    private double dragStartY = 0.0;
    private double dragStartScroll = 0.0;
    private boolean isHovered = false;
    private boolean wasMouseDown = false;

    public ScrollBar(int x, int y, int height) {
        this.x = x;
        this.y = y;
        this.height = height;
    }

    public void setScrollData(double contentHeight, double visibleHeight) {
        this.contentHeight = contentHeight;
        this.visibleHeight = visibleHeight;
    }

    public void setScrollPercentage(double percentage) {
        this.scrollPercentage = Math.max(0.0, Math.min(1.0, percentage));
    }

    public double getScrollPercentage() {
        return this.scrollPercentage;
    }

    public boolean isVisible() {
        return this.contentHeight > this.visibleHeight;
    }

    public boolean isDragging() {
        return this.isDragging;
    }

    private double getHandleHeight() {
        return Math.max(20.0, this.visibleHeight / this.contentHeight * (double)this.height);
    }

    private double getMaxHandleY() {
        return (double)this.height - this.getHandleHeight();
    }

    private double getHandleY() {
        return (double)this.y + this.scrollPercentage * this.getMaxHandleY();
    }

    private boolean isMouseOverHandle(int mouseX, int mouseY) {
        double handleHeight = this.getHandleHeight();
        double handleY = this.getHandleY();
        return mouseX >= this.x && mouseX < this.x + 8 && (double)mouseY >= handleY && (double)mouseY < handleY + handleHeight;
    }

    private boolean isMouseOverTrack(int mouseX, int mouseY) {
        return mouseX >= this.x && mouseX < this.x + 8 && mouseY >= this.y && mouseY < this.y + this.height;
    }

    public boolean updateAndRender(class_332 context, int mouseX, int mouseY, float delta, long windowHandle) {
        double deltaYMouse;
        double deltaScroll;
        double newPercentage;
        boolean isMouseDown = GLFW.glfwGetMouseButton((long)windowHandle, (int)0) == 1;
        double handleHeight = this.getHandleHeight();
        double maxHandleY = this.getMaxHandleY();
        this.isHovered = this.isMouseOverHandle(mouseX, mouseY);
        boolean isOverTrack = this.isMouseOverTrack(mouseX, mouseY);
        boolean scrollChanged = false;
        if (isMouseDown && !this.wasMouseDown) {
            if (this.isHovered) {
                this.isDragging = true;
                this.dragStartY = mouseY;
                this.dragStartScroll = this.scrollPercentage;
            } else if (isOverTrack) {
                double clickPositionInTrack = (double)(mouseY - this.y) - handleHeight / 2.0;
                double newPercentage2 = Math.max(0.0, Math.min(1.0, clickPositionInTrack / maxHandleY));
                if (newPercentage2 != this.scrollPercentage) {
                    this.scrollPercentage = newPercentage2;
                    scrollChanged = true;
                }
                this.isDragging = true;
                this.dragStartY = mouseY;
                this.dragStartScroll = this.scrollPercentage;
            }
        }
        if (this.isDragging && isMouseDown && (newPercentage = Math.max(0.0, Math.min(1.0, this.dragStartScroll + (deltaScroll = (deltaYMouse = (double)mouseY - this.dragStartY) / maxHandleY)))) != this.scrollPercentage) {
            this.scrollPercentage = newPercentage;
            scrollChanged = true;
        }
        if (!isMouseDown && this.isDragging) {
            this.isDragging = false;
        }
        this.wasMouseDown = isMouseDown;
        this.drawScrollBar(context, handleHeight);
        return scrollChanged;
    }

    private void drawScrollBar(class_332 context, double handleHeight) {
        context.method_25294(this.x, this.y, this.x + 8, this.y + this.height, -15066598);
        if (this.isVisible()) {
            double handleY = this.getHandleY();
            int handleColor = this.isHovered || this.isDragging ? -7829368 : -11184811;
            context.method_25294(this.x, (int)handleY, this.x + 8, (int)(handleY + handleHeight), handleColor);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.isHovered = this.isMouseOverHandle(mouseX, mouseY);
        this.drawScrollBar(context, this.getHandleHeight());
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isVisible() || button != 0) {
            return false;
        }
        if (this.isMouseOverHandle((int)mouseX, (int)mouseY)) {
            this.isDragging = true;
            this.dragStartY = mouseY;
            this.dragStartScroll = this.scrollPercentage;
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isDragging) {
            this.isDragging = false;
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.isDragging) {
            return false;
        }
        double deltaYMouse = mouseY - this.dragStartY;
        double deltaScroll = deltaYMouse / this.getMaxHandleY();
        this.setScrollPercentage(this.dragStartScroll + deltaScroll);
        return true;
    }

    public int getWidth() {
        return 8;
    }
}

