/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui.widget;

import com.choculaterie.gui.widget.BlockReplacementPopup;
import com.choculaterie.gui.widget.CustomButton;
import com.choculaterie.gui.widget.ScrollBar;
import com.choculaterie.util.LitematicBlockReplacer;
import com.choculaterie.util.LitematicParser;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11909;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class LitematicDetailPanel
implements class_4068,
class_364 {
    private int x;
    private int y;
    private int width;
    private int height;
    private File litematicFile;
    private final class_310 client;
    private CustomButton closeButton;
    private Runnable onClose;
    private List<LitematicParser.BlockCount> blockCounts = new ArrayList<LitematicParser.BlockCount>();
    private boolean isParsing = false;
    private boolean parseFailed = false;
    private int scrollOffset = 0;
    private ScrollBar scrollBar;
    private BlockReplacementPopup replacementPopup;
    private static final int ITEM_HEIGHT = 24;
    private static final int HEADER_HEIGHT = 58;

    public LitematicDetailPanel(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.client = class_310.method_1551();
        this.updateCloseButton();
        this.updateScrollBar();
    }

    public void setDimensions(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.updateCloseButton();
        this.updateScrollBar();
    }

    public void setOnClose(Runnable onClose) {
        this.onClose = onClose;
    }

    private void updateCloseButton() {
        int closeButtonSize = 20;
        this.closeButton = new CustomButton(this.x + this.width - closeButtonSize, this.y, closeButtonSize, closeButtonSize, class_2561.method_30163((String)"X"), btn -> {
            if (this.onClose != null) {
                this.onClose.run();
            }
        });
        this.closeButton.setRenderAsXIcon(true);
    }

    private void updateScrollBar() {
        int listY = this.y + 58;
        int listHeight = this.height - 58 - 10;
        this.scrollBar = new ScrollBar(this.x + this.width - 8 - 10, listY, listHeight);
        int contentHeight = this.blockCounts.size() * 24;
        this.scrollBar.setScrollData(contentHeight, listHeight);
        int maxScroll = this.getMaxScroll();
        if (maxScroll > 0) {
            this.scrollBar.setScrollPercentage((double)this.scrollOffset / (double)maxScroll);
        }
    }

    private int getMaxScroll() {
        int listHeight = this.height - 58 - 10;
        int contentHeight = this.blockCounts.size() * 24;
        return contentHeight <= listHeight ? 0 : this.blockCounts.size() - listHeight / 24;
    }

    public void setFile(File file) {
        this.litematicFile = file;
        this.blockCounts.clear();
        this.scrollOffset = 0;
        this.parseFailed = false;
        if (file != null && file.getName().toLowerCase().endsWith(".litematic")) {
            this.isParsing = true;
            new Thread(() -> {
                try {
                    List<LitematicParser.BlockCount> counts = LitematicParser.parseBlockCounts(file);
                    this.blockCounts = counts;
                    this.isParsing = false;
                    this.updateScrollBar();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.parseFailed = true;
                    this.isParsing = false;
                }
            }, "Litematic-Parser").start();
        }
    }

    public File getFile() {
        return this.litematicFile;
    }

    public boolean hasFile() {
        return this.litematicFile != null;
    }

    public boolean hasPopup() {
        return this.replacementPopup != null;
    }

    public boolean closePopup() {
        if (this.replacementPopup != null) {
            this.replacementPopup = null;
            return true;
        }
        return false;
    }

    public void clear() {
        this.litematicFile = null;
        this.blockCounts.clear();
        this.scrollOffset = 0;
        this.isParsing = false;
        this.parseFailed = false;
        this.replacementPopup = null;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        boolean scrollChanged;
        int renderMouseX = this.replacementPopup != null ? -1 : mouseX;
        int renderMouseY = this.replacementPopup != null ? -1 : mouseY;
        context.method_25294(this.x, this.y, this.x + this.width, this.y + this.height, -15066598);
        context.method_25294(this.x, this.y, this.x + 1, this.y + this.height, -12303292);
        context.method_25294(this.x, this.y, this.x + this.width, this.y + 1, -12303292);
        context.method_25294(this.x + this.width - 1, this.y, this.x + this.width, this.y + this.height, -12303292);
        context.method_25294(this.x, this.y + this.height - 1, this.x + this.width, this.y + this.height, -12303292);
        if (this.closeButton != null) {
            this.closeButton.method_25394(context, renderMouseX, renderMouseY, delta);
        }
        if (this.litematicFile == null) {
            String emptyText = "Select a litematic file";
            int textWidth = this.client.field_1772.method_1727(emptyText);
            context.method_25303(this.client.field_1772, emptyText, this.x + (this.width - textWidth) / 2, this.y + this.height / 2 - 4, -7829368);
            return;
        }
        int contentX = this.x + 10;
        int contentY = this.y + 10;
        String fileName = this.litematicFile.getName();
        context.method_25303(this.client.field_1772, fileName, contentX, contentY, -1);
        long sizeKB = this.litematicFile.length() / 1024L;
        String sizeText = "Size: " + sizeKB + " KB";
        context.method_25303(this.client.field_1772, sizeText, contentX, contentY += 15, -5592406);
        contentY += 15;
        if (this.isParsing) {
            context.method_25303(this.client.field_1772, "Parsing blocks...", contentX, contentY, -22016);
            return;
        }
        if (this.parseFailed) {
            context.method_25303(this.client.field_1772, "Failed to parse file", contentX, contentY, -65536);
            return;
        }
        if (this.blockCounts.isEmpty()) {
            context.method_25303(this.client.field_1772, "No blocks found", contentX, contentY, -7829368);
            return;
        }
        String blocksHeader = "Blocks (" + this.blockCounts.size() + " types):";
        context.method_25303(this.client.field_1772, blocksHeader, contentX, contentY, -5592406);
        int listY = this.y + 58;
        int listHeight = this.height - 58 - 10;
        int listRightEdge = this.x + this.width - 10 - 8 - 2;
        context.method_25294(contentX, listY, listRightEdge, listY + listHeight, -15395563);
        context.method_44379(contentX, listY, listRightEdge, listY + listHeight);
        int maxVisibleItems = listHeight / 24 + 1;
        for (int i = this.scrollOffset; i < Math.min(this.blockCounts.size(), this.scrollOffset + maxVisibleItems); ++i) {
            LitematicParser.BlockCount blockCount = this.blockCounts.get(i);
            int itemY = listY + (i - this.scrollOffset) * 24;
            boolean isHovered = renderMouseX >= contentX && renderMouseX < listRightEdge && renderMouseY >= itemY && renderMouseY < itemY + 24;
            int bgColor = isHovered ? -14013910 : -15066598;
            context.method_25294(contentX + 2, itemY + 2, listRightEdge - 2, itemY + 24 - 2, bgColor);
            class_1799 itemStack = this.getItemStackForBlock(blockCount.blockId);
            if (itemStack != null && !itemStack.method_7960()) {
                context.method_51427(itemStack, contentX + 4, itemY + 4);
            }
            Object blockName = LitematicParser.getSimpleBlockName(blockCount.blockId);
            int textX = contentX + 24;
            int textY = itemY + 8;
            int maxTextWidth = listRightEdge - textX - 70;
            if (this.client.field_1772.method_1727((String)blockName) > maxTextWidth) {
                String test;
                String ellipsis = "...";
                int ellipsisWidth = this.client.field_1772.method_1727(ellipsis);
                int availableWidth = maxTextWidth - ellipsisWidth;
                StringBuilder truncated = new StringBuilder();
                for (int c = 0; c < ((String)blockName).length() && this.client.field_1772.method_1727(test = truncated.toString() + ((String)blockName).charAt(c)) <= availableWidth; ++c) {
                    truncated.append(((String)blockName).charAt(c));
                }
                blockName = String.valueOf(truncated) + ellipsis;
            }
            context.method_25303(this.client.field_1772, (String)blockName, textX, textY, -1);
            String countText = "x" + blockCount.count;
            int countWidth = this.client.field_1772.method_1727(countText);
            context.method_25303(this.client.field_1772, countText, listRightEdge - countWidth - 5, textY, -5570816);
        }
        context.method_44380();
        if (this.scrollBar != null && this.scrollBar.isVisible() && this.client != null && (scrollChanged = this.scrollBar.updateAndRender(context, renderMouseX, renderMouseY, delta, this.client.method_22683().method_4490()))) {
            int maxScroll = this.getMaxScroll();
            this.scrollOffset = (int)(this.scrollBar.getScrollPercentage() * (double)maxScroll);
        }
        if (this.replacementPopup != null) {
            this.replacementPopup.method_25394(context, mouseX, mouseY, delta);
        }
    }

    private class_1799 getItemStackForBlock(String blockId) {
        try {
            class_2960 identifier = class_2960.method_12829((String)blockId);
            if (identifier == null) {
                return new class_1799((class_1935)class_1802.field_8077);
            }
            class_2248 block = (class_2248)class_7923.field_41175.method_63535(identifier);
            if (block == null || block == class_2246.field_10124) {
                return new class_1799((class_1935)class_1802.field_8077);
            }
            class_1792 item = block.method_8389();
            if (item == class_1802.field_8162) {
                return new class_1799((class_1935)class_1802.field_8077);
            }
            return new class_1799((class_1935)item);
        }
        catch (Exception e) {
            return new class_1799((class_1935)class_1802.field_8077);
        }
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        int clickedIndex;
        if (this.replacementPopup != null) {
            if (this.replacementPopup.mouseClicked(click.comp_4798(), click.comp_4799(), 0)) {
                return true;
            }
            return true;
        }
        if (this.closeButton != null && this.closeButton.method_25402(click, doubled)) {
            return true;
        }
        int listY = this.y + 58;
        int listHeight = this.height - 58 - 10;
        int listRightEdge = this.x + this.width - 10 - 8 - 2;
        int contentX = this.x + 10;
        if (click.comp_4798() >= (double)contentX && click.comp_4798() < (double)listRightEdge && click.comp_4799() >= (double)listY && click.comp_4799() < (double)(listY + listHeight) && (clickedIndex = this.scrollOffset + (int)((click.comp_4799() - (double)listY) / 24.0)) >= 0 && clickedIndex < this.blockCounts.size()) {
            LitematicParser.BlockCount blockCount = this.blockCounts.get(clickedIndex);
            this.openReplacementPopup(blockCount.blockId);
            return true;
        }
        return false;
    }

    private void openReplacementPopup(String blockId) {
        if (this.client == null) {
            return;
        }
        this.replacementPopup = new BlockReplacementPopup(this.client.method_22683().method_4486(), this.client.method_22683().method_4502(), blockId);
        this.replacementPopup.setOnBlockSelected((oldBlockId, newBlockId) -> {
            boolean success;
            if (this.litematicFile != null && (success = LitematicBlockReplacer.replaceBlock(this.litematicFile, oldBlockId, newBlockId))) {
                this.setFile(this.litematicFile);
            }
            this.replacementPopup = null;
        });
        this.replacementPopup.setOnCancel(() -> {
            this.replacementPopup = null;
        });
    }

    public boolean method_25406(class_11909 click) {
        if (this.closeButton != null) {
            return this.closeButton.method_25406(click);
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.replacementPopup != null) {
            return this.replacementPopup.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
        }
        if (mouseX < (double)this.x || mouseX > (double)(this.x + this.width) || mouseY < (double)this.y || mouseY > (double)(this.y + this.height)) {
            return false;
        }
        int maxScroll = this.getMaxScroll();
        this.scrollOffset = Math.max(0, Math.min(maxScroll, this.scrollOffset - (int)verticalAmount));
        if (this.scrollBar != null && maxScroll > 0) {
            this.scrollBar.setScrollPercentage((double)this.scrollOffset / (double)maxScroll);
        }
        return true;
    }

    private boolean isMouseOverButton(CustomButton button, double mouseX, double mouseY) {
        return button != null && mouseX >= (double)button.method_46426() && mouseX < (double)(button.method_46426() + button.method_25368()) && mouseY >= (double)button.method_46427() && mouseY < (double)(button.method_46427() + button.method_25364());
    }

    public void method_25365(boolean focused) {
    }

    public boolean method_25370() {
        return false;
    }
}

