/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui.widget;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.lwjgl.glfw.GLFW;

@Environment(value=EnvType.CLIENT)
public class KeyboardHelper {
    private final long windowHandle;

    public KeyboardHelper(long windowHandle) {
        this.windowHandle = windowHandle;
    }

    public boolean isKeyPressed(int key) {
        return GLFW.glfwGetKey((long)this.windowHandle, (int)key) == 1;
    }

    public boolean isCtrlHeld() {
        return this.isKeyPressed(341) || this.isKeyPressed(345);
    }

    public boolean isShiftHeld() {
        return this.isKeyPressed(340) || this.isKeyPressed(344);
    }

    public boolean isAltHeld() {
        return this.isKeyPressed(342) || this.isKeyPressed(346);
    }

    public boolean isMouseButtonPressed(int button) {
        return GLFW.glfwGetMouseButton((long)this.windowHandle, (int)button) == 1;
    }

    public boolean isLeftMousePressed() {
        return this.isMouseButtonPressed(0);
    }

    public boolean isRightMousePressed() {
        return this.isMouseButtonPressed(1);
    }
}

