/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui.widget;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class FileActionManager {
    private final List<FileAction> undoStack = new ArrayList<FileAction>();
    private final List<FileAction> redoStack = new ArrayList<FileAction>();
    private final int maxHistory;
    private final File trashFolder;

    public FileActionManager(File trashFolder, int maxHistory) {
        this.trashFolder = trashFolder;
        this.maxHistory = maxHistory;
        if (!trashFolder.exists()) {
            trashFolder.mkdirs();
        }
    }

    public void addAction(FileAction action) {
        this.undoStack.add(action);
        this.redoStack.clear();
        while (this.undoStack.size() > this.maxHistory) {
            FileAction removed = this.undoStack.removeFirst();
            this.cleanupAction(removed);
        }
    }

    public boolean canUndo() {
        return !this.undoStack.isEmpty();
    }

    public boolean canRedo() {
        return !this.redoStack.isEmpty();
    }

    public String performUndo() {
        if (this.undoStack.isEmpty()) {
            return null;
        }
        FileAction action = this.undoStack.removeLast();
        String result = this.executeUndo(action);
        if (result != null) {
            this.limitStackSize(this.redoStack);
            this.redoStack.add(action);
        }
        return result;
    }

    public String performRedo() {
        if (this.redoStack.isEmpty()) {
            return null;
        }
        FileAction action = this.redoStack.removeLast();
        String result = this.executeRedo(action);
        if (result != null) {
            this.limitStackSize(this.undoStack);
            this.undoStack.add(action);
        }
        return result;
    }

    private void limitStackSize(List<FileAction> stack) {
        while (stack.size() >= this.maxHistory) {
            FileAction removed = stack.removeFirst();
            if (stack != this.undoStack) continue;
            this.cleanupAction(removed);
        }
    }

    private String executeUndo(FileAction action) {
        return switch (action.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.undoMove(action);
            case 1 -> this.undoDelete(action);
            case 2 -> this.undoRename(action);
            case 3 -> this.undoCreateFolder(action);
        };
    }

    private String executeRedo(FileAction action) {
        return switch (action.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.redoMove(action);
            case 1 -> this.redoDelete(action);
            case 2 -> this.redoRename(action);
            case 3 -> this.redoCreateFolder(action);
        };
    }

    private String undoMove(FileAction action) {
        int successCount = this.moveFiles(action.operations, true);
        return successCount > 0 ? "Undid move of " + successCount + " item(s)" : null;
    }

    private String undoDelete(FileAction action) {
        int successCount = this.moveFiles(action.operations, true);
        return successCount > 0 ? "Restored " + successCount + " item(s)" : null;
    }

    private String undoRename(FileAction action) {
        if (action.operations.isEmpty()) {
            return null;
        }
        FileOperation op = action.operations.getFirst();
        if (this.renameFile(op.destination, op.source)) {
            return "Undid rename of \"" + op.destination.getName() + "\"";
        }
        return null;
    }

    private String undoCreateFolder(FileAction action) {
        File[] contents;
        if (action.operations.isEmpty()) {
            return null;
        }
        FileOperation op = action.operations.getFirst();
        if (op.destination.exists() && op.destination.isDirectory() && ((contents = op.destination.listFiles()) == null || contents.length == 0) && op.destination.delete()) {
            return "Undid creation of \"" + op.destination.getName() + "\"";
        }
        return null;
    }

    private String redoMove(FileAction action) {
        int successCount = this.moveFiles(action.operations, false);
        return successCount > 0 ? "Redid move of " + successCount + " item(s)" : null;
    }

    private String redoDelete(FileAction action) {
        int successCount = this.moveFiles(action.operations, false);
        return successCount > 0 ? "Deleted " + successCount + " item(s) again" : null;
    }

    private String redoRename(FileAction action) {
        if (action.operations.isEmpty()) {
            return null;
        }
        FileOperation op = action.operations.getFirst();
        if (this.renameFile(op.source, op.destination)) {
            return "Redid rename to \"" + op.destination.getName() + "\"";
        }
        return null;
    }

    private String redoCreateFolder(FileAction action) {
        if (action.operations.isEmpty()) {
            return null;
        }
        FileOperation op = action.operations.getFirst();
        if (!op.destination.exists() && op.destination.mkdir()) {
            return "Recreated folder \"" + op.destination.getName() + "\"";
        }
        return null;
    }

    private int moveFiles(List<FileOperation> operations, boolean reverse) {
        int successCount = 0;
        for (FileOperation op : operations) {
            File to;
            File from = reverse ? op.destination : op.source;
            if (!this.renameFile(from, to = reverse ? op.source : op.destination)) continue;
            ++successCount;
        }
        return successCount;
    }

    private boolean renameFile(File from, File to) {
        return from.exists() && !to.exists() && from.renameTo(to);
    }

    private void cleanupAction(FileAction action) {
        if (action.type == ActionType.DELETE) {
            for (FileOperation op : action.operations) {
                if (!op.destination.exists() || !op.destination.getAbsolutePath().contains(".trash")) continue;
                this.deleteRecursively(op.destination);
            }
        }
    }

    private void deleteRecursively(File file) {
        File[] children;
        if (file.isDirectory() && (children = file.listFiles()) != null) {
            for (File child : children) {
                this.deleteRecursively(child);
            }
        }
        file.delete();
    }

    public String getUndoDescription() {
        if (this.undoStack.isEmpty()) {
            return null;
        }
        FileAction action = this.undoStack.getLast();
        return this.getActionDescription(action, "Undo");
    }

    public String getRedoDescription() {
        if (this.redoStack.isEmpty()) {
            return null;
        }
        FileAction action = this.redoStack.getLast();
        return this.getActionDescription(action, "Redo");
    }

    private String getActionDescription(FileAction action, String prefix) {
        return switch (action.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> prefix + " move";
            case 1 -> prefix + " delete";
            case 2 -> {
                if (!action.operations.isEmpty()) {
                    yield prefix + " rename of \"" + action.operations.getFirst().source.getName() + "\"";
                }
                yield prefix + " rename";
            }
            case 3 -> !action.operations.isEmpty() ? prefix + " creation of \"" + action.operations.getFirst().destination.getName() + "\"" : prefix + " folder creation";
        };
    }

    @Environment(value=EnvType.CLIENT)
    public static class FileAction {
        public final ActionType type;
        public final List<FileOperation> operations;

        public FileAction(ActionType type, List<FileOperation> operations) {
            this.type = type;
            this.operations = operations;
        }

        public FileAction(ActionType type, FileOperation operation) {
            this.type = type;
            this.operations = new ArrayList<FileOperation>();
            this.operations.add(operation);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum ActionType {
        MOVE,
        DELETE,
        RENAME,
        CREATE_FOLDER;

    }

    @Environment(value=EnvType.CLIENT)
    public static class FileOperation {
        public final File source;
        public final File destination;
        public final boolean wasDirectory;

        public FileOperation(File source, File destination, boolean wasDirectory) {
            this.source = source;
            this.destination = destination;
            this.wasDirectory = wasDirectory;
        }
    }
}

