/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui.widget;

import com.choculaterie.gui.widget.CustomButton;
import com.choculaterie.gui.widget.CustomTextField;
import com.choculaterie.gui.widget.ScrollBar;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4068;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class BlockReplacementPopup
implements class_4068 {
    private final class_310 client;
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private CustomTextField searchField;
    private CustomButton cancelButton;
    private CustomButton replaceButton;
    private final List<class_2248> allBlocks = new ArrayList<class_2248>();
    private final List<class_2248> filteredBlocks = new ArrayList<class_2248>();
    private int scrollOffset = 0;
    private ScrollBar scrollBar;
    private int selectedIndex = -1;
    private final String originalBlockId;
    private BiConsumer<String, String> onBlockSelected;
    private Runnable onCancel;
    private static final int ITEM_HEIGHT = 24;
    private static final int HEADER_HEIGHT = 90;

    public BlockReplacementPopup(int screenWidth, int screenHeight, String originalBlockId) {
        this.client = class_310.method_1551();
        this.originalBlockId = originalBlockId;
        this.width = Math.min(400, screenWidth - 40);
        this.height = Math.min(500, screenHeight - 40);
        this.x = (screenWidth - this.width) / 2;
        this.y = (screenHeight - this.height) / 2;
        this.loadAllBlocks();
        this.filteredBlocks.addAll(this.allBlocks);
        if (this.client != null) {
            int searchFieldWidth = this.width - 20;
            this.searchField = new CustomTextField(this.client, this.x + 10, this.y + 10 + 12 + 10, searchFieldWidth, 20, class_2561.method_30163((String)"Search"));
            this.searchField.method_47404(class_2561.method_30163((String)"Search blocks..."));
            this.searchField.setOnChanged(() -> this.onSearchChanged(this.searchField.method_1882()));
            this.searchField.method_25365(true);
        }
        int buttonWidth = 80;
        this.cancelButton = new CustomButton(this.x + 10, this.y + this.height - 10 - 20, buttonWidth, 20, class_2561.method_30163((String)"Cancel"), btn -> {
            if (this.onCancel != null) {
                this.onCancel.run();
            }
        });
        this.replaceButton = new CustomButton(this.x + this.width - 10 - buttonWidth, this.y + this.height - 10 - 20, buttonWidth, 20, class_2561.method_30163((String)"Replace"), btn -> {
            if (this.selectedIndex >= 0 && this.selectedIndex < this.filteredBlocks.size()) {
                class_2248 selectedBlock = this.filteredBlocks.get(this.selectedIndex);
                String newBlockId = class_7923.field_41175.method_10221((Object)selectedBlock).toString();
                if (this.onBlockSelected != null) {
                    this.onBlockSelected.accept(originalBlockId, newBlockId);
                }
            }
        });
        this.updateScrollBar();
    }

    private void loadAllBlocks() {
        for (class_2960 id : class_7923.field_41175.method_10235()) {
            class_2248 block = (class_2248)class_7923.field_41175.method_63535(id);
            if (block == null || block.method_8389().equals(class_1802.field_8162)) continue;
            this.allBlocks.add(block);
        }
        this.allBlocks.sort((a, b) -> {
            String nameA = class_7923.field_41175.method_10221(a).method_12832();
            String nameB = class_7923.field_41175.method_10221(b).method_12832();
            return nameA.compareTo(nameB);
        });
    }

    private void onSearchChanged(String search) {
        this.filteredBlocks.clear();
        String lowerSearch = search.toLowerCase();
        if (search.isEmpty()) {
            this.filteredBlocks.addAll(this.allBlocks);
        } else {
            for (class_2248 block : this.allBlocks) {
                String blockName = class_7923.field_41175.method_10221((Object)block).method_12832();
                if (!blockName.contains(lowerSearch)) continue;
                this.filteredBlocks.add(block);
            }
        }
        this.scrollOffset = 0;
        this.updateScrollBar();
    }

    private void updateScrollBar() {
        int listY = this.y + 90;
        int listHeight = this.height - 90 - 10 - 20 - 10;
        int scrollBarX = this.x + this.width - 10 - 8;
        this.scrollBar = new ScrollBar(scrollBarX, listY, listHeight);
        int contentHeight = this.filteredBlocks.size() * 24;
        this.scrollBar.setScrollData(contentHeight, listHeight);
    }

    private int getMaxScroll() {
        int listHeight = this.height - 90 - 10 - 20 - 10;
        int contentHeight = this.filteredBlocks.size() * 24;
        return contentHeight <= listHeight ? 0 : this.filteredBlocks.size() - listHeight / 24;
    }

    public void setOnBlockSelected(BiConsumer<String, String> callback) {
        this.onBlockSelected = callback;
    }

    public void setOnCancel(Runnable callback) {
        this.onCancel = callback;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        boolean scrollChanged;
        context.method_25294(0, 0, this.client.method_22683().method_4486(), this.client.method_22683().method_4502(), Integer.MIN_VALUE);
        context.method_25294(this.x, this.y, this.x + this.width, this.y + this.height, -14013910);
        context.method_25294(this.x, this.y, this.x + this.width, this.y + 1, -11184811);
        context.method_25294(this.x, this.y + this.height - 1, this.x + this.width, this.y + this.height, -11184811);
        context.method_25294(this.x, this.y, this.x + 1, this.y + this.height, -11184811);
        context.method_25294(this.x + this.width - 1, this.y, this.x + this.width, this.y + this.height, -11184811);
        String title = "Replace: " + this.getSimpleBlockName(this.originalBlockId);
        context.method_25300(this.client.field_1772, title, this.x + this.width / 2, this.y + 10, -1);
        if (this.searchField != null) {
            this.searchField.method_25394(context, mouseX, mouseY, delta);
        }
        int listY = this.y + 90;
        int listHeight = this.height - 90 - 10 - 20 - 10;
        int listRightEdge = this.x + this.width - 10 - 8 - 2;
        context.method_25294(this.x + 10, listY, listRightEdge, listY + listHeight, -15066598);
        context.method_44379(this.x + 10, listY, listRightEdge, listY + listHeight);
        int maxVisibleItems = listHeight / 24 + 1;
        for (int i = this.scrollOffset; i < Math.min(this.filteredBlocks.size(), this.scrollOffset + maxVisibleItems); ++i) {
            boolean isHovered;
            class_2248 block = this.filteredBlocks.get(i);
            int itemY = listY + (i - this.scrollOffset) * 24;
            boolean isSelected = i == this.selectedIndex;
            boolean bl = isHovered = mouseX >= this.x + 10 && mouseX < listRightEdge && mouseY >= itemY && mouseY < itemY + 24;
            int bgColor = isSelected ? -11513776 : (isHovered ? -12566464 : -15066598);
            context.method_25294(this.x + 10 + 2, itemY, listRightEdge - 2, itemY + 24, bgColor);
            class_1799 itemStack = new class_1799((class_1935)block.method_8389());
            context.method_51427(itemStack, this.x + 10 + 4, itemY + 4);
            String blockName = this.getSimpleBlockName(class_7923.field_41175.method_10221((Object)block).toString());
            context.method_25303(this.client.field_1772, blockName, this.x + 10 + 24, itemY + 8, -1);
        }
        context.method_44380();
        if (this.scrollBar != null && this.scrollBar.isVisible() && this.client != null && (scrollChanged = this.scrollBar.updateAndRender(context, mouseX, mouseY, delta, this.client.method_22683().method_4490()))) {
            int maxScroll = this.getMaxScroll();
            this.scrollOffset = (int)(this.scrollBar.getScrollPercentage() * (double)maxScroll);
        }
        if (this.replaceButton != null) {
            boolean bl = this.replaceButton.field_22763 = this.selectedIndex >= 0;
        }
        if (this.cancelButton != null) {
            this.cancelButton.method_25394(context, mouseX, mouseY, delta);
        }
        if (this.replaceButton != null) {
            this.replaceButton.method_25394(context, mouseX, mouseY, delta);
        }
    }

    private String getSimpleBlockName(String blockId) {
        if (blockId.startsWith("minecraft:")) {
            blockId = blockId.substring("minecraft:".length());
        }
        String[] words = blockId.split("_");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (!result.isEmpty()) {
                result.append(" ");
            }
            result.append(word.substring(0, 1).toUpperCase()).append(word.substring(1));
        }
        return result.toString();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int clickedIndex;
        if (button != 0) {
            return true;
        }
        if (mouseX < (double)this.x || mouseX > (double)(this.x + this.width) || mouseY < (double)this.y || mouseY > (double)(this.y + this.height)) {
            if (this.onCancel != null) {
                this.onCancel.run();
            }
            return true;
        }
        if (this.searchField != null) {
            boolean clickedInField = mouseX >= (double)this.searchField.method_46426() && mouseX < (double)(this.searchField.method_46426() + this.searchField.method_25368()) && mouseY >= (double)this.searchField.method_46427() && mouseY < (double)(this.searchField.method_46427() + this.searchField.method_25364());
            this.searchField.method_25365(clickedInField);
            if (clickedInField) {
                return true;
            }
        }
        if (this.cancelButton != null) {
            boolean isOverCancel;
            boolean bl = isOverCancel = mouseX >= (double)this.cancelButton.method_46426() && mouseX < (double)(this.cancelButton.method_46426() + this.cancelButton.method_25368()) && mouseY >= (double)this.cancelButton.method_46427() && mouseY < (double)(this.cancelButton.method_46427() + this.cancelButton.method_25364());
            if (isOverCancel) {
                if (this.onCancel != null) {
                    this.onCancel.run();
                }
                return true;
            }
        }
        if (this.replaceButton != null) {
            boolean isOverReplace;
            boolean bl = isOverReplace = mouseX >= (double)this.replaceButton.method_46426() && mouseX < (double)(this.replaceButton.method_46426() + this.replaceButton.method_25368()) && mouseY >= (double)this.replaceButton.method_46427() && mouseY < (double)(this.replaceButton.method_46427() + this.replaceButton.method_25364());
            if (isOverReplace) {
                if (this.selectedIndex >= 0 && this.selectedIndex < this.filteredBlocks.size()) {
                    class_2248 selectedBlock = this.filteredBlocks.get(this.selectedIndex);
                    String newBlockId = class_7923.field_41175.method_10221((Object)selectedBlock).toString();
                    if (this.onBlockSelected != null) {
                        this.onBlockSelected.accept(this.originalBlockId, newBlockId);
                    }
                }
                return true;
            }
        }
        int listY = this.y + 90;
        int listHeight = this.height - 90 - 10 - 20 - 10;
        int listRightEdge = this.x + this.width - 10 - 8 - 2;
        if (mouseX >= (double)(this.x + 10) && mouseX < (double)listRightEdge && mouseY >= (double)listY && mouseY < (double)(listY + listHeight) && (clickedIndex = this.scrollOffset + (int)((mouseY - (double)listY) / 24.0)) >= 0 && clickedIndex < this.filteredBlocks.size()) {
            this.selectedIndex = clickedIndex;
            return true;
        }
        return true;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int listY = this.y + 90;
        int listHeight = this.height - 90 - 10 - 20 - 10;
        if (mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)listY && mouseY < (double)(listY + listHeight)) {
            int maxScroll = this.getMaxScroll();
            this.scrollOffset = Math.max(0, Math.min(maxScroll, this.scrollOffset - (int)verticalAmount));
            if (this.scrollBar != null && maxScroll > 0) {
                this.scrollBar.setScrollPercentage((double)this.scrollOffset / (double)maxScroll);
            }
            return true;
        }
        return false;
    }
}

