/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui.localfolder;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class LocalFolderSelectionManager {
    private final List<Integer> selectedIndices = new ArrayList<Integer>();
    private int lastClickedIndex = -1;

    public void selectSingle(int index) {
        this.selectedIndices.clear();
        this.selectedIndices.add(index);
        this.lastClickedIndex = index;
    }

    public void toggleSelection(int index) {
        if (this.selectedIndices.contains(index)) {
            this.selectedIndices.remove((Object)index);
        } else {
            this.selectedIndices.add(index);
        }
        this.lastClickedIndex = index;
    }

    public void selectRange(int index) {
        if (this.lastClickedIndex == -1) {
            this.selectSingle(index);
            return;
        }
        this.selectedIndices.clear();
        int start = Math.min(this.lastClickedIndex, index);
        int end = Math.max(this.lastClickedIndex, index);
        for (int i = start; i <= end; ++i) {
            this.selectedIndices.add(i);
        }
    }

    public void selectAll(int totalItems) {
        this.selectedIndices.clear();
        for (int i = 0; i < totalItems; ++i) {
            this.selectedIndices.add(i);
        }
    }

    public void clearSelection() {
        this.selectedIndices.clear();
        this.lastClickedIndex = -1;
    }

    public boolean isSelected(int index) {
        return this.selectedIndices.contains(index);
    }

    public List<Integer> getSelectedIndices() {
        return new ArrayList<Integer>(this.selectedIndices);
    }

    public int getSelectionCount() {
        return this.selectedIndices.size();
    }

    public boolean hasSelection() {
        return !this.selectedIndices.isEmpty();
    }

    public void saveSelection() {
    }

    public void restoreSelection() {
    }
}

