/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui.localfolder;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class FileOperationsManager {
    private final File baseDirectory;
    private final File trashFolder;
    private final List<FileAction> undoStack = new ArrayList<FileAction>();
    private final List<FileAction> redoStack = new ArrayList<FileAction>();
    private static final int MAX_UNDO_HISTORY = 50;

    public FileOperationsManager(File baseDirectory, File trashFolder) {
        this.baseDirectory = baseDirectory;
        this.trashFolder = trashFolder;
    }

    public void moveFiles(List<File> files, File targetFolder) {
        ArrayList<FileOperation> operations = new ArrayList<FileOperation>();
        for (File file : files) {
            File destination = new File(targetFolder, file.getName());
            operations.add(new FileOperation(file, destination, file.isDirectory()));
            file.renameTo(destination);
        }
        this.recordAction(new FileAction(FileAction.Type.MOVE, operations));
    }

    public void deleteFiles(List<File> files) {
        ArrayList<FileOperation> operations = new ArrayList<FileOperation>();
        for (File file : files) {
            operations.add(new FileOperation(file, new File(this.trashFolder, file.getName()), file.isDirectory()));
            this.moveToTrash(file);
        }
        this.recordAction(new FileAction(FileAction.Type.DELETE, operations));
    }

    public void renameFile(File file, String newName) {
        File newFile = new File(file.getParent(), newName);
        file.renameTo(newFile);
        this.recordAction(new FileAction(FileAction.Type.RENAME, new FileOperation(file, newFile, file.isDirectory())));
    }

    public void createFolder(String folderName, File parentDir) {
        File newFolder = new File(parentDir, folderName);
        newFolder.mkdirs();
        this.recordAction(new FileAction(FileAction.Type.CREATE_FOLDER, new FileOperation(newFolder, newFolder, true)));
    }

    public void performUndo() {
        if (this.undoStack.isEmpty()) {
            return;
        }
        FileAction action = this.undoStack.remove(this.undoStack.size() - 1);
        this.reverseAction(action);
        this.redoStack.add(action);
    }

    public void performRedo() {
        if (this.redoStack.isEmpty()) {
            return;
        }
        FileAction action = this.redoStack.remove(this.redoStack.size() - 1);
        this.executeAction(action);
        this.undoStack.add(action);
    }

    private void reverseAction(FileAction action) {
        for (FileOperation op : action.operations) {
            if (action.type == FileAction.Type.DELETE) {
                op.source.renameTo(op.destination);
                continue;
            }
            if (action.type != FileAction.Type.MOVE) continue;
            op.destination.renameTo(op.source);
        }
    }

    private void executeAction(FileAction action) {
        for (FileOperation op : action.operations) {
            op.source.renameTo(op.destination);
        }
    }

    private void recordAction(FileAction action) {
        this.undoStack.add(action);
        this.redoStack.clear();
        if (this.undoStack.size() > 50) {
            this.undoStack.remove(0);
        }
    }

    private void moveToTrash(File file) {
        if (file.isDirectory()) {
            this.moveDirectoryToTrash(file);
        } else {
            file.renameTo(new File(this.trashFolder, file.getName()));
        }
    }

    private void moveDirectoryToTrash(File directory) {
        File trashDest = new File(this.trashFolder, directory.getName());
        directory.renameTo(trashDest);
    }

    public boolean deleteDirectoryRecursively(File directory) {
        File[] files;
        if (directory.isDirectory() && (files = directory.listFiles()) != null) {
            for (File file : files) {
                this.deleteDirectoryRecursively(file);
            }
        }
        return directory.delete();
    }

    public boolean canUndo() {
        return !this.undoStack.isEmpty();
    }

    public boolean canRedo() {
        return !this.redoStack.isEmpty();
    }

    @Environment(value=EnvType.CLIENT)
    public static class FileOperation {
        public final File source;
        public final File destination;
        public final boolean wasDirectory;

        public FileOperation(File source, File destination, boolean wasDirectory) {
            this.source = source;
            this.destination = destination;
            this.wasDirectory = wasDirectory;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class FileAction {
        public final Type type;
        public final List<FileOperation> operations;

        public FileAction(Type type, List<FileOperation> operations) {
            this.type = type;
            this.operations = operations;
        }

        public FileAction(Type type, FileOperation operation) {
            this.type = type;
            this.operations = new ArrayList<FileOperation>();
            this.operations.add(operation);
        }

        @Environment(value=EnvType.CLIENT)
        public static enum Type {
            MOVE,
            DELETE,
            RENAME,
            CREATE_FOLDER;

        }
    }
}

