/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui;

import com.choculaterie.config.DownloadSettings;
import com.choculaterie.gui.DirectoryPickerScreen;
import com.choculaterie.gui.widget.ConfirmPopup;
import com.choculaterie.gui.widget.CustomButton;
import com.choculaterie.gui.widget.CustomTextField;
import com.choculaterie.gui.widget.ToastManager;
import com.choculaterie.gui.widget.ToggleButton;
import java.io.File;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class SettingsPage
extends class_437 {
    private static final int PADDING = 10;
    private static final int BACK_BUTTON_SIZE = 20;
    private static final int LABEL_HEIGHT = 20;
    private static final int TEXT_FIELD_HEIGHT = 20;
    private static final int TOGGLE_SPACING = 25;
    private static final String TITLE = "Settings";
    private final class_437 parentScreen;
    private CustomTextField downloadPathField;
    private CustomButton setPathButton;
    private ToastManager toastManager;
    private ConfirmPopup activePopup;
    private String pendingToastMessage;
    private boolean pendingToastSuccess;
    private Runnable onApiToggleChanged;

    public SettingsPage(class_437 parentScreen) {
        super(class_2561.method_30163((String)TITLE));
        this.parentScreen = parentScreen;
    }

    public void setOnApiToggleChanged(Runnable callback) {
        this.onApiToggleChanged = callback;
    }

    protected void method_25426() {
        super.method_25426();
        if (this.field_22787 != null) {
            this.toastManager = new ToastManager(this.field_22787);
        }
        this.addBackButton();
        int contentY = this.initDownloadPathSection();
        this.initToastToggles(contentY);
    }

    private void addBackButton() {
        CustomButton backButton = new CustomButton(10, 10, 20, 20, class_2561.method_30163((String)"\u2190"), button -> this.goBack());
        this.method_37063((class_364)backButton);
    }

    private int initDownloadPathSection() {
        boolean isVeryCompact;
        int contentY = 60;
        boolean bl = isVeryCompact = this.field_22789 < 300;
        int browseButtonWidth = isVeryCompact ? 50 : (this.field_22789 < 400 ? 70 : 90);
        String browseLabel = isVeryCompact ? "..." : "Browse...";
        int setButtonSize = 20;
        int setButtonX = this.field_22789 - 20 - setButtonSize;
        int browseButtonX = setButtonX - 10 - browseButtonWidth;
        int fieldWidth = Math.max(100, browseButtonX - 30);
        if (this.field_22787 != null) {
            this.downloadPathField = new CustomTextField(this.field_22787, 20, contentY + 20, fieldWidth, 20, class_2561.method_30163((String)"Download Path"));
            this.downloadPathField.method_1852(DownloadSettings.getInstance().getDownloadPath());
            this.downloadPathField.method_47404(class_2561.method_30163((String)"Enter download path..."));
        }
        CustomButton browseButton = new CustomButton(browseButtonX, contentY + 20, browseButtonWidth, 20, class_2561.method_30163((String)browseLabel), button -> this.openFileDialog());
        this.method_37063((class_364)browseButton);
        this.setPathButton = new CustomButton(setButtonX, contentY + 20, setButtonSize, setButtonSize, class_2561.method_30163((String)"\u2713"), button -> this.saveDownloadPath());
        this.setPathButton.field_22764 = false;
        this.method_37063((class_364)this.setPathButton);
        return contentY;
    }

    private void initToastToggles(int contentY) {
        int toastsY = contentY + 20 + 20 + 30;
        DownloadSettings settings = DownloadSettings.getInstance();
        this.createToastToggle(0, toastsY, settings.isInfoToastsEnabled(), settings::setInfoToastsEnabled);
        this.createToastToggle(1, toastsY, settings.isSuccessToastsEnabled(), settings::setSuccessToastsEnabled);
        this.createToastToggle(2, toastsY, settings.isWarningToastsEnabled(), settings::setWarningToastsEnabled);
        this.createToastToggle(3, toastsY, settings.isErrorToastsEnabled(), settings::setErrorToastsEnabled);
        int apiToggleY = toastsY + 20 + 100 + 20;
        ToggleButton apiToggle = new ToggleButton(220, apiToggleY, settings.isUseChoculaterieAPI(), enabled -> {
            settings.setUseChoculaterieAPI((boolean)enabled);
            if (this.onApiToggleChanged != null) {
                this.onApiToggleChanged.run();
            }
        });
        this.method_37063((class_364)apiToggle);
    }

    private void createToastToggle(int index, int baseY, boolean enabled, Consumer<Boolean> callback) {
        ToggleButton toggle = new ToggleButton(140, baseY + 20 + 25 * index, enabled, callback);
        this.method_37063((class_364)toggle);
    }

    private void goBack() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parentScreen);
        }
    }

    private void openFileDialog() {
        if (this.field_22787 != null) {
            String startPath = DownloadSettings.getInstance().getAbsoluteDownloadPath();
            DirectoryPickerScreen picker = new DirectoryPickerScreen(this, startPath, selectedPath -> {
                if (this.downloadPathField != null) {
                    this.downloadPathField.method_1852((String)selectedPath);
                }
                if (selectedPath != null && !selectedPath.isEmpty()) {
                    DownloadSettings.getInstance().setDownloadPath((String)selectedPath);
                    System.out.println("Download path saved from directory picker: " + selectedPath);
                    this.pendingToastMessage = "Download path updated!";
                    this.pendingToastSuccess = true;
                } else {
                    this.pendingToastMessage = "Failed to select folder";
                    this.pendingToastSuccess = false;
                }
            });
            this.field_22787.method_1507((class_437)picker);
        }
    }

    private void saveDownloadPath() {
        if (this.downloadPathField == null) {
            return;
        }
        String newPath = this.downloadPathField.method_1882();
        if (newPath == null || newPath.isEmpty()) {
            return;
        }
        String absolutePath = DownloadSettings.getInstance().getGameDirectory() + File.separator + newPath;
        File directory = new File(absolutePath);
        if (directory.exists()) {
            this.completeSave(newPath);
        } else {
            this.showCreateFolderConfirmation(newPath, directory);
        }
    }

    private void showCreateFolderConfirmation(String relativePath, File directory) {
        this.activePopup = new ConfirmPopup(this, "Create Folder?", "The folder '" + relativePath + "' does not exist.\n\nDo you want to create it?", () -> this.createFolderAndSave(directory, relativePath), () -> {
            this.activePopup = null;
        }, "Create");
    }

    private void createFolderAndSave(File directory, String relativePath) {
        if (directory.mkdirs()) {
            this.completeSave(relativePath);
        } else if (this.toastManager != null) {
            this.toastManager.showError("Failed to create folder!");
        }
        this.activePopup = null;
    }

    private void completeSave(String newPath) {
        DownloadSettings.getInstance().setDownloadPath(newPath);
        if (this.toastManager != null) {
            this.toastManager.showSuccess("Download path saved!");
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.showPendingToast();
        context.method_25294(0, 0, this.field_22789, this.field_22790, -14671840);
        super.method_25394(context, mouseX, mouseY, delta);
        int contentY = this.renderTitleAndDownloadSection(context, mouseX, mouseY, delta);
        this.renderToastTogglesSection(context, contentY);
        this.renderOverlays(context, mouseX, mouseY, delta);
    }

    private void showPendingToast() {
        if (this.pendingToastMessage == null || this.toastManager == null) {
            return;
        }
        if (this.pendingToastSuccess) {
            this.toastManager.showSuccess(this.pendingToastMessage);
        } else {
            this.toastManager.showError(this.pendingToastMessage);
        }
        this.pendingToastMessage = null;
    }

    private int renderTitleAndDownloadSection(class_332 context, int mouseX, int mouseY, float delta) {
        int titleX = (this.field_22789 - this.field_22793.method_1727(TITLE)) / 2;
        context.method_25303(this.field_22793, TITLE, titleX, 40, -1);
        int contentY = 60;
        context.method_25303(this.field_22793, "Download Path (relative to game folder):", 20, contentY, -1);
        this.renderDownloadPathField(context, contentY, mouseX, mouseY, delta);
        return contentY;
    }

    private void renderDownloadPathField(class_332 context, int contentY, int mouseX, int mouseY, float delta) {
        if (this.downloadPathField == null) {
            return;
        }
        this.downloadPathField.method_25394(context, mouseX, mouseY, delta);
        String currentText = this.downloadPathField.method_1882();
        String savedPath = DownloadSettings.getInstance().getDownloadPath();
        if (this.setPathButton != null) {
            this.setPathButton.field_22764 = !currentText.equals(savedPath);
        }
        String previewText = "Full path: " + DownloadSettings.getInstance().getAbsoluteDownloadPath();
        context.method_25303(this.field_22793, previewText, 20, contentY + 20 + 20 + 5, -5592406);
    }

    private void renderToastTogglesSection(class_332 context, int contentY) {
        int toastsY = contentY + 20 + 20 + 30;
        context.method_25303(this.field_22793, "Show Notifications:", 20, toastsY, -1);
        this.renderToastToggleLabel(context, "Info:", toastsY, 0, -14575885);
        this.renderToastToggleLabel(context, "Success:", toastsY, 1, -11751600);
        this.renderToastToggleLabel(context, "Warning:", toastsY, 2, -16121);
        this.renderToastToggleLabel(context, "Error:", toastsY, 3, -44462);
        int apiToggleY = toastsY + 20 + 100 + 20;
        context.method_25303(this.field_22793, "Use Choculaterie API:", 20, apiToggleY + 6, -1);
    }

    private void renderToastToggleLabel(class_332 context, String label, int baseY, int index, int color) {
        int y = baseY + 20 + 25 * index + 6;
        context.method_25303(this.field_22793, label, 20, y, color);
    }

    private void renderOverlays(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.toastManager != null) {
            this.toastManager.render(context, delta, mouseX, mouseY);
        }
        if (this.activePopup != null) {
            this.activePopup.method_25394(context, mouseX, mouseY, delta);
        }
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        double mouseX = click.comp_4798();
        double mouseY = click.comp_4799();
        int button = click.method_74245();
        if (this.activePopup != null) {
            return this.activePopup.mouseClicked(mouseX, mouseY, button);
        }
        if (button == 0 && this.downloadPathField != null) {
            if (this.downloadPathField.method_25405(mouseX, mouseY)) {
                this.downloadPathField.method_25365(true);
                return true;
            }
            this.downloadPathField.method_25365(false);
        }
        return super.method_25402(click, doubled);
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25422() {
        if (this.activePopup != null) {
            this.activePopup = null;
            return false;
        }
        return super.method_25422();
    }

    public void method_25419() {
        this.goBack();
    }
}

