/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.network;

import com.choculaterie.models.ModMessage;
import com.choculaterie.models.QuickShareResponse;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ChoculaterieNetworkManager {
    private static final String BASE_URL = "https://choculaterie.com/api/LitematicDownloaderModAPI";
    private static final String UPLOAD_ENDPOINT = "https://choculaterie.com/api/LitematicDownloaderModAPI/upload";
    private static final String MESSAGE_ENDPOINT = "https://choculaterie.com/api/LitematicDownloaderModAPI/GetModMessage";
    private static final Gson GSON = new Gson();
    private static final int TIMEOUT_STANDARD = 10000;
    private static final int TIMEOUT_UPLOAD = 30000;
    private static final String BOUNDARY = "----WebKitFormBoundary" + System.currentTimeMillis();
    private static final String LITEMATIC_EXTENSION = ".litematic";

    public static CompletableFuture<QuickShareResponse> uploadLitematic(File file) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                ChoculaterieNetworkManager.validateFile(file);
                byte[] fileBytes = Files.readAllBytes(file.toPath());
                String jsonResponse = ChoculaterieNetworkManager.uploadMultipartFile(file.getName(), fileBytes);
                return ChoculaterieNetworkManager.parseQuickShareResponse(jsonResponse);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to upload litematic file", e);
            }
        });
    }

    public static CompletableFuture<ModMessage> getModMessage() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String jsonResponse = ChoculaterieNetworkManager.makeGetRequest();
                return ChoculaterieNetworkManager.parseModMessage(jsonResponse);
            }
            catch (Exception e) {
                return new ModMessage(false, null, null, null);
            }
        });
    }

    private static void validateFile(File file) throws IOException {
        if (file == null || !file.exists()) {
            throw new IOException("File does not exist");
        }
        if (!file.getName().toLowerCase().endsWith(LITEMATIC_EXTENSION)) {
            throw new IOException("Only .litematic files are allowed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String uploadMultipartFile(String fileName, byte[] fileBytes) throws IOException {
        URL url = new URL(UPLOAD_ENDPOINT);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        try {
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setConnectTimeout(30000);
            conn.setReadTimeout(30000);
            conn.setRequestProperty("User-Agent", "LitematicDownloader/1.0");
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
            try (DataOutputStream out = new DataOutputStream(conn.getOutputStream());){
                out.writeBytes("--" + BOUNDARY + "\r\n");
                out.writeBytes("Content-Disposition: form-data; name=\"file\"; filename=\"" + fileName + "\"\r\n");
                out.writeBytes("Content-Type: application/octet-stream\r\n");
                out.writeBytes("\r\n");
                out.write(fileBytes);
                out.writeBytes("\r\n");
                out.writeBytes("--" + BOUNDARY + "--\r\n");
                out.flush();
            }
            int responseCode = conn.getResponseCode();
            InputStream stream = responseCode >= 200 && responseCode < 300 ? conn.getInputStream() : conn.getErrorStream();
            String response = ChoculaterieNetworkManager.readStream(stream);
            if (responseCode != 200) {
                throw new IOException("HTTP error: " + responseCode + ", response: " + response);
            }
            String string = response;
            return string;
        }
        finally {
            conn.disconnect();
        }
    }

    private static String makeGetRequest() throws IOException {
        URL url = new URL(MESSAGE_ENDPOINT);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        try {
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            conn.setRequestProperty("User-Agent", "LitematicDownloader/1.0");
            if (conn.getResponseCode() != 200) {
                throw new IOException("HTTP error: " + conn.getResponseCode());
            }
            String string = ChoculaterieNetworkManager.readStream(conn.getInputStream());
            return string;
        }
        finally {
            conn.disconnect();
        }
    }

    private static String readStream(InputStream stream) throws IOException {
        if (stream == null) {
            return "";
        }
        StringBuilder response = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
        }
        return response.toString();
    }

    private static QuickShareResponse parseQuickShareResponse(String json) {
        JsonObject root = (JsonObject)GSON.fromJson(json, JsonObject.class);
        if (!root.has("shortUrl")) {
            throw new RuntimeException("Response does not contain shortUrl");
        }
        return new QuickShareResponse(root.get("shortUrl").getAsString());
    }

    private static ModMessage parseModMessage(String json) {
        JsonObject root = (JsonObject)GSON.fromJson(json, JsonObject.class);
        boolean hasMessage = ChoculaterieNetworkManager.getBoolean(root);
        if (!hasMessage) {
            return new ModMessage(false, null, null, null);
        }
        return new ModMessage(true, ChoculaterieNetworkManager.getInt(root), ChoculaterieNetworkManager.getString(root, "message"), ChoculaterieNetworkManager.getString(root, "type"));
    }

    private static String getString(JsonObject obj, String key) {
        return obj.has(key) && !obj.get(key).isJsonNull() ? obj.get(key).getAsString() : null;
    }

    private static Integer getInt(JsonObject obj) {
        return obj.has("id") && !obj.get("id").isJsonNull() ? Integer.valueOf(obj.get("id").getAsInt()) : null;
    }

    private static boolean getBoolean(JsonObject obj) {
        return obj.has("hasMessage") && !obj.get("hasMessage").isJsonNull() && obj.get("hasMessage").getAsBoolean();
    }
}

