/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui.widget;

import com.choculaterie.gui.widget.CustomButton;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class Toast {
    private static final int TOAST_WIDTH = 300;
    private static final int TOAST_HEIGHT = 70;
    private static final long SLIDE_DURATION = 300L;
    private static final long ERROR_DISPLAY_DURATION = 8000L;
    private static final int ACCENT_BORDER_WIDTH = 4;
    private static final int BUTTON_SPACING = 4;
    private static final int CLOSE_BUTTON_SIZE = 16;
    private static final int COPY_BUTTON_WIDTH = 50;
    private static final int COPY_BUTTON_HEIGHT = 18;
    private static final int TOAST_EXTRA_HEIGHT = 20;
    private static final int Y_TRANSITION_DURATION = 400;
    private static final int TOAST_SPACING = 5;
    private static double mouseX;
    private static double mouseY;
    private final String message;
    private final Type type;
    private final long createdTime;
    private final int screenWidth;
    private final boolean hasCopyButton;
    private final String copyText;
    private int yPosition;
    private int targetYPosition;
    private long lastYPositionChange;
    private CustomButton copyButton;
    private final CustomButton closeButton;
    private boolean dismissed;
    private boolean hovered;
    private long pausedTime;
    private long hoverStartTime;

    public Toast(String message, Type type, int screenWidth, int yPosition) {
        this(message, type, screenWidth, yPosition, false, null);
    }

    public Toast(String message, Type type, int screenWidth, int yPosition, boolean hasCopyButton, String copyText) {
        this.message = message;
        this.type = type;
        this.screenWidth = screenWidth;
        this.yPosition = yPosition;
        this.targetYPosition = yPosition;
        this.lastYPositionChange = this.createdTime = System.currentTimeMillis();
        this.hasCopyButton = hasCopyButton;
        this.copyText = copyText != null ? copyText : message;
        this.closeButton = new CustomButton(0, 0, 16, 16, class_2561.method_30163((String)"\u00d7"), btn -> {});
        if (hasCopyButton) {
            this.copyButton = new CustomButton(0, 0, 50, 18, class_2561.method_30163((String)"Copy"), btn -> {});
        }
    }

    private int getAccentColor() {
        return switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> -12255420;
            case 1 -> -48060;
            case 2 -> -12285697;
            case 3 -> -21948;
        };
    }

    public void setTargetYPosition(int targetY) {
        if (this.targetYPosition != targetY) {
            this.targetYPosition = targetY;
            this.lastYPositionChange = System.currentTimeMillis();
        }
    }

    public boolean render(class_332 context, class_327 textRenderer) {
        long displayDuration;
        long now = System.currentTimeMillis();
        long elapsed = this.getEffectiveElapsedTime(now);
        if (this.shouldRemove(elapsed, displayDuration = this.getDisplayDuration())) {
            return true;
        }
        this.updateYPosition(now);
        float slideProgress = this.calculateSlideProgress(elapsed);
        float fadeProgress = this.calculateFadeProgress(elapsed, displayDuration);
        int alpha = (int)(255.0f * fadeProgress);
        if (alpha <= 0) {
            return true;
        }
        int currentX = this.calculateXPosition(slideProgress);
        int toastHeight = this.getToastHeight();
        this.renderToastBackground(context, currentX, toastHeight, alpha);
        this.renderIcon(context, textRenderer, currentX, alpha);
        this.renderMessage(context, textRenderer, currentX, alpha);
        this.renderCloseButton(context, currentX);
        if (this.hasCopyButton) {
            this.renderCopyButton(context, currentX, toastHeight);
        }
        return false;
    }

    private long getEffectiveElapsedTime(long now) {
        long totalPausedTime = this.pausedTime;
        if (this.hovered && this.hoverStartTime > 0L) {
            totalPausedTime += now - this.hoverStartTime;
        }
        return now - this.createdTime - totalPausedTime;
    }

    private long getDisplayDuration() {
        return this.hasCopyButton ? 8000L : 5000L;
    }

    private boolean shouldRemove(long elapsed, long displayDuration) {
        return this.dismissed || elapsed > 300L + displayDuration + 500L;
    }

    private void updateYPosition(long now) {
        if (this.yPosition != this.targetYPosition) {
            long yTransitionElapsed = now - this.lastYPositionChange;
            float yTransitionProgress = Math.min(1.0f, (float)yTransitionElapsed / 400.0f);
            yTransitionProgress = (float)(1.0 - Math.pow(1.0f - yTransitionProgress, 3.0));
            this.yPosition = (int)((float)this.yPosition + (float)(this.targetYPosition - this.yPosition) * yTransitionProgress);
            if (Math.abs(this.yPosition - this.targetYPosition) < 1) {
                this.yPosition = this.targetYPosition;
            }
        }
    }

    private float calculateSlideProgress(long elapsed) {
        float progress = Math.min(1.0f, (float)elapsed / 300.0f);
        return 1.0f - (float)Math.pow(1.0f - progress, 3.0);
    }

    private float calculateFadeProgress(long elapsed, long displayDuration) {
        if (elapsed > 300L + displayDuration) {
            long fadeElapsed = elapsed - 300L - displayDuration;
            return 1.0f - (float)fadeElapsed / 500.0f;
        }
        return 1.0f;
    }

    private int calculateXPosition(float slideProgress) {
        int targetX = this.screenWidth - 300 - 10;
        int startX = this.screenWidth + 300;
        return (int)((float)startX + (float)(targetX - startX) * slideProgress);
    }

    private int getToastHeight() {
        return this.hasCopyButton ? 90 : 70;
    }

    private void renderToastBackground(class_332 context, int currentX, int toastHeight, int alpha) {
        int bgColor = -14013910;
        int bgColorWithAlpha = alpha << 24 | bgColor & 0xFFFFFF;
        context.method_25294(currentX, this.yPosition, currentX + 300, this.yPosition + toastHeight, bgColorWithAlpha);
        int borderColor = this.getAccentColor();
        int borderColorWithAlpha = alpha << 24 | borderColor & 0xFFFFFF;
        context.method_25294(currentX, this.yPosition, currentX + 4, this.yPosition + toastHeight, borderColorWithAlpha);
        int topBorderColor = -12303292;
        int topBorderColorWithAlpha = alpha << 24 | topBorderColor & 0xFFFFFF;
        context.method_25294(currentX, this.yPosition, currentX + 300, this.yPosition + 1, topBorderColorWithAlpha);
        context.method_25294(currentX, this.yPosition + toastHeight - 1, currentX + 300, this.yPosition + toastHeight, topBorderColorWithAlpha);
        context.method_25294(currentX + 300 - 1, this.yPosition, currentX + 300, this.yPosition + toastHeight, topBorderColorWithAlpha);
    }

    private void renderIcon(class_332 context, class_327 textRenderer, int currentX, int alpha) {
        String icon = this.getTypeIcon();
        int iconColor = this.getAccentColor();
        int iconColorWithAlpha = alpha << 24 | iconColor & 0xFFFFFF;
        context.method_51433(textRenderer, icon, currentX + 12, this.yPosition + 8, iconColorWithAlpha, false);
    }

    private String getTypeIcon() {
        return switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "\u2713";
            case 1 -> "\u2717";
            case 3 -> "\u26a0";
            case 2 -> "\u2139";
        };
    }

    private void renderMessage(class_332 context, class_327 textRenderer, int currentX, int alpha) {
        int textX = currentX + 28;
        int textY = this.yPosition + 8;
        int maxTextWidth = 260;
        String displayText = this.truncateText(textRenderer, this.message, maxTextWidth);
        int textColor = -1;
        int textColorWithAlpha = alpha << 24 | textColor & 0xFFFFFF;
        context.method_51433(textRenderer, displayText, textX, textY, textColorWithAlpha, false);
    }

    private String truncateText(class_327 textRenderer, String text, int maxWidth) {
        Object displayText = text;
        int textWidth = textRenderer.method_1727((String)displayText);
        if (textWidth > maxWidth) {
            while (textWidth > maxWidth - 10 && ((String)displayText).length() > 3) {
                displayText = ((String)displayText).substring(0, ((String)displayText).length() - 1);
                textWidth = textRenderer.method_1727((String)displayText + "...");
            }
            displayText = (String)displayText + "...";
        }
        return displayText;
    }

    private void renderCloseButton(class_332 context, int currentX) {
        if (this.closeButton != null) {
            int closeButtonX = currentX + 300 - 16 - 4;
            int closeButtonY = this.yPosition + 4;
            this.closeButton.method_46421(closeButtonX);
            this.closeButton.method_46419(closeButtonY);
            this.closeButton.method_25358(16);
            this.closeButton.method_53533(16);
            this.closeButton.method_25394(context, (int)mouseX, (int)mouseY, 0.0f);
        }
    }

    private void renderCopyButton(class_332 context, int currentX, int toastHeight) {
        if (this.copyButton != null) {
            int buttonX = currentX + 300 - 50 - 5 - 3;
            int buttonY = this.yPosition + toastHeight - 18 - 6;
            this.copyButton.method_46421(buttonX);
            this.copyButton.method_46419(buttonY);
            this.copyButton.method_25358(50);
            this.copyButton.method_53533(18);
            this.copyButton.method_25394(context, (int)mouseX, (int)mouseY, 0.0f);
        }
    }

    public boolean isHovering(double mouseX, double mouseY) {
        long now = System.currentTimeMillis();
        long elapsed = now - this.createdTime;
        long displayDuration = this.getDisplayDuration();
        if (this.dismissed || elapsed > 300L + displayDuration) {
            return false;
        }
        float slideProgress = this.calculateSlideProgress(elapsed);
        int currentX = this.calculateXPosition(slideProgress);
        int toastHeight = this.getToastHeight();
        return mouseX >= (double)currentX && mouseX < (double)(currentX + 300) && mouseY >= (double)this.yPosition && mouseY < (double)(this.yPosition + toastHeight);
    }

    public boolean isCloseButtonClicked(double mouseX, double mouseY) {
        if (this.closeButton == null) {
            return false;
        }
        return this.isWithinBounds(mouseX, mouseY, this.closeButton.method_46426(), this.closeButton.method_46427(), this.closeButton.method_25368(), this.closeButton.method_25364());
    }

    public boolean isCopyButtonClicked(double mouseX, double mouseY) {
        if (!this.hasCopyButton || this.copyButton == null) {
            return false;
        }
        return this.isWithinBounds(mouseX, mouseY, this.copyButton.method_46426(), this.copyButton.method_46427(), this.copyButton.method_25368(), this.copyButton.method_25364());
    }

    private boolean isWithinBounds(double mouseX, double mouseY, int x, int y, int width, int height) {
        return mouseX >= (double)x && mouseX < (double)(x + width) && mouseY >= (double)y && mouseY < (double)(y + height);
    }

    public static void updateMousePosition(double x, double y) {
        mouseX = x;
        mouseY = y;
    }

    public void dismiss() {
        this.dismissed = true;
    }

    public void setHovered(boolean hovered) {
        if (hovered && !this.hovered) {
            this.hoverStartTime = System.currentTimeMillis();
        } else if (!hovered && this.hovered) {
            this.pausedTime += System.currentTimeMillis() - this.hoverStartTime;
        }
        this.hovered = hovered;
    }

    public boolean isHovered() {
        return this.hovered;
    }

    public int getHeight() {
        return this.getToastHeight() + 5;
    }

    public String getCopyText() {
        return this.copyText;
    }

    @Environment(value=EnvType.CLIENT)
    public static enum Type {
        SUCCESS,
        ERROR,
        INFO,
        WARNING;

    }
}

