/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui.widget;

import com.choculaterie.models.MinemevPostInfo;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;

@Environment(value=EnvType.CLIENT)
public class PostEntryWidget
implements class_4068,
class_364 {
    private static final int MIN_ENTRY_HEIGHT = 70;
    private static final int LINE_HEIGHT = 12;
    private static final int CONTENT_SPACING = 5;
    private static final int ENTRY_BG_COLOR = -12961222;
    private static final int ENTRY_HOVER_COLOR = -11908534;
    private static final int ENTRY_PRESSED_COLOR = -14013910;
    private static final int TEXT_COLOR = -1;
    private static final int BORDER_COLOR = -11184811;
    private final MinemevPostInfo post;
    private int x;
    private int y;
    private int width;
    private final class_310 client;
    private final Runnable onClick;
    private boolean isHovered = false;
    private boolean isPressed = false;
    private int calculatedHeight = 70;

    public PostEntryWidget(MinemevPostInfo post, int x, int y, int width, Runnable onClick) {
        this.post = post;
        this.x = x;
        this.y = y;
        this.width = width;
        this.client = class_310.method_1551();
        this.onClick = onClick;
        this.calculateHeight();
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setWidth(int width) {
        this.width = width;
        this.calculateHeight();
    }

    private void calculateHeight() {
        int currentY = 10;
        int contentWidth = this.width - 20;
        if (this.post.title() != null && !this.post.title().isEmpty()) {
            currentY += this.getWrappedTextHeight(this.post.title(), contentWidth) + 5;
        }
        currentY += 17;
        if (this.post.tags() != null && this.post.tags().length > 0) {
            StringBuilder tags = new StringBuilder();
            for (int i = 0; i < this.post.tags().length; ++i) {
                if (i > 0) {
                    tags.append(", ");
                }
                tags.append(this.post.tags()[i]);
            }
            currentY += this.getWrappedTextHeight(tags.toString(), contentWidth) + 5;
        }
        this.calculatedHeight = Math.max(70, currentY += 10);
    }

    private int getWrappedTextHeight(String text, int maxWidth) {
        if (text == null || text.isEmpty()) {
            return 12;
        }
        String[] words = text.split(" ");
        StringBuilder line = new StringBuilder();
        int lines = 1;
        for (String word : words) {
            Object testLine = !line.isEmpty() ? String.valueOf(line) + " " + word : word;
            int testWidth = this.client.field_1772.method_1727((String)testLine);
            if (testWidth > maxWidth && !line.isEmpty()) {
                line = new StringBuilder(word);
                ++lines;
                continue;
            }
            line = new StringBuilder((String)testLine);
        }
        return lines * 12;
    }

    private void drawWrappedText(class_332 context, String text, int textX, int textY, int maxWidth, int color) {
        if (text == null || text.isEmpty()) {
            return;
        }
        String[] words = text.split(" ");
        StringBuilder line = new StringBuilder();
        int lineY = textY;
        for (String word : words) {
            Object testLine = !line.isEmpty() ? String.valueOf(line) + " " + word : word;
            int testWidth = this.client.field_1772.method_1727((String)testLine);
            if (testWidth > maxWidth && !line.isEmpty()) {
                context.method_25303(this.client.field_1772, line.toString(), textX, lineY, color);
                line = new StringBuilder(word);
                lineY += 12;
                continue;
            }
            line = new StringBuilder((String)testLine);
        }
        if (!line.isEmpty()) {
            context.method_25303(this.client.field_1772, line.toString(), textX, lineY, color);
        }
    }

    public void setY(int y) {
        this.y = y;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.updateHoverState(mouseX, mouseY);
        int bgColor = this.getBackgroundColor();
        this.drawBackground(context, bgColor);
        this.drawBorder(context);
        this.renderContent(context);
    }

    private void updateHoverState(int mouseX, int mouseY) {
        this.isHovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.calculatedHeight;
    }

    private int getBackgroundColor() {
        if (this.isPressed && this.isHovered) {
            return -14013910;
        }
        if (this.isHovered) {
            return -11908534;
        }
        return -12961222;
    }

    private void drawBackground(class_332 context, int bgColor) {
        context.method_25294(this.x, this.y, this.x + this.width, this.y + this.calculatedHeight, bgColor);
    }

    private void drawBorder(class_332 context) {
        int borderWidth = 1;
        context.method_25294(this.x, this.y, this.x + this.width, this.y + borderWidth, -11184811);
        context.method_25294(this.x, this.y + this.calculatedHeight - borderWidth, this.x + this.width, this.y + this.calculatedHeight, -11184811);
        context.method_25294(this.x, this.y, this.x + borderWidth, this.y + this.calculatedHeight, -11184811);
        context.method_25294(this.x + this.width - borderWidth, this.y, this.x + this.width, this.y + this.calculatedHeight, -11184811);
    }

    private void renderContent(class_332 context) {
        int currentY = this.y + 10;
        int contentWidth = this.width - 20;
        currentY = this.renderTitle(context, currentY, contentWidth);
        currentY = this.renderInfo(context, currentY);
        this.renderTags(context, currentY, contentWidth);
    }

    private int renderTitle(class_332 context, int currentY, int contentWidth) {
        String title = this.post.title();
        if (title != null && !title.isEmpty()) {
            this.drawWrappedText(context, title, this.x + 10, currentY, contentWidth, -1);
            currentY += this.getWrappedTextHeight(title, contentWidth) + 5;
        }
        return currentY;
    }

    private int renderInfo(class_332 context, int currentY) {
        String author = this.post.author() != null ? this.post.author() : "Unknown";
        String downloads = String.format("Downloads: %d", this.post.downloads());
        String info = String.format("By %s | %s", author, downloads);
        context.method_25303(this.client.field_1772, info, this.x + 10, currentY, -5592406);
        return currentY + 12 + 5;
    }

    private void renderTags(class_332 context, int currentY, int contentWidth) {
        if (this.post.tags() != null && this.post.tags().length > 0) {
            StringBuilder tags = new StringBuilder();
            for (int i = 0; i < this.post.tags().length; ++i) {
                if (i > 0) {
                    tags.append(", ");
                }
                tags.append(this.post.tags()[i]);
            }
            this.drawWrappedText(context, tags.toString(), this.x + 10, currentY, contentWidth, -5592406);
        }
    }

    public int getHeight() {
        return this.calculatedHeight;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public MinemevPostInfo getPost() {
        return this.post;
    }

    public void setPressed(boolean pressed) {
        this.isPressed = pressed;
    }

    public boolean isPressed() {
        return this.isPressed;
    }

    public void setHovered(boolean hovered) {
        this.isHovered = hovered;
    }

    public boolean isHovered() {
        return this.isHovered;
    }

    public void method_25365(boolean focused) {
    }

    public boolean method_25370() {
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return false;
        }
        if (mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.calculatedHeight)) {
            this.isPressed = true;
            if (this.onClick != null) {
                this.onClick.run();
            }
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.isPressed) {
            this.isPressed = false;
            return true;
        }
        return false;
    }
}

