/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui.widget;

import com.choculaterie.config.DownloadSettings;
import com.choculaterie.gui.widget.ConfirmPopup;
import com.choculaterie.gui.widget.CustomButton;
import com.choculaterie.gui.widget.DropdownWidget;
import com.choculaterie.gui.widget.ImageViewerWidget;
import com.choculaterie.gui.widget.LoadingSpinner;
import com.choculaterie.gui.widget.ScrollBar;
import com.choculaterie.models.MinemevFileInfo;
import com.choculaterie.models.MinemevPostDetailInfo;
import com.choculaterie.models.MinemevPostInfo;
import com.choculaterie.network.MinemevNetworkManager;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_10799;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;

@Environment(value=EnvType.CLIENT)
public class PostDetailPanel
implements class_4068,
class_364 {
    private static final int TAG_BG_COLOR = -12961222;
    private static final int MAX_IMAGE_SIZE = 200;
    private static final int MIN_IMAGE_SIZE = 80;
    private int x;
    private int y;
    private int width;
    private int height;
    private MinemevPostInfo postInfo;
    private MinemevPostDetailInfo postDetail;
    private boolean isLoadingDetails = false;
    private boolean isLoadingImage = false;
    private String[] imageUrls;
    private int currentImageIndex = 0;
    private class_2960 currentImageTexture;
    private final Map<String, class_2960> imageCache = new ConcurrentHashMap<String, class_2960>();
    private String loadingImageUrl = null;
    private int originalImageWidth = 0;
    private int originalImageHeight = 0;
    private final Map<String, int[]> imageDimensionsCache = new ConcurrentHashMap<String, int[]>();
    private final class_310 client;
    private double scrollOffset = 0.0;
    private int contentHeight = 0;
    private final LoadingSpinner imageLoadingSpinner;
    private CustomButton prevImageButton;
    private CustomButton nextImageButton;
    private ScrollBar scrollBar;
    private CustomButton downloadButton;
    private DropdownWidget schematicDropdown;
    private MinemevFileInfo[] availableFiles;
    private boolean isLoadingFiles = false;
    private String downloadStatus = "";
    private ImageViewerWidget imageViewer;
    private CustomButton redirectLinkButton;
    private ConfirmPopup confirmPopup;

    public PostDetailPanel(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.client = class_310.method_1551();
        this.imageLoadingSpinner = new LoadingSpinner(0, 0);
        int scrollBarYOffset = 30;
        this.scrollBar = new ScrollBar(x + width - 8, y + scrollBarYOffset, height - scrollBarYOffset);
        this.schematicDropdown = new DropdownWidget(x, y, width - 20, this::onSchematicSelected);
    }

    public void setDimensions(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        int scrollBarYOffset = 30;
        this.scrollBar = new ScrollBar(x + width - 8, y + scrollBarYOffset, height - scrollBarYOffset);
        if (this.schematicDropdown != null) {
            this.schematicDropdown.setPosition(x, y);
            if (this.schematicDropdown.isOpen()) {
                this.schematicDropdown.close();
            }
        }
    }

    public boolean hasConfirmPopupOpen() {
        return this.confirmPopup != null;
    }

    public void closeDropdown() {
        if (this.schematicDropdown != null && this.schematicDropdown.isOpen()) {
            this.schematicDropdown.close();
        }
    }

    private int getDisplayImageWidth() {
        return this.width - 10;
    }

    private int getDisplayImageHeight() {
        return 200;
    }

    private int getActualImageWidth() {
        if (this.originalImageWidth <= 0 || this.originalImageHeight <= 0) {
            return this.getDisplayImageWidth();
        }
        int containerWidth = this.getDisplayImageWidth();
        int containerHeight = this.getDisplayImageHeight();
        int widthAtContainerHeight = (int)((float)this.originalImageWidth / (float)this.originalImageHeight * (float)containerHeight);
        if (widthAtContainerHeight <= containerWidth) {
            return Math.min(this.originalImageWidth, widthAtContainerHeight);
        }
        return Math.min(this.originalImageWidth, containerWidth);
    }

    private int getActualImageHeight() {
        if (this.originalImageWidth <= 0 || this.originalImageHeight <= 0) {
            return this.getDisplayImageHeight();
        }
        int containerHeight = this.getDisplayImageHeight();
        int actualWidth = this.getActualImageWidth();
        int calculatedHeight = (int)((float)this.originalImageHeight / (float)this.originalImageWidth * (float)actualWidth);
        return Math.min(this.originalImageHeight, Math.min(containerHeight, calculatedHeight));
    }

    private boolean isCompactMode() {
        return this.width < 200;
    }

    private void updateCarouselButtons(int imageNavY) {
        if (this.imageUrls == null || this.imageUrls.length <= 1) {
            this.prevImageButton = null;
            this.nextImageButton = null;
            return;
        }
        boolean compact = this.isCompactMode();
        int btnWidth = compact ? 18 : 25;
        int btnHeight = compact ? 14 : 16;
        int btnSpacing = compact ? 5 : 10;
        String indicator = String.format("%d / %d", this.currentImageIndex + 1, this.imageUrls.length);
        int indicatorWidth = this.client.field_1772.method_1727(indicator);
        int indicatorX = this.x + (this.width - indicatorWidth) / 2;
        int prevBtnX = indicatorX - btnWidth - btnSpacing;
        int nextBtnX = indicatorX + indicatorWidth + btnSpacing;
        if (this.prevImageButton == null) {
            this.prevImageButton = new CustomButton(prevBtnX, imageNavY, btnWidth, btnHeight, class_2561.method_30163((String)"<"), btn -> this.previousImage());
        } else {
            this.prevImageButton.method_46421(prevBtnX);
            this.prevImageButton.method_46419(imageNavY);
            this.prevImageButton.method_25358(btnWidth);
        }
        if (this.nextImageButton == null) {
            this.nextImageButton = new CustomButton(nextBtnX, imageNavY, btnWidth, btnHeight, class_2561.method_30163((String)">"), btn -> this.nextImage());
        } else {
            this.nextImageButton.method_46421(nextBtnX);
            this.nextImageButton.method_46419(imageNavY);
            this.nextImageButton.method_25358(btnWidth);
        }
    }

    public void setPost(MinemevPostInfo post) {
        String[] parts;
        System.out.println("[PostDetailPanel] setPost called!");
        System.out.println("[PostDetailPanel] Post: " + (post != null ? post.title() : "null"));
        if (post == null) {
            System.out.println("[PostDetailPanel] Post is null, clearing panel");
            this.clear();
            return;
        }
        if (this.postInfo != null && post.uuid() != null && post.uuid().equals(this.postInfo.uuid())) {
            System.out.println("[PostDetailPanel] Same post already loaded, skipping reload");
            return;
        }
        System.out.println("[PostDetailPanel] Setting post: " + post.title());
        System.out.println("[PostDetailPanel] UUID: " + post.uuid());
        System.out.println("[PostDetailPanel] Vendor: " + post.vendor());
        this.clearDownloadState();
        this.postInfo = post;
        this.postDetail = null;
        this.isLoadingDetails = true;
        this.currentImageIndex = 0;
        this.currentImageTexture = null;
        this.originalImageWidth = 0;
        this.originalImageHeight = 0;
        this.scrollOffset = 0.0;
        System.out.println("[PostDetailPanel] Post info set, loading details...");
        String vendor = post.vendor() != null ? post.vendor() : "minemev";
        String uuid = post.uuid();
        if (uuid != null && uuid.contains("/") && (parts = uuid.split("/", 2)).length == 2) {
            vendor = parts[0];
            uuid = parts[1];
            System.out.println("[PostDetailPanel] Stripped vendor prefix - vendor: " + vendor + ", uuid: " + uuid);
        }
        if ("LitematicaGen".equalsIgnoreCase(vendor) || "LitematicaShare".equalsIgnoreCase(vendor)) {
            vendor = "redenmc";
            System.out.println("[PostDetailPanel] Overriding vendor to redenmc");
        }
        ((CompletableFuture)MinemevNetworkManager.getPostDetails(vendor, uuid).thenAccept(this::handlePostDetailLoaded)).exceptionally(throwable -> {
            if (this.client != null) {
                this.client.execute(() -> {
                    this.isLoadingDetails = false;
                    System.err.println("[PostDetailPanel] Failed to load post details: " + throwable.getMessage());
                    throwable.printStackTrace();
                });
            }
            return null;
        });
        if (post.images() != null && post.images().length > 0) {
            System.out.println("[PostDetailPanel] Found " + post.images().length + " images");
            this.imageUrls = post.images();
            this.loadImage(this.imageUrls[0]);
        } else if (post.thumbnailUrl() != null && !post.thumbnailUrl().isEmpty()) {
            System.out.println("[PostDetailPanel] Using thumbnail URL");
            this.imageUrls = new String[]{post.thumbnailUrl()};
            this.loadImage(post.thumbnailUrl());
        } else {
            System.out.println("[PostDetailPanel] No images available");
            this.imageUrls = new String[0];
        }
    }

    private void handlePostDetailLoaded(MinemevPostDetailInfo detail) {
        if (this.client != null) {
            this.client.execute(() -> {
                this.postDetail = detail;
                this.isLoadingDetails = false;
                if (detail.getImages() != null && detail.getImages().length > 0) {
                    this.imageUrls = detail.getImages();
                    if (this.currentImageIndex >= this.imageUrls.length) {
                        this.currentImageIndex = 0;
                    }
                    this.preloadImages(this.imageUrls);
                    if (this.currentImageTexture == null && this.imageUrls.length > 0) {
                        this.loadImage(this.imageUrls[this.currentImageIndex]);
                    }
                }
            });
        }
    }

    private void preloadImages(String[] urls) {
        for (String url : urls) {
            if (this.imageCache.containsKey(url)) continue;
            new Thread(() -> {
                try {
                    this.loadImageSync(url);
                }
                catch (Exception e) {
                    System.err.println("Failed to preload image: " + url);
                }
            }).start();
        }
    }

    private void loadImage(String imageUrl) {
        if (imageUrl == null || imageUrl.isEmpty()) {
            return;
        }
        if (this.imageCache.containsKey(imageUrl)) {
            this.currentImageTexture = this.imageCache.get(imageUrl);
            int[] dims = this.imageDimensionsCache.get(imageUrl);
            if (dims != null) {
                this.originalImageWidth = dims[0];
                this.originalImageHeight = dims[1];
            }
            this.isLoadingImage = false;
            return;
        }
        this.isLoadingImage = true;
        this.loadingImageUrl = imageUrl;
        new Thread(() -> {
            block3: {
                try {
                    class_2960 texId = this.loadImageSync(imageUrl);
                    if (this.client != null) {
                        this.client.execute(() -> {
                            if (imageUrl.equals(this.loadingImageUrl)) {
                                this.currentImageTexture = texId;
                                int[] dims = this.imageDimensionsCache.get(imageUrl);
                                if (dims != null) {
                                    this.originalImageWidth = dims[0];
                                    this.originalImageHeight = dims[1];
                                }
                                this.isLoadingImage = false;
                            }
                        });
                    }
                }
                catch (Exception e) {
                    if (this.client == null) break block3;
                    this.client.execute(() -> {
                        this.isLoadingImage = false;
                        System.err.println("Failed to load image: " + e.getMessage());
                    });
                }
            }
        }).start();
    }

    private class_2960 loadImageSync(String imageUrl) throws Exception {
        HttpRequest request;
        if (this.imageCache.containsKey(imageUrl)) {
            return this.imageCache.get(imageUrl);
        }
        String encodedUrl = this.encodeImageUrl(imageUrl);
        HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
        HttpResponse<byte[]> response = httpClient.send(request = HttpRequest.newBuilder().uri(URI.create(encodedUrl)).GET().header("User-Agent", "LitematicDownloader/1.0").build(), HttpResponse.BodyHandlers.ofByteArray());
        if (response.statusCode() != 200) {
            throw new Exception("HTTP error: " + response.statusCode());
        }
        byte[] imageData = response.body();
        byte[] pngBytes = this.convertImageToPng(imageData);
        class_1011 nativeImage = class_1011.method_4309((InputStream)new ByteArrayInputStream(pngBytes));
        int imgWidth = nativeImage.method_4307();
        int imgHeight = nativeImage.method_4323();
        if (imgWidth <= 0 || imgHeight <= 0) {
            nativeImage.close();
            throw new Exception("Invalid image dimensions");
        }
        if (imgWidth > 4096 || imgHeight > 4096) {
            nativeImage.close();
            throw new Exception("Image too large");
        }
        this.imageDimensionsCache.put(imageUrl, new int[]{imgWidth, imgHeight});
        class_1011 finalImage = nativeImage;
        String uniqueId = UUID.randomUUID().toString().replace("-", "");
        class_2960 texId = class_2960.method_60655((String)"litematicdownloader", (String)("textures/dynamic/" + uniqueId));
        if (this.client != null) {
            this.client.execute(() -> {
                this.client.method_1531().method_4616(texId, (class_1044)new class_1043(() -> "minemev_image", finalImage));
                this.imageCache.put(imageUrl, texId);
            });
        }
        Thread.sleep(50L);
        return texId;
    }

    private String encodeImageUrl(String url) {
        try {
            URI uri = URI.create(url);
            String path = uri.getPath();
            String encodedPath = path.replace(" ", "%20");
            return uri.getScheme() + "://" + uri.getHost() + (String)(uri.getPort() != -1 ? ":" + uri.getPort() : "") + encodedPath + (String)(uri.getQuery() != null ? "?" + uri.getQuery() : "");
        }
        catch (Exception e) {
            return url.replace(" ", "%20");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] convertImageToPng(byte[] imageData) throws Exception {
        BufferedImage bufferedImage;
        block14: {
            bufferedImage = null;
            try (ImageInputStream iis2 = ImageIO.createImageInputStream(new ByteArrayInputStream(imageData));){
                Iterator<ImageReader> readers = ImageIO.getImageReaders(iis2);
                if (!readers.hasNext()) break block14;
                ImageReader reader = readers.next();
                try {
                    reader.setInput(iis2);
                    bufferedImage = reader.read(0);
                }
                finally {
                    reader.dispose();
                }
            }
            catch (Exception iis2) {
                // empty catch block
            }
        }
        if (bufferedImage == null) {
            bufferedImage = ImageIO.read(new ByteArrayInputStream(imageData));
        }
        if (bufferedImage == null) {
            throw new Exception("Failed to decode image");
        }
        if (bufferedImage.getType() != 1 && bufferedImage.getType() != 2) {
            BufferedImage converted = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
            Graphics2D g2d = converted.createGraphics();
            g2d.drawImage((Image)bufferedImage, 0, 0, null);
            g2d.dispose();
            bufferedImage = converted;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "PNG", baos);
        return baos.toByteArray();
    }

    public void clear() {
        this.postInfo = null;
        this.postDetail = null;
        this.isLoadingDetails = false;
        this.isLoadingImage = false;
        this.currentImageTexture = null;
        this.originalImageWidth = 0;
        this.originalImageHeight = 0;
        this.imageUrls = null;
        this.currentImageIndex = 0;
        this.scrollOffset = 0.0;
        this.clearDownloadState();
    }

    private void clearDownloadState() {
        this.availableFiles = null;
        this.isLoadingFiles = false;
        this.downloadStatus = "";
        if (this.schematicDropdown != null) {
            this.schematicDropdown.close();
            this.schematicDropdown.setStatusMessage("");
        }
    }

    private void onDownloadButtonClick() {
        String[] parts;
        boolean isLitematicaGenVendor;
        if (this.postInfo == null || this.isLoadingFiles) {
            return;
        }
        if (this.schematicDropdown.isOpen()) {
            this.schematicDropdown.close();
            return;
        }
        if (this.availableFiles != null && this.availableFiles.length > 0) {
            this.showSchematicDropdown();
            return;
        }
        boolean bl = isLitematicaGenVendor = "LitematicaGen".equalsIgnoreCase(this.postInfo.vendor()) || "LitematicaShare".equalsIgnoreCase(this.postInfo.vendor());
        if (isLitematicaGenVendor && this.postInfo.urlRedirect() != null && !this.postInfo.urlRedirect().isEmpty()) {
            this.showRedirectConfirmation();
            return;
        }
        this.isLoadingFiles = true;
        this.downloadStatus = "";
        String vendor = this.postInfo.vendor() != null ? this.postInfo.vendor() : "minemev";
        String uuid = this.postInfo.uuid();
        if (uuid != null && uuid.contains("/") && (parts = uuid.split("/", 2)).length == 2) {
            vendor = parts[0];
            uuid = parts[1];
        }
        if ("LitematicaGen".equalsIgnoreCase(vendor) || "LitematicaShare".equalsIgnoreCase(vendor)) {
            vendor = "redenmc";
        }
        ((CompletableFuture)MinemevNetworkManager.getPostFiles(vendor, uuid).thenAccept(files -> {
            if (this.client != null) {
                this.client.execute(() -> {
                    this.availableFiles = files;
                    this.isLoadingFiles = false;
                    if (files != null && ((MinemevFileInfo[])files).length > 0) {
                        this.showSchematicDropdown();
                    } else {
                        boolean isLitGen;
                        boolean bl = isLitGen = this.postInfo != null && ("LitematicaGen".equalsIgnoreCase(this.postInfo.vendor()) || "LitematicaShare".equalsIgnoreCase(this.postInfo.vendor()));
                        if (isLitGen && this.postInfo.urlRedirect() != null && !this.postInfo.urlRedirect().isEmpty()) {
                            this.showRedirectConfirmation();
                        } else {
                            this.downloadStatus = "No files available";
                        }
                    }
                });
            }
        })).exceptionally(throwable -> {
            if (this.client != null) {
                this.client.execute(() -> {
                    this.isLoadingFiles = false;
                    String errorMsg = throwable.getMessage();
                    this.downloadStatus = errorMsg != null && errorMsg.contains("UnknownHost") ? "\u2717 Error: No internet connection" : (errorMsg != null && errorMsg.contains("timeout") ? "\u2717 Error: Connection timeout" : "\u2717 Error: Failed to load file list");
                    System.err.println("Failed to load files: " + errorMsg);
                });
            }
            return null;
        });
    }

    private void showSchematicDropdown() {
        boolean isLitematicaGenVendor;
        if (this.availableFiles == null || this.availableFiles.length == 0) {
            return;
        }
        ArrayList<DropdownWidget.DropdownItem> items = new ArrayList<DropdownWidget.DropdownItem>();
        boolean bl = isLitematicaGenVendor = this.postInfo != null && ("LitematicaGen".equalsIgnoreCase(this.postInfo.vendor()) || "LitematicaShare".equalsIgnoreCase(this.postInfo.vendor()));
        if (isLitematicaGenVendor && this.postInfo.urlRedirect() != null && !this.postInfo.urlRedirect().isEmpty()) {
            items.add(new DropdownWidget.DropdownItem("\ud83d\udd17 View on Website", "WEBSITE_LINK"));
        }
        for (MinemevFileInfo file : this.availableFiles) {
            Object displayText = file.getDefaultFileName();
            if (file.getFileSize() > 0L) {
                displayText = (String)displayText + " (" + this.formatFileSize(file.getFileSize()) + ")";
            }
            items.add(new DropdownWidget.DropdownItem((String)displayText, file));
        }
        this.schematicDropdown.setItems(items);
        this.schematicDropdown.setStatusMessage(this.downloadStatus);
        if (this.downloadButton != null) {
            this.schematicDropdown.setPosition(this.downloadButton.method_46426(), this.downloadButton.method_46427() + this.downloadButton.method_25364() + 2);
        }
        this.schematicDropdown.open();
    }

    private void onSchematicSelected(DropdownWidget.DropdownItem item) {
        if (item == null) {
            return;
        }
        if ("WEBSITE_LINK".equals(item.getData())) {
            if (this.schematicDropdown != null) {
                this.schematicDropdown.close();
            }
            this.showRedirectConfirmation();
            return;
        }
        if (!(item.getData() instanceof MinemevFileInfo)) {
            return;
        }
        MinemevFileInfo file = (MinemevFileInfo)item.getData();
        this.downloadSchematic(file);
    }

    private void downloadSchematic(MinemevFileInfo file) {
        this.downloadStatus = "Downloading...";
        if (this.schematicDropdown != null) {
            this.schematicDropdown.setStatusMessage(this.downloadStatus);
        }
        new Thread(() -> {
            try {
                String downloadUrl = file.getDownloadUrl();
                if (downloadUrl == null || downloadUrl.isEmpty()) {
                    this.client.execute(() -> {
                        this.downloadStatus = "Invalid download URL";
                        if (this.schematicDropdown != null) {
                            this.schematicDropdown.setStatusMessage(this.downloadStatus);
                        }
                    });
                    System.err.println("[Download] Invalid download URL");
                    return;
                }
                System.out.println("[Download] Starting download from: " + downloadUrl);
                System.out.println("[Download] File: " + file.getDefaultFileName());
                String encodedUrl = downloadUrl.replace(" ", "%20");
                HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(30L)).followRedirects(HttpClient.Redirect.ALWAYS).build();
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(encodedUrl)).GET().header("User-Agent", "LitematicDownloader/1.0").build();
                System.out.println("[Download] Sending request...");
                HttpResponse<byte[]> response = httpClient.send(request, HttpResponse.BodyHandlers.ofByteArray());
                System.out.println("[Download] Response status: " + response.statusCode());
                System.out.println("[Download] Content length: " + response.body().length);
                if (response.statusCode() != 200) {
                    Object errorMsg = switch (response.statusCode()) {
                        case 404 -> "\u2717 Error: File not found on server";
                        case 403 -> "\u2717 Error: Access denied";
                        case 500, 502, 503 -> "\u2717 Error: Server error (" + response.statusCode() + ")";
                        case 429 -> "\u2717 Error: Too many requests, try again later";
                        default -> "\u2717 Download failed: HTTP " + response.statusCode();
                    };
                    System.err.println("[Download] " + (String)errorMsg);
                    this.client.execute(() -> this.lambda$downloadSchematic$16((String)errorMsg));
                    return;
                }
                Path schematicsPath = Paths.get(DownloadSettings.getInstance().getAbsoluteDownloadPath(), new String[0]);
                File schematicsDir = schematicsPath.toFile();
                if (!schematicsDir.exists()) {
                    boolean created = schematicsDir.mkdirs();
                    System.out.println("[Download] Created schematics directory: " + created);
                }
                System.out.println("[Download] Schematics directory: " + schematicsDir.getAbsolutePath());
                Object fileName = file.getDefaultFileName();
                if (!((String)fileName).endsWith(".litematic")) {
                    fileName = (String)fileName + ".litematic";
                }
                File outputFile = new File(schematicsDir, (String)fileName);
                int counter = 1;
                while (outputFile.exists()) {
                    String baseName = ((String)fileName).substring(0, ((String)fileName).lastIndexOf(".litematic"));
                    outputFile = new File(schematicsDir, baseName + "_" + counter + ".litematic");
                    ++counter;
                }
                try (FileOutputStream fos = new FileOutputStream(outputFile);){
                    fos.write(response.body());
                }
                String finalFileName = outputFile.getName();
                String finalPath = outputFile.getAbsolutePath();
                this.client.execute(() -> {
                    this.downloadStatus = "\u2713 Downloaded: " + finalFileName;
                    if (this.schematicDropdown != null) {
                        this.schematicDropdown.setStatusMessage(this.downloadStatus);
                    }
                    System.out.println("Downloaded schematic to: " + finalPath);
                });
            }
            catch (Exception e) {
                this.client.execute(() -> {
                    Object errorMsg;
                    if (e instanceof UnknownHostException) {
                        errorMsg = "\u2717 Error: No internet connection";
                    } else if (e instanceof SocketTimeoutException) {
                        errorMsg = "\u2717 Error: Connection timeout";
                    } else if (e instanceof FileNotFoundException) {
                        errorMsg = "\u2717 Error: File not found";
                    } else if (e instanceof IOException && e.getMessage().contains("Permission denied")) {
                        errorMsg = "\u2717 Error: Cannot write to disk (permission denied)";
                    } else if (e instanceof IOException && e.getMessage().contains("No space")) {
                        errorMsg = "\u2717 Error: Not enough disk space";
                    } else {
                        Object msg = e.getMessage();
                        if (msg != null && ((String)msg).length() > 40) {
                            msg = ((String)msg).substring(0, 37) + "...";
                        }
                        errorMsg = "\u2717 Error: " + (String)(msg != null ? msg : "Unknown error");
                    }
                    this.downloadStatus = errorMsg;
                    if (this.schematicDropdown != null) {
                        this.schematicDropdown.setStatusMessage(this.downloadStatus);
                    }
                    System.err.println("Failed to download schematic: " + e.getMessage());
                    e.printStackTrace();
                });
            }
        }).start();
    }

    private String formatFileSize(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return String.format("%.1f KB", (double)bytes / 1024.0);
        }
        return String.format("%.1f MB", (double)bytes / 1048576.0);
    }

    private void showRedirectConfirmation() {
        if (this.postInfo == null || this.postInfo.urlRedirect() == null) {
            return;
        }
        this.confirmPopup = new ConfirmPopup(null, "Leaving Mod", "LitematicaGen posts are not supported in this version :(\n\nYou are about to open an external website:\n\n" + this.postInfo.urlRedirect() + "\n\nDo you want to continue?", this::openRedirectUrl, this::closeConfirmPopup, "Continue");
    }

    private void openRedirectUrl() {
        if (this.postInfo != null && this.postInfo.urlRedirect() != null && !this.postInfo.urlRedirect().isEmpty()) {
            try {
                class_156.method_668().method_670(this.postInfo.urlRedirect());
            }
            catch (Exception e) {
                System.err.println("[PostDetailPanel] ERROR - Failed to open URL: " + e.getMessage());
            }
        }
        this.closeConfirmPopup();
    }

    private void closeConfirmPopup() {
        this.confirmPopup = null;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        String[] versions;
        int renderMouseX = mouseX;
        int renderMouseY = mouseY;
        if (this.confirmPopup != null) {
            renderMouseX = -1;
            renderMouseY = -1;
        } else if (this.schematicDropdown != null && this.schematicDropdown.isOpen() && this.schematicDropdown.method_25405(mouseX, mouseY)) {
            renderMouseX = -1;
            renderMouseY = -1;
        }
        context.method_25294(this.x, this.y, this.x + this.width, this.y + this.height, -14342875);
        context.method_25294(this.x, this.y, this.x + 1, this.y + this.height, -11184811);
        if (this.postInfo == null) {
            String text = "Select a schematic to view details";
            int textWidth = this.client.field_1772.method_1727(text);
            context.method_25303(this.client.field_1772, text, this.x + (this.width - textWidth) / 2, this.y + this.height / 2 - 4, -5592406);
            return;
        }
        int downloadBtnSize = 20;
        int downloadBtnX = this.x;
        int downloadBtnY = this.y;
        if (this.downloadButton == null) {
            this.downloadButton = new CustomButton(downloadBtnX, downloadBtnY, downloadBtnSize, downloadBtnSize, class_2561.method_30163((String)"\u2b07\ufe0f"), button -> this.onDownloadButtonClick());
            this.downloadButton.setRenderAsDownloadIcon(true);
        } else {
            this.downloadButton.method_46421(downloadBtnX);
            this.downloadButton.method_46419(downloadBtnY);
            this.downloadButton.field_22763 = !this.isLoadingFiles;
        }
        this.downloadButton.method_25394(context, renderMouseX, renderMouseY, delta);
        int contentStartY = this.y + downloadBtnSize;
        context.method_44379(this.x + 1, contentStartY, this.x + this.width, this.y + this.height);
        int currentY = contentStartY + 10 - (int)this.scrollOffset;
        this.contentHeight = 0;
        int containerWidth = this.getDisplayImageWidth();
        int containerHeight = this.getDisplayImageHeight();
        int actualImageWidth = this.getActualImageWidth();
        int actualImageHeight = this.getActualImageHeight();
        int containerX = this.x + 1;
        int containerY = currentY;
        int imageX = containerX + (containerWidth - actualImageWidth) / 2;
        int imageY = containerY + (containerHeight - actualImageHeight) / 2;
        if (this.isLoadingImage) {
            context.method_25294(containerX, containerY, containerX + containerWidth, containerY + containerHeight, -13421773);
            this.imageLoadingSpinner.setPosition(containerX + containerWidth / 2 - this.imageLoadingSpinner.getWidth() / 2, containerY + containerHeight / 2 - this.imageLoadingSpinner.getHeight() / 2);
            this.imageLoadingSpinner.method_25394(context, mouseX, mouseY, delta);
        } else if (this.currentImageTexture != null) {
            context.method_25294(containerX, containerY, containerX + containerWidth, containerY + containerHeight, -15066598);
            context.method_25290(class_10799.field_56883, this.currentImageTexture, imageX, imageY, 0.0f, 0.0f, actualImageWidth, actualImageHeight, actualImageWidth, actualImageHeight);
        } else {
            context.method_25294(containerX, containerY, containerX + containerWidth, containerY + containerHeight, -13421773);
            String noImg = this.isCompactMode() ? "..." : "No image";
            int tw = this.client.field_1772.method_1727(noImg);
            context.method_25303(this.client.field_1772, noImg, containerX + (containerWidth - tw) / 2, containerY + containerHeight / 2 - 4, -5592406);
        }
        currentY += containerHeight + 10;
        this.contentHeight += containerHeight + 10;
        if (this.imageUrls != null && this.imageUrls.length > 1) {
            String indicator = String.format("%d / %d", this.currentImageIndex + 1, this.imageUrls.length);
            int indicatorWidth = this.client.field_1772.method_1727(indicator);
            int indicatorX = this.x + (this.width - indicatorWidth) / 2;
            int btnY = currentY;
            this.updateCarouselButtons(btnY);
            if (this.prevImageButton != null) {
                this.prevImageButton.method_25394(context, renderMouseX, renderMouseY, delta);
            }
            context.method_25303(this.client.field_1772, indicator, indicatorX, btnY + 4, -5592406);
            if (this.nextImageButton != null) {
                this.nextImageButton.method_25394(context, renderMouseX, renderMouseY, delta);
            }
            currentY += 26;
            this.contentHeight += 26;
        }
        String title = this.postInfo.title() != null ? this.postInfo.title() : "Untitled";
        this.drawWrappedText(context, title, this.x + 10, currentY, this.width - 20, -1);
        int titleHeight = this.getWrappedTextHeight(title, this.width - 20);
        this.contentHeight += titleHeight + 8;
        String author = "By " + (this.postInfo.author() != null ? this.postInfo.author() : "Unknown");
        context.method_25303(this.client.field_1772, author, this.x + 10, currentY += titleHeight + 8, -5592406);
        this.contentHeight += 12;
        String downloads = "Downloads: " + this.postInfo.downloads();
        context.method_25303(this.client.field_1772, downloads, this.x + 10, currentY += 12, -5592406);
        currentY += 16;
        this.contentHeight += 16;
        String[] tags = this.postInfo.tags();
        if (tags != null && tags.length > 0) {
            context.method_25303(this.client.field_1772, "Tags:", this.x + 10, currentY, -5592406);
            currentY += 12;
            this.contentHeight += 12;
            int tagX = this.x + 10;
            for (String tag : tags) {
                int tagWidth = this.client.field_1772.method_1727(tag) + 8;
                if (tagX + tagWidth > this.x + this.width - 10) {
                    tagX = this.x + 10;
                    currentY += 14;
                    this.contentHeight += 14;
                }
                context.method_25294(tagX, currentY, tagX + tagWidth, currentY + 12, -12961222);
                context.method_25303(this.client.field_1772, tag, tagX + 4, currentY + 2, -3355444);
                tagX += tagWidth + 4;
            }
            currentY += 16;
            this.contentHeight += 16;
        }
        if ((versions = this.postInfo.versions()) != null && versions.length > 0) {
            context.method_25303(this.client.field_1772, "Versions:", this.x + 10, currentY, -5592406);
            currentY += 12;
            this.contentHeight += 12;
            StringBuilder versionText = new StringBuilder();
            for (int i = 0; i < Math.min(5, versions.length); ++i) {
                if (i > 0) {
                    versionText.append(", ");
                }
                versionText.append(versions[i]);
            }
            if (versions.length > 5) {
                versionText.append("... (+").append(versions.length - 5).append(" more)");
            }
            context.method_25303(this.client.field_1772, versionText.toString(), this.x + 10, currentY, -3355444);
            currentY += 16;
            this.contentHeight += 16;
        }
        if (this.postDetail != null && this.postDetail.getDescription() != null && !this.postDetail.getDescription().isEmpty()) {
            this.contentHeight += 8;
            context.method_25303(this.client.field_1772, "Description:", this.x + 10, currentY += 8, -5592406);
            this.contentHeight += 12;
            String desc = this.postDetail.getDescription();
            this.drawWrappedText(context, desc, this.x + 10, currentY += 12, this.width - 20, -3355444);
            int descHeight = this.getWrappedTextHeight(desc, this.width - 20);
            currentY += descHeight;
            this.contentHeight += descHeight;
        } else if (this.isLoadingDetails) {
            context.method_25303(this.client.field_1772, "Loading details...", this.x + 10, currentY += 8, -5592406);
            currentY += 20;
            this.contentHeight += 20;
        }
        if (this.postInfo != null && "redenmc".equalsIgnoreCase(this.postInfo.vendor()) && this.postInfo.urlRedirect() != null && !this.postInfo.urlRedirect().isEmpty()) {
            this.contentHeight += 8;
            int btnWidth = 120;
            int btnHeight = 20;
            int btnX = this.x + 10;
            int btnY = currentY += 8;
            if (this.redirectLinkButton == null) {
                this.redirectLinkButton = new CustomButton(btnX, btnY, btnWidth, btnHeight, class_2561.method_30163((String)"\ud83d\udd17 View on Website"), button -> this.showRedirectConfirmation());
            } else {
                this.redirectLinkButton.method_46421(btnX);
                this.redirectLinkButton.method_46419(btnY);
            }
            this.redirectLinkButton.method_25394(context, renderMouseX, renderMouseY, delta);
            currentY += btnHeight + 8;
            this.contentHeight += btnHeight + 8;
        } else {
            this.redirectLinkButton = null;
        }
        this.contentHeight += 20;
        context.method_44380();
        if (this.schematicDropdown != null && this.schematicDropdown.isOpen()) {
            this.schematicDropdown.method_25394(context, mouseX, mouseY, delta);
        }
        if (this.confirmPopup != null) {
            this.confirmPopup.method_25394(context, mouseX, mouseY, delta);
        }
        if (this.contentHeight > this.height) {
            this.scrollBar.setScrollData(this.contentHeight, this.height);
            this.scrollBar.setScrollPercentage(this.scrollOffset / (double)Math.max(1, this.contentHeight - this.height));
            if (this.client != null && this.client.method_22683() != null) {
                long windowHandle = this.client.method_22683().method_4490();
                if (this.scrollBar.updateAndRender(context, mouseX, mouseY, delta, windowHandle)) {
                    double maxScroll = Math.max(0, this.contentHeight - this.height);
                    this.scrollOffset = this.scrollBar.getScrollPercentage() * maxScroll;
                }
            } else {
                this.scrollBar.method_25394(context, mouseX, mouseY, delta);
            }
        }
    }

    public boolean hasImageViewerOpen() {
        return this.imageViewer != null;
    }

    public void renderImageViewer(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.imageViewer != null) {
            this.imageViewer.render(context, mouseX, mouseY, delta);
        }
    }

    private void drawWrappedText(class_332 context, String text, int textX, int textY, int maxWidth, int color) {
        String[] paragraphs;
        if (text == null || text.isEmpty()) {
            return;
        }
        int lineY = textY;
        for (String paragraph : paragraphs = text.split("\\r?\\n")) {
            if (paragraph.isEmpty()) {
                lineY += 10;
                continue;
            }
            String[] words = paragraph.split(" ");
            StringBuilder line = new StringBuilder();
            for (String word : words) {
                Object testLine = !line.isEmpty() ? String.valueOf(line) + " " + word : word;
                int testWidth = this.client.field_1772.method_1727((String)testLine);
                if (testWidth > maxWidth && !line.isEmpty()) {
                    context.method_25303(this.client.field_1772, line.toString(), textX, lineY, color);
                    line = new StringBuilder(word);
                    lineY += 10;
                    continue;
                }
                line = new StringBuilder((String)testLine);
            }
            if (line.isEmpty()) continue;
            context.method_25303(this.client.field_1772, line.toString(), textX, lineY, color);
            lineY += 10;
        }
    }

    private int getWrappedTextHeight(String text, int maxWidth) {
        String[] paragraphs;
        if (text == null || text.isEmpty()) {
            return 10;
        }
        int lines = 0;
        for (String paragraph : paragraphs = text.split("\\r?\\n")) {
            if (paragraph.isEmpty()) {
                ++lines;
                continue;
            }
            String[] words = paragraph.split(" ");
            StringBuilder line = new StringBuilder();
            int paragraphLines = 1;
            for (String word : words) {
                Object testLine = !line.isEmpty() ? String.valueOf(line) + " " + word : word;
                int testWidth = this.client.field_1772.method_1727((String)testLine);
                if (testWidth > maxWidth && !line.isEmpty()) {
                    line = new StringBuilder(word);
                    ++paragraphLines;
                    continue;
                }
                line = new StringBuilder((String)testLine);
            }
            lines += paragraphLines;
        }
        return Math.max(lines, 1) * 10;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.imageViewer != null) {
            return this.imageViewer.mouseClicked(mouseX, mouseY, button);
        }
        if (this.confirmPopup != null) {
            return this.confirmPopup.mouseClicked(mouseX, mouseY, button);
        }
        if (this.schematicDropdown != null && this.schematicDropdown.isOpen()) {
            if (this.schematicDropdown.method_25405(mouseX, mouseY)) {
                boolean handled = this.schematicDropdown.mouseClicked(mouseX, mouseY, button);
                return handled;
            }
            this.schematicDropdown.close();
        }
        if (mouseX < (double)this.x || mouseX >= (double)(this.x + this.width) || mouseY < (double)this.y || mouseY >= (double)(this.y + this.height)) {
            return false;
        }
        System.out.println("[PostDetailPanel] mouseClicked - x:" + mouseX + " y:" + mouseY + " button:" + button);
        if (button == 0 && this.downloadButton != null && this.postInfo != null) {
            boolean isOverDownload;
            boolean bl = isOverDownload = mouseX >= (double)this.downloadButton.method_46426() && mouseX < (double)(this.downloadButton.method_46426() + this.downloadButton.method_25368()) && mouseY >= (double)this.downloadButton.method_46427() && mouseY < (double)(this.downloadButton.method_46427() + this.downloadButton.method_25364());
            if (isOverDownload && this.downloadButton.field_22763) {
                this.onDownloadButtonClick();
                return true;
            }
        }
        if (button == 0 && this.redirectLinkButton != null) {
            boolean isOverRedirect;
            boolean bl = isOverRedirect = mouseX >= (double)this.redirectLinkButton.method_46426() && mouseX < (double)(this.redirectLinkButton.method_46426() + this.redirectLinkButton.method_25368()) && mouseY >= (double)this.redirectLinkButton.method_46427() && mouseY < (double)(this.redirectLinkButton.method_46427() + this.redirectLinkButton.method_25364());
            if (isOverRedirect) {
                this.showRedirectConfirmation();
                return true;
            }
        }
        if (this.scrollBar != null && this.scrollBar.mouseClicked(mouseX, mouseY, button)) {
            System.out.println("[PostDetailPanel] Scrollbar handled the click");
            return true;
        }
        if (button == 0 && this.currentImageTexture != null && !this.isLoadingImage && this.postInfo != null) {
            int downloadBtnSize = 20;
            int contentStartY = this.y + downloadBtnSize;
            int currentY = contentStartY + 10 - (int)this.scrollOffset;
            int containerWidth = this.getDisplayImageWidth();
            int containerHeight = this.getDisplayImageHeight();
            int actualImageWidth = this.getActualImageWidth();
            int actualImageHeight = this.getActualImageHeight();
            int containerX = this.x + 1;
            int containerY = currentY;
            int imageX = containerX + (containerWidth - actualImageWidth) / 2;
            int imageY = containerY + (containerHeight - actualImageHeight) / 2;
            if (mouseX >= (double)imageX && mouseX < (double)(imageX + actualImageWidth) && mouseY >= (double)imageY && mouseY < (double)(imageY + actualImageHeight) && mouseY >= (double)contentStartY && mouseY < (double)(this.y + this.height)) {
                this.openImageViewer();
                return true;
            }
        }
        if (button == 0 && this.imageUrls != null && this.imageUrls.length > 1) {
            if (this.prevImageButton != null) {
                boolean isOverPrev;
                System.out.println("[PostDetailPanel] Checking prev button - btnX:" + this.prevImageButton.method_46426() + " btnY:" + this.prevImageButton.method_46427() + " btnW:" + this.prevImageButton.method_25368() + " btnH:" + this.prevImageButton.method_25364());
                boolean bl = isOverPrev = mouseX >= (double)this.prevImageButton.method_46426() && mouseX < (double)(this.prevImageButton.method_46426() + this.prevImageButton.method_25368()) && mouseY >= (double)this.prevImageButton.method_46427() && mouseY < (double)(this.prevImageButton.method_46427() + this.prevImageButton.method_25364());
                if (isOverPrev) {
                    System.out.println("[PostDetailPanel] Previous button clicked!");
                    this.previousImage();
                    return true;
                }
            }
            if (this.nextImageButton != null) {
                boolean isOverNext;
                System.out.println("[PostDetailPanel] Checking next button - btnX:" + this.nextImageButton.method_46426() + " btnY:" + this.nextImageButton.method_46427() + " btnW:" + this.nextImageButton.method_25368() + " btnH:" + this.nextImageButton.method_25364());
                boolean bl = isOverNext = mouseX >= (double)this.nextImageButton.method_46426() && mouseX < (double)(this.nextImageButton.method_46426() + this.nextImageButton.method_25368()) && mouseY >= (double)this.nextImageButton.method_46427() && mouseY < (double)(this.nextImageButton.method_46427() + this.nextImageButton.method_25364());
                if (isOverNext) {
                    System.out.println("[PostDetailPanel] Next button clicked!");
                    this.nextImage();
                    return true;
                }
            }
        }
        return true;
    }

    private void previousImage() {
        if (this.imageUrls != null && this.imageUrls.length > 1) {
            this.currentImageIndex = (this.currentImageIndex - 1 + this.imageUrls.length) % this.imageUrls.length;
            this.loadImage(this.imageUrls[this.currentImageIndex]);
        }
    }

    private void nextImage() {
        if (this.imageUrls != null && this.imageUrls.length > 1) {
            this.currentImageIndex = (this.currentImageIndex + 1) % this.imageUrls.length;
            this.loadImage(this.imageUrls[this.currentImageIndex]);
        }
    }

    private void openImageViewer() {
        if (this.currentImageTexture != null && this.client != null && this.client.method_22683() != null) {
            int screenWidth = this.client.method_22683().method_4486();
            int screenHeight = this.client.method_22683().method_4502();
            int totalImages = this.imageUrls != null ? this.imageUrls.length : 1;
            this.imageViewer = new ImageViewerWidget(this.client, this.currentImageTexture, this.originalImageWidth, this.originalImageHeight, this.currentImageIndex, totalImages, this::previousImageInViewer, this::nextImageInViewer, this::closeImageViewer);
            this.imageViewer.updateLayout(screenWidth, screenHeight);
        }
    }

    private void previousImageInViewer() {
        if (this.imageUrls != null && this.imageUrls.length > 1) {
            this.currentImageIndex = (this.currentImageIndex - 1 + this.imageUrls.length) % this.imageUrls.length;
            this.loadImage(this.imageUrls[this.currentImageIndex]);
            this.closeImageViewer();
            this.openImageViewer();
        }
    }

    private void nextImageInViewer() {
        if (this.imageUrls != null && this.imageUrls.length > 1) {
            this.currentImageIndex = (this.currentImageIndex + 1) % this.imageUrls.length;
            this.loadImage(this.imageUrls[this.currentImageIndex]);
            this.closeImageViewer();
            this.openImageViewer();
        }
    }

    private void closeImageViewer() {
        this.imageViewer = null;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.scrollBar != null && (this.scrollBar.isDragging() || this.scrollBar.mouseDragged(mouseX, mouseY, button, deltaX, deltaY))) {
            double maxScroll = Math.max(0, this.contentHeight - this.height);
            this.scrollOffset = this.scrollBar.getScrollPercentage() * maxScroll;
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.imageViewer != null) {
            return this.imageViewer.mouseReleased(mouseX, mouseY, button);
        }
        return this.scrollBar != null && this.scrollBar.mouseReleased(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.imageViewer != null) {
            return true;
        }
        if (this.schematicDropdown != null && this.schematicDropdown.isOpen() && this.schematicDropdown.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)) {
            return true;
        }
        if (mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height)) {
            double maxScroll = Math.max(0, this.contentHeight - this.height + 10);
            this.scrollOffset = Math.max(0.0, Math.min(maxScroll, this.scrollOffset - verticalAmount * 20.0));
            return true;
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.confirmPopup != null && keyCode == 256) {
            this.closeConfirmPopup();
            return true;
        }
        if (this.imageViewer != null) {
            return this.imageViewer.keyPressed(keyCode, scanCode, modifiers);
        }
        if (this.imageUrls != null && this.imageUrls.length > 1) {
            if (keyCode == 263) {
                this.previousImage();
                return true;
            }
            if (keyCode == 262) {
                this.nextImage();
                return true;
            }
        }
        return false;
    }

    public void method_25365(boolean focused) {
    }

    public boolean method_25370() {
        return false;
    }

    private /* synthetic */ void lambda$downloadSchematic$16(String errorMsg) {
        this.downloadStatus = errorMsg;
        if (this.schematicDropdown != null) {
            this.schematicDropdown.setStatusMessage(this.downloadStatus);
        }
    }
}

