/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui.widget;

import com.choculaterie.models.ModMessage;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;

@Environment(value=EnvType.CLIENT)
public class ModMessageBanner
implements class_4068,
class_364 {
    private static final int BANNER_HEIGHT = 30;
    private static final int CLOSE_BUTTON_SIZE = 12;
    private static final int INFO_BG_COLOR = -534669581;
    private static final int WARNING_BG_COLOR = -520120320;
    private static final int ERROR_BG_COLOR = -520862922;
    private static final int DEFAULT_BG_COLOR = -533054918;
    private static final int CLOSE_HOVER_COLOR = 0x40FFFFFF;
    private final class_310 client;
    private int x;
    private int y;
    private int width;
    private ModMessage message;
    private Consumer<ModMessage> onDismiss;
    private boolean visible = false;

    public ModMessageBanner(int x, int y, int width) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.client = class_310.method_1551();
    }

    public void setMessage(ModMessage message) {
        this.message = message;
        this.visible = message != null && message.hasMessage();
    }

    public void setOnDismiss(Consumer<ModMessage> onDismiss) {
        this.onDismiss = onDismiss;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public int getHeight() {
        return this.visible ? 30 : 0;
    }

    public void hide() {
        this.visible = false;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        if (!this.visible) {
            return false;
        }
        return mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + 30);
    }

    private int getCloseButtonX() {
        return this.x + this.width - 12 - 10;
    }

    private int getCloseButtonY() {
        return this.y + 9;
    }

    private boolean isOverCloseButton(double mouseX, double mouseY) {
        int closeX = this.getCloseButtonX();
        int closeY = this.getCloseButtonY();
        return mouseX >= (double)closeX && mouseX < (double)(closeX + 12) && mouseY >= (double)closeY && mouseY < (double)(closeY + 12);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (!this.visible || this.message == null || !this.message.hasMessage()) {
            return;
        }
        int bgColor = this.getBackgroundColor(this.message.type());
        this.drawBackground(context, bgColor);
        this.drawBorder(context);
        this.drawMessageText(context);
        this.drawCloseButton(context, mouseX, mouseY);
    }

    private void drawBackground(class_332 context, int bgColor) {
        context.method_25294(this.x, this.y, this.x + this.width, this.y + 30, bgColor);
    }

    private void drawBorder(class_332 context) {
        context.method_25294(this.x, this.y + 30 - 1, this.x + this.width, this.y + 30, -16777216);
    }

    private void drawMessageText(class_332 context) {
        String text = this.message.message();
        if (text == null) {
            return;
        }
        int maxTextWidth = this.width - 20 - 12 - 10;
        text = this.truncateText(text, maxTextWidth);
        int textY = this.y + 11;
        context.method_25303(this.client.field_1772, text, this.x + 10, textY, -1);
    }

    private String truncateText(String text, int maxWidth) {
        if (this.client.field_1772.method_1727(text) <= maxWidth) {
            return text;
        }
        while (this.client.field_1772.method_1727(text + "...") > maxWidth && text.length() > 0) {
            text = text.substring(0, text.length() - 1);
        }
        return text + "...";
    }

    private void drawCloseButton(class_332 context, int mouseX, int mouseY) {
        int closeX = this.getCloseButtonX();
        int closeY = this.getCloseButtonY();
        if (this.isOverCloseButton(mouseX, mouseY)) {
            context.method_25294(closeX, closeY, closeX + 12, closeY + 12, 0x40FFFFFF);
        }
        String closeText = "\u2715";
        int closeTextWidth = this.client.field_1772.method_1727(closeText);
        context.method_25303(this.client.field_1772, closeText, closeX + (12 - closeTextWidth) / 2, closeY + 2, -1);
    }

    private int getBackgroundColor(String type) {
        if (type == null) {
            return -533054918;
        }
        return switch (type.toLowerCase()) {
            case "info" -> -534669581;
            case "warning" -> -520120320;
            case "error" -> -520862922;
            default -> -533054918;
        };
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.visible || button != 0) {
            return false;
        }
        if (this.isOverCloseButton(mouseX, mouseY)) {
            this.visible = false;
            if (this.onDismiss != null && this.message != null) {
                this.onDismiss.accept(this.message);
            }
            return true;
        }
        return false;
    }

    public void method_25365(boolean focused) {
    }

    public boolean method_25370() {
        return false;
    }
}

