/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui.widget;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import org.lwjgl.glfw.GLFW;

@Environment(value=EnvType.CLIENT)
public class CustomTextField
extends class_342 {
    private static final long KEY_INITIAL_DELAY = 400L;
    private static final long KEY_REPEAT_DELAY = 50L;
    private static final int TEXT_PADDING = 4;
    private static final long CURSOR_BLINK_MS = 500L;
    private static final int CLEAR_BUTTON_SIZE = 12;
    private final class_310 client;
    private Runnable onEnterPressed;
    private Runnable onChanged;
    private Runnable onClearPressed;
    private class_2561 placeholderText;
    private boolean wasEnterDown = false;
    private boolean wasClearButtonMouseDown = false;
    private static CustomTextField activeField = null;
    private static boolean callbackInstalled = false;
    private static long installedWindowHandle = 0L;
    private final KeyRepeatState backspaceState = new KeyRepeatState();
    private final KeyRepeatState deleteState = new KeyRepeatState();
    private final KeyRepeatState leftState = new KeyRepeatState();
    private final KeyRepeatState rightState = new KeyRepeatState();
    private boolean wasHomePressed = false;
    private boolean wasEndPressed = false;

    public CustomTextField(class_310 client, int x, int y, int width, int height, class_2561 text) {
        super(client.field_1772, x, y, width, height, text);
        this.client = client;
        this.method_1880(256);
        this.method_1858(false);
        this.method_1856(true);
    }

    public void method_1867(String text) {
    }

    public void setOnEnterPressed(Runnable callback) {
        this.onEnterPressed = callback;
    }

    public void setOnChanged(Runnable callback) {
        this.onChanged = callback;
    }

    public void setOnClearPressed(Runnable callback) {
        this.onClearPressed = callback;
    }

    public void method_25365(boolean focused) {
        super.method_25365(focused);
        if (focused) {
            activeField = this;
            this.installCharCallback();
        } else if (activeField == this) {
            activeField = null;
        }
    }

    private void installCharCallback() {
        long windowHandle;
        long l = windowHandle = this.client.method_22683() != null ? this.client.method_22683().method_4490() : 0L;
        if (!(windowHandle == 0L || callbackInstalled && installedWindowHandle == windowHandle)) {
            GLFW.glfwSetCharCallback((long)windowHandle, (window, codepoint) -> {
                if (activeField != null && activeField.method_25370()) {
                    activeField.onCharTyped((char)codepoint);
                }
            });
            callbackInstalled = true;
            installedWindowHandle = windowHandle;
        }
    }

    private void onCharTyped(char c) {
        if (c < ' ') {
            return;
        }
        String currentText = this.method_1882();
        int cursorPos = this.method_1881();
        if (currentText.length() < 256) {
            String newText = currentText.substring(0, cursorPos) + c + currentText.substring(cursorPos);
            this.method_1852(newText);
            this.method_1883(cursorPos + 1, false);
            if (this.onChanged != null) {
                this.onChanged.run();
            }
        }
    }

    public void method_47404(class_2561 placeholder) {
        super.method_47404(placeholder);
        this.placeholderText = placeholder;
    }

    private boolean isOverClearButton(int mouseX, int mouseY) {
        if (this.method_1882().isEmpty()) {
            return false;
        }
        int clearX = this.method_46426() + this.method_25368() - 12 - 4;
        int clearY = this.method_46427() + (this.method_25364() - 12) / 2;
        return mouseX >= clearX && mouseX < clearX + 12 && mouseY >= clearY && mouseY < clearY + 12;
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        this.handleMouseInput(mouseX, mouseY);
        this.handleKeyboardInput();
        this.drawBackground(context);
        this.drawBorder(context);
        this.drawTextContent(context, mouseX, mouseY);
        this.drawClearButton(context, mouseX, mouseY);
    }

    private void handleMouseInput(int mouseX, int mouseY) {
        boolean isMouseDown;
        long windowHandle;
        long l = windowHandle = this.client.method_22683() != null ? this.client.method_22683().method_4490() : 0L;
        if (windowHandle == 0L) {
            this.wasClearButtonMouseDown = false;
            return;
        }
        boolean bl = isMouseDown = GLFW.glfwGetMouseButton((long)windowHandle, (int)0) == 1;
        if (!this.method_1882().isEmpty() && isMouseDown && !this.wasClearButtonMouseDown && this.isOverClearButton(mouseX, mouseY)) {
            this.method_1852("");
            if (this.onChanged != null) {
                this.onChanged.run();
            }
            if (this.onClearPressed != null) {
                this.onClearPressed.run();
            }
        }
        this.wasClearButtonMouseDown = isMouseDown;
    }

    private void handleKeyboardInput() {
        long windowHandle;
        long l = windowHandle = this.client.method_22683() != null ? this.client.method_22683().method_4490() : 0L;
        if (windowHandle == 0L) {
            return;
        }
        this.handleEnterKey(windowHandle);
        if (this.method_25370()) {
            this.handleSpecialKeys(windowHandle);
        }
    }

    private void handleEnterKey(long windowHandle) {
        boolean isEnterDown;
        boolean bl = isEnterDown = GLFW.glfwGetKey((long)windowHandle, (int)257) == 1 || GLFW.glfwGetKey((long)windowHandle, (int)335) == 1;
        if (this.method_25370() && this.onEnterPressed != null && isEnterDown && !this.wasEnterDown) {
            this.onEnterPressed.run();
        }
        this.wasEnterDown = isEnterDown;
    }

    private void drawBackground(class_332 context) {
        context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), -14013910);
    }

    private void drawBorder(class_332 context) {
        int borderColor = this.method_25370() ? -7829368 : -11184811;
        int borderWidth = 1;
        int x = this.method_46426();
        int y = this.method_46427();
        int width = this.method_25368();
        int height = this.method_25364();
        context.method_25294(x, y, x + width, y + borderWidth, borderColor);
        context.method_25294(x, y + height - borderWidth, x + width, y + height, borderColor);
        context.method_25294(x, y, x + borderWidth, y + height, borderColor);
        context.method_25294(x + width - borderWidth, y, x + width, y + height, borderColor);
    }

    private void drawTextContent(class_332 context, int mouseX, int mouseY) {
        int textY = this.method_46427() + (this.method_25364() - 8) / 2;
        int textX = this.method_46426() + 4;
        int maxTextWidth = this.method_25368() - 8 - (this.method_1882().isEmpty() ? 0 : 16);
        String text = this.method_1882();
        if (text.isEmpty() && !this.method_25370()) {
            this.drawPlaceholder(context, textX, textY);
        } else {
            this.drawActiveText(context, text, textX, textY, maxTextWidth);
        }
    }

    private void drawPlaceholder(class_332 context, int x, int y) {
        if (this.placeholderText != null) {
            context.method_27535(this.client.field_1772, this.placeholderText, x, y, -6710887);
        }
    }

    private void drawActiveText(class_332 context, String text, int textX, int textY, int maxTextWidth) {
        int color = this.method_25370() ? -1 : -5592406;
        context.method_44379(textX, this.method_46427(), textX + maxTextWidth, this.method_46427() + this.method_25364());
        context.method_25303(this.client.field_1772, text, textX, textY, color);
        context.method_44380();
        if (this.method_25370() && this.method_20315()) {
            this.drawCursor(context, text, textX, textY);
        }
    }

    private void drawCursor(class_332 context, String text, int textX, int textY) {
        if (System.currentTimeMillis() / 500L % 2L == 0L) {
            int cursorPos = this.method_1881();
            String beforeCursor = text.substring(0, Math.min(cursorPos, text.length()));
            int cursorX = textX + this.client.field_1772.method_1727(beforeCursor);
            context.method_25294(cursorX, textY - 1, cursorX + 1, textY + 9, -1);
        }
    }

    private void drawClearButton(class_332 context, int mouseX, int mouseY) {
        if (this.method_1882().isEmpty()) {
            return;
        }
        int clearX = this.method_46426() + this.method_25368() - 12 - 4;
        int clearY = this.method_46427() + (this.method_25364() - 12) / 2;
        boolean isHovered = this.isOverClearButton(mouseX, mouseY);
        int clearColor = isHovered ? -1 : -6710887;
        String xSymbol = "\u2715";
        int xWidth = this.client.field_1772.method_1727(xSymbol);
        int xX = clearX + (12 - xWidth) / 2;
        int xY = clearY + 2;
        context.method_25303(this.client.field_1772, xSymbol, xX, xY, clearColor);
    }

    private void handleSpecialKeys(long windowHandle) {
        boolean isEscapeDown;
        boolean isEndDown;
        boolean isHomeDown;
        boolean isRightDown;
        boolean isLeftDown;
        boolean isDeleteDown;
        boolean isBackspaceDown;
        long currentTime = System.currentTimeMillis();
        String currentText = this.method_1882();
        int cursorPos = this.method_1881();
        boolean bl = isBackspaceDown = GLFW.glfwGetKey((long)windowHandle, (int)259) == 1;
        if (this.backspaceState.shouldTrigger(currentTime, isBackspaceDown) && cursorPos > 0) {
            String newText = currentText.substring(0, cursorPos - 1) + currentText.substring(cursorPos);
            this.method_1852(newText);
            this.method_1883(cursorPos - 1, false);
            if (this.onChanged != null) {
                this.onChanged.run();
            }
        }
        boolean bl2 = isDeleteDown = GLFW.glfwGetKey((long)windowHandle, (int)261) == 1;
        if (this.deleteState.shouldTrigger(currentTime, isDeleteDown) && cursorPos < currentText.length()) {
            String newText = currentText.substring(0, cursorPos) + currentText.substring(cursorPos + 1);
            this.method_1852(newText);
            if (this.onChanged != null) {
                this.onChanged.run();
            }
        }
        boolean bl3 = isLeftDown = GLFW.glfwGetKey((long)windowHandle, (int)263) == 1;
        if (this.leftState.shouldTrigger(currentTime, isLeftDown) && cursorPos > 0) {
            this.method_1883(cursorPos - 1, false);
        }
        boolean bl4 = isRightDown = GLFW.glfwGetKey((long)windowHandle, (int)262) == 1;
        if (this.rightState.shouldTrigger(currentTime, isRightDown) && cursorPos < currentText.length()) {
            this.method_1883(cursorPos + 1, false);
        }
        boolean bl5 = isHomeDown = GLFW.glfwGetKey((long)windowHandle, (int)268) == 1;
        if (isHomeDown && !this.wasHomePressed) {
            this.method_1883(0, false);
        }
        this.wasHomePressed = isHomeDown;
        boolean bl6 = isEndDown = GLFW.glfwGetKey((long)windowHandle, (int)269) == 1;
        if (isEndDown && !this.wasEndPressed) {
            this.method_1883(currentText.length(), false);
        }
        this.wasEndPressed = isEndDown;
        boolean bl7 = isEscapeDown = GLFW.glfwGetKey((long)windowHandle, (int)256) == 1;
        if (isEscapeDown) {
            this.method_25365(false);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class KeyRepeatState {
        boolean wasPressed = false;
        long holdStart = 0L;
        long lastRepeat = 0L;

        private KeyRepeatState() {
        }

        boolean shouldTrigger(long currentTime, boolean isKeyDown) {
            if (!isKeyDown) {
                this.wasPressed = false;
                return false;
            }
            if (!this.wasPressed) {
                this.wasPressed = true;
                this.holdStart = currentTime;
                this.lastRepeat = currentTime;
                return true;
            }
            if (currentTime - this.holdStart > 400L && currentTime - this.lastRepeat > 50L) {
                this.lastRepeat = currentTime;
                return true;
            }
            return false;
        }
    }
}

