/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui.localfolder;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class LocalFolderSearchManager {
    private String searchQuery = "";
    private boolean isSearchActive = false;
    private final List<FileEntry> searchResults = new ArrayList<FileEntry>();

    public void updateSearch(String query) {
        this.searchQuery = query.toLowerCase();
        this.isSearchActive = !query.isEmpty();
        this.searchResults.clear();
    }

    public void clearSearch() {
        this.searchQuery = "";
        this.isSearchActive = false;
        this.searchResults.clear();
    }

    public void performSearch(File baseDirectory, File currentDirectory) {
        this.searchResults.clear();
        if (this.searchQuery.isEmpty()) {
            return;
        }
        this.searchRecursively(currentDirectory, "", baseDirectory);
    }

    private void searchRecursively(File directory, String pathPrefix, File baseDirectory) {
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            String displayPath;
            String string = displayPath = pathPrefix.isEmpty() ? file.getName() : pathPrefix + "/" + file.getName();
            if (file.getName().toLowerCase().contains(this.searchQuery)) {
                this.searchResults.add(new FileEntry(file, displayPath));
            }
            if (!file.isDirectory()) continue;
            this.searchRecursively(file, displayPath, baseDirectory);
        }
    }

    public String getSearchQuery() {
        return this.searchQuery;
    }

    public boolean isActive() {
        return this.isSearchActive;
    }

    public List<FileEntry> getResults() {
        return new ArrayList<FileEntry>(this.searchResults);
    }

    @Environment(value=EnvType.CLIENT)
    public static class FileEntry {
        public final File file;
        public final boolean isDirectory;
        public final String relativePath;

        public FileEntry(File file, String relativePath) {
            this.file = file;
            this.isDirectory = file.isDirectory();
            this.relativePath = relativePath;
        }
    }
}

