/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui;

import com.choculaterie.config.DownloadSettings;
import com.choculaterie.gui.LocalFolderPage;
import com.choculaterie.gui.widget.CustomButton;
import com.choculaterie.gui.widget.CustomTextField;
import com.choculaterie.gui.widget.LoadingSpinner;
import com.choculaterie.gui.widget.ModMessageBanner;
import com.choculaterie.gui.widget.PostDetailPanel;
import com.choculaterie.gui.widget.PostListWidget;
import com.choculaterie.gui.widget.SortFilterPanel;
import com.choculaterie.gui.widget.ToastManager;
import com.choculaterie.models.MinemevPostInfo;
import com.choculaterie.models.MinemevSearchResponse;
import com.choculaterie.models.ModMessage;
import com.choculaterie.network.ChoculaterieNetworkManager;
import com.choculaterie.network.MinemevNetworkManager;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class LitematicDownloaderScreen
extends class_437 {
    private static final int SEARCH_BAR_HEIGHT = 20;
    private static final int BUTTON_HEIGHT = 20;
    private static final int PADDING = 10;
    private static final int ITEMS_PER_PAGE = 20;
    private CustomTextField searchField;
    private PostListWidget postList;
    private PostDetailPanel detailPanel;
    private SortFilterPanel sortFilterPanel;
    private CustomButton searchButton;
    private CustomButton prevPageButton;
    private CustomButton nextPageButton;
    private CustomButton folderButton;
    private CustomButton filterButton;
    private CustomButton closeButton;
    private LoadingSpinner loadingSpinner;
    private ToastManager toastManager;
    private ModMessageBanner modMessageBanner;
    private int currentPage = 1;
    private int totalPages = 1;
    private int totalItems = 0;
    private boolean isLoading = false;
    private String currentSearchQuery = "";
    private boolean noResultsFound = false;
    private boolean showFilterPanel = false;
    private boolean initialized = false;

    public LitematicDownloaderScreen() {
        super(class_2561.method_30163((String)"Litematic Downloader"));
    }

    protected void method_25426() {
        String prevLabel;
        String searchLabel;
        int paginationButtonWidth;
        int searchButtonWidth;
        boolean isVeryCompact;
        String previousSearchText;
        super.method_25426();
        String string = previousSearchText = this.searchField != null ? this.searchField.method_1882() : "";
        if (this.field_22787 != null) {
            this.toastManager = new ToastManager(this.field_22787);
        }
        int leftPanelWidth = this.field_22789 / 2;
        int rightPanelWidth = this.field_22789 - leftPanelWidth;
        boolean isCompact = leftPanelWidth < 250;
        boolean bl = isVeryCompact = leftPanelWidth < 180;
        int n = isVeryCompact ? 25 : (searchButtonWidth = isCompact ? 40 : 70);
        int n2 = isVeryCompact ? 25 : (paginationButtonWidth = isCompact ? 50 : 80);
        String string2 = isVeryCompact ? "\ud83d\udd0d" : (searchLabel = isCompact ? "\ud83d\udd0d" : "Search");
        String string3 = isVeryCompact ? "\u25c0" : (prevLabel = isCompact ? "\u25c0" : "< Previous");
        String nextLabel = isVeryCompact ? "\u25b6" : (isCompact ? "\u25b6" : "Next >");
        int searchBarWidth = Math.max(50, leftPanelWidth - 30 - searchButtonWidth);
        this.loadingSpinner = new LoadingSpinner(leftPanelWidth / 2 - 16, this.field_22790 / 2 - 16);
        if (this.field_22787 != null) {
            this.searchField = new CustomTextField(this.field_22787, 10, 10, searchBarWidth, 20, class_2561.method_30163((String)"Search"));
            this.searchField.method_47404(class_2561.method_30163((String)(isCompact ? "Search..." : "Search schematics...")));
            this.searchField.setOnEnterPressed(this::performSearch);
            this.searchField.setOnClearPressed(this::performSearch);
            if (!previousSearchText.isEmpty()) {
                this.searchField.method_1852(previousSearchText);
            }
            this.method_37063((class_364)this.searchField);
        }
        this.searchButton = new CustomButton(10 + searchBarWidth + 10, 10, searchButtonWidth, 20, class_2561.method_30163((String)searchLabel), button -> this.performSearch());
        this.method_37063((class_364)this.searchButton);
        int listY = 40;
        int listHeight = this.field_22790 - listY - 20 - 20;
        int listWidth = leftPanelWidth - 20;
        if (this.postList == null) {
            this.postList = new PostListWidget(10, listY, listWidth, listHeight, this::onPostClick);
        } else {
            this.postList.setDimensions(10, listY, listWidth, listHeight);
        }
        this.method_37063((class_364)this.postList);
        int rightPanelContentWidth = rightPanelWidth - 10;
        int rightPanelContentHeight = this.field_22790 - 20;
        if (this.detailPanel == null) {
            this.detailPanel = new PostDetailPanel(leftPanelWidth, 10, rightPanelContentWidth, rightPanelContentHeight);
        } else {
            this.detailPanel.setDimensions(leftPanelWidth, 10, rightPanelContentWidth, rightPanelContentHeight);
        }
        this.sortFilterPanel = new SortFilterPanel(leftPanelWidth, 10, rightPanelContentWidth, rightPanelContentHeight);
        this.sortFilterPanel.setOnSettingsChanged(this::onFilterSettingsChanged);
        int closeButtonSize = 20;
        this.folderButton = new CustomButton(this.field_22789 - 10 - closeButtonSize * 3, 10, closeButtonSize, closeButtonSize, class_2561.method_30163((String)"\ud83d\udcc1"), button -> this.openFolderPage());
        this.filterButton = new CustomButton(this.field_22789 - 10 - closeButtonSize * 2, 10, closeButtonSize, closeButtonSize, class_2561.method_30163((String)"\u2699"), button -> this.toggleFilterPanel());
        this.closeButton = new CustomButton(this.field_22789 - 10 - closeButtonSize, 10, closeButtonSize, closeButtonSize, class_2561.method_30163((String)"X"), button -> this.method_25419());
        this.closeButton.setRenderAsXIcon(true);
        int bottomY = this.field_22790 - 20 - 10;
        this.prevPageButton = new CustomButton(10, bottomY, paginationButtonWidth, 20, class_2561.method_30163((String)prevLabel), button -> this.previousPage());
        this.prevPageButton.field_22763 = false;
        this.method_37063((class_364)this.prevPageButton);
        this.nextPageButton = new CustomButton(leftPanelWidth - 10 - paginationButtonWidth, bottomY, paginationButtonWidth, 20, class_2561.method_30163((String)nextLabel), button -> this.nextPage());
        this.nextPageButton.field_22763 = false;
        this.method_37063((class_364)this.nextPageButton);
        this.modMessageBanner = new ModMessageBanner(0, 0, this.field_22789);
        this.modMessageBanner.setOnDismiss(this::onModMessageDismissed);
        if (!this.initialized) {
            this.initialized = true;
            this.fetchModMessage();
            this.performSearch();
        } else {
            this.updatePaginationButtons();
        }
    }

    private void fetchModMessage() {
        ((CompletableFuture)ChoculaterieNetworkManager.getModMessage().thenAccept(message -> {
            if (this.field_22787 != null) {
                this.field_22787.execute(() -> {
                    if (message != null && message.hasMessage() && message.id() != null) {
                        int dismissedId = DownloadSettings.getInstance().getDismissedModMessageId();
                        if (message.id() != dismissedId) {
                            this.modMessageBanner.setMessage((ModMessage)message);
                        }
                    }
                });
            }
        })).exceptionally(throwable -> {
            System.err.println("[LitematicDownloaderScreen] Failed to fetch mod message: " + throwable.getMessage());
            return null;
        });
    }

    private void onModMessageDismissed(ModMessage message) {
        if (message != null && message.id() != null) {
            DownloadSettings.getInstance().setDismissedModMessageId(message.id());
        }
    }

    private boolean isMouseOverButton(CustomButton button, double mouseX, double mouseY) {
        return button != null && mouseX >= (double)button.method_46426() && mouseX < (double)(button.method_46426() + button.method_25368()) && mouseY >= (double)button.method_46427() && mouseY < (double)(button.method_46427() + button.method_25364());
    }

    private Object getActivePanel() {
        return this.showFilterPanel ? this.sortFilterPanel : this.detailPanel;
    }

    private void performSearch() {
        if (this.isLoading) {
            return;
        }
        this.searchField.method_25365(false);
        this.currentSearchQuery = this.searchField.method_1882().trim();
        this.currentPage = 1;
        this.detailPanel.clear();
        this.loadPage();
    }

    private void loadPage() {
        if (this.isLoading) {
            return;
        }
        this.isLoading = true;
        this.searchButton.field_22763 = false;
        this.prevPageButton.field_22763 = false;
        this.nextPageButton.field_22763 = false;
        this.postList.clear();
        String sort = this.sortFilterPanel != null ? this.sortFilterPanel.getSelectedSort() : "newest";
        String tag = this.sortFilterPanel != null ? this.sortFilterPanel.getTagFilter() : null;
        String excludeVendor = this.sortFilterPanel != null ? this.sortFilterPanel.getExcludedVendorsParam() : null;
        ((CompletableFuture)MinemevNetworkManager.searchPostsAdvanced(this.currentSearchQuery, sort, 1, this.currentPage, tag, null, excludeVendor).thenAccept(this::handleSearchResponse)).exceptionally(throwable -> {
            if (this.field_22787 != null) {
                this.field_22787.execute(() -> {
                    String causeMsg;
                    Throwable cause;
                    this.isLoading = false;
                    this.searchButton.field_22763 = true;
                    this.updatePaginationButtons();
                    String errorMessage = throwable.getMessage();
                    Object userMessage = errorMessage != null ? (errorMessage.contains("UnknownHostException") || errorMessage.contains("ConnectException") || errorMessage.contains("SocketTimeoutException") || errorMessage.contains("NoRouteToHostException") ? "Network error: No internet connection" : (errorMessage.contains("HTTP error code: 404") ? "Server error: Resource not found" : (errorMessage.contains("HTTP error code: 500") ? "Server error: Internal server error" : (errorMessage.contains("HTTP error code:") ? "Server error: " + errorMessage.substring(errorMessage.indexOf("HTTP error code:")) : (errorMessage.contains("Failed to search posts") ? ((cause = throwable.getCause()) != null ? ((causeMsg = cause.getMessage()) != null && causeMsg.contains("java.net.") ? "Network error: Cannot reach server" : "Search failed: " + (causeMsg != null ? causeMsg : "Unknown error")) : "Search failed: Connection error") : "Search failed: " + errorMessage))))) : "Search failed: Unknown error";
                    String fullError = "Error: " + errorMessage;
                    if (throwable.getCause() != null) {
                        fullError = fullError + "\nCause: " + throwable.getCause().toString();
                    }
                    System.err.println("Error loading posts: " + errorMessage);
                    if (this.toastManager != null) {
                        this.toastManager.showError((String)userMessage, fullError);
                    }
                });
            }
            return null;
        });
    }

    private void handleSearchResponse(MinemevSearchResponse response) {
        if (this.field_22787 != null) {
            this.field_22787.execute(() -> {
                this.totalPages = response.totalPages();
                this.totalItems = response.totalItems();
                MinemevPostInfo[] posts = response.posts();
                this.postList.setPosts(posts);
                this.isLoading = false;
                this.searchButton.field_22763 = true;
                this.updatePaginationButtons();
                this.noResultsFound = this.totalItems == 0;
            });
        }
    }

    private void updatePaginationButtons() {
        this.prevPageButton.field_22763 = this.currentPage > 1;
        this.nextPageButton.field_22763 = this.currentPage < this.totalPages;
    }

    private void previousPage() {
        if (this.currentPage > 1) {
            --this.currentPage;
            this.loadPage();
        }
    }

    private void nextPage() {
        if (this.currentPage < this.totalPages) {
            ++this.currentPage;
            this.loadPage();
        }
    }

    private void onPostClick(MinemevPostInfo post) {
        if (this.detailPanel != null && post != null) {
            this.detailPanel.setPost(post);
            if (this.showFilterPanel) {
                this.showFilterPanel = false;
            }
        }
    }

    private void openFolderPage() {
        if (this.detailPanel != null) {
            this.detailPanel.closeDropdown();
        }
        if (this.field_22787 != null) {
            LocalFolderPage folderPage = new LocalFolderPage(this);
            folderPage.setOnApiToggleChanged(this::refreshPostList);
            this.field_22787.method_1507((class_437)folderPage);
        }
    }

    public void refreshPostList() {
        this.currentPage = 1;
        this.loadPage();
    }

    private void toggleFilterPanel() {
        this.showFilterPanel = !this.showFilterPanel;
    }

    private void onFilterSettingsChanged(SortFilterPanel panel) {
        this.currentPage = 1;
        this.loadPage();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        int leftPanelWidth = this.field_22789 / 2;
        context.method_25294(0, 0, this.field_22789, this.field_22790, -14671840);
        boolean imageViewerOpen = this.detailPanel != null && this.detailPanel.hasImageViewerOpen();
        boolean confirmPopupOpen = this.detailPanel != null && this.detailPanel.hasConfirmPopupOpen();
        boolean mouseOverBanner = this.modMessageBanner != null && this.modMessageBanner.isVisible() && this.modMessageBanner.method_25405(mouseX, mouseY);
        int listMouseX = mouseOverBanner || imageViewerOpen || confirmPopupOpen ? -1 : mouseX;
        int listMouseY = mouseOverBanner || imageViewerOpen || confirmPopupOpen ? -1 : mouseY;
        int detailMouseX = mouseOverBanner || imageViewerOpen ? -1 : mouseX;
        int detailMouseY = mouseOverBanner || imageViewerOpen ? -1 : mouseY;
        super.method_25394(context, listMouseX, listMouseY, delta);
        if (this.showFilterPanel) {
            this.sortFilterPanel.method_25394(context, detailMouseX, detailMouseY, delta);
        } else {
            this.detailPanel.method_25394(context, detailMouseX, detailMouseY, delta);
        }
        if (this.totalPages > 1 || this.totalItems > 20) {
            boolean isVeryCompact;
            boolean isCompact = leftPanelWidth < 250;
            boolean bl = isVeryCompact = leftPanelWidth < 180;
            int paginationButtonWidth = isVeryCompact ? 25 : (isCompact ? 50 : 80);
            int availableWidth = leftPanelWidth - 10 - paginationButtonWidth - 10 - paginationButtonWidth - 10;
            String fullText = String.format("Page %d / %d (%d items)", this.currentPage, Math.max(this.totalPages, (int)Math.ceil((double)this.totalItems / 20.0)), this.totalItems);
            String mediumText = String.format("%d / %d", this.currentPage, Math.max(this.totalPages, 1));
            String shortText = String.format("%d/%d", this.currentPage, Math.max(this.totalPages, 1));
            String pageText = this.field_22793.method_1727(fullText) <= availableWidth ? fullText : (this.field_22793.method_1727(mediumText) <= availableWidth ? mediumText : (this.field_22793.method_1727(shortText) <= availableWidth ? shortText : null));
            if (pageText != null) {
                int textWidth = this.field_22793.method_1727(pageText);
                context.method_25303(this.field_22793, pageText, (leftPanelWidth - textWidth) / 2, this.field_22790 - 10 - 4 - 10, -1);
            }
        }
        if (this.isLoading) {
            this.loadingSpinner.method_25394(context, listMouseX, listMouseY, delta);
        }
        if (this.noResultsFound) {
            String noResultsText = "No results found :(";
            int textWidth = this.field_22793.method_1727(noResultsText);
            context.method_25303(this.field_22793, noResultsText, (leftPanelWidth - textWidth) / 2, this.field_22790 / 2 + 10, -1);
        }
        if (this.folderButton != null) {
            this.folderButton.method_25394(context, listMouseX, listMouseY, delta);
        }
        if (this.filterButton != null) {
            this.filterButton.method_25394(context, listMouseX, listMouseY, delta);
        }
        if (this.closeButton != null) {
            this.closeButton.method_25394(context, listMouseX, listMouseY, delta);
        }
        if (this.modMessageBanner != null && this.modMessageBanner.isVisible()) {
            this.modMessageBanner.method_25394(context, mouseX, mouseY, delta);
        }
        if (this.detailPanel != null && this.detailPanel.hasImageViewerOpen()) {
            this.detailPanel.renderImageViewer(context, mouseX, mouseY, delta);
        }
        if (this.toastManager != null) {
            this.toastManager.render(context, delta, mouseX, mouseY);
        }
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        double mouseX = click.comp_4798();
        double mouseY = click.comp_4799();
        int button = click.method_74245();
        if (this.detailPanel != null && this.detailPanel.hasImageViewerOpen()) {
            return this.detailPanel.mouseClicked(mouseX, mouseY, button);
        }
        if (button == 0 && this.toastManager != null) {
            if (this.toastManager.mouseClicked(mouseX, mouseY)) {
                return true;
            }
            if (this.toastManager.isMouseOverToast(mouseX, mouseY)) {
                return true;
            }
        }
        if (button == 0 && this.modMessageBanner != null && this.modMessageBanner.isVisible()) {
            if (this.modMessageBanner.mouseClicked(mouseX, mouseY, button)) {
                return true;
            }
            if (this.modMessageBanner.method_25405(mouseX, mouseY)) {
                return true;
            }
        }
        if (button == 0 && this.isMouseOverButton(this.closeButton, mouseX, mouseY)) {
            this.method_25419();
            return true;
        }
        if (button == 0 && this.isMouseOverButton(this.filterButton, mouseX, mouseY)) {
            this.toggleFilterPanel();
            return true;
        }
        if (button == 0 && this.isMouseOverButton(this.folderButton, mouseX, mouseY)) {
            this.openFolderPage();
            return true;
        }
        if (this.showFilterPanel ? this.sortFilterPanel != null && this.sortFilterPanel.mouseClicked(mouseX, mouseY, button) : this.detailPanel != null && this.detailPanel.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 0 && this.searchField != null) {
            if (this.searchField.method_25405(mouseX, mouseY)) {
                this.searchField.method_25365(true);
                return true;
            }
            this.searchField.method_25365(false);
        }
        return super.method_25402(click, doubled);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        Object panel = this.getActivePanel();
        if (panel instanceof SortFilterPanel && ((SortFilterPanel)panel).mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        return panel instanceof PostDetailPanel && ((PostDetailPanel)panel).mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        Object panel = this.getActivePanel();
        if (panel instanceof SortFilterPanel && ((SortFilterPanel)panel).mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        return panel instanceof PostDetailPanel && ((PostDetailPanel)panel).mouseReleased(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        Object panel = this.getActivePanel();
        if (panel instanceof SortFilterPanel && ((SortFilterPanel)panel).method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)) {
            return true;
        }
        if (panel instanceof PostDetailPanel && ((PostDetailPanel)panel).method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)) {
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25422() {
        if (this.detailPanel != null && this.detailPanel.hasConfirmPopupOpen()) {
            this.detailPanel.keyPressed(256, 0, 0);
            return false;
        }
        if (this.detailPanel != null && this.detailPanel.hasImageViewerOpen()) {
            this.detailPanel.keyPressed(256, 0, 0);
            return false;
        }
        return super.method_25422();
    }

    public void method_25419() {
        super.method_25419();
    }
}

