/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui;

import com.choculaterie.config.DownloadSettings;
import com.choculaterie.gui.widget.CustomButton;
import com.choculaterie.gui.widget.ScrollBar;
import com.choculaterie.gui.widget.ToastManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class DirectoryPickerScreen
extends class_437 {
    private static final int PADDING = 10;
    private static final int BUTTON_HEIGHT = 20;
    private static final int ITEM_HEIGHT = 25;
    private static final int SCROLLBAR_WIDTH = 8;
    private static final int SCROLLBAR_PADDING = 2;
    private final class_437 parentScreen;
    private final Consumer<String> onPathSelected;
    private File currentDirectory;
    private final List<File> directories = new ArrayList<File>();
    private int scrollOffset = 0;
    private ScrollBar scrollBar;
    private int selectedIndex = -1;
    private ToastManager toastManager;

    public DirectoryPickerScreen(class_437 parentScreen, String startPath, Consumer<String> onPathSelected) {
        super(class_2561.method_30163((String)"Select Directory"));
        File parentDir;
        this.parentScreen = parentScreen;
        this.onPathSelected = onPathSelected;
        File startDir = new File(startPath);
        if (!startDir.exists() || !startDir.isDirectory()) {
            startDir = new File(DownloadSettings.getInstance().getGameDirectory());
        }
        this.currentDirectory = (parentDir = startDir.getParentFile()) != null && parentDir.exists() ? parentDir : startDir;
        this.loadDirectories();
    }

    private int getListY() {
        return 70;
    }

    private int getListHeight() {
        return this.field_22790 - this.getListY() - 20 - 30;
    }

    private int getListRightEdge() {
        return this.field_22789 - 10 - 8 - 2;
    }

    private int getMaxVisibleItems() {
        return this.getListHeight() / 25;
    }

    private int getMaxScroll() {
        int listHeight;
        int contentHeight = this.directories.size() * 25;
        if (contentHeight <= (listHeight = this.getListHeight())) {
            return 0;
        }
        return Math.max(0, this.directories.size() - this.getMaxVisibleItems());
    }

    protected void method_25426() {
        String upLabel;
        int upButtonWidth;
        boolean isVeryCompact;
        super.method_25426();
        int savedScrollOffset = this.scrollOffset;
        int savedSelectedIndex = this.selectedIndex;
        if (this.field_22787 != null) {
            this.toastManager = new ToastManager(this.field_22787);
        }
        boolean isCompact = this.field_22789 < 400;
        boolean bl = isVeryCompact = this.field_22789 < 300;
        int n = isVeryCompact ? 30 : (upButtonWidth = isCompact ? 45 : 60);
        int selectButtonWidth = isVeryCompact ? 100 : (isCompact ? 150 : 200);
        String string = upLabel = isVeryCompact ? "\u2191" : "Up \u2191";
        String selectLabel = isVeryCompact ? "Select" : (isCompact ? "Select Folder" : "Select This Folder");
        CustomButton backButton = new CustomButton(10, 10, 20, 20, class_2561.method_30163((String)"\u2190"), button -> this.method_25419());
        this.method_37063((class_364)backButton);
        CustomButton upButton = new CustomButton(40, 10, upButtonWidth, 20, class_2561.method_30163((String)upLabel), button -> this.goUpDirectory());
        this.method_37063((class_364)upButton);
        CustomButton selectButton = new CustomButton(this.field_22789 / 2 - selectButtonWidth / 2, this.field_22790 - 10 - 20 - 10, selectButtonWidth, 20, class_2561.method_30163((String)selectLabel), button -> this.selectCurrentDirectory());
        this.method_37063((class_364)selectButton);
        int listY = this.getListY();
        int listHeight = this.getListHeight();
        this.scrollBar = new ScrollBar(this.field_22789 - 10 - 8, listY, listHeight);
        int contentHeight = this.directories.size() * 25;
        this.scrollBar.setScrollData(contentHeight, listHeight);
        int maxScroll = this.getMaxScroll();
        if (maxScroll > 0) {
            this.scrollOffset = Math.min(savedScrollOffset, maxScroll);
            this.scrollBar.setScrollPercentage((double)this.scrollOffset / (double)maxScroll);
        } else {
            this.scrollOffset = 0;
            this.scrollBar.setScrollPercentage(0.0);
        }
        this.selectedIndex = savedSelectedIndex;
    }

    private void loadDirectories() {
        File[] files;
        this.directories.clear();
        this.selectedIndex = -1;
        if (this.currentDirectory != null && this.currentDirectory.exists() && (files = this.currentDirectory.listFiles(File::isDirectory)) != null) {
            Arrays.sort(files, (a, b) -> a.getName().compareToIgnoreCase(b.getName()));
            this.directories.addAll(Arrays.asList(files));
        }
        this.updateScrollBar();
    }

    private void updateScrollBar() {
        if (this.scrollBar != null) {
            int listHeight = this.getListHeight();
            int contentHeight = this.directories.size() * 25;
            this.scrollBar.setScrollData(contentHeight, listHeight);
            int maxScroll = this.getMaxScroll();
            if (maxScroll > 0) {
                this.scrollOffset = Math.max(0, Math.min(maxScroll, this.scrollOffset));
                this.scrollBar.setScrollPercentage((double)this.scrollOffset / (double)maxScroll);
            } else {
                this.scrollOffset = 0;
                this.scrollBar.setScrollPercentage(0.0);
            }
        }
    }

    private void goUpDirectory() {
        File parent;
        if (this.currentDirectory != null && (parent = this.currentDirectory.getParentFile()) != null && parent.exists()) {
            this.currentDirectory = parent;
            this.loadDirectories();
            this.scrollOffset = 0;
        }
    }

    private void selectCurrentDirectory() {
        File directoryToSelect = this.selectedIndex >= 0 && this.selectedIndex < this.directories.size() ? this.directories.get(this.selectedIndex) : this.currentDirectory;
        if (directoryToSelect != null) {
            File gameDir = new File(DownloadSettings.getInstance().getGameDirectory());
            String relativePath = this.getRelativePath(gameDir, directoryToSelect);
            if (this.toastManager != null) {
                this.toastManager.showSuccess("Directory selected!");
            }
            this.onPathSelected.accept(relativePath);
            this.method_25419();
        }
    }

    private String getRelativePath(File base, File target) {
        try {
            String basePath = base.getCanonicalPath();
            String targetPath = target.getCanonicalPath();
            if (targetPath.startsWith(basePath)) {
                String relative = targetPath.substring(basePath.length());
                if (relative.startsWith(File.separator)) {
                    relative = relative.substring(1);
                }
                return relative.isEmpty() ? "." : relative;
            }
            return targetPath;
        }
        catch (Exception e) {
            return target.getAbsolutePath();
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        boolean scrollChanged;
        context.method_25294(0, 0, this.field_22789, this.field_22790, -14671840);
        super.method_25394(context, mouseX, mouseY, delta);
        String currentPath = this.currentDirectory != null ? this.currentDirectory.getAbsolutePath() : "";
        context.method_25303(this.field_22793, "Current: " + currentPath, 10, 50, -1);
        int listY = this.getListY();
        int listHeight = this.getListHeight();
        int maxVisibleItems = this.getMaxVisibleItems();
        int listRightEdge = this.getListRightEdge();
        context.method_25294(10, listY, listRightEdge, listY + listHeight, -15395563);
        context.method_44379(10, listY, listRightEdge, listY + listHeight);
        for (int i = this.scrollOffset; i < Math.min(this.directories.size(), this.scrollOffset + maxVisibleItems); ++i) {
            boolean isSelected;
            File dir = this.directories.get(i);
            int itemY = listY + (i - this.scrollOffset) * 25;
            boolean isHovered = mouseX >= 10 && mouseX < listRightEdge && mouseY >= itemY && mouseY < itemY + 25;
            boolean bl = isSelected = i == this.selectedIndex;
            int bgColor = isSelected ? -12566464 : (isHovered ? -14013910 : -15066598);
            context.method_25294(12, itemY + 2, listRightEdge - 2, itemY + 25 - 2, bgColor);
            String displayName = "\ud83d\udcc1 " + dir.getName();
            context.method_25303(this.field_22793, displayName, 15, itemY + 8, -1);
        }
        context.method_44380();
        if (this.scrollBar != null && this.scrollBar.isVisible() && this.field_22787 != null && (scrollChanged = this.scrollBar.updateAndRender(context, mouseX, mouseY, delta, this.field_22787.method_22683().method_4490()))) {
            int maxScroll = this.getMaxScroll();
            this.scrollOffset = (int)(this.scrollBar.getScrollPercentage() * (double)maxScroll);
        }
        if (this.toastManager != null) {
            this.toastManager.render(context, delta, mouseX, mouseY);
        }
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        int clickedIndex;
        double mouseX = click.comp_4798();
        double mouseY = click.comp_4799();
        int button = click.method_74245();
        if (super.method_25402(click, doubled)) {
            return true;
        }
        int listY = this.getListY();
        int listHeight = this.getListHeight();
        int listRightEdge = this.getListRightEdge();
        if (mouseX >= 10.0 && mouseX < (double)listRightEdge && mouseY >= (double)listY && mouseY < (double)(listY + listHeight) && (clickedIndex = this.scrollOffset + (int)((mouseY - (double)listY) / 25.0)) >= 0 && clickedIndex < this.directories.size() && button == 0) {
            if (clickedIndex == this.selectedIndex && doubled) {
                this.currentDirectory = this.directories.get(clickedIndex);
                this.loadDirectories();
                this.scrollOffset = 0;
            } else {
                this.selectedIndex = clickedIndex;
            }
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int maxScroll = this.getMaxScroll();
        this.scrollOffset = Math.max(0, Math.min(maxScroll, this.scrollOffset - (int)verticalAmount));
        if (this.scrollBar != null && maxScroll > 0) {
            this.scrollBar.setScrollPercentage((double)this.scrollOffset / (double)maxScroll);
        }
        return true;
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parentScreen);
        }
    }

    public boolean method_25421() {
        return false;
    }
}

