/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class DownloadSettings {
    private static final String CONFIG_FILE = "litematic-downloader-settings.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static DownloadSettings INSTANCE;
    private JsonObject config = this.loadConfig();

    private DownloadSettings() {
        this.applyDefaults();
    }

    public static DownloadSettings getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DownloadSettings();
        }
        return INSTANCE;
    }

    private JsonObject loadConfig() {
        JsonObject jsonObject;
        File configFile = this.getConfigFile();
        if (!configFile.exists()) {
            return new JsonObject();
        }
        FileReader reader = new FileReader(configFile);
        try {
            JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            jsonObject = json != null ? json : new JsonObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                System.err.println("Failed to load settings: " + e.getMessage());
                return new JsonObject();
            }
        }
        reader.close();
        return jsonObject;
    }

    private void applyDefaults() {
        this.setDefault("downloadPath", "schematics");
        this.setDefault("successToastsEnabled", false);
        this.setDefault("errorToastsEnabled", true);
        this.setDefault("infoToastsEnabled", false);
        this.setDefault("warningToastsEnabled", true);
        this.setDefault("sortOption", "newest");
        this.setDefault("itemsPerPage", 20);
        this.setDefault("tagFilter", "");
        this.setDefault("excludedVendors", "");
        this.setDefault("dismissedModMessageId", -1);
        this.setDefault("useChoculaterieAPI", false);
    }

    private void setDefault(String key, Object value) {
        if (!this.config.has(key)) {
            if (value instanceof String) {
                this.config.addProperty(key, (String)value);
            } else if (value instanceof Number) {
                this.config.addProperty(key, (Number)value);
            } else if (value instanceof Boolean) {
                this.config.addProperty(key, (Boolean)value);
            }
        }
    }

    public String getDownloadPath() {
        return this.config.get("downloadPath").getAsString();
    }

    public String getAbsoluteDownloadPath() {
        Path gamePath = FabricLoader.getInstance().getGameDir();
        return gamePath.resolve(this.getDownloadPath()).toString();
    }

    public String getGameDirectory() {
        return FabricLoader.getInstance().getGameDir().toString();
    }

    private boolean isToastEnabled(String type) {
        return this.config.get(type + "ToastsEnabled").getAsBoolean();
    }

    public String getSortOption() {
        return this.config.get("sortOption").getAsString();
    }

    public int getItemsPerPage() {
        return this.config.get("itemsPerPage").getAsInt();
    }

    public String getTagFilter() {
        return this.config.get("tagFilter").getAsString();
    }

    public String getExcludedVendors() {
        return this.config.get("excludedVendors").getAsString();
    }

    public int getDismissedModMessageId() {
        return this.config.get("dismissedModMessageId").getAsInt();
    }

    private void set(String key, Object value) {
        if (value instanceof String) {
            this.config.addProperty(key, (String)value);
        } else if (value instanceof Number) {
            this.config.addProperty(key, (Number)value);
        } else if (value instanceof Boolean) {
            this.config.addProperty(key, (Boolean)value);
        }
        this.save();
    }

    public boolean isSuccessToastsEnabled() {
        return this.isToastEnabled("success");
    }

    public void setSuccessToastsEnabled(boolean enabled) {
        this.set("successToastsEnabled", enabled);
    }

    public boolean isErrorToastsEnabled() {
        return this.isToastEnabled("error");
    }

    public void setErrorToastsEnabled(boolean enabled) {
        this.set("errorToastsEnabled", enabled);
    }

    public boolean isInfoToastsEnabled() {
        return this.isToastEnabled("info");
    }

    public void setInfoToastsEnabled(boolean enabled) {
        this.set("infoToastsEnabled", enabled);
    }

    public boolean isWarningToastsEnabled() {
        return this.isToastEnabled("warning");
    }

    public void setWarningToastsEnabled(boolean enabled) {
        this.set("warningToastsEnabled", enabled);
    }

    public void setDownloadPath(String path) {
        this.set("downloadPath", path);
    }

    public void setSortOption(String sortOption) {
        this.set("sortOption", sortOption);
    }

    public void setItemsPerPage(int itemsPerPage) {
        this.set("itemsPerPage", itemsPerPage);
    }

    public void setTagFilter(String tagFilter) {
        this.set("tagFilter", tagFilter != null ? tagFilter : "");
    }

    public void setExcludedVendors(String excludedVendors) {
        this.set("excludedVendors", excludedVendors != null ? excludedVendors : "");
    }

    public void setDismissedModMessageId(int messageId) {
        this.set("dismissedModMessageId", messageId);
    }

    public boolean isUseChoculaterieAPI() {
        return this.config.get("useChoculaterieAPI").getAsBoolean();
    }

    public void setUseChoculaterieAPI(boolean enabled) {
        this.set("useChoculaterieAPI", enabled);
    }

    private File getConfigFile() {
        Path configDir = FabricLoader.getInstance().getConfigDir();
        return configDir.resolve(CONFIG_FILE).toFile();
    }

    private void save() {
        try {
            File configFile = this.getConfigFile();
            File parentDir = configFile.getParentFile();
            if (parentDir != null && !parentDir.exists() && !parentDir.mkdirs()) {
                System.err.println("Failed to create config directory");
                return;
            }
            try (FileWriter writer = new FileWriter(configFile);){
                GSON.toJson((JsonElement)this.config, (Appendable)writer);
            }
        }
        catch (IOException e) {
            System.err.println("Failed to save settings: " + e.getMessage());
        }
    }
}

