/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui;

import com.choculaterie.SaveManagerMod;
import com.choculaterie.gui.AccountLinkingScreen;
import com.choculaterie.network.NetworkManager;
import com.choculaterie.widget.ConfirmPopup;
import com.choculaterie.widget.CustomButton;
import com.choculaterie.widget.LoadingSpinner;
import com.choculaterie.widget.ScrollBar;
import com.choculaterie.widget.ToastManager;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.Key;
import java.security.MessageDigest;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11909;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_526;

@Environment(value=EnvType.CLIENT)
public class SaveManagerScreen
extends class_437 {
    private static final int ROW_HEIGHT = 24;
    private static final int VISIBLE_ROWS = 8;
    private static final int PANEL_GAP = 20;
    private static final long RELOAD_THRESHOLD_MS = 900000L;
    private static long lastLoadTimeMs = 0L;
    private static final List<LocalSave> cachedLocalSaves = new ArrayList<LocalSave>();
    private static final List<CloudSave> cachedCloudSaves = new ArrayList<CloudSave>();
    private static String cachedQuotaFormatted = "Loading";
    private final class_437 parent;
    private final NetworkManager networkManager = new NetworkManager();
    private final ToastManager toastManager;
    private final LoadingSpinner spinner;
    private final List<LocalSave> localSaves = new ArrayList<LocalSave>();
    private final List<CloudSave> cloudSaves = new ArrayList<CloudSave>();
    private ScrollBar localScrollBar;
    private ScrollBar cloudScrollBar;
    private int localScrollOffset = 0;
    private int cloudScrollOffset = 0;
    private int localSelectedIndex = -1;
    private int cloudSelectedIndex = -1;
    private boolean localLoading = true;
    private boolean cloudLoading = true;
    private int localPanelX;
    private int localPanelW;
    private int cloudPanelX;
    private int cloudPanelW;
    private int listY;
    private int listH;
    private ConfirmPopup confirmPopup = null;
    private final List<CustomButton> allButtons = new ArrayList<CustomButton>();
    private CustomButton uploadBtn;
    private CustomButton downloadBtn;
    private CustomButton deleteBtn;
    private CustomButton refreshBtn;
    private String quotaFormatted = "Loading";
    private long quotaBytes = 0x140000000L;
    private boolean quotaLoading = false;
    private static final ActiveOp ACTIVE = new ActiveOp();
    private static float tinySpinnerAngle = 0.0f;

    public SaveManagerScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Save Manager"));
        this.parent = parent;
        this.toastManager = new ToastManager(null);
        this.spinner = new LoadingSpinner(0, 0);
    }

    protected void method_25426() {
        boolean shouldReload;
        this.initToastManager();
        int cx = this.field_22789 / 2;
        int btnSize = 20;
        int margin = 6;
        this.addCustomButton(margin, margin, btnSize, btnSize, (class_2561)class_2561.method_43470((String)"\u2190"), b -> this.closeScreen());
        this.addCustomButton(margin + btnSize + 5, margin, btnSize, btnSize, (class_2561)class_2561.method_43470((String)"\ud83d\udd04"), b -> this.refresh(), btn -> {
            this.refreshBtn = btn;
        });
        this.addCustomButton(this.field_22789 - margin - btnSize * 2 - 5, margin, btnSize, btnSize, (class_2561)class_2561.method_43470((String)"\ud83d\udcc1"), b -> this.openSavesFolder());
        this.addCustomButton(this.field_22789 - margin - btnSize, margin, btnSize, btnSize, (class_2561)class_2561.method_43470((String)"\u2699"), b -> this.field_22787.method_1507((class_437)new AccountLinkingScreen(this)));
        int totalW = this.field_22789 - 60;
        int panelW = (totalW - 20) / 2;
        this.localPanelX = 30;
        this.localPanelW = panelW;
        this.cloudPanelX = this.localPanelX + panelW + 20;
        this.cloudPanelW = panelW;
        this.listY = 70;
        this.listH = 192;
        this.localScrollBar = new ScrollBar(this.localPanelX + this.localPanelW + 4, this.listY, this.listH);
        this.cloudScrollBar = new ScrollBar(this.cloudPanelX + this.cloudPanelW + 4, this.listY, this.listH);
        int bottomY = this.field_22790 - 28;
        int btnW = 80;
        this.addCustomButton(this.localPanelX + (this.localPanelW - btnW) / 2, bottomY, btnW, 20, (class_2561)class_2561.method_43470((String)"Upload"), b -> this.onUpload(), btn -> {
            this.uploadBtn = btn;
        });
        this.addCustomButton(this.cloudPanelX + (this.cloudPanelW - btnW * 2 - 10) / 2, bottomY, btnW, 20, (class_2561)class_2561.method_43470((String)"Download"), b -> this.onDownload(), btn -> {
            this.downloadBtn = btn;
        });
        this.addCustomButton(this.cloudPanelX + (this.cloudPanelW - btnW * 2 - 10) / 2 + btnW + 10, bottomY, btnW, 20, (class_2561)class_2561.method_43470((String)"Delete"), b -> this.onDelete(), btn -> {
            this.deleteBtn = btn;
        });
        String apiKey = this.loadApiKeyFromDisk();
        if (apiKey == null || apiKey.isBlank()) {
            this.field_22787.method_1507((class_437)new AccountLinkingScreen(this));
            return;
        }
        this.networkManager.setApiKey(apiKey);
        this.quotaFormatted = cachedQuotaFormatted;
        this.quotaBytes = this.parseQuotaBytes(cachedQuotaFormatted);
        long now = System.currentTimeMillis();
        boolean bl = shouldReload = now - lastLoadTimeMs > 900000L || cachedLocalSaves.isEmpty();
        if (shouldReload) {
            this.quotaLoading = true;
            this.fetchLocalSaves();
            this.fetchCloudSaves();
            this.fetchQuotaInfo();
        } else {
            this.quotaLoading = false;
            this.localSaves.clear();
            this.localSaves.addAll(cachedLocalSaves);
            this.cloudSaves.clear();
            this.cloudSaves.addAll(cachedCloudSaves);
            this.localLoading = false;
            this.cloudLoading = false;
        }
    }

    private void addCustomButton(int x, int y, int width, int height, class_2561 message, class_4185.class_4241 onPress) {
        CustomButton button = new CustomButton(x, y, width, height, message, onPress);
        button.setToastManager(this.toastManager);
        this.allButtons.add(button);
        this.method_37063((class_364)button);
    }

    private void addCustomButton(int x, int y, int width, int height, class_2561 message, class_4185.class_4241 onPress, Consumer<CustomButton> store) {
        CustomButton button = new CustomButton(x, y, width, height, message, onPress);
        button.setToastManager(this.toastManager);
        this.allButtons.add(button);
        store.accept(button);
        this.method_37063((class_364)button);
    }

    private void initToastManager() {
        try {
            Field f = ToastManager.class.getDeclaredField("client");
            f.setAccessible(true);
            f.set(this.toastManager, this.field_22787);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void refresh() {
        this.localSelectedIndex = -1;
        this.cloudSelectedIndex = -1;
        this.localScrollOffset = 0;
        this.cloudScrollOffset = 0;
        this.fetchLocalSaves();
        this.fetchCloudSaves();
        this.fetchQuotaInfo();
    }

    private void openSavesFolder() {
        try {
            Path savesDir = this.field_22787.field_1697.toPath().resolve("saves");
            Files.createDirectories(savesDir, new FileAttribute[0]);
            class_156.method_668().method_672(savesDir.toFile());
        }
        catch (Exception e) {
            String cleanError = SaveManagerScreen.extractErrorMessage(e);
            SaveManagerMod.LOGGER.warn("LocalSaveManager: failed to open saves folder - {}", (Object)cleanError);
            this.toastManager.showError("Failed to open saves folder");
        }
    }

    private void fetchLocalSaves() {
        this.localLoading = true;
        CompletableFuture.runAsync(() -> {
            ArrayList<LocalSave> tmp = new ArrayList<LocalSave>();
            try {
                Path savesDir = this.field_22787.field_1697.toPath().resolve("saves");
                if (Files.exists(savesDir, new LinkOption[0]) && Files.isDirectory(savesDir, new LinkOption[0])) {
                    try (DirectoryStream<Path> ds = Files.newDirectoryStream(savesDir);){
                        for (Path p : ds) {
                            if (!Files.isDirectory(p, new LinkOption[0])) continue;
                            tmp.add(LocalSave.fromDir(p));
                        }
                    }
                }
                tmp.sort(Comparator.comparingLong(s -> s.lastModified).reversed());
            }
            catch (Exception e) {
                String cleanError = SaveManagerScreen.extractErrorMessage(e);
                SaveManagerMod.LOGGER.warn("LocalSaveManager: error scanning saves - {}", (Object)cleanError);
            }
            this.runOnClient(() -> {
                this.localSaves.clear();
                this.localSaves.addAll(tmp);
                cachedLocalSaves.clear();
                cachedLocalSaves.addAll(tmp);
                lastLoadTimeMs = System.currentTimeMillis();
                this.localScrollOffset = 0;
                this.localSelectedIndex = -1;
                this.localLoading = false;
            });
        });
    }

    private void fetchCloudSaves() {
        this.cloudLoading = true;
        this.networkManager.listWorldSaves().whenComplete((json, err) -> {
            if (err != null) {
                String cleanError = SaveManagerScreen.extractErrorMessage(err);
                SaveManagerMod.LOGGER.warn("CloudSaveManager: list failed - {}", (Object)cleanError);
                this.runOnClient(() -> {
                    this.cloudLoading = false;
                    this.cloudSaves.clear();
                    if (cleanError.contains("account must be linked")) {
                        this.toastManager.showError(cleanError, "Profile -> Edit profile -> Link");
                    } else {
                        this.toastManager.showError(cleanError);
                    }
                });
                return;
            }
            ArrayList<CloudSave> tmp = new ArrayList<CloudSave>();
            try {
                JsonArray arr = SaveManagerScreen.findArray(json, "saves", "items", "data", "list", "worlds");
                if (arr == null && json.has("result") && json.get("result").isJsonObject()) {
                    arr = SaveManagerScreen.findArray(json.getAsJsonObject("result"), "saves", "items", "data", "list", "worlds");
                }
                if (arr == null) {
                    for (Map.Entry e : json.entrySet()) {
                        if (e.getValue() == null || !((JsonElement)e.getValue()).isJsonArray()) continue;
                        arr = ((JsonElement)e.getValue()).getAsJsonArray();
                        break;
                    }
                }
                if (arr != null) {
                    for (int i = 0; i < arr.size(); ++i) {
                        if (!arr.get(i).isJsonObject()) continue;
                        tmp.add(CloudSave.from(arr.get(i).getAsJsonObject()));
                    }
                }
            }
            catch (Throwable parseEx) {
                String cleanError = SaveManagerScreen.extractErrorMessage(parseEx);
                SaveManagerMod.LOGGER.warn("CloudSaveManager: parse error - {}", (Object)cleanError);
            }
            this.runOnClient(() -> {
                this.cloudSaves.clear();
                this.cloudSaves.addAll(tmp);
                cachedCloudSaves.clear();
                cachedCloudSaves.addAll(tmp);
                this.cloudLoading = false;
                this.cloudScrollOffset = 0;
                this.cloudSelectedIndex = -1;
            });
        });
    }

    private void fetchQuotaInfo() {
        this.networkManager.getQuotaInfo().whenComplete((json, err) -> {
            if (err != null) {
                String cleanError = SaveManagerScreen.extractErrorMessage(err);
                SaveManagerMod.LOGGER.warn("QuotaManager: failed to fetch quota - {}", (Object)cleanError);
                this.quotaFormatted = cachedQuotaFormatted;
                this.runOnClient(() -> {
                    this.quotaLoading = false;
                });
                return;
            }
            try {
                String quota;
                this.quotaFormatted = quota = json.has("quotaFormatted") ? json.get("quotaFormatted").getAsString() : "5 GB";
                cachedQuotaFormatted = quota;
                this.quotaBytes = this.parseQuotaBytes(quota);
            }
            catch (Exception e) {
                String cleanError = SaveManagerScreen.extractErrorMessage(e);
                SaveManagerMod.LOGGER.warn("QuotaManager: error parsing quota - {}", (Object)cleanError);
                this.quotaFormatted = cachedQuotaFormatted;
            }
            this.runOnClient(() -> {
                this.quotaLoading = false;
            });
        });
    }

    private long parseQuotaBytes(String quotaFormatted) {
        if (quotaFormatted == null || quotaFormatted.isEmpty()) {
            return 0x140000000L;
        }
        try {
            String[] parts = quotaFormatted.trim().split("\\s+");
            if (parts.length >= 2) {
                String unit;
                double value = Double.parseDouble(parts[0]);
                long multiplier = switch (unit = parts[1].toUpperCase()) {
                    case "B" -> 1L;
                    case "KB" -> 1024L;
                    case "MB" -> 0x100000L;
                    case "GB" -> 0x40000000L;
                    case "TB" -> 0x10000000000L;
                    default -> 0x40000000L;
                };
                return (long)(value * (double)multiplier);
            }
        }
        catch (Exception e) {
            SaveManagerMod.LOGGER.warn("QuotaManager: failed to parse quota bytes from '{}'", (Object)quotaFormatted);
        }
        return 0x140000000L;
    }

    private void onUpload() {
        if (this.localSelectedIndex < 0 || this.localSelectedIndex >= this.localSaves.size()) {
            return;
        }
        if (this.networkManager.getApiKey() == null || this.networkManager.getApiKey().isBlank()) {
            this.field_22787.method_1507((class_437)new AccountLinkingScreen(this));
            return;
        }
        LocalSave s = this.localSaves.get(this.localSelectedIndex);
        this.localLoading = true;
        this.networkManager.listWorldSaveNames().whenComplete((names, err) -> this.runOnClient(() -> {
            if (err != null) {
                this.localLoading = false;
                this.field_22787.method_1507((class_437)new AccountLinkingScreen(this));
                return;
            }
            String sanitized = SaveManagerScreen.sanitizeFolderName(s.worldName);
            boolean exists = false;
            if (names != null) {
                for (String n : names) {
                    if (n == null || !n.equalsIgnoreCase(s.worldName) && (sanitized.isEmpty() || !n.equalsIgnoreCase(sanitized))) continue;
                    exists = true;
                    break;
                }
            }
            if (!exists) {
                this.beginZipAndUpload(s);
                return;
            }
            this.confirmPopup = new ConfirmPopup(this, "Overwrite Cloud Save?", "A save named \"" + s.worldName + "\" already exists. Overwrite?", () -> {
                this.confirmPopup = null;
                this.beginZipAndUpload(s);
            }, () -> {
                this.confirmPopup = null;
                this.localLoading = false;
            }, "Overwrite");
        }));
    }

    private void beginZipAndUpload(LocalSave s) {
        SaveManagerScreen.ACTIVE.upActive = true;
        SaveManagerScreen.ACTIVE.zipping = true;
        SaveManagerScreen.ACTIVE.bytes = 0L;
        SaveManagerScreen.ACTIVE.total = -1L;
        SaveManagerScreen.ACTIVE.lastTickNanos = System.nanoTime();
        SaveManagerScreen.ACTIVE.lastBytes = 0L;
        SaveManagerScreen.ACTIVE.speedBps = 0.0;
        this.localLoading = true;
        new Thread(() -> {
            Path zip;
            try {
                zip = SaveManagerScreen.zipWorld(s.dir, s.worldName.replaceAll("[\\\\/:*?\"<>|]+", "_"));
            }
            catch (Exception ex) {
                String cleanError = SaveManagerScreen.extractErrorMessage(ex);
                SaveManagerMod.LOGGER.warn("ZipManager: zip failed - {}", (Object)cleanError);
                this.runOnClient(() -> {
                    SaveManagerScreen.ACTIVE.upActive = false;
                    SaveManagerScreen.ACTIVE.zipping = false;
                    this.localLoading = false;
                    this.toastManager.showError(cleanError);
                });
                return;
            }
            this.runOnClient(() -> this.startUpload(zip, s.worldName));
        }, "SaveManager-zip").start();
    }

    private void startUpload(Path zipFile, String worldName) {
        SaveManagerScreen.ACTIVE.zipping = false;
        SaveManagerScreen.ACTIVE.bytes = 0L;
        SaveManagerScreen.ACTIVE.total = -1L;
        SaveManagerScreen.ACTIVE.lastTickNanos = System.nanoTime();
        SaveManagerScreen.ACTIVE.lastBytes = 0L;
        SaveManagerScreen.ACTIVE.speedBps = 0.0;
        try {
            this.networkManager.uploadWorldSave(worldName, zipFile, (sent, total) -> {
                SaveManagerScreen.ACTIVE.bytes = Math.max(0L, sent);
                if (total > 0L) {
                    SaveManagerScreen.ACTIVE.total = total;
                }
                this.updateSpeed();
            }).whenComplete((json, err) -> this.runOnClient(() -> {
                try {
                    Files.deleteIfExists(zipFile);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                SaveManagerScreen.ACTIVE.upActive = false;
                SaveManagerScreen.ACTIVE.zipping = false;
                this.localLoading = false;
                if (err != null) {
                    String cleanError = SaveManagerScreen.extractErrorMessage(err);
                    SaveManagerMod.LOGGER.warn("UploadManager: upload failed - {}", (Object)cleanError);
                    this.toastManager.showError(cleanError);
                } else {
                    this.toastManager.showSuccess("Upload complete: " + worldName);
                    this.fetchLocalSaves();
                    this.fetchCloudSaves();
                }
            }));
        }
        catch (Throwable t) {
            try {
                Files.deleteIfExists(zipFile);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            SaveManagerScreen.ACTIVE.upActive = false;
            this.localLoading = false;
            this.toastManager.showError("Upload failed");
        }
    }

    private void onDownload() {
        Path targetBase;
        if (this.cloudSelectedIndex < 0 || this.cloudSelectedIndex >= this.cloudSaves.size()) {
            return;
        }
        CloudSave s = this.cloudSaves.get(this.cloudSelectedIndex);
        this.cloudLoading = true;
        Path savesDir = this.field_22787.field_1697.toPath().resolve("saves");
        try {
            Files.createDirectories(savesDir, new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String baseName = SaveManagerScreen.sanitizeFolderName(s.worldName);
        if (baseName.isEmpty()) {
            baseName = "world";
        }
        if (Files.exists(targetBase = savesDir.resolve(baseName), new LinkOption[0])) {
            this.cloudLoading = false;
            this.confirmPopup = new ConfirmPopup(this, "Overwrite Local Save?", "A save named \"" + s.worldName + "\" already exists. Overwrite?", () -> {
                this.confirmPopup = null;
                this.beginDownload(s, savesDir);
            }, () -> {
                this.confirmPopup = null;
                this.cloudLoading = false;
            }, "Overwrite");
            return;
        }
        this.beginDownload(s, savesDir);
    }

    private void beginDownload(CloudSave s, Path savesDir) {
        Path tmpDir;
        this.cloudLoading = true;
        try {
            tmpDir = Files.createTempDirectory("savemanager-dl-", new FileAttribute[0]);
        }
        catch (Exception e) {
            this.toastManager.showError("Failed to prepare temp dir");
            this.cloudLoading = false;
            return;
        }
        SaveManagerScreen.ACTIVE.dlActive = true;
        SaveManagerScreen.ACTIVE.unzipping = false;
        SaveManagerScreen.ACTIVE.bytes = 0L;
        SaveManagerScreen.ACTIVE.total = s.fileSizeBytes > 0L ? s.fileSizeBytes : -1L;
        SaveManagerScreen.ACTIVE.lastTickNanos = System.nanoTime();
        SaveManagerScreen.ACTIVE.lastBytes = 0L;
        SaveManagerScreen.ACTIVE.speedBps = 0.0;
        this.networkManager.downloadWorldSave(s.id, tmpDir, (downloaded, total) -> {
            SaveManagerScreen.ACTIVE.bytes = Math.max(0L, downloaded);
            if (total > 0L) {
                SaveManagerScreen.ACTIVE.total = total;
            }
            this.updateSpeed();
        }).whenComplete((zipPath, err) -> {
            SaveManagerScreen.ACTIVE.dlActive = false;
            if (err != null) {
                String cleanError = SaveManagerScreen.extractErrorMessage(err);
                SaveManagerMod.LOGGER.warn("DownloadManager: download failed - {}", (Object)cleanError);
                this.runOnClient(() -> {
                    this.cloudLoading = false;
                    this.toastManager.showError(cleanError);
                });
                return;
            }
            this.runOnClient(() -> {
                SaveManagerScreen.ACTIVE.unzipping = true;
            });
            String baseName = SaveManagerScreen.sanitizeFolderName(s.worldName);
            if (baseName.isEmpty()) {
                baseName = "world";
            }
            Path targetBase = savesDir.resolve(baseName);
            try {
                Files.createDirectories(targetBase, new FileAttribute[0]);
                SaveManagerScreen.deleteDirectoryRecursively(targetBase);
                Files.createDirectories(targetBase, new FileAttribute[0]);
                SaveManagerScreen.unzipSmart(zipPath, targetBase);
                this.runOnClient(() -> {
                    this.toastManager.showSuccess("Download complete");
                    this.fetchLocalSaves();
                });
            }
            catch (Exception ex) {
                String cleanError = SaveManagerScreen.extractErrorMessage(ex);
                SaveManagerMod.LOGGER.warn("UnzipManager: unzip failed - {}", (Object)cleanError);
                this.runOnClient(() -> this.toastManager.showError(cleanError));
            }
            finally {
                try {
                    Files.deleteIfExists(zipPath);
                }
                catch (Exception exception) {}
                try {
                    Files.deleteIfExists(tmpDir);
                }
                catch (Exception exception) {}
                this.runOnClient(() -> {
                    SaveManagerScreen.ACTIVE.unzipping = false;
                    this.cloudLoading = false;
                });
            }
        });
    }

    private void onDelete() {
        if (this.localSelectedIndex >= 0 && this.localSelectedIndex < this.localSaves.size()) {
            LocalSave s = this.localSaves.get(this.localSelectedIndex);
            this.confirmPopup = new ConfirmPopup(this, "Delete Local Save?", "Are you sure you want to permanently delete \"" + SaveManagerScreen.safe(s.worldName) + "\"?", () -> {
                this.confirmPopup = null;
                this.deleteLocalSave(s);
            }, () -> {
                this.confirmPopup = null;
            }, "Delete");
            return;
        }
        if (this.cloudSelectedIndex < 0 || this.cloudSelectedIndex >= this.cloudSaves.size()) {
            return;
        }
        CloudSave s = this.cloudSaves.get(this.cloudSelectedIndex);
        this.confirmPopup = new ConfirmPopup(this, "Delete Cloud Save?", "Are you sure you want to permanently delete \"" + SaveManagerScreen.safe(s.worldName) + "\"?", () -> {
            this.confirmPopup = null;
            this.cloudLoading = true;
            this.networkManager.deleteWorldSave(s.id).whenComplete((resp, err) -> this.runOnClient(() -> {
                if (err != null) {
                    String cleanError = SaveManagerScreen.extractErrorMessage(err);
                    SaveManagerMod.LOGGER.warn("DeleteManager: delete failed - {}", (Object)cleanError);
                    this.toastManager.showError(cleanError);
                    this.cloudLoading = false;
                    return;
                }
                this.toastManager.showSuccess("Deleted");
                this.cloudLoading = false;
                this.cloudSelectedIndex = -1;
                this.fetchCloudSaves();
            }));
        }, () -> {
            this.confirmPopup = null;
        }, "Delete");
    }

    private void deleteLocalSave(LocalSave s) {
        new Thread(() -> {
            try {
                SaveManagerScreen.deleteDirectoryRecursively(s.dir);
                this.runOnClient(() -> {
                    this.toastManager.showSuccess("Deleted");
                    this.localSelectedIndex = -1;
                    this.fetchLocalSaves();
                });
            }
            catch (Exception e) {
                String cleanError = SaveManagerScreen.extractErrorMessage(e);
                SaveManagerMod.LOGGER.warn("DeleteManager: local delete failed - {}", (Object)cleanError);
                this.runOnClient(() -> this.toastManager.showError(cleanError));
            }
        }, "SaveManager-delete").start();
    }

    private void updateButtonStates() {
        boolean hasCloudSelected;
        boolean opActive = SaveManagerScreen.ACTIVE.dlActive || SaveManagerScreen.ACTIVE.upActive || SaveManagerScreen.ACTIVE.zipping || SaveManagerScreen.ACTIVE.unzipping;
        boolean isLoading = this.localLoading || this.cloudLoading;
        boolean hasLocalSelected = this.localSelectedIndex >= 0 && this.localSelectedIndex < this.localSaves.size();
        boolean bl = hasCloudSelected = this.cloudSelectedIndex >= 0 && this.cloudSelectedIndex < this.cloudSaves.size();
        if (this.uploadBtn != null) {
            boolean bl2 = this.uploadBtn.field_22763 = hasLocalSelected && !opActive;
        }
        if (this.downloadBtn != null) {
            boolean bl3 = this.downloadBtn.field_22763 = hasCloudSelected && !opActive;
        }
        if (this.deleteBtn != null) {
            boolean bl4 = this.deleteBtn.field_22763 = (hasLocalSelected || hasCloudSelected) && !opActive;
        }
        if (this.refreshBtn != null) {
            this.refreshBtn.field_22763 = !isLoading;
        }
    }

    private void updateSpeed() {
        long now = System.nanoTime();
        long dtNs = now - SaveManagerScreen.ACTIVE.lastTickNanos;
        long dBytes = SaveManagerScreen.ACTIVE.bytes - SaveManagerScreen.ACTIVE.lastBytes;
        if (dtNs > 50000000L) {
            double instBps = dBytes > 0L ? (double)dBytes * 1.0E9 / (double)dtNs : 0.0;
            SaveManagerScreen.ACTIVE.speedBps = SaveManagerScreen.ACTIVE.speedBps <= 0.0 ? instBps : 0.2 * instBps + 0.8 * SaveManagerScreen.ACTIVE.speedBps;
            SaveManagerScreen.ACTIVE.lastTickNanos = now;
            SaveManagerScreen.ACTIVE.lastBytes = SaveManagerScreen.ACTIVE.bytes;
        }
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        boolean opActive;
        super.method_25394(ctx, mouseX, mouseY, delta);
        this.updateButtonStates();
        int cx = this.field_22789 / 2;
        ctx.method_27534(this.field_22793, this.field_22785, cx, 10, -1);
        if (this.quotaLoading) {
            this.renderTinyLoadingSpinner(ctx, cx, 28, delta);
        } else {
            ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)this.computeQuotaLine()), cx, 22, -5592406);
        }
        ctx.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"Local Saves"), this.localPanelX, 50, -1);
        ctx.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"Cloud Saves"), this.cloudPanelX, 50, -1);
        this.renderLocalPanel(ctx, mouseX, mouseY, delta);
        this.renderCloudPanel(ctx, mouseX, mouseY, delta);
        boolean bl = opActive = SaveManagerScreen.ACTIVE.dlActive || SaveManagerScreen.ACTIVE.upActive || SaveManagerScreen.ACTIVE.zipping || SaveManagerScreen.ACTIVE.unzipping;
        if (opActive) {
            int statusY = this.field_22790 - 70;
            if (SaveManagerScreen.ACTIVE.zipping || SaveManagerScreen.ACTIVE.unzipping || SaveManagerScreen.ACTIVE.bytes <= 0L) {
                this.spinner.setPosition(cx - 16, statusY);
                this.spinner.method_25394(ctx, mouseX, mouseY, delta);
                String msg = SaveManagerScreen.ACTIVE.zipping ? "Zipping..." : (SaveManagerScreen.ACTIVE.unzipping ? "Unzipping..." : "Preparing...");
                ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)msg), cx, statusY + 40, -1);
            } else {
                this.renderProgressBar(ctx, cx, statusY);
            }
        } else if (this.localLoading || this.cloudLoading) {
            int statusY = this.field_22790 - 70;
            this.spinner.setPosition(cx - 16, statusY);
            this.spinner.method_25394(ctx, mouseX, mouseY, delta);
            ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Loading..."), cx, statusY + 40, -1);
        }
        this.toastManager.render(ctx, delta, mouseX, mouseY);
        if (this.confirmPopup != null) {
            this.confirmPopup.method_25394(ctx, mouseX, mouseY, delta);
        }
    }

    private void renderLocalPanel(class_332 ctx, int mouseX, int mouseY, float delta) {
        this.renderSavePanel(ctx, mouseX, mouseY, delta, true);
    }

    private void renderCloudPanel(class_332 ctx, int mouseX, int mouseY, float delta) {
        this.renderSavePanel(ctx, mouseX, mouseY, delta, false);
    }

    private void renderSavePanel(class_332 ctx, int mouseX, int mouseY, float delta, boolean isLocal) {
        List<Object> saves = isLocal ? this.localSaves : this.cloudSaves;
        ScrollBar scrollBar = isLocal ? this.localScrollBar : this.cloudScrollBar;
        int panelX = isLocal ? this.localPanelX : this.cloudPanelX;
        int panelW = isLocal ? this.localPanelW : this.cloudPanelW;
        int selectedIndex = isLocal ? this.localSelectedIndex : this.cloudSelectedIndex;
        int scrollOffset = isLocal ? this.localScrollOffset : this.cloudScrollOffset;
        int maxScroll = Math.max(0, saves.size() - 8);
        scrollBar.setScrollData(saves.size() * 24, this.listH);
        if (maxScroll > 0) {
            scrollBar.setScrollPercentage((double)scrollOffset / (double)maxScroll);
        }
        boolean blockHover = this.toastManager.isMouseOverToast(mouseX, mouseY) || this.confirmPopup != null;
        long windowHandle = this.field_22787.method_22683().method_4490();
        if (scrollBar.updateAndRender(ctx, mouseX, mouseY, delta, windowHandle)) {
            int newOffset = (int)Math.round(scrollBar.getScrollPercentage() * (double)maxScroll);
            if (isLocal) {
                this.localScrollOffset = newOffset;
            } else {
                this.cloudScrollOffset = newOffset;
            }
            scrollOffset = newOffset;
        }
        ctx.method_44379(panelX, this.listY, panelX + panelW, this.listY + this.listH);
        int end = Math.min(scrollOffset + 8, saves.size());
        for (int i = scrollOffset; i < end; ++i) {
            String info;
            String worldName;
            boolean isHovered;
            int ry = this.listY + (i - scrollOffset) * 24;
            boolean bl = isHovered = !blockHover && i == selectedIndex;
            if (isHovered) {
                ctx.method_25294(panelX, ry - 1, panelX + panelW, ry + 24 - 2, 0x66FFFFFF);
            }
            if (isLocal) {
                s = (LocalSave)saves.get(i);
                worldName = ((LocalSave)s).worldName;
                info = SaveManagerScreen.formatBytes(((LocalSave)s).sizeBytes) + " \u2022 " + SaveManagerScreen.shortDateMillis(((LocalSave)s).lastModified);
            } else {
                s = (CloudSave)saves.get(i);
                worldName = ((CloudSave)s).worldName;
                info = SaveManagerScreen.formatBytes(((CloudSave)s).fileSizeBytes) + " \u2022 " + SaveManagerScreen.shortDate(((CloudSave)s).updatedAt);
            }
            ctx.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)SaveManagerScreen.safe(worldName)), panelX + 4, ry + 2, -2236963);
            ctx.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)info), panelX + 4, ry + 12, -7829368);
            ctx.method_25294(panelX, ry + 24 - 2, panelX + panelW, ry + 24 - 1, 0x22FFFFFF);
        }
        ctx.method_44380();
    }

    private void renderProgressBar(class_332 ctx, int cx, int statusY) {
        long bytes = SaveManagerScreen.ACTIVE.bytes;
        long total = SaveManagerScreen.ACTIVE.total;
        double speed = SaveManagerScreen.ACTIVE.speedBps;
        int barW = 360;
        int barH = 8;
        int bx = cx - barW / 2;
        int by = statusY + 14;
        ctx.method_25294(bx, by, bx + barW, by + barH, -12303292);
        if (total > 0L) {
            double frac = Math.min(1.0, (double)bytes / (double)total);
            ctx.method_25294(bx, by, bx + (int)((double)barW * frac), by + barH, -3355444);
            int pct = (int)Math.min(100.0, (double)bytes * 100.0 / (double)total);
            ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)(pct + "%")), cx, by - 10, -1);
            String info = SaveManagerScreen.formatBytes(bytes) + " / " + SaveManagerScreen.formatBytes(total);
            if (speed > 1.0) {
                long remaining = Math.max(0L, total - bytes);
                long etaSec = (long)Math.ceil((double)remaining / Math.max(1.0, speed));
                info = info + " \u2022 " + SaveManagerScreen.formatBytes((long)speed) + "/s \u2022 ETA " + SaveManagerScreen.formatDuration(etaSec);
            }
            ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)info), cx, by + barH + 2, -3355444);
        }
    }

    public boolean method_25402(class_11909 click, boolean consumed) {
        double mouseX = click.comp_4798();
        double mouseY = click.comp_4799();
        int button = click.method_74245();
        if (this.confirmPopup != null) {
            return this.confirmPopup.method_25402(click, consumed);
        }
        if (this.toastManager.mouseClicked(click, consumed)) {
            return true;
        }
        if (this.toastManager.isMouseOverToast(mouseX, mouseY)) {
            return true;
        }
        if (consumed) {
            return true;
        }
        if (this.toastManager.isMouseOverToast(mouseX, mouseY)) {
            return true;
        }
        if (super.method_25402(click, false)) {
            return true;
        }
        if (!(button != 0 || this.localLoading || this.cloudLoading || SaveManagerScreen.ACTIVE.dlActive || SaveManagerScreen.ACTIVE.upActive)) {
            int clickY;
            int rowIdx;
            if (mouseX >= (double)this.localPanelX && mouseX < (double)(this.localPanelX + this.localPanelW) && mouseY >= (double)this.listY && mouseY < (double)(this.listY + this.listH) && (rowIdx = (int)((mouseY - (double)this.listY) / 24.0) + this.localScrollOffset) >= 0 && rowIdx < this.localSaves.size() && mouseY >= (double)(clickY = this.listY + (rowIdx - this.localScrollOffset) * 24) && mouseY < (double)(clickY + 24)) {
                this.localSelectedIndex = rowIdx;
                this.cloudSelectedIndex = -1;
                return true;
            }
            if (mouseX >= (double)this.cloudPanelX && mouseX < (double)(this.cloudPanelX + this.cloudPanelW) && mouseY >= (double)this.listY && mouseY < (double)(this.listY + this.listH) && (rowIdx = (int)((mouseY - (double)this.listY) / 24.0) + this.cloudScrollOffset) >= 0 && rowIdx < this.cloudSaves.size() && mouseY >= (double)(clickY = this.listY + (rowIdx - this.cloudScrollOffset) * 24) && mouseY < (double)(clickY + 24)) {
                this.cloudSelectedIndex = rowIdx;
                this.localSelectedIndex = -1;
                return true;
            }
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.confirmPopup != null && this.confirmPopup.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)) {
            return true;
        }
        if (mouseX >= (double)this.localPanelX && mouseX < (double)(this.localPanelX + this.localPanelW + 20)) {
            int maxScroll = Math.max(0, this.localSaves.size() - 8);
            this.localScrollOffset = Math.max(0, Math.min(maxScroll, this.localScrollOffset - (int)verticalAmount));
            return true;
        }
        if (mouseX >= (double)this.cloudPanelX && mouseX < (double)(this.cloudPanelX + this.cloudPanelW + 20)) {
            int maxScroll = Math.max(0, this.cloudSaves.size() - 8);
            this.cloudScrollOffset = Math.max(0, Math.min(maxScroll, this.cloudScrollOffset - (int)verticalAmount));
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25422() {
        return true;
    }

    public void method_25419() {
        if (this.confirmPopup != null) {
            this.confirmPopup = null;
        } else {
            this.closeScreen();
        }
    }

    private String computeQuotaLine() {
        long used = this.cloudSaves.stream().mapToLong(s -> Math.max(0L, s.fileSizeBytes)).sum();
        long left = Math.max(0L, this.quotaBytes - used);
        return SaveManagerScreen.formatBytes(used) + " of " + this.quotaFormatted + " (" + SaveManagerScreen.formatBytes(left) + " left)";
    }

    private void closeScreen() {
        if (this.field_22787 != null) {
            if (this.parent instanceof class_526) {
                this.field_22787.method_1507(this.parent);
            } else {
                this.field_22787.method_1507((class_437)new class_526(SaveManagerScreen.resolveRootParent(this.parent)));
            }
        }
    }

    private void runOnClient(Runnable r) {
        if (this.field_22787 != null) {
            this.field_22787.execute(r);
        }
    }

    private static String extractErrorMessage(Throwable err) {
        if (err == null) {
            return "Unknown error";
        }
        Throwable cause = err;
        while (cause.getCause() != null && (cause instanceof CompletionException || cause instanceof ExecutionException)) {
            cause = cause.getCause();
        }
        String msg = cause.getMessage();
        if (msg == null || msg.isBlank()) {
            msg = cause.getClass().getSimpleName();
        }
        msg = msg.replaceFirst("^Request failed: \\d+ - ", "");
        msg = msg.replaceFirst("^Upload failed: ", "");
        if ((msg = msg.replaceFirst("^HTTP \\d+: ", "")).contains("{") && msg.contains("\"error\"")) {
            try {
                String jsonPart;
                JsonObject json;
                int start = msg.indexOf(123);
                int end = msg.lastIndexOf(125) + 1;
                if (start >= 0 && end > start && (json = (JsonObject)new Gson().fromJson(jsonPart = msg.substring(start, end), JsonObject.class)) != null && json.has("error")) {
                    return json.get("error").getAsString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return msg;
    }

    private static String safe(String s) {
        return s == null ? "" : s;
    }

    private static String shortDate(String iso) {
        if (iso == null) {
            return "";
        }
        int t = iso.indexOf(84);
        return t > 0 ? iso.substring(0, t) : iso;
    }

    private static String shortDateMillis(long epochMillis) {
        if (epochMillis <= 0L) {
            return "";
        }
        return DateTimeFormatter.ofPattern("yyyy-MM-dd").withZone(ZoneId.systemDefault()).format(Instant.ofEpochMilli(epochMillis));
    }

    private static String formatBytes(long n) {
        if (n < 1024L) {
            return n + " B";
        }
        int u = -1;
        double d = n;
        String[] units = new String[]{"KB", "MB", "GB", "TB"};
        while ((d /= 1024.0) >= 1024.0 && ++u < units.length - 1) {
        }
        return String.format(Locale.ROOT, "%.1f %s", d, units[u]);
    }

    private static String formatDuration(long seconds) {
        if (seconds <= 0L) {
            return "0s";
        }
        long h = seconds / 3600L;
        long m = seconds % 3600L / 60L;
        long s = seconds % 60L;
        if (h > 0L) {
            return String.format("%dh %02dm", h, m);
        }
        if (m > 0L) {
            return String.format("%dm %02ds", m, s);
        }
        return String.format("%ds", s);
    }

    private static String sanitizeFolderName(String s) {
        if (s == null) {
            return "";
        }
        String clean = s.trim().replaceAll("[\\\\/:*?\"<>|]+", "_");
        return clean.isBlank() ? "" : clean;
    }

    private static Path ensureUniqueDir(Path parent, String baseName) {
        Path p = parent.resolve(baseName);
        if (!Files.exists(p, new LinkOption[0])) {
            return p;
        }
        int idx = 1;
        Path cand;
        while (Files.exists(cand = parent.resolve(baseName + "-" + idx), new LinkOption[0])) {
            ++idx;
        }
        return cand;
    }

    private static void unzipSmart(Path zipFile, Path targetBase) throws Exception {
        String root = SaveManagerScreen.detectSingleRootDir(zipFile);
        try (ZipInputStream zis = new ZipInputStream(Files.newInputStream(zipFile, new OpenOption[0]));){
            ZipEntry e;
            while ((e = zis.getNextEntry()) != null) {
                if (e.isDirectory()) continue;
                String name = e.getName().replace('\\', '/');
                if (root != null && name.startsWith(root + "/")) {
                    name = name.substring(root.length() + 1);
                }
                if (name.isBlank()) continue;
                Path out = targetBase.resolve(name).normalize();
                if (!out.startsWith(targetBase)) {
                    throw new IllegalArgumentException("Blocked zip entry: " + name);
                }
                Files.createDirectories(out.getParent(), new FileAttribute[0]);
                Files.copy(zis, out, StandardCopyOption.REPLACE_EXISTING);
                zis.closeEntry();
            }
        }
    }

    private static String detectSingleRootDir(Path zipFile) throws Exception {
        try (ZipFile zf = new ZipFile(zipFile.toFile());){
            String root = null;
            Enumeration<? extends ZipEntry> en = zf.entries();
            while (en.hasMoreElements()) {
                String name = en.nextElement().getName().replace('\\', '/');
                if (name.isBlank()) continue;
                String top = name.split("/", 2)[0];
                if (top.isBlank()) {
                    String string = null;
                    return string;
                }
                if (root == null) {
                    root = top;
                    continue;
                }
                if (root.equals(top)) continue;
                String string = null;
                return string;
            }
            String string = root;
            return string;
        }
    }

    private static Path zipWorld(final Path worldDir, String worldName) throws Exception {
        Path zip = Files.createTempFile("savemanager-" + worldName + "-", ".zip", new FileAttribute[0]);
        try (final ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(zip, StandardOpenOption.WRITE));){
            Files.walkFileTree(worldDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path rel = worldDir.relativize(file);
                    if ("session.lock".equalsIgnoreCase(rel.getFileName().toString())) {
                        return FileVisitResult.CONTINUE;
                    }
                    zos.putNextEntry(new ZipEntry(rel.toString().replace('\\', '/')));
                    Files.copy(file, zos);
                    zos.closeEntry();
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Exception e) {
            try {
                Files.deleteIfExists(zip);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        return zip;
    }

    private static JsonArray findArray(JsonObject obj, String ... names) {
        for (String n : names) {
            JsonElement e;
            if (!obj.has(n) || (e = obj.get(n)) == null || !e.isJsonArray()) continue;
            return e.getAsJsonArray();
        }
        return null;
    }

    private static String getString(JsonObject obj, String ... names) {
        for (String n : names) {
            JsonElement e;
            if (!obj.has(n) || (e = obj.get(n)) == null || !e.isJsonPrimitive() || !e.getAsJsonPrimitive().isString()) continue;
            return e.getAsString();
        }
        return "";
    }

    private static long getLong(JsonObject obj, String ... names) {
        for (String n : names) {
            JsonElement e;
            if (!obj.has(n) || (e = obj.get(n)) == null || !e.isJsonPrimitive() || !e.getAsJsonPrimitive().isNumber()) continue;
            return e.getAsLong();
        }
        return 0L;
    }

    private static class_437 resolveRootParent(class_437 parent) {
        class_437 p = parent;
        int guard = 0;
        while (p instanceof class_526 && guard++ < 8) {
            try {
                Field f = class_526.class.getDeclaredField("parent");
                f.setAccessible(true);
                class_437 next = (class_437)f.get(p);
                if (next == null || next == p) break;
                p = next;
            }
            catch (Throwable ignored) {
                break;
            }
        }
        return p;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadApiKeyFromDisk() {
        try {
            File configFile = new File(new File(class_310.method_1551().field_1697, "config"), "save-manager-settings.json");
            if (!configFile.exists()) {
                return null;
            }
            try (FileReader reader = new FileReader(configFile);){
                JsonObject json = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
                if (json == null) {
                    String string = null;
                    return string;
                }
                if (json.has("encryptedApiToken")) {
                    String string = this.decrypt(json.get("encryptedApiToken").getAsString());
                    return string;
                }
                if (!json.has("apiToken")) return null;
                String string = json.get("apiToken").getAsString();
                return string;
            }
        }
        catch (Exception e) {
            String cleanError = SaveManagerScreen.extractErrorMessage(e);
            SaveManagerMod.LOGGER.warn("ConfigManager: error loading API key - {}", (Object)cleanError);
        }
        return null;
    }

    private static void deleteDirectoryRecursively(Path dir) throws Exception {
        if (!Files.exists(dir, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (exc != null) {
                    throw exc;
                }
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private String decrypt(String base64) throws Exception {
        byte[] data = Base64.getDecoder().decode(base64);
        if (data.length < 28) {
            throw new IllegalArgumentException("Invalid data");
        }
        byte[] iv = new byte[12];
        byte[] ct = new byte[data.length - 12];
        System.arraycopy(data, 0, iv, 0, 12);
        System.arraycopy(data, 12, ct, 0, ct.length);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(2, (Key)new SecretKeySpec(MessageDigest.getInstance("SHA-256").digest("SaveManagerSecKey.v1".getBytes(StandardCharsets.UTF_8)), "AES"), new GCMParameterSpec(128, iv));
        return new String(cipher.doFinal(ct), StandardCharsets.UTF_8);
    }

    private void renderTinyLoadingSpinner(class_332 ctx, int centerX, int centerY, float delta) {
        if ((tinySpinnerAngle += 6.0f * delta) >= 360.0f) {
            tinySpinnerAngle -= 360.0f;
        }
        int size = 3;
        int radius = 4;
        for (int i = 0; i < 8; ++i) {
            float angle = tinySpinnerAngle + (float)i * 45.0f;
            double angleRad = Math.toRadians(angle);
            int x = (int)((double)centerX + Math.cos(angleRad) * (double)radius);
            int y = (int)((double)centerY + Math.sin(angleRad) * (double)radius);
            float opacity = 1.0f - (float)i * 0.125f;
            int color = (int)(opacity * 255.0f) << 24 | 0xAAAAAA;
            ctx.method_25294(x - size / 2, y - size / 2, x + size / 2, y + size / 2, color);
        }
    }

    public class_437 getParent() {
        return this.parent;
    }

    @Environment(value=EnvType.CLIENT)
    private static class LocalSave {
        final Path dir;
        final String worldName;
        final long sizeBytes;
        final long lastModified;

        LocalSave(Path dir, String worldName, long sizeBytes, long lastModified) {
            this.dir = dir;
            this.worldName = worldName;
            this.sizeBytes = sizeBytes;
            this.lastModified = lastModified;
        }

        static LocalSave fromDir(Path dir) {
            String name = dir.getFileName() != null ? dir.getFileName().toString() : dir.toString();
            long lm = 0L;
            try {
                lm = Files.getLastModifiedTime(dir, new LinkOption[0]).toMillis();
            }
            catch (Exception exception) {
                // empty catch block
            }
            long size = 0L;
            try {
                size = LocalSave.computeDirSize(dir);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new LocalSave(dir, name, size, lm);
        }

        static long computeDirSize(Path dir) throws Exception {
            final long[] sum = new long[]{0L};
            Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    try {
                        sum[0] = sum[0] + Files.size(file);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            return sum[0];
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static final class ActiveOp {
        volatile boolean dlActive = false;
        volatile boolean upActive = false;
        volatile boolean zipping = false;
        volatile boolean unzipping = false;
        volatile long bytes = 0L;
        volatile long total = -1L;
        volatile long lastBytes = 0L;
        volatile long lastTickNanos = 0L;
        volatile double speedBps = 0.0;

        private ActiveOp() {
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class CloudSave {
        String id;
        String worldName;
        long fileSizeBytes;
        String createdAt;
        String updatedAt;

        private CloudSave() {
        }

        static CloudSave from(JsonObject o) {
            CloudSave s = new CloudSave();
            s.id = SaveManagerScreen.getString(o, "id", "saveId", "guid");
            s.worldName = SaveManagerScreen.getString(o, "worldName", "name", "world", "title");
            s.fileSizeBytes = SaveManagerScreen.getLong(o, "sizeBytes", "fileSizeBytes", "fileSize", "size", "bytes");
            s.createdAt = SaveManagerScreen.getString(o, "createdAt", "created", "created_on");
            s.updatedAt = SaveManagerScreen.getString(o, "updatedAt", "updated", "updated_on", "lastModified");
            return s;
        }
    }
}

