/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui;

import com.choculaterie.gui.SaveManagerScreen;
import com.choculaterie.network.NetworkManager;
import com.choculaterie.widget.CustomButton;
import com.choculaterie.widget.ToastManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_412;
import net.minecraft.class_437;
import net.minecraft.class_526;
import net.minecraft.class_639;
import net.minecraft.class_642;

@Environment(value=EnvType.CLIENT)
public class AccountLinkingScreen
extends class_437 {
    private static final String CONFIG_FILE = "save-manager-settings.json";
    private static final String KEY_MATERIAL = "SaveManagerSecKey.v1";
    private static final byte[] AES_KEY;
    private static final int GCM_TAG_BITS = 128;
    private static final int IV_LEN = 12;
    private static final SecureRandom RNG;
    private final class_437 parent;
    private final NetworkManager networkManager;
    private final ToastManager toastManager;
    private CustomButton linkResetButton;
    private String currentFlowId = null;
    private String pendingLinkCode = null;
    private String pendingSaveKey = null;
    private boolean isLinking = false;
    private String linkingStatus = "";
    private ScheduledExecutorService pollExecutor = null;

    public AccountLinkingScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Link Your Account"));
        this.parent = parent;
        this.networkManager = new NetworkManager();
        this.toastManager = new ToastManager(null);
    }

    protected void method_25426() {
        if (this.toastManager != null) {
            try {
                Field f = ToastManager.class.getDeclaredField("client");
                f.setAccessible(true);
                f.set(this.toastManager, this.field_22787);
            }
            catch (Exception f) {
                // empty catch block
            }
        }
        int btnSize = 20;
        int margin = 6;
        CustomButton backButton = new CustomButton(margin, margin, btnSize, btnSize, (class_2561)class_2561.method_43470((String)"\u2190"), b -> this.goBack());
        this.method_37063((class_364)backButton);
        int cx = this.field_22789 / 2;
        int btnW = 100;
        int btnY = this.field_22790 / 2;
        String apiKey = this.loadApiKeyFromDisk();
        boolean hasKey = apiKey != null && !apiKey.isBlank();
        this.linkResetButton = new CustomButton(cx - btnW / 2, btnY, btnW, 20, (class_2561)class_2561.method_43470((String)(hasKey ? "Reset" : "Link Account")), b -> this.handleLinkOrReset(hasKey));
        this.method_37063((class_364)this.linkResetButton);
        if (hasKey) {
            this.networkManager.setApiKey(apiKey);
        }
    }

    private void goBack() {
        if (this.field_22787 != null) {
            String apiKey = this.loadApiKeyFromDisk();
            if (this.parent instanceof SaveManagerScreen) {
                if (apiKey != null && !apiKey.isBlank()) {
                    this.field_22787.method_1507(this.parent);
                } else {
                    class_437 grandParent = ((SaveManagerScreen)this.parent).getParent();
                    if (grandParent instanceof class_526) {
                        this.field_22787.method_1507(grandParent);
                    } else {
                        this.field_22787.method_1507((class_437)new class_526(AccountLinkingScreen.resolveRootParent(grandParent)));
                    }
                }
            } else if (this.parent instanceof class_526) {
                this.field_22787.method_1507(this.parent);
            } else {
                this.field_22787.method_1507((class_437)new class_526(AccountLinkingScreen.resolveRootParent(this.parent)));
            }
        }
    }

    private void handleLinkOrReset(boolean hasKey) {
        if (hasKey) {
            this.networkManager.setApiKey(null);
            this.clearConfigToken();
            this.field_22787.method_1507((class_437)new AccountLinkingScreen(this.parent));
        } else {
            this.startOAuthFlow();
        }
    }

    private void startOAuthFlow() {
        if (this.isLinking) {
            return;
        }
        this.isLinking = true;
        this.linkingStatus = "Initiating...";
        this.networkManager.initiateOAuthFlow("SaveManager Mod").whenComplete((json, err) -> {
            if (err != null) {
                this.runOnClient(() -> {
                    this.isLinking = false;
                    this.linkingStatus = "";
                });
                return;
            }
            try {
                int expiresIn;
                this.currentFlowId = json.has("flowId") ? json.get("flowId").getAsString() : null;
                int n = expiresIn = json.has("expiresInSeconds") ? json.get("expiresInSeconds").getAsInt() : 300;
                if (this.currentFlowId == null) {
                    this.runOnClient(() -> {
                        this.isLinking = false;
                        this.linkingStatus = "";
                    });
                    return;
                }
                String authUrl = this.networkManager.getOAuthAuthorizeUrl(this.currentFlowId);
                this.runOnClient(() -> {
                    this.linkingStatus = "Waiting for approval...";
                    try {
                        class_156.method_668().method_673(new URI(authUrl));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
                this.startPolling(this.currentFlowId, expiresIn);
            }
            catch (Exception e) {
                this.runOnClient(() -> {
                    this.isLinking = false;
                    this.linkingStatus = "";
                });
            }
        });
    }

    private void startPolling(String flowId, int timeoutSeconds) {
        this.stopPolling();
        this.pollExecutor = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r, "SaveManager-OAuth-Poll");
            t.setDaemon(true);
            return t;
        });
        int[] attempts = new int[]{0};
        int maxAttempts = timeoutSeconds / 2;
        class_310 mc = class_310.method_1551();
        this.pollExecutor.scheduleAtFixedRate(() -> {
            attempts[0] = attempts[0] + 1;
            int currentAttempt = attempts[0];
            if (currentAttempt >= maxAttempts) {
                mc.execute(() -> {
                    this.stopPolling();
                    this.isLinking = false;
                    this.linkingStatus = "";
                });
                return;
            }
            this.networkManager.getOAuthFlowStatus(flowId).whenComplete((json, err) -> {
                if (err != null) {
                    return;
                }
                try {
                    String status;
                    String string = status = json.has("status") ? json.get("status").getAsString() : "pending";
                    if ("expired".equals(status)) {
                        mc.execute(() -> {
                            this.stopPolling();
                            this.isLinking = false;
                            this.linkingStatus = "";
                        });
                        return;
                    }
                    if ("pending".equals(status)) {
                        mc.execute(() -> {
                            this.linkingStatus = "Waiting for approval...";
                        });
                        return;
                    }
                    if ("completed".equals(status)) {
                        String linkCode;
                        String saveKey = json.has("saveKey") ? json.get("saveKey").getAsString() : null;
                        boolean isMinecraftLinked = json.has("isMinecraftLinked") && json.get("isMinecraftLinked").getAsBoolean();
                        boolean minecraftLinkingComplete = json.has("minecraftLinkingComplete") && json.get("minecraftLinkingComplete").getAsBoolean();
                        String string2 = linkCode = json.has("linkCode") && !json.get("linkCode").isJsonNull() ? json.get("linkCode").getAsString() : null;
                        if (saveKey == null) {
                            return;
                        }
                        this.pendingSaveKey = saveKey;
                        if (isMinecraftLinked) {
                            this.stopPolling();
                            mc.execute(() -> this.completeLinking(saveKey));
                            return;
                        }
                        if (minecraftLinkingComplete) {
                            this.stopPolling();
                            mc.execute(() -> {
                                if (mc.method_1562() != null) {
                                    mc.method_1562().method_48296().method_10747((class_2561)class_2561.method_43470((String)"Linking complete"));
                                }
                                CompletableFuture.delayedExecutor(1L, TimeUnit.SECONDS).execute(() -> mc.execute(() -> this.completeLinking(saveKey)));
                            });
                            return;
                        }
                        if (linkCode != null && !linkCode.equals(this.pendingLinkCode)) {
                            this.pendingLinkCode = linkCode;
                            mc.execute(() -> {
                                this.linkingStatus = "Linking MC account...";
                                this.autoJoinServerAndLink(linkCode, saveKey);
                            });
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }, 0L, 2L, TimeUnit.SECONDS);
    }

    private void stopPolling() {
        if (this.pollExecutor != null && !this.pollExecutor.isShutdown()) {
            this.pollExecutor.shutdownNow();
            this.pollExecutor = null;
        }
    }

    private void autoJoinServerAndLink(String linkCode, String saveKey) {
        this.linkingStatus = "Joining server...";
        class_310 mc = class_310.method_1551();
        try {
            class_639 serverAddress = class_639.method_2950((String)"mc.choculaterie.com");
            class_642 serverInfo = new class_642("Choculaterie", "mc.choculaterie.com", class_642.class_8678.field_45611);
            String[] linkCodeRef = new String[]{linkCode};
            class_412.method_36877((class_437)this, (class_310)mc, (class_639)serverAddress, (class_642)serverInfo, (boolean)false, null);
            CompletableFuture.delayedExecutor(6L, TimeUnit.SECONDS).execute(() -> mc.execute(() -> {
                if (mc.field_1724 != null && mc.field_1724.field_3944 != null) {
                    this.linkingStatus = "Sending link command...";
                    mc.field_1724.field_3944.method_45730("link " + linkCodeRef[0]);
                } else {
                    CompletableFuture.delayedExecutor(3L, TimeUnit.SECONDS).execute(() -> mc.execute(() -> {
                        if (mc.field_1724 != null && mc.field_1724.field_3944 != null) {
                            this.linkingStatus = "Sending link command...";
                            mc.field_1724.field_3944.method_45730("link " + linkCodeRef[0]);
                        }
                    }));
                }
            }));
        }
        catch (Exception e) {
            this.isLinking = false;
            this.linkingStatus = "";
        }
    }

    private void completeLinking(String saveKey) {
        class_310 mc2;
        this.stopPolling();
        this.isLinking = false;
        this.linkingStatus = "";
        this.pendingLinkCode = null;
        this.pendingSaveKey = null;
        this.currentFlowId = null;
        this.networkManager.setApiKey(saveKey);
        try {
            mc2 = class_310.method_1551();
            File configDir = new File(mc2.field_1697, "config");
            if (!configDir.exists()) {
                configDir.mkdirs();
            }
            File configFile = new File(configDir, CONFIG_FILE);
            JsonObject json = new JsonObject();
            json.addProperty("encryptedApiToken", this.encrypt(saveKey));
            try (FileWriter writer = new FileWriter(configFile);){
                new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)json, (Appendable)writer);
            }
        }
        catch (Exception mc2) {
            // empty catch block
        }
        mc2 = class_310.method_1551();
        mc2.execute(() -> {
            if (this.parent instanceof SaveManagerScreen) {
                SaveManagerScreen sms = (SaveManagerScreen)this.parent;
                mc2.method_1507((class_437)sms);
                sms.refresh();
            } else {
                class_437 targetParent = this.parent;
                if (this.parent instanceof class_526) {
                    targetParent = this.parent;
                }
                SaveManagerScreen screen = new SaveManagerScreen(targetParent);
                mc2.method_1507((class_437)screen);
                screen.refresh();
            }
        });
    }

    private void runOnClient(Runnable r) {
        if (this.field_22787 != null) {
            this.field_22787.execute(r);
        }
    }

    private void clearConfigToken() {
        block13: {
            try {
                JsonObject json;
                File configFile = new File(new File(this.field_22787.field_1697, "config"), CONFIG_FILE);
                if (!configFile.exists()) break block13;
                try (FileReader reader = new FileReader(configFile);){
                    json = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
                }
                if (json == null) break block13;
                json.remove("encryptedApiToken");
                json.remove("apiToken");
                if (json.entrySet().isEmpty()) {
                    configFile.delete();
                    break block13;
                }
                try (FileWriter writer = new FileWriter(configFile);){
                    new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)json, (Appendable)writer);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeScreen() {
        this.stopPolling();
        if (this.field_22787 != null) {
            String apiKey = this.loadApiKeyFromDisk();
            if (this.parent instanceof SaveManagerScreen) {
                if (apiKey != null && !apiKey.isBlank()) {
                    this.field_22787.method_1507(this.parent);
                } else {
                    class_437 grandParent = ((SaveManagerScreen)this.parent).getParent();
                    if (grandParent instanceof class_526) {
                        this.field_22787.method_1507(grandParent);
                    } else {
                        this.field_22787.method_1507((class_437)new class_526(AccountLinkingScreen.resolveRootParent(grandParent)));
                    }
                }
            } else if (this.parent instanceof class_526) {
                this.field_22787.method_1507(this.parent);
            } else {
                this.field_22787.method_1507((class_437)new class_526(AccountLinkingScreen.resolveRootParent(this.parent)));
            }
        }
    }

    public void method_25432() {
        super.method_25432();
    }

    public boolean method_25422() {
        return true;
    }

    public void method_25419() {
        this.goBack();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadApiKeyFromDisk() {
        try {
            File configFile = new File(new File(this.field_22787.field_1697, "config"), CONFIG_FILE);
            if (!configFile.exists()) {
                return null;
            }
            try (FileReader reader = new FileReader(configFile);){
                JsonObject json = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
                if (json == null) {
                    String string = null;
                    return string;
                }
                if (json.has("encryptedApiToken")) {
                    String string = this.decrypt(json.get("encryptedApiToken").getAsString());
                    return string;
                }
                if (!json.has("apiToken")) return null;
                String string = json.get("apiToken").getAsString();
                return string;
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        int cx = this.field_22789 / 2;
        context.method_27534(this.field_22793, this.field_22785, cx, 10, -1);
        if (this.isLinking && !this.linkingStatus.isEmpty()) {
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)this.linkingStatus), cx, this.field_22790 / 2 + 30, -7798904);
        }
        this.toastManager.render(context, delta, mouseX, mouseY);
    }

    private static String extractErrorMessage(Throwable err) {
        if (err == null) {
            return "Unknown error";
        }
        Throwable cause = err;
        while (cause.getCause() != null && (cause instanceof CompletionException || cause instanceof ExecutionException)) {
            cause = cause.getCause();
        }
        String msg = cause.getMessage();
        if (msg == null || msg.isBlank()) {
            msg = cause.getClass().getSimpleName();
        }
        return msg;
    }

    private String encrypt(String input) throws Exception {
        byte[] iv = new byte[12];
        RNG.nextBytes(iv);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(1, (Key)new SecretKeySpec(AES_KEY, "AES"), new GCMParameterSpec(128, iv));
        byte[] ct = cipher.doFinal(input.getBytes(StandardCharsets.UTF_8));
        byte[] out = new byte[iv.length + ct.length];
        System.arraycopy(iv, 0, out, 0, iv.length);
        System.arraycopy(ct, 0, out, iv.length, ct.length);
        return Base64.getEncoder().encodeToString(out);
    }

    private String decrypt(String base64) throws Exception {
        byte[] data = Base64.getDecoder().decode(base64);
        if (data.length < 28) {
            throw new IllegalArgumentException("Invalid data");
        }
        byte[] iv = new byte[12];
        byte[] ct = new byte[data.length - 12];
        System.arraycopy(data, 0, iv, 0, 12);
        System.arraycopy(data, 12, ct, 0, ct.length);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(2, (Key)new SecretKeySpec(AES_KEY, "AES"), new GCMParameterSpec(128, iv));
        return new String(cipher.doFinal(ct), StandardCharsets.UTF_8);
    }

    private static class_437 resolveRootParent(class_437 parent) {
        class_437 p = parent;
        int guard = 0;
        while (p instanceof class_526 && guard++ < 8) {
            try {
                Field f = class_526.class.getDeclaredField("parent");
                f.setAccessible(true);
                class_437 next = (class_437)f.get(p);
                if (next == null || next == p) break;
                p = next;
            }
            catch (Throwable ignored) {
                break;
            }
        }
        return p;
    }

    static {
        RNG = new SecureRandom();
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            AES_KEY = md.digest(KEY_MATERIAL.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to init crypto key", e);
        }
    }
}

