/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.network;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class NetworkManager {
    private static final String BASE_URL = "https://choculaterie.com";
    private static final String API_BASE_PATH = "/api/SaveManagerAPI";
    private static final String API_KEY_HEADER = "X-Save-Key";
    private static final HttpClient INSECURE_CLIENT;
    private static final SSLSocketFactory INSECURE_SSLSF;
    private static final HostnameVerifier INSECURE_HV;
    private final HttpClient httpClient = INSECURE_CLIENT;
    private String apiKey;

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApiTokenGenerationUrl() {
        return "https://choculaterie.com/api/SaveManagerAPI/GenerateSaveToken";
    }

    public CompletableFuture<JsonObject> initiateOAuthFlow(String clientName) {
        String body = "\"" + (clientName != null ? clientName : "SaveManager Mod") + "\"";
        HttpRequest req = HttpRequest.newBuilder().uri(URI.create("https://choculaterie.com/api/SaveManagerAPI/flow/initiate")).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(body)).build();
        return this.httpClient.sendAsync(req, HttpResponse.BodyHandlers.ofString()).thenApply(this::handleJsonResponse);
    }

    public CompletableFuture<JsonObject> getOAuthFlowStatus(String flowId) {
        HttpRequest req = HttpRequest.newBuilder().uri(URI.create("https://choculaterie.com/api/SaveManagerAPI/flow/status/" + flowId)).GET().build();
        return this.httpClient.sendAsync(req, HttpResponse.BodyHandlers.ofString()).thenApply(this::handleJsonResponse);
    }

    public String getOAuthAuthorizeUrl(String flowId) {
        return "https://choculaterie.com/api/SaveManagerAPI/flow/authorize/" + flowId;
    }

    public CompletableFuture<JsonObject> getQuotaInfo() {
        this.validateApiKey();
        HttpRequest req = HttpRequest.newBuilder().uri(URI.create("https://choculaterie.com/api/SaveManagerAPI/quota-info")).header(API_KEY_HEADER, this.apiKey).GET().build();
        return this.httpClient.sendAsync(req, HttpResponse.BodyHandlers.ofString()).thenApply(this::handleJsonResponse);
    }

    public CompletableFuture<JsonObject> listWorldSaves() {
        this.validateApiKey();
        HttpRequest req = HttpRequest.newBuilder().uri(URI.create("https://choculaterie.com/api/SaveManagerAPI/list")).header(API_KEY_HEADER, this.apiKey).GET().build();
        return this.httpClient.sendAsync(req, HttpResponse.BodyHandlers.ofString()).thenApply(this::handleJsonResponse);
    }

    public CompletableFuture<JsonObject> uploadWorldSave(String worldName, Path zipFilePath, BiConsumer<Long, Long> progressCallback) throws IOException {
        this.validateApiKey();
        String safeWorldName = worldName == null || worldName.isBlank() ? "world" : worldName;
        String fileName = safeWorldName + ".zip";
        String boundary = "----savemanager-" + String.valueOf(UUID.randomUUID());
        String CRLF = "\r\n";
        long fileSize = Files.size(zipFilePath);
        String uploadBase = "https://upload.choculaterie.com";
        String partWorldName = "--" + boundary + "\r\nContent-Disposition: form-data; name=\"WorldName\"\r\n\r\n" + safeWorldName + "\r\n";
        String partFileHeader = "--" + boundary + "\r\nContent-Disposition: form-data; name=\"SaveFile\"; filename=\"" + fileName + "\"\r\nContent-Type: application/zip\r\n\r\n";
        byte[] preamble = (partWorldName + partFileHeader).getBytes(StandardCharsets.UTF_8);
        byte[] closing = ("\r\n--" + boundary + "--\r\n").getBytes(StandardCharsets.UTF_8);
        long contentLength = (long)preamble.length + fileSize + (long)closing.length;
        return CompletableFuture.supplyAsync(() -> {
            JsonObject result;
            HttpURLConnection conn = null;
            try {
                URL url = new URL(uploadBase + "/api/SaveManagerAPI/upload");
                conn = (HttpURLConnection)url.openConnection();
                if (conn instanceof HttpsURLConnection) {
                    HttpsURLConnection https = (HttpsURLConnection)conn;
                    try {
                        https.setSSLSocketFactory(INSECURE_SSLSF);
                        https.setHostnameVerifier(INSECURE_HV);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                conn.setDoOutput(true);
                conn.setDoInput(true);
                conn.setRequestMethod("POST");
                conn.setRequestProperty(API_KEY_HEADER, this.apiKey);
                conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
                conn.setRequestProperty("Accept", "application/json");
                conn.setRequestProperty("Connection", "keep-alive");
                conn.setRequestProperty("User-Agent", "SaveManager/1.0");
                conn.setConnectTimeout(30000);
                conn.setReadTimeout(600000);
                conn.setFixedLengthStreamingMode(contentLength);
                try (OutputStream rawOut = conn.getOutputStream();
                     BufferedOutputStream out = new BufferedOutputStream(rawOut, 131072);
                     InputStream in = Files.newInputStream(zipFilePath, new OpenOption[0]);){
                    int r;
                    out.write(preamble);
                    byte[] buf = new byte[131072];
                    long sentFileBytes = 0L;
                    if (progressCallback != null) {
                        progressCallback.accept(0L, fileSize);
                    }
                    while ((r = in.read(buf)) != -1) {
                        out.write(buf, 0, r);
                        sentFileBytes += (long)r;
                        if (progressCallback != null) {
                            progressCallback.accept(sentFileBytes, fileSize);
                        }
                        if (sentFileBytes % 0x100000L != 0L) continue;
                        out.flush();
                    }
                    out.write(closing);
                    out.flush();
                    if (progressCallback != null) {
                        progressCallback.accept(fileSize, fileSize);
                    }
                }
                int status = conn.getResponseCode();
                InputStream respStream = status >= 400 ? conn.getErrorStream() : conn.getInputStream();
                String body = "";
                if (respStream != null) {
                    try (InputStream twrVar0$ = respStream;){
                        body = new String(respStream.readAllBytes(), StandardCharsets.UTF_8);
                    }
                }
                if (status >= 400) {
                    Object errorMsg;
                    if (status == 413) {
                        errorMsg = "File too large: Server's reverse proxy is blocking uploads.";
                    } else if (status == 401 || status == 403) {
                        errorMsg = "Authentication failed: Please check your API key.";
                    } else if (status == 429) {
                        errorMsg = "Rate limit exceeded. Please try again later.";
                    } else {
                        Object cleanBody = body.replaceAll("<[^>]+>", "").trim();
                        if (((String)cleanBody).length() > 200) {
                            cleanBody = ((String)cleanBody).substring(0, 200) + "...";
                        }
                        errorMsg = "HTTP " + status + (String)(((String)cleanBody).isEmpty() ? "" : ": " + (String)cleanBody);
                    }
                    throw new RuntimeException((String)errorMsg);
                }
                if (body.isBlank()) {
                    result = new JsonObject();
                    result.addProperty("status", "success");
                    JsonObject cleanBody = result;
                    return cleanBody;
                }
                result = JsonParser.parseString((String)body).getAsJsonObject();
            }
            catch (IOException ioEx) {
                String errorDetails = "IO Error: " + ioEx.getMessage();
                if (conn != null) {
                    try {
                        int status = conn.getResponseCode();
                        InputStream errStream = conn.getErrorStream();
                        if (errStream != null) {
                            String errBody = new String(errStream.readAllBytes(), StandardCharsets.UTF_8);
                            errorDetails = "HTTP " + status + ": " + errBody;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw new RuntimeException("Upload failed: " + errorDetails, ioEx);
            }
            catch (Exception e) {
                throw new RuntimeException("Upload failed: " + e.getMessage(), e);
            }
            finally {
                if (conn != null) {
                    try {
                        conn.disconnect();
                    }
                    catch (Throwable throwable) {}
                }
            }
            return result;
        });
    }

    public CompletableFuture<List<String>> listWorldSaveNames() {
        this.validateApiKey();
        HttpRequest req = HttpRequest.newBuilder().uri(URI.create("https://choculaterie.com/api/SaveManagerAPI/names")).header(API_KEY_HEADER, this.apiKey).GET().build();
        return this.httpClient.sendAsync(req, HttpResponse.BodyHandlers.ofString()).thenApply(response -> {
            if (response.statusCode() >= 400) {
                throw new RuntimeException("Request failed: " + response.statusCode() + " - " + (String)response.body());
            }
            String body = (String)response.body();
            Optional<String> ct = response.headers().firstValue("Content-Type");
            if (ct.map(s -> s.contains("text/html")).orElse(false).booleanValue() || body.startsWith("<!DOCTYPE")) {
                throw new RuntimeException("Unexpected HTML response from server.");
            }
            JsonArray arr = JsonParser.parseString((String)body).getAsJsonArray();
            ArrayList<String> out = new ArrayList<String>();
            for (JsonElement e : arr) {
                if (e == null || !e.isJsonPrimitive()) continue;
                out.add(e.getAsString());
            }
            return out;
        });
    }

    public CompletableFuture<Path> downloadWorldSave(String saveId, Path destinationDirectory, BiConsumer<Long, Long> progressCallback) {
        this.validateApiKey();
        HttpRequest req = HttpRequest.newBuilder().uri(URI.create("https://choculaterie.com/api/SaveManagerAPI/download/" + saveId)).header(API_KEY_HEADER, this.apiKey).header("Accept-Encoding", "identity").GET().build();
        return this.httpClient.sendAsync(req, HttpResponse.BodyHandlers.ofInputStream()).thenCompose(response -> CompletableFuture.supplyAsync(() -> {
            int status = response.statusCode();
            if (status >= 400) {
                try {
                    InputStream err = (InputStream)response.body();
                    try {
                        String body = new String(err.readAllBytes(), StandardCharsets.UTF_8);
                        throw new RuntimeException("Request failed: " + status + " - " + body);
                    }
                    catch (Throwable t$) {
                        if (err != null) {
                            try {
                                err.close();
                            }
                            catch (Throwable x2) {
                                t$.addSuppressed(x2);
                            }
                        }
                        throw t$;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Request failed: " + status, e);
                }
            }
            long total = this.firstLongHeader((HttpResponse<?>)response, "Content-Length", "X-Content-Length", "X-File-Size", "X-Total-Length").orElse(-1L);
            if (progressCallback != null) {
                try {
                    progressCallback.accept(0L, total);
                }
                catch (Throwable x2) {
                    // empty catch block
                }
            }
            String fileName = this.extractFileNameFromResponse((HttpResponse<?>)response);
            try {
                Files.createDirectories(destinationDirectory, new FileAttribute[0]);
                Path temp = Files.createTempFile(destinationDirectory, "download-", ".tmp", new FileAttribute[0]);
                long downloaded = 0L;
                try (InputStream in = (InputStream)response.body();
                     OutputStream out = Files.newOutputStream(temp, new OpenOption[0]);){
                    int read;
                    byte[] buffer = new byte[262144];
                    while ((read = in.read(buffer)) != -1) {
                        out.write(buffer, 0, read);
                        downloaded += (long)read;
                        if (progressCallback == null) continue;
                        try {
                            progressCallback.accept(downloaded, total);
                        }
                        catch (Throwable throwable) {}
                    }
                    out.flush();
                }
                Path finalPath = destinationDirectory.resolve(fileName);
                try {
                    Files.move(temp, finalPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                }
                catch (Exception e) {
                    Files.move(temp, finalPath, StandardCopyOption.REPLACE_EXISTING);
                }
                long finalSize = Files.size(finalPath);
                if (progressCallback != null) {
                    long finalTotal = total > 0L ? total : finalSize;
                    try {
                        progressCallback.accept(finalSize, finalTotal);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return finalPath;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    public CompletableFuture<JsonObject> deleteWorldSave(String saveId) {
        this.validateApiKey();
        HttpRequest req = HttpRequest.newBuilder().uri(URI.create("https://choculaterie.com/api/SaveManagerAPI/delete/" + saveId)).header(API_KEY_HEADER, this.apiKey).DELETE().build();
        return this.httpClient.sendAsync(req, HttpResponse.BodyHandlers.ofString()).thenApply(this::handleJsonResponse);
    }

    private String extractFileNameFromResponse(HttpResponse<?> response) {
        String def = "world_save.zip";
        return response.headers().firstValue("Content-Disposition").map(header -> {
            String lower = header.toLowerCase(Locale.ROOT);
            int idx = lower.indexOf("filename=");
            if (idx >= 0) {
                int end;
                String raw = header.substring(idx + 9).trim();
                if (raw.startsWith("\"") && (end = raw.indexOf(34, 1)) > 1) {
                    return raw.substring(1, end);
                }
                int semi = raw.indexOf(59);
                String v = (semi >= 0 ? raw.substring(0, semi) : raw).replace("\"", "").trim();
                if (!v.isEmpty()) {
                    return v;
                }
            }
            return def;
        }).orElse(def);
    }

    private Optional<Long> firstLongHeader(HttpResponse<?> response, String ... names) {
        for (String n : names) {
            Optional<String> v = response.headers().firstValue(n);
            if (!v.isPresent()) continue;
            try {
                return Optional.of(Long.parseLong(v.get().trim()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    private void validateApiKey() {
        if (this.apiKey == null || this.apiKey.isEmpty()) {
            throw new IllegalStateException("API key is not set");
        }
    }

    private JsonObject handleJsonResponse(HttpResponse<String> response) {
        if (response.statusCode() >= 400) {
            throw new RuntimeException("Request failed: " + response.statusCode() + " - " + response.body());
        }
        Optional<String> ct = response.headers().firstValue("Content-Type");
        String body = response.body();
        if (ct.map(s -> s.contains("text/html")).orElse(false).booleanValue() || body.startsWith("<!DOCTYPE")) {
            throw new RuntimeException("Unexpected HTML response from server.");
        }
        return JsonParser.parseString((String)body).getAsJsonObject();
    }

    static {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext ssl = SSLContext.getInstance("TLS");
            ssl.init(null, trustAllCerts, new SecureRandom());
            try {
                SSLContext.setDefault(ssl);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            INSECURE_CLIENT = HttpClient.newBuilder().sslContext(ssl).followRedirects(HttpClient.Redirect.NORMAL).build();
            INSECURE_SSLSF = ssl.getSocketFactory();
            INSECURE_HV = (hostname, session) -> true;
            try {
                HttpsURLConnection.setDefaultSSLSocketFactory(INSECURE_SSLSF);
                HttpsURLConnection.setDefaultHostnameVerifier(INSECURE_HV);
            }
            catch (Throwable throwable) {}
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize HttpClient with custom SSL context", e);
        }
    }
}

