/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui;

import com.choculaterie.SaveManagerMod;
import com.choculaterie.gui.SaveManagerScreen;
import com.choculaterie.network.NetworkManager;
import com.choculaterie.widget.CustomButton;
import com.choculaterie.widget.CustomTextField;
import com.choculaterie.widget.ToastManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_526;
import net.minecraft.class_5481;

@Environment(value=EnvType.CLIENT)
public class AccountLinkingScreen
extends class_437 {
    private static final String CONFIG_FILE = "save-manager-settings.json";
    private static final String KEY_MATERIAL = "SaveManagerSecKey.v1";
    private static final byte[] AES_KEY;
    private static final int GCM_TAG_BITS = 128;
    private static final int IV_LEN = 12;
    private static final SecureRandom RNG;
    private final class_437 parent;
    private final NetworkManager networkManager;
    private final ToastManager toastManager;
    private CustomTextField tokenField;
    private CustomButton visibilityButton;
    private CustomButton resetButton;
    private CustomButton saveButton;
    private CustomButton cancelButton;
    private String realToken = "";
    private boolean passwordVisible = false;

    public AccountLinkingScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Link Your Account"));
        this.parent = parent;
        this.networkManager = new NetworkManager();
        this.toastManager = new ToastManager(null);
    }

    protected void method_25426() {
        if (this.toastManager != null) {
            try {
                Field f = ToastManager.class.getDeclaredField("client");
                f.setAccessible(true);
                f.set(this.toastManager, this.field_22787);
            }
            catch (Exception f) {
                // empty catch block
            }
        }
        int cx = this.field_22789 / 2;
        int fieldW = 200;
        int eyeW = 25;
        int resetW = 50;
        int gap = 6;
        int groupW = fieldW + gap + eyeW + gap + resetW;
        int groupLeft = cx - groupW / 2;
        int fieldY = this.field_22790 / 2 - 10;
        int actionY = fieldY + 30;
        this.tokenField = new CustomTextField(this.field_22787, groupLeft, fieldY, fieldW, 20, (class_2561)class_2561.method_43470((String)"API Key"));
        this.tokenField.method_47404((class_2561)class_2561.method_43470((String)"Enter your API key..."));
        this.tokenField.setOnChanged(() -> {
            if (this.passwordVisible) {
                this.realToken = this.tokenField.method_1882();
                this.updateResetButton();
            }
        });
        this.method_25429((class_364)this.tokenField);
        this.method_48265((class_364)this.tokenField);
        this.visibilityButton = new CustomButton(groupLeft + fieldW + gap, fieldY, eyeW, 20, (class_2561)class_2561.method_43470((String)"\ud83d\udc41"), b -> this.toggleVisibility());
        this.method_37063((class_364)this.visibilityButton);
        this.resetButton = new CustomButton(groupLeft + fieldW + gap + eyeW + gap, fieldY, resetW, 20, (class_2561)class_2561.method_43470((String)(this.realToken.isEmpty() ? "Link" : "Reset")), b -> this.handleResetOrLink());
        this.method_37063((class_364)this.resetButton);
        int actionW = 95;
        int actionGap = 10;
        int actionsGroupW = actionW + actionGap + actionW;
        int actionsLeft = cx - actionsGroupW / 2;
        this.saveButton = new CustomButton(actionsLeft, actionY, actionW, 20, (class_2561)class_2561.method_43470((String)"Save"), b -> this.saveApiKey());
        this.method_37063((class_364)this.saveButton);
        this.cancelButton = new CustomButton(actionsLeft + actionW + actionGap, actionY, actionW, 20, (class_2561)class_2561.method_43470((String)"Cancel"), b -> this.closeScreen());
        this.method_37063((class_364)this.cancelButton);
        this.loadSavedApiKey();
        this.passwordVisible = this.realToken.isEmpty();
        this.applyMasking();
        this.updateResetButton();
    }

    private void toggleVisibility() {
        this.passwordVisible = !this.passwordVisible;
        this.applyMasking();
    }

    private void applyMasking() {
        boolean visible = this.passwordVisible || this.realToken.isEmpty();
        try {
            BiFunction<String, Integer, class_5481> provider = visible ? (text, idx) -> class_2561.method_43470((String)text.substring(Math.min(idx, text.length()))).method_30937() : (text, idx) -> class_2561.method_43470((String)AccountLinkingScreen.mask(text.length()).substring(Math.min(idx, text.length()))).method_30937();
            Method m = class_342.class.getMethod("setRenderTextProvider", BiFunction.class);
            m.invoke((Object)this.tokenField, provider);
            this.tokenField.method_1852(this.realToken);
        }
        catch (Exception ignored) {
            this.tokenField.method_1852(visible ? this.realToken : AccountLinkingScreen.mask(this.realToken.length()));
        }
    }

    private void updateResetButton() {
        if (this.resetButton != null) {
            this.resetButton.method_25355((class_2561)class_2561.method_43470((String)(this.realToken.isEmpty() ? "Link" : "Reset")));
        }
    }

    private void handleResetOrLink() {
        if (!this.realToken.isEmpty()) {
            this.realToken = "";
            this.networkManager.setApiKey(null);
            this.clearConfigToken();
            this.passwordVisible = true;
            this.applyMasking();
            this.updateResetButton();
            this.toastManager.showInfo("API key cleared");
        }
        this.openApiKeyWebsite();
    }

    private void loadSavedApiKey() {
        block11: {
            try {
                File configFile = new File(new File(this.field_22787.field_1697, "config"), CONFIG_FILE);
                if (!configFile.exists()) break block11;
                try (FileReader reader = new FileReader(configFile);){
                    JsonObject json = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
                    if (json != null) {
                        if (json.has("encryptedApiToken")) {
                            this.realToken = this.decrypt(json.get("encryptedApiToken").getAsString());
                            this.networkManager.setApiKey(this.realToken);
                        } else if (json.has("apiToken")) {
                            this.realToken = json.get("apiToken").getAsString();
                            this.networkManager.setApiKey(this.realToken);
                        }
                    }
                }
            }
            catch (Exception e) {
                String cleanError = AccountLinkingScreen.extractErrorMessage(e);
                SaveManagerMod.LOGGER.warn("ConfigManager: error loading API key - {}", (Object)cleanError);
                this.toastManager.showError("Error loading saved API key");
            }
        }
    }

    private void saveApiKey() {
        String apiKey = this.passwordVisible ? this.tokenField.method_1882() : this.realToken;
        try {
            if (apiKey == null || apiKey.isEmpty()) {
                this.networkManager.setApiKey(null);
                this.clearConfigToken();
                this.toastManager.showInfo("API key cleared");
            } else {
                this.networkManager.setApiKey(apiKey);
                File configDir = new File(this.field_22787.field_1697, "config");
                if (!configDir.exists()) {
                    configDir.mkdirs();
                }
                File configFile = new File(configDir, CONFIG_FILE);
                JsonObject json = new JsonObject();
                json.addProperty("encryptedApiToken", this.encrypt(apiKey));
                try (FileWriter writer = new FileWriter(configFile);){
                    new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)json, (Appendable)writer);
                }
                this.toastManager.showSuccess("API key saved");
            }
            this.closeScreen();
        }
        catch (Exception e) {
            String cleanError = AccountLinkingScreen.extractErrorMessage(e);
            SaveManagerMod.LOGGER.warn("ConfigManager: error saving API key - {}", (Object)cleanError);
            this.toastManager.showError("Error saving API key");
        }
    }

    private void clearConfigToken() {
        block13: {
            try {
                JsonObject json;
                File configFile = new File(new File(this.field_22787.field_1697, "config"), CONFIG_FILE);
                if (!configFile.exists()) break block13;
                try (FileReader reader = new FileReader(configFile);){
                    json = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
                }
                if (json == null) break block13;
                json.remove("encryptedApiToken");
                json.remove("apiToken");
                if (json.entrySet().isEmpty()) {
                    configFile.delete();
                    break block13;
                }
                try (FileWriter writer = new FileWriter(configFile);){
                    new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)json, (Appendable)writer);
                }
            }
            catch (Exception e) {
                String cleanError = AccountLinkingScreen.extractErrorMessage(e);
                SaveManagerMod.LOGGER.warn("ConfigManager: error clearing config - {}", (Object)cleanError);
            }
        }
    }

    private void openApiKeyWebsite() {
        try {
            class_156.method_668().method_670(this.networkManager.getApiTokenGenerationUrl());
        }
        catch (Exception e) {
            String cleanError = AccountLinkingScreen.extractErrorMessage(e);
            SaveManagerMod.LOGGER.warn("BrowserManager: failed to open API key website - {}", (Object)cleanError);
            this.toastManager.showError("Could not open browser");
        }
    }

    private void closeScreen() {
        if (this.field_22787 != null) {
            String apiKey = this.loadApiKeyFromDisk();
            if (apiKey != null && !apiKey.isBlank()) {
                if (this.parent instanceof SaveManagerScreen) {
                    this.field_22787.method_1507(this.parent);
                } else {
                    this.field_22787.method_1507((class_437)new SaveManagerScreen(AccountLinkingScreen.resolveRootParent(this.parent)));
                }
            } else {
                this.field_22787.method_1507((class_437)new class_526(AccountLinkingScreen.resolveRootParent(this.parent instanceof SaveManagerScreen ? ((SaveManagerScreen)this.parent).getParent() : this.parent)));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadApiKeyFromDisk() {
        try {
            File configFile = new File(new File(this.field_22787.field_1697, "config"), CONFIG_FILE);
            if (!configFile.exists()) {
                return null;
            }
            try (FileReader reader = new FileReader(configFile);){
                JsonObject json = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
                if (json == null) {
                    String string = null;
                    return string;
                }
                if (json.has("encryptedApiToken")) {
                    String string = this.decrypt(json.get("encryptedApiToken").getAsString());
                    return string;
                }
                if (!json.has("apiToken")) return null;
                String string = json.get("apiToken").getAsString();
                return string;
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        int cx = this.field_22789 / 2;
        int fieldY = this.field_22790 / 2 - 10;
        context.method_27534(this.field_22793, this.field_22785, cx, 10, -1);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Enter your API key to link your account"), cx, fieldY - 14, -5592406);
        this.tokenField.method_25394(context, mouseX, mouseY, delta);
        this.toastManager.render(context, delta, mouseX, mouseY);
    }

    private static String mask(int len) {
        return "*".repeat(Math.max(0, len));
    }

    private static String extractErrorMessage(Throwable err) {
        if (err == null) {
            return "Unknown error";
        }
        Throwable cause = err;
        while (cause.getCause() != null && (cause instanceof CompletionException || cause instanceof ExecutionException)) {
            cause = cause.getCause();
        }
        String msg = cause.getMessage();
        if (msg == null || msg.isBlank()) {
            msg = cause.getClass().getSimpleName();
        }
        return msg;
    }

    private String encrypt(String input) throws Exception {
        byte[] iv = new byte[12];
        RNG.nextBytes(iv);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(1, (Key)new SecretKeySpec(AES_KEY, "AES"), new GCMParameterSpec(128, iv));
        byte[] ct = cipher.doFinal(input.getBytes(StandardCharsets.UTF_8));
        byte[] out = new byte[iv.length + ct.length];
        System.arraycopy(iv, 0, out, 0, iv.length);
        System.arraycopy(ct, 0, out, iv.length, ct.length);
        return Base64.getEncoder().encodeToString(out);
    }

    private String decrypt(String base64) throws Exception {
        byte[] data = Base64.getDecoder().decode(base64);
        if (data.length < 28) {
            throw new IllegalArgumentException("Invalid data");
        }
        byte[] iv = new byte[12];
        byte[] ct = new byte[data.length - 12];
        System.arraycopy(data, 0, iv, 0, 12);
        System.arraycopy(data, 12, ct, 0, ct.length);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(2, (Key)new SecretKeySpec(AES_KEY, "AES"), new GCMParameterSpec(128, iv));
        return new String(cipher.doFinal(ct), StandardCharsets.UTF_8);
    }

    private static class_437 resolveRootParent(class_437 parent) {
        class_437 p = parent;
        int guard = 0;
        while (p instanceof class_526 && guard++ < 8) {
            try {
                Field f = class_526.class.getDeclaredField("parent");
                f.setAccessible(true);
                class_437 next = (class_437)f.get(p);
                if (next == null || next == p) break;
                p = next;
            }
            catch (Throwable ignored) {
                break;
            }
        }
        return p;
    }

    static {
        RNG = new SecureRandom();
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            AES_KEY = md.digest(KEY_MATERIAL.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to init crypto key", e);
        }
    }
}

