/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui;

import com.choculaterie.config.DownloadSettings;
import com.choculaterie.gui.LocalFolderPage;
import com.choculaterie.gui.widget.CustomButton;
import com.choculaterie.gui.widget.CustomTextField;
import com.choculaterie.gui.widget.LoadingSpinner;
import com.choculaterie.gui.widget.ModMessageBanner;
import com.choculaterie.gui.widget.PostDetailPanel;
import com.choculaterie.gui.widget.PostListWidget;
import com.choculaterie.gui.widget.SortFilterPanel;
import com.choculaterie.gui.widget.ToastManager;
import com.choculaterie.models.MinemevPostInfo;
import com.choculaterie.models.MinemevSearchResponse;
import com.choculaterie.models.ModMessage;
import com.choculaterie.network.ChoculaterieNetworkManager;
import com.choculaterie.network.MinemevNetworkManager;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class LitematicDownloaderScreen
extends class_437 {
    private static final int SEARCH_BAR_HEIGHT = 20;
    private static final int BUTTON_HEIGHT = 20;
    private static final int PADDING = 10;
    private static final int ITEMS_PER_PAGE = 20;
    private CustomTextField searchField;
    private PostListWidget postList;
    private PostDetailPanel detailPanel;
    private SortFilterPanel sortFilterPanel;
    private CustomButton searchButton;
    private CustomButton prevPageButton;
    private CustomButton nextPageButton;
    private CustomButton folderButton;
    private CustomButton filterButton;
    private CustomButton closeButton;
    private LoadingSpinner loadingSpinner;
    private ToastManager toastManager;
    private ModMessageBanner modMessageBanner;
    private int currentPage = 1;
    private int totalPages = 1;
    private int totalItems = 0;
    private boolean isLoading = false;
    private String currentSearchQuery = "";
    private boolean noResultsFound = false;
    private boolean showFilterPanel = false;
    private boolean initialized = false;

    public LitematicDownloaderScreen() {
        super((class_2561)class_2561.method_43470((String)"Litematic Downloader"));
    }

    protected void method_25426() {
        String prevLabel;
        String searchLabel;
        int paginationButtonWidth;
        int searchButtonWidth;
        boolean isVeryCompact;
        String previousSearchText;
        super.method_25426();
        String string = previousSearchText = this.searchField != null ? this.searchField.method_1882() : "";
        if (this.field_22787 != null) {
            this.toastManager = new ToastManager(this.field_22787);
        }
        int leftPanelWidth = this.field_22789 / 2;
        int rightPanelWidth = this.field_22789 - leftPanelWidth;
        boolean isCompact = leftPanelWidth < 250;
        boolean bl = isVeryCompact = leftPanelWidth < 180;
        int n = isVeryCompact ? 25 : (searchButtonWidth = isCompact ? 40 : 70);
        int n2 = isVeryCompact ? 25 : (paginationButtonWidth = isCompact ? 50 : 80);
        String string2 = isVeryCompact ? "\ud83d\udd0d" : (searchLabel = isCompact ? "\ud83d\udd0d" : "Search");
        String string3 = isVeryCompact ? "\u25c0" : (prevLabel = isCompact ? "\u25c0" : "< Previous");
        String nextLabel = isVeryCompact ? "\u25b6" : (isCompact ? "\u25b6" : "Next >");
        int searchBarWidth = Math.max(50, leftPanelWidth - 30 - searchButtonWidth);
        this.loadingSpinner = new LoadingSpinner(leftPanelWidth / 2 - 16, this.field_22790 / 2 - 16);
        if (this.field_22787 != null) {
            this.searchField = new CustomTextField(this.field_22787, 10, 10, searchBarWidth, 20, (class_2561)class_2561.method_43470((String)"Search"));
            this.searchField.method_47404((class_2561)class_2561.method_43470((String)(isCompact ? "Search..." : "Search schematics...")));
            this.searchField.setOnEnterPressed(this::performSearch);
            this.searchField.setOnClearPressed(this::performSearch);
            if (!previousSearchText.isEmpty()) {
                this.searchField.method_1852(previousSearchText);
            }
            this.method_37063((class_364)this.searchField);
        }
        this.searchButton = new CustomButton(10 + searchBarWidth + 10, 10, searchButtonWidth, 20, (class_2561)class_2561.method_43470((String)searchLabel), button -> this.performSearch());
        this.method_37063((class_364)this.searchButton);
        int listY = 40;
        int listHeight = this.field_22790 - listY - 20 - 20;
        if (this.postList == null) {
            this.postList = new PostListWidget(10, listY, leftPanelWidth - 20, listHeight, this::onPostClick);
        } else {
            this.postList.setDimensions(10, listY, leftPanelWidth - 20, listHeight);
        }
        this.method_37063((class_364)this.postList);
        if (this.detailPanel == null) {
            this.detailPanel = new PostDetailPanel(leftPanelWidth, 10, rightPanelWidth - 10, this.field_22790 - 20);
            this.detailPanel.setOnPopupStateChangeListener(isActive -> {
                if (this.postList != null) {
                    this.postList.setPopupsActive(isActive);
                }
            });
        } else {
            this.detailPanel.setDimensions(leftPanelWidth, 10, rightPanelWidth - 10, this.field_22790 - 20);
        }
        this.sortFilterPanel = new SortFilterPanel(leftPanelWidth, 10, rightPanelWidth - 10, this.field_22790 - 20);
        this.sortFilterPanel.setOnSettingsChanged(this::onFilterSettingsChanged);
        int closeButtonSize = 20;
        this.folderButton = new CustomButton(this.field_22789 - 10 - closeButtonSize * 3, 10, closeButtonSize, closeButtonSize, (class_2561)class_2561.method_43470((String)"\ud83d\udcc1"), button -> this.openFolderPage());
        this.filterButton = new CustomButton(this.field_22789 - 10 - closeButtonSize * 2, 10, closeButtonSize, closeButtonSize, (class_2561)class_2561.method_43470((String)"\u2699"), button -> this.toggleFilterPanel());
        this.closeButton = new CustomButton(this.field_22789 - 10 - closeButtonSize, 10, closeButtonSize, closeButtonSize, (class_2561)class_2561.method_43470((String)"X"), button -> this.method_25419());
        this.closeButton.setRenderAsXIcon(true);
        int bottomY = this.field_22790 - 20 - 10;
        this.prevPageButton = new CustomButton(10, bottomY, paginationButtonWidth, 20, (class_2561)class_2561.method_43470((String)prevLabel), button -> this.previousPage());
        this.prevPageButton.field_22763 = false;
        this.method_37063((class_364)this.prevPageButton);
        this.nextPageButton = new CustomButton(leftPanelWidth - 10 - paginationButtonWidth, bottomY, paginationButtonWidth, 20, (class_2561)class_2561.method_43470((String)nextLabel), button -> this.nextPage());
        this.nextPageButton.field_22763 = false;
        this.method_37063((class_364)this.nextPageButton);
        this.modMessageBanner = new ModMessageBanner(0, 0, this.field_22789);
        this.modMessageBanner.setOnDismiss(this::onModMessageDismissed);
        if (!this.initialized) {
            this.initialized = true;
            this.fetchModMessage();
            this.performSearch();
        } else {
            this.updatePaginationButtons();
        }
    }

    private void fetchModMessage() {
        ((CompletableFuture)ChoculaterieNetworkManager.getModMessage().thenAccept(message -> {
            if (this.field_22787 != null) {
                this.field_22787.execute(() -> {
                    if (message != null && message.hasMessage() && message.getId() != null) {
                        int dismissedId = DownloadSettings.getInstance().getDismissedModMessageId();
                        if (message.getId() != dismissedId) {
                            this.modMessageBanner.setMessage((ModMessage)message);
                            this.repositionForBanner();
                        }
                    }
                });
            }
        })).exceptionally(throwable -> {
            System.err.println("[LitematicDownloaderScreen] Failed to fetch mod message: " + throwable.getMessage());
            return null;
        });
    }

    private void onModMessageDismissed(ModMessage message) {
        if (message != null && message.getId() != null) {
            DownloadSettings.getInstance().setDismissedModMessageId(message.getId());
        }
        this.repositionForBanner();
    }

    private void repositionForBanner() {
    }

    private void performSearch() {
        if (this.isLoading) {
            return;
        }
        this.searchField.method_25365(false);
        this.currentSearchQuery = this.searchField.method_1882().trim();
        this.currentPage = 1;
        this.detailPanel.clear();
        this.loadPage();
    }

    private void loadPage() {
        if (this.isLoading) {
            return;
        }
        this.isLoading = true;
        this.searchButton.field_22763 = false;
        this.prevPageButton.field_22763 = false;
        this.nextPageButton.field_22763 = false;
        this.postList.clear();
        String sort = this.sortFilterPanel != null ? this.sortFilterPanel.getSelectedSort() : "newest";
        String tag = this.sortFilterPanel != null ? this.sortFilterPanel.getTagFilter() : null;
        String excludeVendor = this.sortFilterPanel != null ? this.sortFilterPanel.getExcludedVendorsParam() : null;
        ((CompletableFuture)MinemevNetworkManager.searchPostsAdvanced(this.currentSearchQuery, sort, 1, this.currentPage, tag, null, excludeVendor).thenAccept(this::handleSearchResponse)).exceptionally(throwable -> {
            if (this.field_22787 != null) {
                this.field_22787.execute(() -> {
                    String causeMsg;
                    Throwable cause;
                    this.isLoading = false;
                    this.searchButton.field_22763 = true;
                    this.updatePaginationButtons();
                    String errorMessage = throwable.getMessage();
                    Object userMessage = errorMessage != null ? (errorMessage.contains("UnknownHostException") || errorMessage.contains("ConnectException") || errorMessage.contains("SocketTimeoutException") || errorMessage.contains("NoRouteToHostException") ? "Network error: No internet connection" : (errorMessage.contains("HTTP error code: 404") ? "Server error: Resource not found" : (errorMessage.contains("HTTP error code: 500") ? "Server error: Internal server error" : (errorMessage.contains("HTTP error code:") ? "Server error: " + errorMessage.substring(errorMessage.indexOf("HTTP error code:")) : (errorMessage.contains("Failed to search posts") ? ((cause = throwable.getCause()) != null ? ((causeMsg = cause.getMessage()) != null && causeMsg.contains("java.net.") ? "Network error: Cannot reach server" : "Search failed: " + (causeMsg != null ? causeMsg : "Unknown error")) : "Search failed: Connection error") : "Search failed: " + errorMessage))))) : "Search failed: Unknown error";
                    String fullError = "Error: " + errorMessage;
                    if (throwable.getCause() != null) {
                        fullError = fullError + "\nCause: " + throwable.getCause().toString();
                    }
                    System.err.println("Error loading posts: " + errorMessage);
                    if (this.toastManager != null) {
                        this.toastManager.showError((String)userMessage, fullError);
                    }
                });
            }
            return null;
        });
    }

    private void handleSearchResponse(MinemevSearchResponse response) {
        if (this.field_22787 != null) {
            this.field_22787.execute(() -> {
                this.totalPages = response.getTotalPages();
                this.totalItems = response.getTotalItems();
                MinemevPostInfo[] posts = response.getPosts();
                this.postList.setPosts(posts);
                this.isLoading = false;
                this.searchButton.field_22763 = true;
                this.updatePaginationButtons();
                this.noResultsFound = this.totalItems == 0;
            });
        }
    }

    private void updatePaginationButtons() {
        this.prevPageButton.field_22763 = this.currentPage > 1;
        this.nextPageButton.field_22763 = this.currentPage < this.totalPages;
    }

    private void previousPage() {
        if (this.currentPage > 1) {
            --this.currentPage;
            this.loadPage();
        }
    }

    private void nextPage() {
        if (this.currentPage < this.totalPages) {
            ++this.currentPage;
            this.loadPage();
        }
    }

    private void onPostClick(MinemevPostInfo post) {
        System.out.println("[LitematicDownloaderScreen] onPostClick called!");
        System.out.println("[LitematicDownloaderScreen] Post: " + (post != null ? post.getTitle() : "null"));
        System.out.println("[LitematicDownloaderScreen] UUID: " + (post != null ? post.getUuid() : "null"));
        System.out.println("[LitematicDownloaderScreen] DetailPanel: " + (this.detailPanel != null ? "exists" : "null"));
        if (this.detailPanel != null && post != null) {
            this.detailPanel.setPost(post);
            if (this.showFilterPanel) {
                this.showFilterPanel = false;
            }
            System.out.println("[LitematicDownloaderScreen] detailPanel.setPost() called");
        } else {
            System.out.println("[LitematicDownloaderScreen] WARNING: Cannot set post - detailPanel or post is null!");
        }
    }

    private void openFolderPage() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507((class_437)new LocalFolderPage(this));
        }
    }

    private void toggleFilterPanel() {
        this.showFilterPanel = !this.showFilterPanel;
    }

    private void onFilterSettingsChanged(SortFilterPanel panel) {
        this.currentPage = 1;
        this.loadPage();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        int leftPanelWidth = this.field_22789 / 2;
        context.method_25294(0, 0, this.field_22789, this.field_22790, -14671840);
        boolean mouseOverBanner = this.modMessageBanner != null && this.modMessageBanner.isVisible() && this.modMessageBanner.method_25405(mouseX, mouseY);
        int effectiveMouseX = mouseOverBanner ? -1 : mouseX;
        int effectiveMouseY = mouseOverBanner ? -1 : mouseY;
        super.method_25394(context, effectiveMouseX, effectiveMouseY, delta);
        if (this.showFilterPanel) {
            this.sortFilterPanel.method_25394(context, effectiveMouseX, effectiveMouseY, delta);
        } else {
            this.detailPanel.method_25394(context, effectiveMouseX, effectiveMouseY, delta);
        }
        if (this.totalPages > 1 || this.totalItems > 20) {
            boolean isVeryCompact;
            boolean isCompact = leftPanelWidth < 250;
            boolean bl = isVeryCompact = leftPanelWidth < 180;
            int paginationButtonWidth = isVeryCompact ? 25 : (isCompact ? 50 : 80);
            int availableWidth = leftPanelWidth - 10 - paginationButtonWidth - 10 - paginationButtonWidth - 10;
            String fullText = String.format("Page %d / %d (%d items)", this.currentPage, Math.max(this.totalPages, (int)Math.ceil((double)this.totalItems / 20.0)), this.totalItems);
            String mediumText = String.format("%d / %d", this.currentPage, Math.max(this.totalPages, 1));
            String shortText = String.format("%d/%d", this.currentPage, Math.max(this.totalPages, 1));
            String pageText = this.field_22793.method_1727(fullText) <= availableWidth ? fullText : (this.field_22793.method_1727(mediumText) <= availableWidth ? mediumText : (this.field_22793.method_1727(shortText) <= availableWidth ? shortText : null));
            if (pageText != null) {
                int textWidth = this.field_22793.method_1727(pageText);
                context.method_25303(this.field_22793, pageText, (leftPanelWidth - textWidth) / 2, this.field_22790 - 10 - 4 - 10, -1);
            }
        }
        if (this.isLoading) {
            this.loadingSpinner.method_25394(context, effectiveMouseX, effectiveMouseY, delta);
        }
        if (this.noResultsFound) {
            String noResultsText = "No results found :(";
            int textWidth = this.field_22793.method_1727(noResultsText);
            context.method_25303(this.field_22793, noResultsText, (leftPanelWidth - textWidth) / 2, this.field_22790 / 2 + 10, -1);
        }
        if (this.folderButton != null) {
            this.folderButton.method_25394(context, effectiveMouseX, effectiveMouseY, delta);
        }
        if (this.filterButton != null) {
            this.filterButton.method_25394(context, effectiveMouseX, effectiveMouseY, delta);
        }
        if (this.closeButton != null) {
            this.closeButton.method_25394(context, effectiveMouseX, effectiveMouseY, delta);
        }
        if (this.modMessageBanner != null && this.modMessageBanner.isVisible()) {
            this.modMessageBanner.method_25394(context, mouseX, mouseY, delta);
        }
        if (this.toastManager != null) {
            this.toastManager.render(context, delta, mouseX, mouseY);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 && this.toastManager != null) {
            if (this.toastManager.mouseClicked(mouseX, mouseY)) {
                return true;
            }
            if (this.toastManager.isMouseOverToast(mouseX, mouseY)) {
                return true;
            }
        }
        if (button == 0 && this.modMessageBanner != null && this.modMessageBanner.isVisible()) {
            if (this.modMessageBanner.method_25402(mouseX, mouseY, button)) {
                return true;
            }
            if (this.modMessageBanner.method_25405(mouseX, mouseY)) {
                return true;
            }
        }
        if (button == 0 && this.closeButton != null) {
            boolean isOverClose;
            boolean bl = isOverClose = mouseX >= (double)this.closeButton.method_46426() && mouseX < (double)(this.closeButton.method_46426() + this.closeButton.method_25368()) && mouseY >= (double)this.closeButton.method_46427() && mouseY < (double)(this.closeButton.method_46427() + this.closeButton.method_25364());
            if (isOverClose) {
                this.method_25419();
                return true;
            }
        }
        if (button == 0 && this.filterButton != null) {
            boolean isOverFilter;
            boolean bl = isOverFilter = mouseX >= (double)this.filterButton.method_46426() && mouseX < (double)(this.filterButton.method_46426() + this.filterButton.method_25368()) && mouseY >= (double)this.filterButton.method_46427() && mouseY < (double)(this.filterButton.method_46427() + this.filterButton.method_25364());
            if (isOverFilter) {
                this.toggleFilterPanel();
                return true;
            }
        }
        if (button == 0 && this.folderButton != null) {
            boolean isOverFolder;
            boolean bl = isOverFolder = mouseX >= (double)this.folderButton.method_46426() && mouseX < (double)(this.folderButton.method_46426() + this.folderButton.method_25368()) && mouseY >= (double)this.folderButton.method_46427() && mouseY < (double)(this.folderButton.method_46427() + this.folderButton.method_25364());
            if (isOverFolder) {
                this.openFolderPage();
                return true;
            }
        }
        if (this.showFilterPanel ? this.sortFilterPanel != null && this.sortFilterPanel.method_25402(mouseX, mouseY, button) : this.detailPanel != null && this.detailPanel.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 0 && this.searchField != null) {
            if (this.searchField.method_25405(mouseX, mouseY)) {
                this.searchField.method_25365(true);
                return true;
            }
            this.searchField.method_25365(false);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.showFilterPanel ? this.sortFilterPanel != null && this.sortFilterPanel.method_25403(mouseX, mouseY, button, deltaX, deltaY) : this.detailPanel != null && this.detailPanel.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        return this.showFilterPanel ? this.sortFilterPanel != null && this.sortFilterPanel.method_25406(mouseX, mouseY, button) : this.detailPanel != null && this.detailPanel.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.showFilterPanel ? this.sortFilterPanel != null && this.sortFilterPanel.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount) : this.detailPanel != null && this.detailPanel.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)) {
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25419() {
        super.method_25419();
    }
}

