/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.network;

import com.choculaterie.models.MinemevFileInfo;
import com.choculaterie.models.MinemevPostDetailInfo;
import com.choculaterie.models.MinemevPostInfo;
import com.choculaterie.models.MinemevSearchResponse;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class MinemevNetworkManager {
    private static final String BASE_URL = "https://www.minemev.com/api";
    private static final Gson GSON = new Gson();
    private static final int TIMEOUT = 10000;

    public static CompletableFuture<String[]> getVendors() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String urlString = "https://www.minemev.com/api/vendors";
                String jsonResponse = MinemevNetworkManager.makeGetRequest(urlString);
                return MinemevNetworkManager.parseVendorList(jsonResponse);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get vendors", e);
            }
        });
    }

    public static CompletableFuture<MinemevSearchResponse> searchPosts(String searchQuery, String sort, int cleanUuid, int page) {
        return MinemevNetworkManager.searchPostsAdvanced(searchQuery, sort, cleanUuid, page, null, null, null);
    }

    public static CompletableFuture<MinemevSearchResponse> searchPostsAdvanced(String searchQuery, String sort, int cleanUuid, int page, String tag, String versions, String excludeVendor) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                StringBuilder urlBuilder = new StringBuilder();
                urlBuilder.append(BASE_URL).append("/search?clean_uuid=").append(cleanUuid);
                if (searchQuery != null && !searchQuery.isEmpty()) {
                    urlBuilder.append("&search=").append(URLEncoder.encode(searchQuery, StandardCharsets.UTF_8));
                }
                if (sort != null && !sort.isEmpty()) {
                    urlBuilder.append("&sort=").append(sort);
                }
                if (page > 0) {
                    urlBuilder.append("&page=").append(page);
                }
                if (tag != null && !tag.isEmpty()) {
                    urlBuilder.append("&tag=").append(URLEncoder.encode(tag, StandardCharsets.UTF_8));
                }
                if (versions != null && !versions.isEmpty() && !versions.equals("all")) {
                    urlBuilder.append("&versions=").append(URLEncoder.encode(versions, StandardCharsets.UTF_8));
                }
                if (excludeVendor != null && !excludeVendor.isEmpty()) {
                    urlBuilder.append("&exclude_vendor=").append(URLEncoder.encode(excludeVendor, StandardCharsets.UTF_8));
                }
                String finalUrl = urlBuilder.toString();
                System.out.println("[MinemevNetworkManager] Request URL: " + finalUrl);
                String jsonResponse = MinemevNetworkManager.makeGetRequest(finalUrl);
                return MinemevNetworkManager.parseSearchResponse(jsonResponse);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to search posts", e);
            }
        });
    }

    public static CompletableFuture<MinemevSearchResponse> searchPosts(String searchQuery, String sort, int cleanUuid) {
        return MinemevNetworkManager.searchPosts(searchQuery, sort, cleanUuid, 1);
    }

    public static CompletableFuture<MinemevPostDetailInfo> getPostDetails(String vendorUuid) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String[] parts = MinemevNetworkManager.parseVendorUuid(vendorUuid);
                String vendor = parts[0];
                String uuid = parts[1];
                String urlString = String.format("%s/details/%s/%s", BASE_URL, vendor, uuid);
                String jsonResponse = MinemevNetworkManager.makeGetRequest(urlString);
                return MinemevNetworkManager.parsePostDetail(jsonResponse);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get post details", e);
            }
        });
    }

    public static CompletableFuture<MinemevPostDetailInfo> getPostDetails(String vendor, String uuid) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String urlString = String.format("%s/details/%s/%s", BASE_URL, vendor, uuid);
                String jsonResponse = MinemevNetworkManager.makeGetRequest(urlString);
                return MinemevNetworkManager.parsePostDetail(jsonResponse);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get post details", e);
            }
        });
    }

    public static CompletableFuture<MinemevFileInfo[]> getPostFiles(String vendorUuid) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String[] parts = MinemevNetworkManager.parseVendorUuid(vendorUuid);
                String vendor = parts[0];
                String uuid = parts[1];
                String urlString = String.format("%s/files/%s/%s", BASE_URL, vendor, uuid);
                String jsonResponse = MinemevNetworkManager.makeGetRequest(urlString);
                return MinemevNetworkManager.parseFileList(jsonResponse);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get post files", e);
            }
        });
    }

    public static CompletableFuture<MinemevFileInfo[]> getPostFiles(String vendor, String uuid) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String urlString = String.format("%s/files/%s/%s", BASE_URL, vendor, uuid);
                String jsonResponse = MinemevNetworkManager.makeGetRequest(urlString);
                return MinemevNetworkManager.parseFileList(jsonResponse);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get post files", e);
            }
        });
    }

    private static String[] parseVendorUuid(String vendorUuid) {
        if (vendorUuid.contains("/")) {
            String[] parts = vendorUuid.split("/", 2);
            return new String[]{parts[0], parts[1]};
        }
        return new String[]{"minemev", vendorUuid};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String makeGetRequest(String urlString) throws IOException {
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        try {
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.setRequestProperty("User-Agent", "LitematicDownloader/1.0");
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                throw new IOException("HTTP error code: " + responseCode);
            }
            StringBuilder response = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
            }
            String string = response.toString();
            return string;
        }
        finally {
            connection.disconnect();
        }
    }

    private static MinemevSearchResponse parseSearchResponse(String json) {
        JsonObject root = (JsonObject)GSON.fromJson(json, JsonObject.class);
        JsonArray postsArray = root.getAsJsonArray("posts");
        int totalPages = root.get("total_pages").getAsInt();
        int totalItems = root.get("total_items").getAsInt();
        ArrayList<MinemevPostInfo> posts = new ArrayList<MinemevPostInfo>();
        for (int i = 0; i < postsArray.size(); ++i) {
            JsonObject postObj = postsArray.get(i).getAsJsonObject();
            posts.add(MinemevNetworkManager.parsePostInfo(postObj));
        }
        return new MinemevSearchResponse(posts.toArray(new MinemevPostInfo[0]), totalPages, totalItems);
    }

    private static MinemevPostInfo parsePostInfo(JsonObject postObj) {
        String uuid = MinemevNetworkManager.getStringOrNull(postObj, "uuid");
        String title = MinemevNetworkManager.getStringOrNull(postObj, "post_name");
        String description = MinemevNetworkManager.getStringOrNull(postObj, "description");
        String author = MinemevNetworkManager.getStringOrNull(postObj, "User");
        int downloads = MinemevNetworkManager.getIntOrZero(postObj, "downloads");
        String createdAt = MinemevNetworkManager.getStringOrNull(postObj, "published_at");
        String[] tags = MinemevNetworkManager.parseStringArray(postObj, "tags");
        String[] versions = MinemevNetworkManager.parseStringArray(postObj, "versions");
        String vendor = MinemevNetworkManager.getStringOrNull(postObj, "vendor");
        String[] images = MinemevNetworkManager.parseStringArray(postObj, "images");
        String thumbnailUrl = MinemevNetworkManager.getStringOrNull(postObj, "thumbnail_url");
        String userPicture = MinemevNetworkManager.getStringOrNull(postObj, "user_picture");
        String ytLink = MinemevNetworkManager.getStringOrNull(postObj, "yt_link");
        return new MinemevPostInfo(uuid, title, description, author, downloads, createdAt, tags, versions, vendor, images, thumbnailUrl, userPicture, ytLink);
    }

    private static MinemevPostDetailInfo parsePostDetail(String json) {
        JsonObject root = (JsonObject)GSON.fromJson(json, JsonObject.class);
        String uuid = MinemevNetworkManager.getStringOrNull(root, "uuid");
        String title = MinemevNetworkManager.getStringOrNull(root, "post_name");
        String description = MinemevNetworkManager.getStringOrNull(root, "description");
        String descriptionMd = MinemevNetworkManager.getStringOrNull(root, "description_md");
        String author = MinemevNetworkManager.getStringOrNull(root, "User");
        int downloads = MinemevNetworkManager.getIntOrZero(root, "downloads");
        String createdAt = MinemevNetworkManager.getStringOrNull(root, "published_at");
        String[] tags = MinemevNetworkManager.parseStringArray(root, "tags");
        String[] versions = MinemevNetworkManager.parseStringArray(root, "versions");
        String[] images = MinemevNetworkManager.parseStringArray(root, "images");
        String ytLink = MinemevNetworkManager.getStringOrNull(root, "yt_link");
        boolean owner = MinemevNetworkManager.getBooleanOrFalse(root, "owner");
        String creators = MinemevNetworkManager.getStringOrNull(root, "creators");
        return new MinemevPostDetailInfo(uuid, title, description, descriptionMd, author, downloads, createdAt, tags, versions, images, ytLink, owner, creators);
    }

    private static MinemevFileInfo[] parseFileList(String json) {
        JsonArray filesArray = (JsonArray)GSON.fromJson(json, JsonArray.class);
        ArrayList<MinemevFileInfo> files = new ArrayList<MinemevFileInfo>();
        for (int i = 0; i < filesArray.size(); ++i) {
            JsonObject fileObj = filesArray.get(i).getAsJsonObject();
            int id = MinemevNetworkManager.getIntOrZero(fileObj, "id");
            String defaultFileName = MinemevNetworkManager.getStringOrNull(fileObj, "default_file_name");
            String downloadUrl = MinemevNetworkManager.getStringOrNull(fileObj, "file");
            long fileSize = MinemevNetworkManager.getLongOrZero(fileObj, "file_size");
            String[] versions = MinemevNetworkManager.parseStringArray(fileObj, "versions");
            int downloads = MinemevNetworkManager.getIntOrZero(fileObj, "downloads");
            String fileType = MinemevNetworkManager.getStringOrNull(fileObj, "file_type");
            boolean isVerified = MinemevNetworkManager.getBooleanOrFalse(fileObj, "is_verified");
            files.add(new MinemevFileInfo(id, defaultFileName, downloadUrl, fileSize, versions, downloads, fileType, isVerified));
        }
        return files.toArray(new MinemevFileInfo[0]);
    }

    private static String getStringOrNull(JsonObject obj, String key) {
        return obj.has(key) && !obj.get(key).isJsonNull() ? obj.get(key).getAsString() : null;
    }

    private static int getIntOrZero(JsonObject obj, String key) {
        return obj.has(key) && !obj.get(key).isJsonNull() ? obj.get(key).getAsInt() : 0;
    }

    private static long getLongOrZero(JsonObject obj, String key) {
        return obj.has(key) && !obj.get(key).isJsonNull() ? obj.get(key).getAsLong() : 0L;
    }

    private static boolean getBooleanOrFalse(JsonObject obj, String key) {
        return obj.has(key) && !obj.get(key).isJsonNull() && obj.get(key).getAsBoolean();
    }

    private static String[] parseStringArray(JsonObject obj, String key) {
        if (!obj.has(key) || obj.get(key).isJsonNull()) {
            return new String[0];
        }
        JsonArray array = obj.getAsJsonArray(key);
        String[] result = new String[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            result[i] = array.get(i).getAsString();
        }
        return result;
    }

    private static String[] parseVendorList(String json) {
        JsonObject root = (JsonObject)GSON.fromJson(json, JsonObject.class);
        if (!root.has("vendors") || root.get("vendors").isJsonNull()) {
            return new String[0];
        }
        JsonArray vendorsArray = root.getAsJsonArray("vendors");
        String[] result = new String[vendorsArray.size()];
        for (int i = 0; i < vendorsArray.size(); ++i) {
            result[i] = vendorsArray.get(i).getAsString();
        }
        return result;
    }
}

