/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.network;

import com.choculaterie.models.ModMessage;
import com.choculaterie.models.QuickShareResponse;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ChoculaterieNetworkManager {
    private static final String BASE_URL = "https://choculaterie.com/api/LitematicDownloaderModAPI";
    private static final Gson GSON = new Gson();
    private static final int TIMEOUT = 30000;
    private static final String BOUNDARY = "----WebKitFormBoundary" + System.currentTimeMillis();

    public static CompletableFuture<QuickShareResponse> uploadLitematic(File file) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                if (file == null || !file.exists()) {
                    throw new IllegalArgumentException("File does not exist");
                }
                if (!file.getName().toLowerCase().endsWith(".litematic")) {
                    throw new IllegalArgumentException("Only .litematic files are allowed");
                }
                byte[] fileBytes = Files.readAllBytes(file.toPath());
                String jsonResponse = ChoculaterieNetworkManager.uploadMultipartFile(file.getName(), fileBytes);
                return ChoculaterieNetworkManager.parseQuickShareResponse(jsonResponse);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to upload litematic file", e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String uploadMultipartFile(String fileName, byte[] fileBytes) throws IOException {
        String urlString = "https://choculaterie.com/api/LitematicDownloaderModAPI/upload";
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        try {
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setConnectTimeout(30000);
            connection.setReadTimeout(30000);
            connection.setRequestProperty("User-Agent", "LitematicDownloader/1.0");
            connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
            try (DataOutputStream outputStream = new DataOutputStream(connection.getOutputStream());){
                outputStream.writeBytes("--" + BOUNDARY + "\r\n");
                outputStream.writeBytes("Content-Disposition: form-data; name=\"file\"; filename=\"" + fileName + "\"\r\n");
                outputStream.writeBytes("Content-Type: application/octet-stream\r\n");
                outputStream.writeBytes("\r\n");
                outputStream.write(fileBytes);
                outputStream.writeBytes("\r\n");
                outputStream.writeBytes("--" + BOUNDARY + "--\r\n");
                outputStream.flush();
            }
            int responseCode = connection.getResponseCode();
            InputStream inputStream = responseCode >= 200 && responseCode < 300 ? connection.getInputStream() : connection.getErrorStream();
            StringBuilder response = new StringBuilder();
            if (inputStream != null) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        response.append(line);
                    }
                }
            }
            if (responseCode != 200) {
                throw new IOException("HTTP error code: " + responseCode + ", response: " + String.valueOf(response));
            }
            String string = response.toString();
            return string;
        }
        finally {
            connection.disconnect();
        }
    }

    private static QuickShareResponse parseQuickShareResponse(String json) {
        JsonObject root = (JsonObject)GSON.fromJson(json, JsonObject.class);
        if (!root.has("shortUrl")) {
            throw new RuntimeException("Response does not contain shortUrl");
        }
        String shortUrl = root.get("shortUrl").getAsString();
        return new QuickShareResponse(shortUrl);
    }

    public static CompletableFuture<QuickShareResponse> uploadLitematic(String filePath) {
        return ChoculaterieNetworkManager.uploadLitematic(new File(filePath));
    }

    public static CompletableFuture<ModMessage> getModMessage() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String urlString = "https://choculaterie.com/api/LitematicDownloaderModAPI/GetModMessage";
                System.out.println("[ChoculaterieNetworkManager] Request URL: " + urlString);
                String jsonResponse = ChoculaterieNetworkManager.makeGetRequest(urlString);
                return ChoculaterieNetworkManager.parseModMessage(jsonResponse);
            }
            catch (Exception e) {
                System.err.println("[ChoculaterieNetworkManager] Failed to get mod message: " + e.getMessage());
                return new ModMessage(false, null, null, null, null);
            }
        });
    }

    private static ModMessage parseModMessage(String json) {
        boolean hasMessage;
        JsonObject root = (JsonObject)GSON.fromJson(json, JsonObject.class);
        boolean bl = hasMessage = root.has("hasMessage") && !root.get("hasMessage").isJsonNull() && root.get("hasMessage").getAsBoolean();
        if (!hasMessage) {
            return new ModMessage(false, null, null, null, null);
        }
        Integer id = root.has("id") && !root.get("id").isJsonNull() ? Integer.valueOf(root.get("id").getAsInt()) : null;
        String message = root.has("message") && !root.get("message").isJsonNull() ? root.get("message").getAsString() : null;
        String type = root.has("type") && !root.get("type").isJsonNull() ? root.get("type").getAsString() : null;
        String time = root.has("time") && !root.get("time").isJsonNull() ? root.get("time").getAsString() : null;
        return new ModMessage(hasMessage, id, message, type, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String makeGetRequest(String urlString) throws IOException {
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        try {
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.setRequestProperty("User-Agent", "LitematicDownloader/1.0");
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                throw new IOException("HTTP error code: " + responseCode);
            }
            StringBuilder response = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
            }
            String string = response.toString();
            return string;
        }
        finally {
            connection.disconnect();
        }
    }
}

