/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui.widget;

import com.choculaterie.config.DownloadSettings;
import com.choculaterie.gui.widget.Toast;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class ToastManager {
    private final List<Toast> toasts = new ArrayList<Toast>();
    private final class_310 client;
    private static final int TOAST_SPACING = 5;
    private static final int TOP_PADDING = 10;

    public ToastManager(class_310 client) {
        this.client = client;
    }

    public void showToast(String message, Toast.Type type) {
        this.showToast(message, type, false, null);
    }

    public void showToast(String message, Toast.Type type, boolean hasCopyButton, String copyText) {
        DownloadSettings settings = DownloadSettings.getInstance();
        switch (type) {
            case SUCCESS: {
                if (settings.isSuccessToastsEnabled()) break;
                return;
            }
            case ERROR: {
                if (settings.isErrorToastsEnabled()) break;
                return;
            }
            case INFO: {
                if (settings.isInfoToastsEnabled()) break;
                return;
            }
            case WARNING: {
                if (settings.isWarningToastsEnabled()) break;
                return;
            }
        }
        if (this.client.method_22683() == null) {
            return;
        }
        int screenWidth = this.client.method_22683().method_4486();
        int screenHeight = this.client.method_22683().method_4502();
        int yPosition = 10;
        for (Toast toast : this.toasts) {
            yPosition += toast.getHeight();
        }
        if (yPosition + 70 > screenHeight && !this.toasts.isEmpty()) {
            this.toasts.remove(0);
            yPosition = 10;
            for (Toast toast : this.toasts) {
                yPosition += toast.getHeight();
            }
        }
        this.toasts.add(new Toast(message, type, screenWidth, yPosition, hasCopyButton, copyText, this.client));
    }

    public void showSuccess(String message) {
        this.showToast(message, Toast.Type.SUCCESS);
    }

    public void showError(String message) {
        this.showToast(message, Toast.Type.ERROR);
    }

    public void showError(String message, String fullErrorText) {
        this.showToast(message, Toast.Type.ERROR, true, fullErrorText);
    }

    public void showInfo(String message) {
        this.showToast(message, Toast.Type.INFO);
    }

    public void showWarning(String message) {
        this.showToast(message, Toast.Type.WARNING);
    }

    public void render(class_332 context, float delta, int mouseX, int mouseY) {
        if (this.toasts.isEmpty()) {
            return;
        }
        Toast.updateMousePosition(mouseX, mouseY);
        Iterator<Toast> iterator = this.toasts.iterator();
        boolean toastRemoved = false;
        while (iterator.hasNext()) {
            Toast toast = iterator.next();
            toast.setHovered(toast.isHovering(mouseX, mouseY));
            boolean shouldRemove = toast.render(context, this.client.field_1772);
            if (!shouldRemove) continue;
            iterator.remove();
            toastRemoved = true;
        }
        if (toastRemoved && !this.toasts.isEmpty()) {
            int newY = 10;
            for (Toast toast : this.toasts) {
                toast.setTargetYPosition(newY);
                newY += toast.getHeight();
            }
        }
    }

    public void clear() {
        this.toasts.clear();
    }

    public boolean hasToasts() {
        return !this.toasts.isEmpty();
    }

    public boolean isMouseOverToast(double mouseX, double mouseY) {
        for (Toast toast : this.toasts) {
            if (!toast.isHovering(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY) {
        for (Toast toast : this.toasts) {
            if (toast.isCloseButtonClicked(mouseX, mouseY)) {
                toast.dismiss();
                return true;
            }
            if (!toast.isCopyButtonClicked(mouseX, mouseY)) continue;
            String textToCopy = toast.getCopyText();
            if (this.client.field_1774 == null) continue;
            this.client.field_1774.method_1455(textToCopy);
            this.showSuccess("Error copied to clipboard!");
            return true;
        }
        return false;
    }
}

