/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui.widget;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class FileActionManager {
    private final List<FileAction> undoStack = new ArrayList<FileAction>();
    private final List<FileAction> redoStack = new ArrayList<FileAction>();
    private final int maxHistory;
    private final File trashFolder;

    public FileActionManager(File trashFolder, int maxHistory) {
        this.trashFolder = trashFolder;
        this.maxHistory = maxHistory;
        if (!trashFolder.exists()) {
            trashFolder.mkdirs();
        }
    }

    public void addAction(FileAction action) {
        this.undoStack.add(action);
        this.redoStack.clear();
        while (this.undoStack.size() > this.maxHistory) {
            FileAction removed = this.undoStack.removeFirst();
            this.cleanupAction(removed);
        }
    }

    public boolean canUndo() {
        return !this.undoStack.isEmpty();
    }

    public boolean canRedo() {
        return !this.redoStack.isEmpty();
    }

    public String performUndo() {
        if (this.undoStack.isEmpty()) {
            return null;
        }
        FileAction action = this.undoStack.removeLast();
        String result = null;
        switch (action.type.ordinal()) {
            case 0: {
                result = this.undoMove(action);
                break;
            }
            case 1: {
                result = this.undoDelete(action);
                break;
            }
            case 2: {
                result = this.undoRename(action);
                break;
            }
            case 3: {
                result = this.undoCreateFolder(action);
            }
        }
        if (result != null) {
            while (this.redoStack.size() >= this.maxHistory) {
                this.redoStack.removeFirst();
            }
            this.redoStack.add(action);
        }
        return result;
    }

    public String performRedo() {
        if (this.redoStack.isEmpty()) {
            return null;
        }
        FileAction action = this.redoStack.removeLast();
        String result = null;
        switch (action.type.ordinal()) {
            case 0: {
                result = this.redoMove(action);
                break;
            }
            case 1: {
                result = this.redoDelete(action);
                break;
            }
            case 2: {
                result = this.redoRename(action);
                break;
            }
            case 3: {
                result = this.redoCreateFolder(action);
            }
        }
        if (result != null) {
            while (this.undoStack.size() >= this.maxHistory) {
                FileAction removed = this.undoStack.removeFirst();
                this.cleanupAction(removed);
            }
            this.undoStack.add(action);
        }
        return result;
    }

    private String undoMove(FileAction action) {
        int successCount = 0;
        for (FileOperation op : action.operations) {
            if (!op.destination.exists() || op.source.exists() || !op.destination.renameTo(op.source)) continue;
            ++successCount;
        }
        if (successCount > 0) {
            return "Undid move of " + successCount + " item(s)";
        }
        return null;
    }

    private String undoDelete(FileAction action) {
        int successCount = 0;
        for (FileOperation op : action.operations) {
            if (!op.destination.exists() || op.source.exists() || !op.destination.renameTo(op.source)) continue;
            ++successCount;
        }
        if (successCount > 0) {
            return "Restored " + successCount + " item(s)";
        }
        return null;
    }

    private String undoRename(FileAction action) {
        if (action.operations.isEmpty()) {
            return null;
        }
        FileOperation op = action.operations.getFirst();
        if (op.destination.exists() && !op.source.exists() && op.destination.renameTo(op.source)) {
            return "Undid rename of \"" + op.destination.getName() + "\"";
        }
        return null;
    }

    private String undoCreateFolder(FileAction action) {
        File[] contents;
        if (action.operations.isEmpty()) {
            return null;
        }
        FileOperation op = action.operations.getFirst();
        if (op.destination.exists() && op.destination.isDirectory() && ((contents = op.destination.listFiles()) == null || contents.length == 0) && op.destination.delete()) {
            return "Undid creation of \"" + op.destination.getName() + "\"";
        }
        return null;
    }

    private String redoMove(FileAction action) {
        int successCount = 0;
        for (FileOperation op : action.operations) {
            if (!op.source.exists() || op.destination.exists() || !op.source.renameTo(op.destination)) continue;
            ++successCount;
        }
        if (successCount > 0) {
            return "Redid move of " + successCount + " item(s)";
        }
        return null;
    }

    private String redoDelete(FileAction action) {
        int successCount = 0;
        for (FileOperation op : action.operations) {
            if (!op.source.exists() || op.destination.exists() || !op.source.renameTo(op.destination)) continue;
            ++successCount;
        }
        if (successCount > 0) {
            return "Deleted " + successCount + " item(s) again";
        }
        return null;
    }

    private String redoRename(FileAction action) {
        if (action.operations.isEmpty()) {
            return null;
        }
        FileOperation op = action.operations.getFirst();
        if (op.source.exists() && !op.destination.exists() && op.source.renameTo(op.destination)) {
            return "Redid rename to \"" + op.destination.getName() + "\"";
        }
        return null;
    }

    private String redoCreateFolder(FileAction action) {
        if (action.operations.isEmpty()) {
            return null;
        }
        FileOperation op = action.operations.getFirst();
        if (!op.destination.exists() && op.destination.mkdir()) {
            return "Recreated folder \"" + op.destination.getName() + "\"";
        }
        return null;
    }

    private void cleanupAction(FileAction action) {
        if (action.type == ActionType.DELETE) {
            for (FileOperation op : action.operations) {
                if (!op.destination.exists() || !op.destination.getAbsolutePath().contains(".trash")) continue;
                this.deleteRecursively(op.destination);
            }
        }
    }

    private void deleteRecursively(File file) {
        File[] children;
        if (file.isDirectory() && (children = file.listFiles()) != null) {
            for (File child : children) {
                this.deleteRecursively(child);
            }
        }
        file.delete();
    }

    public String getUndoDescription() {
        if (this.undoStack.isEmpty()) {
            return null;
        }
        FileAction action = this.undoStack.getLast();
        return this.getActionDescription(action, "Undo");
    }

    public String getRedoDescription() {
        if (this.redoStack.isEmpty()) {
            return null;
        }
        FileAction action = this.redoStack.getLast();
        return this.getActionDescription(action, "Redo");
    }

    private String getActionDescription(FileAction action, String prefix) {
        switch (action.type.ordinal()) {
            case 0: {
                return prefix + " move";
            }
            case 1: {
                return prefix + " delete";
            }
            case 2: {
                if (!action.operations.isEmpty()) {
                    return prefix + " rename of \"" + action.operations.getFirst().source.getName() + "\"";
                }
                return prefix + " rename";
            }
            case 3: {
                if (!action.operations.isEmpty()) {
                    return prefix + " creation of \"" + action.operations.getFirst().destination.getName() + "\"";
                }
                return prefix + " folder creation";
            }
        }
        return prefix;
    }

    @Environment(value=EnvType.CLIENT)
    public static class FileAction {
        public final ActionType type;
        public final List<FileOperation> operations;

        public FileAction(ActionType type, List<FileOperation> operations) {
            this.type = type;
            this.operations = operations;
        }

        public FileAction(ActionType type, FileOperation operation) {
            this.type = type;
            this.operations = new ArrayList<FileOperation>();
            this.operations.add(operation);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum ActionType {
        MOVE,
        DELETE,
        RENAME,
        CREATE_FOLDER;

    }

    @Environment(value=EnvType.CLIENT)
    public static class FileOperation {
        public final File source;
        public final File destination;
        public final boolean wasDirectory;

        public FileOperation(File source, File destination, boolean wasDirectory) {
            this.source = source;
            this.destination = destination;
            this.wasDirectory = wasDirectory;
        }
    }
}

