/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui.widget;

import com.choculaterie.gui.widget.ScrollBar;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;

@Environment(value=EnvType.CLIENT)
public class DropdownWidget
implements class_4068,
class_364 {
    private static final int ITEM_HEIGHT = 24;
    private static final int PADDING = 4;
    private static final int MAX_VISIBLE_ITEMS = 6;
    private static final int BG_COLOR = -534436571;
    private static final int SCROLLBAR_WIDTH = 8;
    private static final int SCROLLBAR_PADDING = 2;
    private static final int SCROLLBAR_SIDE_SPACING = 2;
    private static final int ITEM_COLOR = -12961222;
    private static final int ITEM_HOVER_COLOR = -11908534;
    private static final int BORDER_COLOR = -11184811;
    private static final int TEXT_COLOR = -1;
    private static final int ERROR_TEXT_COLOR = -48060;
    private final class_310 client = class_310.method_1551();
    private int x;
    private int y;
    private int width;
    private final List<DropdownItem> items;
    private final Consumer<DropdownItem> onSelect;
    private boolean isOpen;
    private int hoveredIndex = -1;
    private double scrollOffset = 0.0;
    private int maxScrollOffset = 0;
    private String statusMessage = "";
    private ScrollBar scrollBar;
    private int lastScrollBarX = -1;
    private int lastScrollBarY = -1;
    private int lastScrollBarHeight = -1;

    public DropdownWidget(int x, int y, int width, Consumer<DropdownItem> onSelect) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.items = new ArrayList<DropdownItem>();
        this.onSelect = onSelect;
        this.isOpen = false;
        this.scrollBar = new ScrollBar(x + width - 10, y + 1, 100);
    }

    public void setStatusMessage(String message) {
        this.statusMessage = message != null ? message : "";
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setItems(List<DropdownItem> items) {
        this.items.clear();
        this.items.addAll(items);
        this.scrollOffset = 0.0;
        this.updateScrollBounds();
    }

    public void open() {
        this.isOpen = true;
    }

    public void close() {
        this.isOpen = false;
        this.hoveredIndex = -1;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    private void updateScrollBounds() {
        int visibleHeight = Math.min(this.items.size(), 6) * 24;
        int contentHeight = this.items.size() * 24;
        this.maxScrollOffset = Math.max(0, contentHeight - visibleHeight);
    }

    private int getDropdownHeight() {
        if (!this.isOpen || this.items.isEmpty()) {
            return 0;
        }
        int itemCount = Math.min(this.items.size(), 6);
        int baseHeight = itemCount * 24 + 2;
        if (!this.statusMessage.isEmpty()) {
            baseHeight += 24;
        }
        return baseHeight;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        int visibleItemsHeight;
        if (!this.isOpen || this.items.isEmpty()) {
            return;
        }
        int height = this.getDropdownHeight();
        int renderWidth = this.width + 1;
        context.method_25294(this.x, this.y, this.x + renderWidth, this.y + height, -534436571);
        context.method_25294(this.x, this.y, this.x + renderWidth, this.y + 1, -11184811);
        context.method_25294(this.x, this.y + height - 1, this.x + renderWidth, this.y + height, -11184811);
        context.method_25294(this.x, this.y, this.x + 1, this.y + height, -11184811);
        context.method_25294(this.x + renderWidth - 1, this.y, this.x + renderWidth, this.y + height, -11184811);
        int contentY = this.y + 1;
        int itemCount = Math.min(this.items.size(), 6);
        int visibleHeight = visibleItemsHeight = itemCount * 24;
        int scissorX = Math.max(this.x, 0);
        int scissorY = Math.max(contentY, 0);
        int scissorWidth = Math.max(0, Math.min(renderWidth, context.method_51421() - scissorX));
        int scissorHeight = Math.max(0, Math.min(visibleHeight, context.method_51443() - scissorY));
        if (scissorWidth > 0 && scissorHeight > 0) {
            context.method_44379(scissorX, scissorY, scissorX + scissorWidth, scissorY + scissorHeight);
            this.hoveredIndex = -1;
            boolean hasScrollbar = this.items.size() > 6;
            int itemRightEdge = hasScrollbar ? this.x + renderWidth - 8 - 2 - 1 : this.x + renderWidth - 1;
            for (int i = 0; i < this.items.size(); ++i) {
                int itemY = contentY + i * 24 - (int)this.scrollOffset;
                if (itemY + 24 < contentY || itemY > contentY + visibleHeight) continue;
                DropdownItem item = this.items.get(i);
                boolean isHovered = mouseX >= this.x && mouseX < itemRightEdge && mouseY >= itemY && mouseY < itemY + 24;
                int itemBgColor = isHovered ? -11908534 : -12961222;
                int itemX = this.x + 1;
                int itemWidth = itemRightEdge - itemX;
                context.method_25294(itemX, itemY, itemX + itemWidth, itemY + 24, itemBgColor);
                if (i < this.items.size() - 1) {
                    context.method_25294(itemX, itemY + 24 - 1, itemX + itemWidth, itemY + 24, -11184811);
                }
                if (isHovered) {
                    this.hoveredIndex = i;
                }
                Object displayText = item.getDisplayText();
                int textX = itemX + 4 + 2;
                Objects.requireNonNull(this.client.field_1772);
                int textY = itemY + (24 - 9) / 2;
                int maxTextWidth = itemWidth - 8 - 4;
                if (this.client.field_1772.method_1727((String)displayText) > maxTextWidth) {
                    displayText = this.client.field_1772.method_27523((String)displayText, maxTextWidth - 10) + "...";
                }
                if (textY < scissorY) continue;
                Objects.requireNonNull(this.client.field_1772);
                if (textY + 9 > scissorY + scissorHeight) continue;
                context.method_51433(this.client.field_1772, (String)displayText, textX, textY, -1, false);
            }
            context.method_44380();
        }
        if (!this.statusMessage.isEmpty()) {
            String lowerMessage;
            int statusY = contentY + visibleItemsHeight;
            int statusX = this.x + 1;
            int statusWidth = renderWidth - 2;
            context.method_25294(statusX, statusY, statusX + statusWidth, statusY + 1, -11184811);
            int maxStatusWidth = statusWidth - 8;
            Object displayStatus = this.statusMessage;
            int statusTextWidth = this.client.field_1772.method_1727(this.statusMessage);
            if (statusTextWidth > maxStatusWidth) {
                displayStatus = this.client.field_1772.method_27523(this.statusMessage, maxStatusWidth - this.client.field_1772.method_1727("...")) + "...";
            }
            int statusColor = (lowerMessage = this.statusMessage.toLowerCase()).contains("error") || lowerMessage.contains("failed") || lowerMessage.contains("fail") || lowerMessage.startsWith("\u2717") || lowerMessage.contains("could not") || lowerMessage.contains("cannot") || lowerMessage.contains("unable") ? -48060 : (lowerMessage.contains("success") || lowerMessage.contains("complete") || lowerMessage.contains("downloaded") || lowerMessage.startsWith("\u2713") ? -7798904 : -1);
            int finalStatusWidth = this.client.field_1772.method_1727((String)displayStatus);
            int statusTextX = this.x + (renderWidth - finalStatusWidth) / 2;
            Objects.requireNonNull(this.client.field_1772);
            int statusTextY = statusY + 1 + (24 - 9) / 2;
            context.method_51433(this.client.field_1772, (String)displayStatus, statusTextX, statusTextY, statusColor, false);
        }
        if (this.items.size() > 6) {
            boolean scrollChanged;
            int scrollbarX = this.x + renderWidth - 8 - 1;
            int scrollbarY = this.y + 1;
            if (this.scrollBar == null || this.lastScrollBarX != scrollbarX || this.lastScrollBarY != scrollbarY || this.lastScrollBarHeight != visibleItemsHeight) {
                this.scrollBar = new ScrollBar(scrollbarX, scrollbarY, visibleItemsHeight);
                this.lastScrollBarX = scrollbarX;
                this.lastScrollBarY = scrollbarY;
                this.lastScrollBarHeight = visibleItemsHeight;
            }
            int contentHeight = this.items.size() * 24;
            this.scrollBar.setScrollData(contentHeight, visibleItemsHeight);
            if (this.maxScrollOffset > 0) {
                this.scrollBar.setScrollPercentage(this.scrollOffset / (double)this.maxScrollOffset);
            }
            if (this.client.method_22683() != null && ((scrollChanged = this.scrollBar.updateAndRender(context, mouseX, mouseY, delta, this.client.method_22683().method_4490())) || this.scrollBar.isDragging())) {
                this.scrollOffset = (int)(this.scrollBar.getScrollPercentage() * (double)this.maxScrollOffset);
            }
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.isOpen || this.items.isEmpty()) {
            return false;
        }
        int height = this.getDropdownHeight();
        int renderWidth = this.width + 1;
        if (mouseX >= (double)this.x && mouseX < (double)(this.x + renderWidth) && mouseY >= (double)this.y && mouseY < (double)(this.y + height)) {
            int statusAreaStart = this.y + Math.min(this.items.size(), 6) * 24 + 1;
            if (!this.statusMessage.isEmpty() && mouseY >= (double)statusAreaStart) {
                return true;
            }
            if (this.hoveredIndex >= 0 && this.hoveredIndex < this.items.size()) {
                DropdownItem selectedItem = this.items.get(this.hoveredIndex);
                if (this.onSelect != null) {
                    this.onSelect.accept(selectedItem);
                }
                return true;
            }
        } else {
            this.close();
            return false;
        }
        return false;
    }

    public void method_25365(boolean focused) {
    }

    public boolean method_25370() {
        return this.isOpen;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        if (!this.isOpen || this.items.isEmpty()) {
            return false;
        }
        int height = this.getDropdownHeight();
        int renderWidth = this.width + 1;
        return mouseX >= (double)this.x && mouseX < (double)(this.x + renderWidth) && mouseY >= (double)this.y && mouseY < (double)(this.y + height);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (!this.isOpen || this.items.isEmpty()) {
            return false;
        }
        if (!this.method_25405(mouseX, mouseY)) {
            return false;
        }
        if (this.items.size() <= 6) {
            return true;
        }
        double scrollAmount = -verticalAmount * 24.0;
        this.scrollOffset = Math.max(0.0, Math.min((double)this.maxScrollOffset, this.scrollOffset + scrollAmount));
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public static class DropdownItem {
        private final String displayText;
        private final Object data;

        public DropdownItem(String displayText, Object data) {
            this.displayText = displayText;
            this.data = data;
        }

        public String getDisplayText() {
            return this.displayText;
        }

        public Object getData() {
            return this.data;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static interface OnPopupStateChangeListener {
        public void onPopupStateChanged(boolean var1);
    }
}

