/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui.widget;

import com.choculaterie.models.MinemevPostInfo;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;

@Environment(value=EnvType.CLIENT)
public class PostEntryWidget
implements class_4068,
class_364 {
    private static final int MIN_ENTRY_HEIGHT = 70;
    private static final int PADDING = 10;
    private static final int LINE_HEIGHT = 10;
    private static final int ENTRY_BG_COLOR = -12961222;
    private static final int ENTRY_HOVER_COLOR = -11908534;
    private static final int ENTRY_PRESSED_COLOR = -14013910;
    private static final int TEXT_COLOR = -1;
    private static final int SUBTITLE_COLOR = -5592406;
    private static final int BORDER_COLOR = -11184811;
    private final MinemevPostInfo post;
    private int x;
    int y;
    private int width;
    private final class_310 client;
    private final Runnable onClick;
    private boolean isHovered = false;
    private boolean isPressed = false;
    private int calculatedHeight = 70;

    public PostEntryWidget(MinemevPostInfo post, int x, int y, int width, Runnable onClick) {
        this.post = post;
        this.x = x;
        this.y = y;
        this.width = width;
        this.client = class_310.method_1551();
        this.onClick = onClick;
        this.calculateHeight();
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setWidth(int width) {
        this.width = width;
        this.calculateHeight();
    }

    private void calculateHeight() {
        int currentY = 10;
        int contentWidth = this.width - 20;
        if (this.post.getTitle() != null && !this.post.getTitle().isEmpty()) {
            currentY += this.getWrappedTextHeight(this.post.getTitle(), contentWidth) + 5;
        }
        currentY += 15;
        if (this.post.getTags() != null && this.post.getTags().length > 0) {
            StringBuilder tags = new StringBuilder();
            for (int i = 0; i < this.post.getTags().length; ++i) {
                if (i > 0) {
                    tags.append(", ");
                }
                tags.append(this.post.getTags()[i]);
            }
            currentY += this.getWrappedTextHeight(tags.toString(), contentWidth) + 5;
        }
        this.calculatedHeight = Math.max(70, currentY += 10);
    }

    private int getWrappedTextHeight(String text, int maxWidth) {
        if (text == null || text.isEmpty()) {
            return 10;
        }
        String[] words = text.split(" ");
        StringBuilder line = new StringBuilder();
        int lines = 1;
        for (String word : words) {
            Object testLine = !line.isEmpty() ? String.valueOf(line) + " " + word : word;
            int testWidth = this.client.field_1772.method_1727((String)testLine);
            if (testWidth > maxWidth && !line.isEmpty()) {
                line = new StringBuilder(word);
                ++lines;
                continue;
            }
            line = new StringBuilder((String)testLine);
        }
        return lines * 10;
    }

    private void drawWrappedText(class_332 context, String text, int textX, int textY, int maxWidth, int color) {
        if (text == null || text.isEmpty()) {
            return;
        }
        String[] words = text.split(" ");
        StringBuilder line = new StringBuilder();
        int lineY = textY;
        for (String word : words) {
            Object testLine = !line.isEmpty() ? String.valueOf(line) + " " + word : word;
            int testWidth = this.client.field_1772.method_1727((String)testLine);
            if (testWidth > maxWidth && !line.isEmpty()) {
                context.method_25303(this.client.field_1772, line.toString(), textX, lineY, color);
                line = new StringBuilder(word);
                lineY += 10;
                continue;
            }
            line = new StringBuilder((String)testLine);
        }
        if (!line.isEmpty()) {
            context.method_25303(this.client.field_1772, line.toString(), textX, lineY, color);
        }
    }

    public void setY(int y) {
        this.y = y;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        boolean bl = this.isHovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.calculatedHeight;
        int bgColor = this.isPressed && this.isHovered ? -14013910 : (this.isHovered ? -11908534 : -12961222);
        context.method_25294(this.x, this.y, this.x + this.width, this.y + this.calculatedHeight, bgColor);
        context.method_25294(this.x, this.y, this.x + this.width, this.y + 1, -11184811);
        context.method_25294(this.x, this.y + this.calculatedHeight - 1, this.x + this.width, this.y + this.calculatedHeight, -11184811);
        context.method_25294(this.x, this.y, this.x + 1, this.y + this.calculatedHeight, -11184811);
        context.method_25294(this.x + this.width - 1, this.y, this.x + this.width, this.y + this.calculatedHeight, -11184811);
        int currentY = this.y + 10;
        int contentWidth = this.width - 20;
        String title = this.post.getTitle();
        if (title != null && !title.isEmpty()) {
            this.drawWrappedText(context, title, this.x + 10, currentY, contentWidth, -1);
            currentY += this.getWrappedTextHeight(title, contentWidth) + 5;
        }
        String author = this.post.getAuthor() != null ? this.post.getAuthor() : "Unknown";
        String downloads = String.format("Downloads: %d", this.post.getDownloads());
        String info = String.format("By %s | %s", author, downloads);
        context.method_25303(this.client.field_1772, info, this.x + 10, currentY, -5592406);
        currentY += 15;
        if (this.post.getTags() != null && this.post.getTags().length > 0) {
            StringBuilder tags = new StringBuilder();
            for (int i = 0; i < this.post.getTags().length; ++i) {
                if (i > 0) {
                    tags.append(", ");
                }
                tags.append(this.post.getTags()[i]);
            }
            this.drawWrappedText(context, tags.toString(), this.x + 10, currentY, contentWidth, -5592406);
        }
    }

    public int getHeight() {
        return this.calculatedHeight;
    }

    public int getWidth() {
        return this.width;
    }

    public int getX() {
        return this.x;
    }

    public MinemevPostInfo getPost() {
        return this.post;
    }

    public void setPressed(boolean pressed) {
        this.isPressed = pressed;
    }

    public boolean isPressed() {
        return this.isPressed;
    }

    public void setHovered(boolean hovered) {
        this.isHovered = hovered;
    }

    public boolean isHovered() {
        return this.isHovered;
    }

    public void method_25365(boolean focused) {
    }

    public boolean method_25370() {
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        System.out.println("[PostEntryWidget] mouseClicked called - mouseX: " + mouseX + ", mouseY: " + mouseY + ", button: " + button);
        System.out.println("[PostEntryWidget] Entry bounds - x: " + this.x + ", y: " + this.y + ", width: " + this.width + ", height: " + this.calculatedHeight);
        System.out.println("[PostEntryWidget] Post title: " + (this.post != null ? this.post.getTitle() : "null"));
        if (mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.calculatedHeight) && button == 0) {
            this.isPressed = true;
            System.out.println("[PostEntryWidget] CLICK DETECTED! Calling onClick for: " + this.post.getTitle());
            if (this.onClick != null) {
                this.onClick.run();
                System.out.println("[PostEntryWidget] onClick.run() completed");
            } else {
                System.out.println("[PostEntryWidget] WARNING: onClick is null!");
            }
            return true;
        }
        System.out.println("[PostEntryWidget] Click outside bounds, ignoring");
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.isPressed) {
            this.isPressed = false;
            return true;
        }
        return false;
    }
}

