/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui;

import com.choculaterie.config.DownloadSettings;
import com.choculaterie.gui.SettingsPage;
import com.choculaterie.gui.widget.ConfirmPopup;
import com.choculaterie.gui.widget.CustomButton;
import com.choculaterie.gui.widget.CustomTextField;
import com.choculaterie.gui.widget.ScrollBar;
import com.choculaterie.gui.widget.TextInputPopup;
import com.choculaterie.gui.widget.ToastManager;
import com.choculaterie.network.ChoculaterieNetworkManager;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import org.lwjgl.glfw.GLFW;

@Environment(value=EnvType.CLIENT)
public class LocalFolderPage
extends class_437 {
    private static final int PADDING = 10;
    private static final int BUTTON_HEIGHT = 20;
    private static final int ITEM_HEIGHT = 25;
    private static final int SCROLLBAR_WIDTH = 8;
    private static final int SCROLLBAR_PADDING = 2;
    private final class_437 parentScreen;
    private CustomButton renameButton;
    private CustomButton deleteButton;
    private ScrollBar scrollBar;
    private TextInputPopup activePopup;
    private ConfirmPopup confirmPopup;
    private File currentDirectory;
    private File baseDirectory;
    private final List<FileEntry> entries = new ArrayList<FileEntry>();
    private int scrollOffset = 0;
    private final List<Integer> selectedIndices = new ArrayList<Integer>();
    private int lastClickedIndex = -1;
    private boolean isDragging = false;
    private int dragStartIndex = -1;
    private double dragStartX = 0.0;
    private double dragStartY = 0.0;
    private int dropTargetIndex = -1;
    private File dropTargetBreadcrumb = null;
    private final List<Integer> preClickSelection = new ArrayList<Integer>();
    private final List<QuickShareButton> quickShareButtons = new ArrayList<QuickShareButton>();
    private int uploadingIndex = -1;
    private ToastManager toastManager;
    private final List<BreadcrumbSegment> breadcrumbSegments = new ArrayList<BreadcrumbSegment>();
    private final List<FileAction> undoStack = new ArrayList<FileAction>();
    private final List<FileAction> redoStack = new ArrayList<FileAction>();
    private static final int MAX_UNDO_HISTORY = 50;
    private File trashFolder;
    private CustomTextField searchField;
    private String searchQuery = "";
    private boolean isSearchActive = false;
    private boolean wasDeleteKeyPressed = false;
    private boolean wasZKeyPressed = false;
    private boolean wasYKeyPressed = false;
    private boolean wasAKeyPressed = false;

    public LocalFolderPage(class_437 parentScreen) {
        super((class_2561)class_2561.method_43470((String)"Local Folder"));
        this.parentScreen = parentScreen;
        String downloadPath = DownloadSettings.getInstance().getAbsoluteDownloadPath();
        this.baseDirectory = this.currentDirectory = new File(downloadPath);
        if (!this.currentDirectory.exists()) {
            this.currentDirectory.mkdirs();
        }
        this.trashFolder = new File(this.baseDirectory, ".trash");
        if (!this.trashFolder.exists()) {
            this.trashFolder.mkdirs();
        }
        this.loadEntries();
    }

    protected void method_25426() {
        String deleteLabel;
        int openFolderWidth;
        int deleteWidth;
        int renameWidth;
        int newFolderWidth;
        boolean isVeryCompact;
        int availableWidth;
        String previousSearchText;
        super.method_25426();
        String downloadPath = DownloadSettings.getInstance().getAbsoluteDownloadPath();
        File newBaseDirectory = new File(downloadPath);
        if (!newBaseDirectory.equals(this.baseDirectory)) {
            this.baseDirectory = newBaseDirectory;
            this.currentDirectory = newBaseDirectory;
            this.trashFolder = new File(this.baseDirectory, ".trash");
            if (!this.currentDirectory.exists()) {
                this.currentDirectory.mkdirs();
            }
            if (!this.trashFolder.exists()) {
                this.trashFolder.mkdirs();
            }
            this.selectedIndices.clear();
            this.scrollOffset = 0;
        }
        this.loadEntries();
        int savedScrollOffset = this.scrollOffset;
        String string = previousSearchText = this.searchField != null ? this.searchField.method_1882() : "";
        if (this.field_22787 != null) {
            this.toastManager = new ToastManager(this.field_22787);
        }
        boolean isCompact = (availableWidth = this.field_22789 - 20 - 20 - 10) < 550;
        boolean bl = isVeryCompact = availableWidth < 450;
        int n = isVeryCompact ? 25 : (newFolderWidth = isCompact ? 70 : 100);
        int n2 = isVeryCompact ? 25 : (renameWidth = isCompact ? 50 : 70);
        int n3 = isVeryCompact ? 25 : (deleteWidth = isCompact ? 45 : 60);
        int n4 = isVeryCompact ? 25 : (openFolderWidth = isCompact ? 80 : 120);
        String newFolderLabel = isVeryCompact ? "+" : (isCompact ? "+ New" : "+ New Folder");
        String renameLabel = isVeryCompact ? "\u270f" : "Rename";
        String string2 = deleteLabel = isVeryCompact ? "\ud83d\uddd1" : "Delete";
        String openFolderLabel = isVeryCompact ? "\ud83d\udcc1" : (isCompact ? "\ud83d\udcc1 Open" : "\ud83d\udcc1 Open Folder");
        int currentX = 10;
        this.method_37063((class_364)new CustomButton(currentX, 10, 20, 20, (class_2561)class_2561.method_43470((String)"\u2190"), button -> this.goBack()));
        this.method_37063((class_364)new CustomButton(currentX += 30, 10, newFolderWidth, 20, (class_2561)class_2561.method_43470((String)newFolderLabel), button -> this.openNewFolderPopup()));
        this.renameButton = new CustomButton(currentX += newFolderWidth + 10, 10, renameWidth, 20, (class_2561)class_2561.method_43470((String)renameLabel), button -> this.openRenamePopup());
        this.renameButton.field_22763 = false;
        this.method_37063((class_364)this.renameButton);
        this.deleteButton = new CustomButton(currentX += renameWidth + 10, 10, deleteWidth, 20, (class_2561)class_2561.method_43470((String)deleteLabel), button -> this.handleDeleteClick());
        this.deleteButton.field_22763 = false;
        this.method_37063((class_364)this.deleteButton);
        this.method_37063((class_364)new CustomButton(currentX += deleteWidth + 10, 10, openFolderWidth, 20, (class_2561)class_2561.method_43470((String)openFolderLabel), button -> this.openInFileExplorer()));
        int settingsX = this.field_22789 - 10 - 20;
        this.method_37063((class_364)new CustomButton(settingsX, 10, 20, 20, (class_2561)class_2561.method_43470((String)"\u2699"), button -> this.openSettings()));
        int searchWidth = settingsX - (currentX += openFolderWidth + 10) - 10;
        if (this.field_22787 != null && searchWidth > 30) {
            this.searchField = new CustomTextField(this.field_22787, currentX, 10, searchWidth, 20, (class_2561)class_2561.method_43470((String)"Search"));
            this.searchField.method_47404((class_2561)class_2561.method_43470((String)"Search..."));
            this.searchField.setOnChanged(this::onSearchChanged);
            this.searchField.setOnClearPressed(this::onSearchCleared);
            if (!previousSearchText.isEmpty()) {
                this.searchField.method_1852(previousSearchText);
            }
            this.method_37063((class_364)this.searchField);
        }
        int listY = 68;
        int listHeight = this.field_22790 - listY - 20;
        this.scrollBar = new ScrollBar(this.field_22789 - 10 - 8, listY, listHeight);
        int contentHeight = this.entries.size() * 25;
        int maxScroll = contentHeight <= listHeight ? 0 : this.entries.size() - listHeight / 25;
        this.scrollBar.setScrollData(contentHeight, listHeight);
        this.scrollOffset = Math.max(0, Math.min(maxScroll, savedScrollOffset));
        if (maxScroll > 0) {
            this.scrollBar.setScrollPercentage((double)this.scrollOffset / (double)maxScroll);
        }
    }

    private void goBack() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parentScreen);
        }
    }

    private void openSettings() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507((class_437)new SettingsPage(this));
        }
    }

    private void openInFileExplorer() {
        class_156.method_668().method_672(this.currentDirectory);
    }

    private void handleQuickShare(int entryIndex) {
        if (entryIndex < 0 || entryIndex >= this.entries.size()) {
            return;
        }
        FileEntry entry = this.entries.get(entryIndex);
        if (entry.isDirectory || !entry.file.getName().toLowerCase().endsWith(".litematic")) {
            if (this.toastManager != null) {
                this.toastManager.showError("Only .litematic files can be shared");
            }
            return;
        }
        this.uploadingIndex = entryIndex;
        if (this.toastManager != null) {
            this.toastManager.showInfo("Uploading " + entry.file.getName() + "...");
        }
        ((CompletableFuture)ChoculaterieNetworkManager.uploadLitematic(entry.file).thenAccept(response -> {
            String shortUrl = response.getShortUrl();
            if (shortUrl == null || shortUrl.isEmpty()) {
                if (this.field_22787 != null) {
                    this.field_22787.execute(() -> {
                        if (this.toastManager != null) {
                            this.toastManager.showError("Upload failed: No URL returned");
                        }
                        this.uploadingIndex = -1;
                    });
                }
                System.err.println("Upload failed: No URL returned");
                return;
            }
            if (this.field_22787 != null) {
                this.field_22787.execute(() -> {
                    try {
                        if (this.field_22787.field_1774 != null) {
                            this.field_22787.field_1774.method_1455(shortUrl);
                            if (this.toastManager != null) {
                                this.toastManager.showSuccess("Link copied to clipboard!");
                            }
                            System.out.println("Quick share URL copied: " + shortUrl);
                        } else {
                            StringSelection selection = new StringSelection(shortUrl);
                            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, selection);
                            if (this.toastManager != null) {
                                this.toastManager.showSuccess("Link copied to clipboard!");
                            }
                            System.out.println("Quick share URL copied (AWT): " + shortUrl);
                        }
                    }
                    catch (Exception e) {
                        if (this.toastManager != null) {
                            this.toastManager.showError("Failed to copy to clipboard");
                        }
                        System.err.println("Failed to copy to clipboard: " + e.getMessage());
                        e.printStackTrace();
                    }
                    this.uploadingIndex = -1;
                });
            }
        })).exceptionally(error -> {
            String errorMessage = error.getMessage();
            Object userMessage = errorMessage != null ? (errorMessage.contains("UnknownHostException") || errorMessage.contains("ConnectException") || errorMessage.contains("NoRouteToHostException") ? "Upload failed: No internet connection" : (errorMessage.contains("SocketTimeoutException") ? "Upload failed: Connection timeout" : (errorMessage.contains("HTTP error code: 413") ? "Upload failed: File too large" : (errorMessage.contains("HTTP error code:") ? "Upload failed: Server error" : "Upload failed: " + errorMessage)))) : "Upload failed: Unknown error";
            String fullError = "Quick Share Error: " + errorMessage;
            if (error.getCause() != null) {
                fullError = fullError + "\nCause: " + error.getCause().toString();
            }
            if (this.toastManager != null) {
                this.toastManager.showError((String)userMessage, fullError);
            }
            System.err.println("Quick share failed: " + errorMessage);
            error.printStackTrace();
            this.uploadingIndex = -1;
            return null;
        });
    }

    private void openNewFolderPopup() {
        if (this.activePopup != null) {
            return;
        }
        if (this.searchField != null) {
            this.searchField.method_25365(false);
        }
        this.activePopup = new TextInputPopup(this, "Create New Folder", this::createNewFolder, this::closePopup);
    }

    private void createNewFolder(String folderName) {
        if (this.currentDirectory == null) {
            this.closePopup();
            return;
        }
        File newFolder = new File(this.currentDirectory, folderName);
        if (newFolder.exists()) {
            if (this.activePopup != null) {
                this.activePopup.setErrorMessage("\"" + folderName + "\" already exists in this folder");
            }
            return;
        }
        boolean success = newFolder.mkdir();
        if (success) {
            this.addUndoAction(new FileAction(FileAction.Type.CREATE_FOLDER, new FileOperation(null, newFolder, true)));
            System.out.println("Created folder: " + newFolder.getAbsolutePath());
            if (this.toastManager != null) {
                this.toastManager.showSuccess("Created folder \"" + folderName + "\"");
            }
            this.closePopup();
            this.loadEntries();
        } else if (this.activePopup != null) {
            this.activePopup.setErrorMessage("Failed to create folder - check folder permissions");
        }
    }

    private void closePopup() {
        this.activePopup = null;
        this.confirmPopup = null;
    }

    private void openRenamePopup() {
        if (this.activePopup != null) {
            return;
        }
        if (this.selectedIndices.size() != 1) {
            return;
        }
        int index = this.selectedIndices.getFirst();
        if (index < 0 || index >= this.entries.size()) {
            return;
        }
        FileEntry entry = this.entries.get(index);
        String currentName = entry.file.getName();
        if (this.searchField != null) {
            this.searchField.method_25365(false);
        }
        this.activePopup = new TextInputPopup(this, "Rename", "Rename", newName -> this.renameFile(entry.file, (String)newName), this::closePopup);
        this.activePopup.setText(currentName);
    }

    private void renameFile(File file, String newName) {
        if (file == null || newName == null || newName.trim().isEmpty()) {
            this.closePopup();
            return;
        }
        if ((newName = newName.trim()).equals(file.getName())) {
            this.closePopup();
            return;
        }
        File newFile = new File(file.getParentFile(), newName);
        if (newFile.exists()) {
            if (this.activePopup != null) {
                this.activePopup.setErrorMessage("\"" + newName + "\" already exists in this folder");
            }
            return;
        }
        boolean isDirectory = file.isDirectory();
        boolean success = file.renameTo(newFile);
        if (success) {
            this.addUndoAction(new FileAction(FileAction.Type.RENAME, new FileOperation(file, newFile, isDirectory)));
            System.out.println("Renamed: " + file.getName() + " -> " + newName);
            if (this.toastManager != null) {
                this.toastManager.showSuccess("Renamed to \"" + newName + "\"");
            }
            this.closePopup();
            this.loadEntries();
        } else if (this.activePopup != null) {
            this.activePopup.setErrorMessage("Failed to rename - file may be in use or protected");
        }
    }

    private void handleDeleteClick() {
        if (this.activePopup != null || this.confirmPopup != null) {
            return;
        }
        if (this.selectedIndices.isEmpty()) {
            return;
        }
        long windowHandle = this.field_22787 != null ? this.field_22787.method_22683().method_4490() : 0L;
        boolean shiftHeld = false;
        if (windowHandle != 0L) {
            boolean bl = shiftHeld = GLFW.glfwGetKey((long)windowHandle, (int)340) == 1 || GLFW.glfwGetKey((long)windowHandle, (int)344) == 1;
        }
        if (shiftHeld) {
            this.deleteSelectedFiles();
        } else {
            Object message;
            String title;
            if (this.selectedIndices.size() == 1) {
                FileEntry entry = this.entries.get(this.selectedIndices.getFirst());
                String itemType = entry.isDirectory ? "folder" : "file";
                title = "Delete " + itemType + "?";
                if (entry.isDirectory) {
                    StringBuilder messageBuilder = new StringBuilder();
                    messageBuilder.append("Are you sure you want to delete \"").append(entry.file.getName()).append("\"?\n\n");
                    messageBuilder.append("Contents:\n");
                    this.buildDeleteTree(entry.file, messageBuilder, "", true);
                    message = messageBuilder.toString();
                } else {
                    message = "Are you sure you want to delete \"" + entry.file.getName() + "\"?";
                }
            } else {
                title = "Delete " + this.selectedIndices.size() + " items?";
                boolean hasFolders = false;
                for (int idx : this.selectedIndices) {
                    if (idx < 0 || idx >= this.entries.size() || !this.entries.get((int)idx).isDirectory) continue;
                    hasFolders = true;
                    break;
                }
                if (hasFolders) {
                    StringBuilder messageBuilder = new StringBuilder();
                    messageBuilder.append("Are you sure you want to delete ").append(this.selectedIndices.size()).append(" selected items?\n\n");
                    messageBuilder.append("Items to delete:\n");
                    ArrayList<FileEntry> selectedEntries = new ArrayList<FileEntry>();
                    for (int idx : this.selectedIndices) {
                        if (idx < 0 || idx >= this.entries.size()) continue;
                        selectedEntries.add(this.entries.get(idx));
                    }
                    selectedEntries.sort((a, b) -> {
                        if (a.isDirectory && !b.isDirectory) {
                            return -1;
                        }
                        if (!a.isDirectory && b.isDirectory) {
                            return 1;
                        }
                        return a.file.getName().compareToIgnoreCase(b.file.getName());
                    });
                    for (int i = 0; i < selectedEntries.size(); ++i) {
                        String connector;
                        FileEntry entry = (FileEntry)selectedEntries.get(i);
                        boolean isLast = i == selectedEntries.size() - 1;
                        String string = connector = isLast ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ";
                        if (entry.isDirectory) {
                            File[] subFiles = entry.file.listFiles();
                            boolean isEmpty = subFiles == null || subFiles.length == 0;
                            messageBuilder.append(connector).append("\ud83d\udcc1 ").append(entry.file.getName()).append("/\n");
                            if (isEmpty) continue;
                            String newIndent = isLast ? "    " : "\u2502   ";
                            this.buildDeleteTree(entry.file, messageBuilder, newIndent, false);
                            continue;
                        }
                        messageBuilder.append(connector).append("\ud83d\udcc4 ").append(entry.file.getName()).append("\n");
                    }
                    message = messageBuilder.toString();
                } else {
                    message = "Are you sure you want to delete " + this.selectedIndices.size() + " selected items?";
                }
            }
            if (this.searchField != null) {
                this.searchField.method_25365(false);
            }
            this.confirmPopup = new ConfirmPopup(this, title, (String)message, () -> {
                this.deleteSelectedFiles();
                this.closePopup();
            }, this::closePopup);
        }
    }

    private void deleteSelectedFiles() {
        if (this.selectedIndices.isEmpty()) {
            return;
        }
        if (!this.trashFolder.exists()) {
            this.trashFolder.mkdirs();
        }
        ArrayList<Integer> sortedIndices = new ArrayList<Integer>(this.selectedIndices);
        sortedIndices.sort((a, b) -> b - a);
        int successCount = 0;
        int failCount = 0;
        ArrayList<String> failedNames = new ArrayList<String>();
        ArrayList<FileOperation> successfulOperations = new ArrayList<FileOperation>();
        Iterator iterator = sortedIndices.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            if (index < 0 || index >= this.entries.size()) continue;
            FileEntry entry = this.entries.get(index);
            File sourceFile = entry.file;
            String trashName = System.currentTimeMillis() + "_" + sourceFile.getName();
            File trashFile = new File(this.trashFolder, trashName);
            boolean success = sourceFile.renameTo(trashFile);
            if (success) {
                ++successCount;
                successfulOperations.add(new FileOperation(sourceFile, trashFile, entry.isDirectory));
                System.out.println("Moved to trash: " + sourceFile.getName());
                continue;
            }
            ++failCount;
            failedNames.add(sourceFile.getName());
            System.err.println("Failed to delete: " + sourceFile.getAbsolutePath());
        }
        if (!successfulOperations.isEmpty()) {
            this.addUndoAction(new FileAction(FileAction.Type.DELETE, successfulOperations));
        }
        if (this.toastManager != null) {
            if (failCount == 0) {
                if (successCount == 1) {
                    this.toastManager.showSuccess("Deleted 1 item (Ctrl+Z to undo)");
                } else {
                    this.toastManager.showSuccess("Deleted " + successCount + " items (Ctrl+Z to undo)");
                }
            } else if (successCount == 0) {
                if (failCount == 1) {
                    this.toastManager.showError("Failed to delete \"" + (String)failedNames.getFirst() + "\" - file may be in use or protected");
                } else if (failCount <= 3) {
                    this.toastManager.showError("Failed to delete: " + String.join((CharSequence)", ", failedNames) + " - files may be in use or protected");
                } else {
                    this.toastManager.showError("Failed to delete " + failCount + " items - files may be in use or protected");
                }
            } else if (failCount == 1) {
                this.toastManager.showError("Deleted " + successCount + " items, failed to delete \"" + (String)failedNames.getFirst() + "\"");
            } else {
                this.toastManager.showError("Deleted " + successCount + " items, failed to delete " + failCount + " items");
            }
        }
        this.loadEntries();
    }

    private void performMove(File targetFolder) {
        if (this.selectedIndices.isEmpty() || targetFolder == null || !targetFolder.isDirectory()) {
            return;
        }
        int successCount = 0;
        int conflictCount = 0;
        int otherFailCount = 0;
        ArrayList<String> conflictNames = new ArrayList<String>();
        ArrayList<String> otherFailNames = new ArrayList<String>();
        ArrayList<FileOperation> successfulOperations = new ArrayList<FileOperation>();
        ArrayList<Integer> sortedIndices = new ArrayList<Integer>(this.selectedIndices);
        sortedIndices.sort((a, b) -> b - a);
        Iterator iterator = sortedIndices.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            if (index < 0 || index >= this.entries.size()) continue;
            FileEntry entry = this.entries.get(index);
            File sourceFile = entry.file;
            File destFile = new File(targetFolder, sourceFile.getName());
            if (destFile.exists()) {
                ++conflictCount;
                conflictNames.add(sourceFile.getName());
                System.err.println("Cannot move: destination already exists: " + destFile.getAbsolutePath());
                continue;
            }
            boolean success = sourceFile.renameTo(destFile);
            if (success) {
                ++successCount;
                successfulOperations.add(new FileOperation(sourceFile, destFile, entry.isDirectory));
                System.out.println("Moved: " + sourceFile.getName() + " -> " + targetFolder.getName());
                continue;
            }
            ++otherFailCount;
            otherFailNames.add(sourceFile.getName());
            System.err.println("Failed to move: " + sourceFile.getAbsolutePath());
        }
        if (!successfulOperations.isEmpty()) {
            this.addUndoAction(new FileAction(FileAction.Type.MOVE, successfulOperations));
        }
        int totalFailCount = conflictCount + otherFailCount;
        if (this.toastManager != null) {
            if (totalFailCount == 0) {
                if (successCount == 1) {
                    this.toastManager.showSuccess("Moved 1 item to " + targetFolder.getName());
                } else {
                    this.toastManager.showSuccess("Moved " + successCount + " items to " + targetFolder.getName());
                }
            } else if (successCount == 0) {
                if (conflictCount > 0 && otherFailCount == 0) {
                    if (conflictCount == 1) {
                        this.toastManager.showError("\"" + (String)conflictNames.getFirst() + "\" already exists in " + targetFolder.getName());
                    } else if (conflictCount <= 3) {
                        this.toastManager.showError("Items already exist in " + targetFolder.getName() + ": " + String.join((CharSequence)", ", conflictNames));
                    } else {
                        this.toastManager.showError(conflictCount + " items already exist in " + targetFolder.getName());
                    }
                } else if (otherFailCount > 0 && conflictCount == 0) {
                    if (otherFailCount == 1) {
                        this.toastManager.showError("Failed to move \"" + (String)otherFailNames.getFirst() + "\" - check file permissions");
                    } else {
                        this.toastManager.showError("Failed to move " + otherFailCount + " items - check file permissions");
                    }
                } else {
                    this.toastManager.showError("Failed to move " + totalFailCount + " items (" + conflictCount + " already exist, " + otherFailCount + " other errors)");
                }
            } else {
                String errorDetail = conflictCount > 0 && otherFailCount == 0 ? conflictCount + " already exist" : (otherFailCount > 0 && conflictCount == 0 ? otherFailCount + " failed" : conflictCount + " already exist, " + otherFailCount + " failed");
                this.toastManager.showError("Moved " + successCount + " to " + targetFolder.getName() + ", " + errorDetail);
            }
        }
        this.loadEntries();
    }

    private int[] countFilesRecursively(File directory) {
        int[] counts = new int[2];
        if (!directory.isDirectory()) {
            return counts;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return counts;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                counts[0] = counts[0] + 1;
                int[] subCounts = this.countFilesRecursively(file);
                counts[0] = counts[0] + subCounts[0];
                counts[1] = counts[1] + subCounts[1];
                continue;
            }
            counts[1] = counts[1] + 1;
        }
        return counts;
    }

    private void buildDeleteTree(File directory, StringBuilder builder, String indent, boolean showCount) {
        if (!directory.isDirectory()) {
            return;
        }
        File[] files = directory.listFiles();
        if (files == null || files.length == 0) {
            builder.append(indent).append("(empty)\n");
            return;
        }
        Arrays.sort(files, (a, b) -> {
            if (a.isDirectory() && !b.isDirectory()) {
                return -1;
            }
            if (!a.isDirectory() && b.isDirectory()) {
                return 1;
            }
            return a.getName().compareToIgnoreCase(b.getName());
        });
        int maxItems = 20;
        int shown = 0;
        for (int i = 0; i < files.length; ++i) {
            String connector;
            File file = files[i];
            if (shown >= maxItems) {
                int remaining = files.length - shown;
                builder.append(indent).append("\u2514\u2500\u2500 ... and ").append(remaining).append(" more item(s)\n");
                break;
            }
            boolean isLast = i == files.length - 1 || shown == maxItems - 1 && files.length > maxItems;
            String string = connector = isLast ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ";
            if (file.isDirectory()) {
                File[] subFiles = file.listFiles();
                boolean isEmpty = subFiles == null || subFiles.length == 0;
                builder.append(indent).append(connector).append("\ud83d\udcc1 ").append(file.getName()).append("/\n");
                if (!isEmpty && indent.length() < 12) {
                    String newIndent = indent + (isLast ? "    " : "\u2502   ");
                    this.buildDeleteTree(file, builder, newIndent, false);
                }
            } else {
                builder.append(indent).append(connector).append("\ud83d\udcc4 ").append(file.getName()).append("\n");
            }
            ++shown;
        }
        if (showCount && files.length > 0) {
            int[] counts = this.countFilesRecursively(directory);
            int totalFolders = counts[0];
            int totalFiles = counts[1];
            builder.append("\n");
            if (totalFolders > 0) {
                builder.append("Total: ").append(totalFolders).append(" folder(s), ").append(totalFiles).append(" file(s)");
            } else {
                builder.append("Total: ").append(totalFiles).append(" file(s)");
            }
        }
    }

    private boolean deleteDirectoryRecursively(File directory) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.deleteDirectoryRecursively(file);
                    continue;
                }
                file.delete();
            }
        }
        return directory.delete();
    }

    private void updateSelectionButtons() {
        boolean hasSelection;
        boolean bl = hasSelection = !this.selectedIndices.isEmpty();
        if (this.renameButton != null) {
            boolean bl2 = this.renameButton.field_22763 = this.selectedIndices.size() == 1;
        }
        if (this.deleteButton != null) {
            this.deleteButton.field_22763 = hasSelection;
        }
    }

    private void selectAll() {
        if (this.entries.isEmpty()) {
            return;
        }
        this.selectedIndices.clear();
        for (int i = 0; i < this.entries.size(); ++i) {
            this.selectedIndices.add(i);
        }
        this.lastClickedIndex = this.entries.size() - 1;
        this.updateSelectionButtons();
    }

    private void onSearchChanged() {
        String newQuery;
        if (this.searchField != null && !(newQuery = this.searchField.method_1882().trim().toLowerCase()).equals(this.searchQuery)) {
            this.searchQuery = newQuery;
            this.isSearchActive = !this.searchQuery.isEmpty();
            this.performSearch();
        }
    }

    private void onSearchCleared() {
        this.searchQuery = "";
        this.isSearchActive = false;
        this.loadEntries();
    }

    private void performSearch() {
        if (!this.isSearchActive || this.searchQuery.isEmpty()) {
            this.loadEntries();
            return;
        }
        this.entries.clear();
        this.selectedIndices.clear();
        this.lastClickedIndex = -1;
        this.scrollOffset = 0;
        this.searchRecursively(this.baseDirectory, "");
        this.entries.sort((a, b) -> {
            if (a.isDirectory && !b.isDirectory) {
                return -1;
            }
            if (!a.isDirectory && b.isDirectory) {
                return 1;
            }
            return a.file.getName().compareToIgnoreCase(b.file.getName());
        });
        this.updateScrollBar();
        this.updateSelectionButtons();
    }

    private void searchRecursively(File directory, String pathPrefix) {
        if (directory == null || !directory.exists() || !directory.isDirectory()) {
            return;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            String currentPath;
            if (file.getName().equals(".trash")) continue;
            String fileName = file.getName().toLowerCase();
            String string = currentPath = pathPrefix.isEmpty() ? file.getName() : pathPrefix + "/" + file.getName();
            if (fileName.contains(this.searchQuery)) {
                String relativePath = this.getRelativePath(file);
                this.entries.add(new FileEntry(file, relativePath));
            }
            if (!file.isDirectory()) continue;
            this.searchRecursively(file, currentPath);
        }
    }

    private String getRelativePath(File file) {
        if (this.baseDirectory == null || file == null) {
            return "";
        }
        try {
            String basePath = this.baseDirectory.getCanonicalPath();
            String filePath = file.getCanonicalPath();
            if (filePath.startsWith(basePath)) {
                int lastSep;
                String relative = filePath.substring(basePath.length());
                if (relative.startsWith(File.separator)) {
                    relative = relative.substring(1);
                }
                if ((lastSep = relative.lastIndexOf(File.separator)) > 0) {
                    return relative.substring(0, lastSep);
                }
                return "";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    private void loadEntries() {
        File[] files;
        this.entries.clear();
        this.selectedIndices.clear();
        this.lastClickedIndex = -1;
        if (this.isSearchActive && !this.searchQuery.isEmpty()) {
            this.performSearch();
            return;
        }
        if (this.currentDirectory != null && this.currentDirectory.exists() && (files = this.currentDirectory.listFiles()) != null) {
            Arrays.sort(files, (a, b) -> {
                if (a.isDirectory() && !b.isDirectory()) {
                    return -1;
                }
                if (!a.isDirectory() && b.isDirectory()) {
                    return 1;
                }
                return a.getName().compareToIgnoreCase(b.getName());
            });
            for (File file : files) {
                if (file.getName().equals(".trash")) continue;
                this.entries.add(new FileEntry(file));
            }
        }
        this.updateScrollBar();
        this.updateSelectionButtons();
    }

    private void updateScrollBar() {
        if (this.scrollBar != null) {
            int listY = 68;
            int listHeight = this.field_22790 - listY - 20;
            int contentHeight = this.entries.size() * 25;
            this.scrollBar.setScrollData(contentHeight, listHeight);
            int maxScroll = contentHeight <= listHeight ? 0 : this.entries.size() - listHeight / 25;
            this.scrollOffset = (int)(this.scrollBar.getScrollPercentage() * (double)maxScroll);
        }
    }

    private void renderBreadcrumb(class_332 context, int mouseX, int mouseY) {
        this.breadcrumbSegments.clear();
        int breadcrumbY = 54;
        int currentX = 10;
        String label = "Current: ";
        context.method_25303(this.field_22793, label, currentX, breadcrumbY, -5592406);
        currentX += this.field_22793.method_1727(label);
        ArrayList<File> pathSegments = new ArrayList<File>();
        try {
            String basePath = this.baseDirectory.getCanonicalPath();
            for (File dir = this.currentDirectory; dir != null; dir = dir.getParentFile()) {
                pathSegments.addFirst(dir);
                String dirPath = dir.getCanonicalPath();
                if (!dirPath.equals(basePath)) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            pathSegments.clear();
            pathSegments.add(this.currentDirectory);
        }
        for (int i = 0; i < pathSegments.size(); ++i) {
            boolean isDropTarget;
            String segmentName;
            File segment = (File)pathSegments.get(i);
            if (i == 0) {
                segmentName = "/";
            } else {
                if (i > 1) {
                    String separator = " / ";
                    context.method_25303(this.field_22793, separator, currentX, breadcrumbY, -7829368);
                    currentX += this.field_22793.method_1727(separator);
                } else {
                    String space = " ";
                    context.method_25303(this.field_22793, space, currentX, breadcrumbY, -7829368);
                    currentX += this.field_22793.method_1727(space);
                }
                segmentName = segment.getName();
            }
            int segmentWidth = this.field_22793.method_1727(segmentName);
            boolean isHovered = this.activePopup == null && mouseX >= currentX && mouseX < currentX + segmentWidth && mouseY >= breadcrumbY - 2 && mouseY < breadcrumbY + 12;
            boolean isCurrent = i == pathSegments.size() - 1;
            boolean bl = isDropTarget = this.isDragging && this.dropTargetBreadcrumb != null && this.dropTargetBreadcrumb.equals(segment);
            int color = isDropTarget ? -11141291 : (isCurrent ? -1 : (isHovered ? -11162881 : -7811841));
            if (isDropTarget) {
                context.method_25294(currentX - 2, breadcrumbY - 2, currentX + segmentWidth + 2, breadcrumbY + 12, -2009897421);
            }
            if (isHovered && !isCurrent) {
                context.method_25294(currentX, breadcrumbY + 10, currentX + segmentWidth, breadcrumbY + 11, color);
            }
            context.method_25303(this.field_22793, segmentName, currentX, breadcrumbY, color);
            if (!isCurrent) {
                this.breadcrumbSegments.add(new BreadcrumbSegment(currentX, segmentWidth, segment));
            }
            currentX += segmentWidth;
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        boolean scrollChanged;
        int listY;
        long windowHandle;
        context.method_25294(0, 0, this.field_22789, this.field_22790, -14671840);
        if (this.field_22787 != null && this.field_22787.method_22683() != null) {
            boolean popupActive;
            windowHandle = this.field_22787.method_22683().method_4490();
            boolean searchFocused = this.searchField != null && this.searchField.method_25370();
            boolean bl = popupActive = this.activePopup != null || this.confirmPopup != null;
            if (!searchFocused && !popupActive) {
                boolean isADown;
                boolean isYDown;
                boolean isZDown;
                boolean isDeleteDown;
                boolean ctrlHeld = GLFW.glfwGetKey((long)windowHandle, (int)341) == 1 || GLFW.glfwGetKey((long)windowHandle, (int)345) == 1;
                boolean shiftHeld = GLFW.glfwGetKey((long)windowHandle, (int)340) == 1 || GLFW.glfwGetKey((long)windowHandle, (int)344) == 1;
                boolean bl2 = isDeleteDown = GLFW.glfwGetKey((long)windowHandle, (int)261) == 1;
                if (isDeleteDown && !this.wasDeleteKeyPressed && !this.selectedIndices.isEmpty()) {
                    if (shiftHeld) {
                        this.deleteSelectedFiles();
                    } else {
                        this.handleDeleteClick();
                    }
                }
                this.wasDeleteKeyPressed = isDeleteDown;
                boolean bl3 = isZDown = GLFW.glfwGetKey((long)windowHandle, (int)90) == 1;
                if (isZDown && !this.wasZKeyPressed && ctrlHeld) {
                    this.performUndo();
                }
                this.wasZKeyPressed = isZDown;
                boolean bl4 = isYDown = GLFW.glfwGetKey((long)windowHandle, (int)89) == 1;
                if (isYDown && !this.wasYKeyPressed && ctrlHeld) {
                    this.performRedo();
                }
                this.wasYKeyPressed = isYDown;
                boolean bl5 = isADown = GLFW.glfwGetKey((long)windowHandle, (int)65) == 1;
                if (isADown && !this.wasAKeyPressed && ctrlHeld) {
                    this.selectAll();
                }
                this.wasAKeyPressed = isADown;
            }
        }
        if (this.dragStartIndex != -1 && this.field_22787 != null && this.field_22787.method_22683() != null) {
            boolean mouseButtonPressed;
            windowHandle = this.field_22787.method_22683().method_4490();
            boolean bl = mouseButtonPressed = GLFW.glfwGetMouseButton((long)windowHandle, (int)0) == 1;
            if (mouseButtonPressed) {
                double distY;
                double distX;
                if (!this.isDragging && Math.sqrt((distX = (double)mouseX - this.dragStartX) * distX + (distY = (double)mouseY - this.dragStartY) * distY) > 3.0) {
                    this.isDragging = true;
                    this.preClickSelection.clear();
                }
                if (this.isDragging) {
                    int hoveredIndex;
                    listY = 68;
                    int listHeight = this.field_22790 - listY - 20;
                    int listRightEdge = this.field_22789 - 10 - 8 - 2;
                    this.dropTargetIndex = -1;
                    this.dropTargetBreadcrumb = null;
                    int breadcrumbY = 54;
                    if (mouseY >= breadcrumbY - 2 && mouseY < breadcrumbY + 12) {
                        for (BreadcrumbSegment segment : this.breadcrumbSegments) {
                            if (mouseX < segment.x || mouseX >= segment.x + segment.width) continue;
                            this.dropTargetBreadcrumb = segment.directory;
                            break;
                        }
                    }
                    if (this.dropTargetBreadcrumb == null && mouseX >= 10 && mouseX < listRightEdge && mouseY >= listY && mouseY < listY + listHeight && (hoveredIndex = this.scrollOffset + (mouseY - listY) / 25) >= 0 && hoveredIndex < this.entries.size()) {
                        FileEntry hoveredEntry = this.entries.get(hoveredIndex);
                        if (hoveredEntry.isDirectory && !this.selectedIndices.contains(hoveredIndex)) {
                            this.dropTargetIndex = hoveredIndex;
                        }
                    }
                }
            } else {
                if (this.isDragging) {
                    if (this.dropTargetBreadcrumb != null) {
                        this.performMove(this.dropTargetBreadcrumb);
                    } else if (this.dropTargetIndex != -1 && this.dropTargetIndex < this.entries.size()) {
                        FileEntry targetFolder = this.entries.get(this.dropTargetIndex);
                        this.performMove(targetFolder.file);
                    }
                } else if (!this.preClickSelection.isEmpty()) {
                    int singleItem = this.preClickSelection.getFirst();
                    this.selectedIndices.clear();
                    this.selectedIndices.add(singleItem);
                    this.lastClickedIndex = singleItem;
                    this.updateSelectionButtons();
                }
                this.isDragging = false;
                this.dragStartIndex = -1;
                this.dropTargetIndex = -1;
                this.dropTargetBreadcrumb = null;
                this.preClickSelection.clear();
            }
        }
        boolean popupActive = this.activePopup != null || this.confirmPopup != null;
        int renderMouseX = popupActive ? -1 : mouseX;
        int renderMouseY = popupActive ? -1 : mouseY;
        super.method_25394(context, renderMouseX, renderMouseY, delta);
        if (this.searchField != null && !popupActive) {
            this.searchField.method_25394(context, mouseX, mouseY, delta);
        }
        if (!this.isSearchActive) {
            this.renderBreadcrumb(context, mouseX, mouseY);
        } else {
            int breadcrumbY = 54;
            String searchInfo = "Found " + this.entries.size() + " result" + (this.entries.size() != 1 ? "s" : "") + " for \"" + this.searchQuery + "\"";
            context.method_25303(this.field_22793, searchInfo, 10, breadcrumbY, -5592321);
        }
        listY = 68;
        int listHeight = this.field_22790 - listY - 20;
        int maxVisibleItems = listHeight / 25 + 1;
        int listRightEdge = this.field_22789 - 10 - 8 - 2;
        context.method_25294(10, listY, listRightEdge, listY + listHeight, -15395563);
        context.method_44379(10, listY, listRightEdge, listY + listHeight);
        this.quickShareButtons.clear();
        for (int i = this.scrollOffset; i < Math.min(this.entries.size(), this.scrollOffset + maxVisibleItems); ++i) {
            int buttonBgColor;
            String buttonText;
            boolean isBeingDragged;
            FileEntry entry = this.entries.get(i);
            int itemY = listY + (i - this.scrollOffset) * 25;
            boolean isHovered = !popupActive && mouseX >= 10 && mouseX < listRightEdge && mouseY >= itemY && mouseY < itemY + 25;
            boolean isSelected = this.selectedIndices.contains(i);
            boolean isDropTarget = this.isDragging && entry.isDirectory && i == this.dropTargetIndex && !this.selectedIndices.contains(i);
            boolean bl = isBeingDragged = this.isDragging && this.selectedIndices.contains(i);
            int bgColor = isDropTarget ? -13408717 : (isBeingDragged ? -11513776 : (isSelected ? -12566464 : (isHovered ? -14013910 : -15066598)));
            context.method_25294(12, itemY + 2, listRightEdge - 2, itemY + 25 - 2, bgColor);
            String icon = entry.isDirectory ? "\ud83d\udcc1" : "\ud83d\udcc4";
            String fileName = entry.file.getName();
            int textX = 15;
            int textY = itemY + (this.isSearchActive && entry.relativePath != null && !entry.relativePath.isEmpty() ? 4 : 8);
            context.method_25303(this.field_22793, icon + " ", textX, textY, -1);
            textX += this.field_22793.method_1727(icon + " ");
            if (this.isSearchActive && !this.searchQuery.isEmpty()) {
                String lowerName = fileName.toLowerCase();
                int searchIndex = lowerName.indexOf(this.searchQuery);
                if (searchIndex >= 0) {
                    String beforeMatch = fileName.substring(0, searchIndex);
                    if (!beforeMatch.isEmpty()) {
                        context.method_25303(this.field_22793, beforeMatch, textX, textY, -1);
                        textX += this.field_22793.method_1727(beforeMatch);
                    }
                    String matchText = fileName.substring(searchIndex, searchIndex + this.searchQuery.length());
                    int matchWidth = this.field_22793.method_1727(matchText);
                    context.method_25294(textX - 1, textY - 1, textX + matchWidth + 1, textY + 9, -12285697);
                    context.method_25303(this.field_22793, matchText, textX, textY, -1);
                    textX += matchWidth;
                    String afterMatch = fileName.substring(searchIndex + this.searchQuery.length());
                    if (!afterMatch.isEmpty()) {
                        context.method_25303(this.field_22793, afterMatch, textX, textY, -1);
                        textX += this.field_22793.method_1727(afterMatch);
                    }
                } else {
                    context.method_25303(this.field_22793, fileName, textX, textY, -1);
                    textX += this.field_22793.method_1727(fileName);
                }
            } else {
                context.method_25303(this.field_22793, fileName, textX, textY, -1);
                textX += this.field_22793.method_1727(fileName);
            }
            if (!entry.isDirectory) {
                long sizeKB = entry.file.length() / 1024L;
                String sizeText = " (" + sizeKB + " KB)";
                context.method_25303(this.field_22793, sizeText, textX, textY, -5592406);
            }
            if (this.isSearchActive && entry.relativePath != null && !entry.relativePath.isEmpty()) {
                String pathDisplay = "\ud83d\udccd " + entry.relativePath;
                context.method_25303(this.field_22793, pathDisplay, 15 + this.field_22793.method_1727(icon + " "), itemY + 15, -7829368);
            }
            if (entry.isDirectory || !entry.file.getName().toLowerCase().endsWith(".litematic")) continue;
            int buttonWidth = 80;
            int buttonHeight = 16;
            int buttonX = listRightEdge - buttonWidth - 5;
            int buttonY = itemY + (25 - buttonHeight) / 2;
            this.quickShareButtons.add(new QuickShareButton(buttonX, buttonY, buttonWidth, buttonHeight, i));
            boolean buttonHovered = !popupActive && mouseX >= buttonX && mouseX < buttonX + buttonWidth && mouseY >= buttonY && mouseY < buttonY + buttonHeight;
            int buttonTextColor = -1;
            if (i == this.uploadingIndex) {
                buttonText = "Uploading...";
                buttonBgColor = -11184811;
            } else if (buttonHovered) {
                buttonText = "\ud83d\udce4 Share";
                buttonBgColor = -12285697;
            } else {
                buttonText = "\ud83d\udce4 Share";
                buttonBgColor = -13408564;
            }
            context.method_25294(buttonX, buttonY, buttonX + buttonWidth, buttonY + buttonHeight, buttonBgColor);
            int borderColor = buttonHovered ? -10048769 : -12290083;
            context.method_25294(buttonX, buttonY, buttonX + buttonWidth, buttonY + 1, borderColor);
            context.method_25294(buttonX, buttonY + buttonHeight - 1, buttonX + buttonWidth, buttonY + buttonHeight, borderColor);
            context.method_25294(buttonX, buttonY, buttonX + 1, buttonY + buttonHeight, borderColor);
            context.method_25294(buttonX + buttonWidth - 1, buttonY, buttonX + buttonWidth, buttonY + buttonHeight, borderColor);
            int btnTextWidth = this.field_22793.method_1727(buttonText);
            int btnTextX = buttonX + (buttonWidth - btnTextWidth) / 2;
            int btnTextY = buttonY + (buttonHeight - 8) / 2;
            context.method_25303(this.field_22793, buttonText, btnTextX, btnTextY, buttonTextColor);
        }
        context.method_44380();
        if (this.scrollBar != null && this.scrollBar.isVisible() && this.field_22787 != null && (scrollChanged = this.scrollBar.updateAndRender(context, mouseX, mouseY, delta, this.field_22787.method_22683().method_4490()))) {
            int maxScroll = Math.max(0, this.entries.size() - maxVisibleItems);
            this.scrollOffset = (int)(this.scrollBar.getScrollPercentage() * (double)maxScroll);
        }
        if (this.activePopup != null) {
            this.activePopup.method_25394(context, mouseX, mouseY, delta);
        }
        if (this.confirmPopup != null) {
            this.confirmPopup.method_25394(context, mouseX, mouseY, delta);
        }
        if (this.isDragging && !this.selectedIndices.isEmpty()) {
            String dragText = this.selectedIndices.size() + " item" + (this.selectedIndices.size() > 1 ? "s" : "");
            int textWidth = this.field_22793.method_1727(dragText);
            int cursorX = mouseX + 10;
            int cursorY = mouseY + 10;
            Objects.requireNonNull(this.field_22793);
            context.method_25294(cursorX - 2, cursorY - 2, cursorX + textWidth + 2, cursorY + 9 + 2, -872415232);
            context.method_25294(cursorX - 2, cursorY - 2, cursorX + textWidth + 2, cursorY - 1, -7829368);
            Objects.requireNonNull(this.field_22793);
            Objects.requireNonNull(this.field_22793);
            context.method_25294(cursorX - 2, cursorY + 9 + 1, cursorX + textWidth + 2, cursorY + 9 + 2, -7829368);
            Objects.requireNonNull(this.field_22793);
            context.method_25294(cursorX - 2, cursorY - 2, cursorX - 1, cursorY + 9 + 2, -7829368);
            Objects.requireNonNull(this.field_22793);
            context.method_25294(cursorX + textWidth + 1, cursorY - 2, cursorX + textWidth + 2, cursorY + 9 + 2, -7829368);
            context.method_51433(this.field_22793, dragText, cursorX, cursorY, -1, false);
        }
        if (this.toastManager != null) {
            this.toastManager.render(context, delta, mouseX, mouseY);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.confirmPopup != null) {
            this.confirmPopup.method_25402(mouseX, mouseY, button);
            return true;
        }
        if (this.activePopup != null) {
            this.activePopup.method_25402(mouseX, mouseY, button);
            return true;
        }
        if (button == 0 && this.toastManager != null) {
            if (this.toastManager.mouseClicked(mouseX, mouseY)) {
                return true;
            }
            if (this.toastManager.isMouseOverToast(mouseX, mouseY)) {
                return true;
            }
        }
        if (button == 0 && this.searchField != null) {
            if (this.searchField.method_25405(mouseX, mouseY)) {
                this.searchField.method_25365(true);
                return true;
            }
            this.searchField.method_25365(false);
        }
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        int breadcrumbY = 54;
        if (mouseY >= (double)(breadcrumbY - 2) && mouseY < (double)(breadcrumbY + 12)) {
            for (BreadcrumbSegment segment : this.breadcrumbSegments) {
                if (!(mouseX >= (double)segment.x) || !(mouseX < (double)(segment.x + segment.width))) continue;
                if (this.isSearchActive) {
                    this.searchQuery = "";
                    this.isSearchActive = false;
                    if (this.searchField != null) {
                        this.searchField.method_1852("");
                    }
                }
                this.currentDirectory = segment.directory;
                this.loadEntries();
                this.scrollOffset = 0;
                return true;
            }
        }
        int listY = 68;
        int listHeight = this.field_22790 - listY - 20;
        int listRightEdge = this.field_22789 - 10 - 8 - 2;
        if (mouseX >= 10.0 && mouseX < (double)listRightEdge && mouseY >= (double)listY && mouseY < (double)(listY + listHeight)) {
            for (QuickShareButton qsButton : this.quickShareButtons) {
                if (!qsButton.isHovered(mouseX, mouseY) || button != 0 || this.uploadingIndex != -1) continue;
                this.handleQuickShare(qsButton.entryIndex);
                return true;
            }
            int clickedIndex = this.scrollOffset + (int)((mouseY - (double)listY) / 25.0);
            if (clickedIndex >= 0 && clickedIndex < this.entries.size() && button == 0) {
                FileEntry entry = this.entries.get(clickedIndex);
                long windowHandle = this.field_22787 != null ? this.field_22787.method_22683().method_4490() : 0L;
                boolean shiftHeld = false;
                boolean ctrlHeld = false;
                if (windowHandle != 0L) {
                    shiftHeld = GLFW.glfwGetKey((long)windowHandle, (int)340) == 1 || GLFW.glfwGetKey((long)windowHandle, (int)344) == 1;
                    boolean bl = ctrlHeld = GLFW.glfwGetKey((long)windowHandle, (int)341) == 1 || GLFW.glfwGetKey((long)windowHandle, (int)345) == 1;
                }
                if (shiftHeld && this.lastClickedIndex != -1) {
                    this.selectedIndices.clear();
                    int start = Math.min(this.lastClickedIndex, clickedIndex);
                    int end = Math.max(this.lastClickedIndex, clickedIndex);
                    for (int i = start; i <= end; ++i) {
                        this.selectedIndices.add(i);
                    }
                } else if (ctrlHeld) {
                    if (this.selectedIndices.contains(clickedIndex)) {
                        this.selectedIndices.remove((Object)clickedIndex);
                    } else {
                        this.selectedIndices.add(clickedIndex);
                    }
                    this.lastClickedIndex = clickedIndex;
                } else if (this.selectedIndices.contains(clickedIndex) && this.selectedIndices.size() > 1) {
                    this.preClickSelection.clear();
                    this.preClickSelection.add(clickedIndex);
                    this.lastClickedIndex = clickedIndex;
                    this.dragStartIndex = clickedIndex;
                    this.dragStartX = mouseX;
                    this.dragStartY = mouseY;
                } else {
                    this.preClickSelection.clear();
                    this.selectedIndices.clear();
                    this.selectedIndices.add(clickedIndex);
                    this.lastClickedIndex = clickedIndex;
                    this.dragStartIndex = clickedIndex;
                    this.dragStartX = mouseX;
                    this.dragStartY = mouseY;
                }
                this.updateSelectionButtons();
                return true;
            }
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.confirmPopup != null && this.confirmPopup.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)) {
            return true;
        }
        if (this.activePopup != null) {
            return true;
        }
        int listY = 68;
        int listHeight = this.field_22790 - listY - 20;
        int contentHeight = this.entries.size() * 25;
        int maxScroll = contentHeight <= listHeight ? 0 : this.entries.size() - listHeight / 25;
        this.scrollOffset = Math.max(0, Math.min(maxScroll, this.scrollOffset - (int)verticalAmount));
        if (this.scrollBar != null && maxScroll > 0) {
            this.scrollBar.setScrollPercentage((double)this.scrollOffset / (double)maxScroll);
        }
        return true;
    }

    private void performUndo() {
        if (this.undoStack.isEmpty()) {
            if (this.toastManager != null) {
                this.toastManager.showInfo("Nothing to undo");
            }
            return;
        }
        FileAction action = this.undoStack.removeLast();
        boolean success = false;
        String actionName = "";
        switch (action.type.ordinal()) {
            case 0: {
                actionName = "move";
                success = this.undoMove(action);
                break;
            }
            case 1: {
                actionName = "delete";
                success = this.undoDelete(action);
                break;
            }
            case 2: {
                actionName = "rename";
                success = this.undoRename(action);
                break;
            }
            case 3: {
                actionName = "folder creation";
                success = this.undoCreateFolder(action);
            }
        }
        if (success) {
            this.redoStack.add(action);
            if (this.redoStack.size() > 50) {
                this.redoStack.removeFirst();
            }
            if (this.toastManager != null) {
                this.toastManager.showSuccess("Undid " + actionName);
            }
            this.loadEntries();
        } else if (this.toastManager != null) {
            this.toastManager.showError("Failed to undo " + actionName);
        }
    }

    private void performRedo() {
        if (this.redoStack.isEmpty()) {
            if (this.toastManager != null) {
                this.toastManager.showInfo("Nothing to redo");
            }
            return;
        }
        FileAction action = this.redoStack.removeLast();
        boolean success = false;
        String actionName = "";
        switch (action.type.ordinal()) {
            case 0: {
                actionName = "move";
                success = this.redoMove(action);
                break;
            }
            case 1: {
                actionName = "delete";
                success = this.redoDelete(action);
                break;
            }
            case 2: {
                actionName = "rename";
                success = this.redoRename(action);
                break;
            }
            case 3: {
                actionName = "folder creation";
                success = this.redoCreateFolder(action);
            }
        }
        if (success) {
            this.undoStack.add(action);
            if (this.undoStack.size() > 50) {
                this.undoStack.removeFirst();
            }
            if (this.toastManager != null) {
                this.toastManager.showSuccess("Redid " + actionName);
            }
            this.loadEntries();
        } else if (this.toastManager != null) {
            this.toastManager.showError("Failed to redo " + actionName);
        }
    }

    private boolean undoMove(FileAction action) {
        boolean allSuccess = true;
        for (FileOperation op : action.operations) {
            if (op.destination.exists()) {
                boolean success = op.destination.renameTo(op.source);
                if (success) continue;
                allSuccess = false;
                continue;
            }
            allSuccess = false;
        }
        return allSuccess;
    }

    private boolean redoMove(FileAction action) {
        boolean allSuccess = true;
        for (FileOperation op : action.operations) {
            if (op.source.exists()) {
                boolean success = op.source.renameTo(op.destination);
                if (success) continue;
                allSuccess = false;
                continue;
            }
            allSuccess = false;
        }
        return allSuccess;
    }

    private boolean undoDelete(FileAction action) {
        boolean allSuccess = true;
        for (FileOperation op : action.operations) {
            if (op.destination.exists()) {
                if (op.source.exists()) {
                    System.err.println("Cannot restore - file already exists at: " + op.source.getAbsolutePath());
                    allSuccess = false;
                    continue;
                }
                boolean success = op.destination.renameTo(op.source);
                if (!success) {
                    System.err.println("Failed to restore from trash: " + op.destination.getAbsolutePath());
                    allSuccess = false;
                    continue;
                }
                System.out.println("Restored from trash: " + op.source.getName());
                continue;
            }
            System.err.println("Trash file not found: " + op.destination.getAbsolutePath());
            allSuccess = false;
        }
        return allSuccess;
    }

    private boolean redoDelete(FileAction action) {
        boolean allSuccess = true;
        for (FileOperation op : action.operations) {
            if (op.source.exists()) {
                boolean success = op.source.renameTo(op.destination);
                if (!success) {
                    System.err.println("Failed to re-delete: " + op.source.getAbsolutePath());
                    allSuccess = false;
                    continue;
                }
                System.out.println("Re-deleted: " + op.source.getName());
                continue;
            }
            System.err.println("File not found for re-delete: " + op.source.getAbsolutePath());
            allSuccess = false;
        }
        return allSuccess;
    }

    private boolean undoRename(FileAction action) {
        if (action.operations.isEmpty()) {
            return false;
        }
        FileOperation op = action.operations.getFirst();
        if (op.destination.exists()) {
            return op.destination.renameTo(op.source);
        }
        return false;
    }

    private boolean redoRename(FileAction action) {
        if (action.operations.isEmpty()) {
            return false;
        }
        FileOperation op = action.operations.getFirst();
        if (op.source.exists()) {
            return op.source.renameTo(op.destination);
        }
        return false;
    }

    private boolean undoCreateFolder(FileAction action) {
        if (action.operations.isEmpty()) {
            return false;
        }
        FileOperation op = action.operations.getFirst();
        if (op.destination.exists() && op.destination.isDirectory()) {
            File[] contents = op.destination.listFiles();
            if (contents == null || contents.length == 0) {
                return op.destination.delete();
            }
            if (this.toastManager != null) {
                this.toastManager.showWarning("Cannot undo - folder is not empty");
            }
            return false;
        }
        return false;
    }

    private boolean redoCreateFolder(FileAction action) {
        if (action.operations.isEmpty()) {
            return false;
        }
        FileOperation op = action.operations.getFirst();
        if (!op.destination.exists()) {
            return op.destination.mkdir();
        }
        return false;
    }

    private void addUndoAction(FileAction action) {
        this.undoStack.add(action);
        if (this.undoStack.size() > 50) {
            FileAction removed = this.undoStack.removeFirst();
            if (removed.type == FileAction.Type.DELETE) {
                this.cleanupTrashFiles(removed);
            }
        }
        for (FileAction redoAction : this.redoStack) {
            if (redoAction.type != FileAction.Type.DELETE) continue;
            this.cleanupTrashFiles(redoAction);
        }
        this.redoStack.clear();
    }

    private void cleanupTrashFiles(FileAction action) {
        if (action.type != FileAction.Type.DELETE) {
            return;
        }
        for (FileOperation op : action.operations) {
            if (op.destination == null || !op.destination.exists()) continue;
            if (op.wasDirectory) {
                this.deleteDirectoryRecursively(op.destination);
            } else {
                op.destination.delete();
            }
            System.out.println("Permanently deleted from trash: " + op.destination.getName());
        }
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25419() {
        this.goBack();
    }

    @Environment(value=EnvType.CLIENT)
    private static class FileEntry {
        final File file;
        final boolean isDirectory;
        String relativePath;

        FileEntry(File file) {
            this.file = file;
            this.isDirectory = file.isDirectory();
            this.relativePath = null;
        }

        FileEntry(File file, String relativePath) {
            this.file = file;
            this.isDirectory = file.isDirectory();
            this.relativePath = relativePath;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class FileAction {
        final Type type;
        final List<FileOperation> operations;

        FileAction(Type type, List<FileOperation> operations) {
            this.type = type;
            this.operations = operations;
        }

        FileAction(Type type, FileOperation operation) {
            this.type = type;
            this.operations = new ArrayList<FileOperation>();
            this.operations.add(operation);
        }

        @Environment(value=EnvType.CLIENT)
        static enum Type {
            MOVE,
            DELETE,
            RENAME,
            CREATE_FOLDER;

        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class FileOperation {
        final File source;
        final File destination;
        final boolean wasDirectory;

        FileOperation(File source, File destination, boolean wasDirectory) {
            this.source = source;
            this.destination = destination;
            this.wasDirectory = wasDirectory;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class BreadcrumbSegment {
        final int x;
        final int width;
        final File directory;

        BreadcrumbSegment(int x, int width, File directory) {
            this.x = x;
            this.width = width;
            this.directory = directory;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class QuickShareButton {
        final int x;
        final int y;
        final int width;
        final int height;
        final int entryIndex;

        QuickShareButton(int x, int y, int width, int height, int entryIndex) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.entryIndex = entryIndex;
        }

        boolean isHovered(double mouseX, double mouseY) {
            return mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height);
        }
    }
}

