/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui.widget;

import com.choculaterie.config.DownloadSettings;
import com.choculaterie.gui.widget.CustomButton;
import com.choculaterie.gui.widget.CustomTextField;
import com.choculaterie.gui.widget.ScrollBar;
import com.choculaterie.gui.widget.ToggleButton;
import com.choculaterie.network.MinemevNetworkManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;

@Environment(value=EnvType.CLIENT)
public class SortFilterPanel
implements class_4068,
class_364 {
    private static final int PANEL_BG_COLOR = -14342875;
    private static final int TITLE_COLOR = -1;
    private static final int LABEL_COLOR = -5592406;
    private static final int SECTION_BG_COLOR = -12961222;
    private static final int PADDING = 10;
    private int x;
    private int y;
    private int width;
    private int height;
    private final class_310 client;
    private double scrollOffset = 0.0;
    private int contentHeight = 0;
    private ScrollBar scrollBar;
    private String selectedSort = "popular";
    private final String[] sortOptions = new String[]{"newest", "popular", "oldest", "downloads"};
    private final String[] sortLabels = new String[]{"Newest", "Popular", "Oldest", "Downloads"};
    private int itemsPerPage = 10;
    private final int[] pageOptions = new int[]{5, 10, 20, 50};
    private String[] availableVendors = new String[0];
    private Set<String> excludedVendors = new HashSet<String>();
    private boolean isLoadingVendors = false;
    private List<ToggleButton> vendorToggles = new ArrayList<ToggleButton>();
    private String versionFilter = "all";
    private String tagFilter = "";
    private Consumer<SortFilterPanel> onSettingsChanged;
    private CustomTextField tagTextField;
    private CustomButton applyButton;
    private CustomButton resetButton;

    public SortFilterPanel(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.client = class_310.method_1551();
        this.scrollBar = new ScrollBar(x + width - 10, y + 30, height - 60);
        this.loadSettings();
        this.tagTextField = new CustomTextField(this.client, x + 10, y + 100, width - 20 - 10, 18, (class_2561)class_2561.method_43473());
        this.tagTextField.method_47404((class_2561)class_2561.method_43470((String)"Enter tag..."));
        this.tagTextField.method_1852(this.tagFilter);
        this.initButtons();
        this.loadVendors();
    }

    private void loadSettings() {
        DownloadSettings settings = DownloadSettings.getInstance();
        this.selectedSort = settings.getSortOption();
        this.itemsPerPage = settings.getItemsPerPage();
        this.tagFilter = settings.getTagFilter();
        String savedExcluded = settings.getExcludedVendors();
        if (savedExcluded != null && !savedExcluded.isEmpty()) {
            this.excludedVendors.addAll(Arrays.asList(savedExcluded.split(",")));
        }
    }

    private void saveSettings() {
        DownloadSettings settings = DownloadSettings.getInstance();
        settings.setSortOption(this.selectedSort);
        settings.setItemsPerPage(this.itemsPerPage);
        settings.setTagFilter(this.tagFilter);
        settings.setExcludedVendors(String.join((CharSequence)",", this.excludedVendors));
    }

    private void initButtons() {
        int buttonY = this.y + this.height - 30;
        int buttonWidth = (this.width - 30) / 2;
        int buttonHeight = 20;
        this.applyButton = new CustomButton(this.x + 10, buttonY, buttonWidth, buttonHeight, (class_2561)class_2561.method_43470((String)(this.width < 150 ? "\u2713" : "Apply")), btn -> {});
        this.resetButton = new CustomButton(this.x + 20 + buttonWidth, buttonY, buttonWidth, buttonHeight, (class_2561)class_2561.method_43470((String)(this.width < 150 ? "\u21ba" : "Reset")), btn -> {});
    }

    public void setOnSettingsChanged(Consumer<SortFilterPanel> callback) {
        this.onSettingsChanged = callback;
    }

    public void setDimensions(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.scrollBar = new ScrollBar(x + width - 10, y + 30, height - 60);
        if (this.tagTextField != null) {
            this.tagTextField.method_48229(x + 10, y + 100);
            this.tagTextField.method_25358(width - 20 - 10);
        }
        this.initButtons();
        this.createVendorToggles();
    }

    private void loadVendors() {
        this.isLoadingVendors = true;
        ((CompletableFuture)MinemevNetworkManager.getVendors().thenAccept(vendors -> {
            if (this.client != null) {
                this.client.execute(() -> {
                    this.availableVendors = vendors;
                    this.isLoadingVendors = false;
                    this.createVendorToggles();
                });
            }
        })).exceptionally(throwable -> {
            if (this.client != null) {
                this.client.execute(() -> {
                    this.isLoadingVendors = false;
                    System.err.println("Failed to load vendors: " + throwable.getMessage());
                });
            }
            return null;
        });
    }

    private void createVendorToggles() {
        this.vendorToggles.clear();
        for (int i = 0; i < this.availableVendors.length; ++i) {
            String vendor = this.availableVendors[i];
            boolean isIncluded = !this.excludedVendors.contains(vendor);
            ToggleButton toggle = new ToggleButton(this.x + 10, 0, isIncluded, enabled -> {
                if (enabled.booleanValue()) {
                    this.excludedVendors.remove(vendor);
                } else {
                    this.excludedVendors.add(vendor);
                }
            });
            this.vendorToggles.add(toggle);
        }
    }

    public String getSelectedSort() {
        return this.selectedSort;
    }

    public int getItemsPerPage() {
        return this.itemsPerPage;
    }

    public String getExcludedVendorsParam() {
        if (this.excludedVendors.isEmpty()) {
            return null;
        }
        return String.join((CharSequence)",", this.excludedVendors);
    }

    public String getTagFilter() {
        return this.tagFilter.isEmpty() ? null : this.tagFilter;
    }

    public String getVersionFilter() {
        return this.versionFilter.equals("all") ? null : this.versionFilter;
    }

    private void notifySettingsChanged() {
        if (this.onSettingsChanged != null) {
            this.onSettingsChanged.accept(this);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25294(this.x, this.y, this.x + this.width, this.y + this.height, -14342875);
        context.method_25294(this.x, this.y, this.x + 1, this.y + this.height, -11184811);
        boolean isCompact = this.width < 180;
        String title = isCompact ? "Filters" : "Sort & Filter";
        context.method_25303(this.client.field_1772, title, this.x + 10, this.y + 10, -1);
        int contentStartY = this.y + 30;
        context.method_44379(this.x + 1, contentStartY, this.x + this.width - 12, this.y + this.height - 40);
        int currentY = contentStartY - (int)this.scrollOffset;
        this.contentHeight = 0;
        currentY = this.renderSortSection(context, mouseX, mouseY, currentY, isCompact);
        currentY = this.renderPaginationSection(context, mouseX, mouseY, currentY, isCompact);
        currentY = this.renderTagSection(context, mouseX, mouseY, currentY, isCompact);
        currentY = this.renderVendorSection(context, mouseX, mouseY, currentY, isCompact);
        context.method_44380();
        int visibleHeight = this.height - 70;
        this.scrollBar.setScrollData(this.contentHeight, visibleHeight);
        this.scrollBar.method_25394(context, mouseX, mouseY, delta);
        this.renderBottomButtons(context, mouseX, mouseY, delta);
    }

    private int renderSortSection(class_332 context, int mouseX, int mouseY, int currentY, boolean isCompact) {
        context.method_25303(this.client.field_1772, "Sort By:", this.x + 10, currentY, -5592406);
        currentY += 14;
        this.contentHeight += 14;
        int btnWidth = isCompact ? this.width - 20 - 10 : (this.width - 20 - 10) / 2;
        int btnHeight = 18;
        int col = 0;
        for (int i = 0; i < this.sortOptions.length; ++i) {
            boolean isHovered;
            int btnX = this.x + 10 + col * (btnWidth + 4);
            int btnY = currentY;
            boolean isSelected = this.sortOptions[i].equals(this.selectedSort);
            boolean bl = isHovered = mouseX >= btnX && mouseX < btnX + btnWidth && mouseY >= btnY && mouseY < btnY + btnHeight;
            int bgColor = isSelected ? -11896246 : (isHovered ? -11908534 : -12961222);
            context.method_25294(btnX, btnY, btnX + btnWidth, btnY + btnHeight, bgColor);
            context.method_25294(btnX, btnY, btnX + btnWidth, btnY + 1, -11184811);
            context.method_25294(btnX, btnY + btnHeight - 1, btnX + btnWidth, btnY + btnHeight, -11184811);
            context.method_25294(btnX, btnY, btnX + 1, btnY + btnHeight, -11184811);
            context.method_25294(btnX + btnWidth - 1, btnY, btnX + btnWidth, btnY + btnHeight, -11184811);
            String label = isCompact ? this.sortOptions[i].substring(0, Math.min(3, this.sortOptions[i].length())).toUpperCase() : this.sortLabels[i];
            int textWidth = this.client.field_1772.method_1727(label);
            context.method_25303(this.client.field_1772, label, btnX + (btnWidth - textWidth) / 2, btnY + 5, -1);
            if (++col < (isCompact ? 1 : 2)) continue;
            col = 0;
            currentY += btnHeight + 2;
            this.contentHeight += btnHeight + 2;
        }
        if (col != 0) {
            currentY += btnHeight + 2;
            this.contentHeight += btnHeight + 2;
        }
        this.contentHeight += 8;
        return currentY += 8;
    }

    private int renderPaginationSection(class_332 context, int mouseX, int mouseY, int currentY, boolean isCompact) {
        context.method_25303(this.client.field_1772, "Items per page:", this.x + 10, currentY, -5592406);
        currentY += 14;
        this.contentHeight += 14;
        int btnWidth = isCompact ? (this.width - 20 - 10) / 2 : (this.width - 20 - 10) / 4;
        int btnHeight = 18;
        for (int i = 0; i < this.pageOptions.length; ++i) {
            boolean isHovered;
            int btnX = this.x + 10 + i % (isCompact ? 2 : 4) * (btnWidth + 2);
            int btnY = currentY + i / (isCompact ? 2 : 4) * (btnHeight + 2);
            boolean isSelected = this.pageOptions[i] == this.itemsPerPage;
            boolean bl = isHovered = mouseX >= btnX && mouseX < btnX + btnWidth && mouseY >= btnY && mouseY < btnY + btnHeight;
            int bgColor = isSelected ? -11896246 : (isHovered ? -11908534 : -12961222);
            context.method_25294(btnX, btnY, btnX + btnWidth, btnY + btnHeight, bgColor);
            String label = String.valueOf(this.pageOptions[i]);
            int textWidth = this.client.field_1772.method_1727(label);
            context.method_25303(this.client.field_1772, label, btnX + (btnWidth - textWidth) / 2, btnY + 5, -1);
        }
        int rows = isCompact ? 2 : 1;
        this.contentHeight += rows * (btnHeight + 2) + 8;
        return currentY += rows * (btnHeight + 2) + 8;
    }

    private int renderTagSection(class_332 context, int mouseX, int mouseY, int currentY, boolean isCompact) {
        context.method_25303(this.client.field_1772, "Tag Filter:", this.x + 10, currentY, -5592406);
        currentY += 14;
        this.contentHeight += 14;
        if (this.tagTextField != null) {
            this.tagTextField.method_48229(this.x + 10, currentY);
            this.tagTextField.method_25358(this.width - 20 - 12);
            this.tagTextField.method_25394(context, mouseX, mouseY, 0.0f);
        }
        currentY += 22;
        this.contentHeight += 22;
        this.contentHeight += 8;
        return currentY += 8;
    }

    private int renderVendorSection(class_332 context, int mouseX, int mouseY, int currentY, boolean isCompact) {
        context.method_25303(this.client.field_1772, "Vendors:", this.x + 10, currentY, -5592406);
        currentY += 14;
        this.contentHeight += 14;
        if (this.isLoadingVendors) {
            context.method_25303(this.client.field_1772, "Loading...", this.x + 10, currentY, -5592406);
            currentY += 14;
            this.contentHeight += 14;
        } else if (this.availableVendors.length == 0) {
            context.method_25303(this.client.field_1772, "No vendors", this.x + 10, currentY, -5592406);
            currentY += 14;
            this.contentHeight += 14;
        } else {
            for (int i = 0; i < this.availableVendors.length && i < this.vendorToggles.size(); ++i) {
                String vendor = this.availableVendors[i];
                ToggleButton toggle = this.vendorToggles.get(i);
                toggle.method_46421(this.x + 10);
                toggle.method_46419(currentY);
                toggle.method_25394(context, mouseX, mouseY, 0.0f);
                context.method_25303(this.client.field_1772, vendor, this.x + 10 + 45, currentY + 6, -1);
                currentY += 24;
                this.contentHeight += 24;
            }
        }
        this.contentHeight += 8;
        return currentY += 8;
    }

    private void renderBottomButtons(class_332 context, int mouseX, int mouseY, float delta) {
        int buttonY = this.y + this.height - 30;
        int buttonWidth = (this.width - 30) / 2;
        if (this.applyButton != null) {
            this.applyButton.method_46421(this.x + 10);
            this.applyButton.method_46419(buttonY);
            this.applyButton.method_25358(buttonWidth);
            this.applyButton.method_25394(context, mouseX, mouseY, delta);
        }
        if (this.resetButton != null) {
            this.resetButton.method_46421(this.x + 20 + buttonWidth);
            this.resetButton.method_46419(buttonY);
            this.resetButton.method_25358(buttonWidth);
            this.resetButton.method_25394(context, mouseX, mouseY, delta);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return false;
        }
        if (mouseX < (double)this.x || mouseX >= (double)(this.x + this.width) || mouseY < (double)this.y || mouseY >= (double)(this.y + this.height)) {
            if (this.tagTextField != null) {
                this.tagTextField.method_25365(false);
            }
            return false;
        }
        if (this.applyButton != null && this.isOverButton(this.applyButton, mouseX, mouseY)) {
            this.tagFilter = this.tagTextField != null ? this.tagTextField.method_1882() : "";
            this.saveSettings();
            this.notifySettingsChanged();
            return true;
        }
        if (this.resetButton != null && this.isOverButton(this.resetButton, mouseX, mouseY)) {
            this.resetSettings();
            return true;
        }
        for (int i = 0; i < this.vendorToggles.size(); ++i) {
            ToggleButton toggle = this.vendorToggles.get(i);
            if (!(mouseX >= (double)toggle.method_46426()) || !(mouseX < (double)(toggle.method_46426() + toggle.method_25368())) || !(mouseY >= (double)toggle.method_46427()) || !(mouseY < (double)(toggle.method_46427() + toggle.method_25364()))) continue;
            String vendor = this.availableVendors[i];
            if (this.excludedVendors.contains(vendor)) {
                this.excludedVendors.remove(vendor);
                toggle.setToggled(true);
            } else {
                this.excludedVendors.add(vendor);
                toggle.setToggled(false);
            }
            return true;
        }
        if (this.scrollBar.mouseClicked(mouseX, mouseY, button)) {
            if (this.tagTextField != null) {
                this.tagTextField.method_25365(false);
            }
            return true;
        }
        if (this.tagTextField != null && this.tagTextField.method_25405(mouseX, mouseY)) {
            this.tagTextField.method_25365(true);
            return true;
        }
        if (this.tagTextField != null) {
            this.tagTextField.method_25365(false);
        }
        int currentY = this.y + 30 + 14 - (int)this.scrollOffset;
        boolean isCompact = this.width < 180;
        int btnWidth = isCompact ? this.width - 20 - 10 : (this.width - 20 - 10) / 2;
        int btnHeight = 18;
        for (int i = 0; i < this.sortOptions.length; ++i) {
            int col = isCompact ? 0 : i % 2;
            int row = isCompact ? i : i / 2;
            int btnX = this.x + 10 + col * (btnWidth + 4);
            int btnY = currentY + row * (btnHeight + 2);
            if (!(mouseX >= (double)btnX) || !(mouseX < (double)(btnX + btnWidth)) || !(mouseY >= (double)btnY) || !(mouseY < (double)(btnY + btnHeight))) continue;
            this.selectedSort = this.sortOptions[i];
            return true;
        }
        int sortRows = isCompact ? this.sortOptions.length : (int)Math.ceil((double)this.sortOptions.length / 2.0);
        currentY += sortRows * (btnHeight + 2) + 8 + 14;
        int pageBtnWidth = isCompact ? (this.width - 20 - 10) / 2 : (this.width - 20 - 10) / 4;
        for (int i = 0; i < this.pageOptions.length; ++i) {
            int col = i % (isCompact ? 2 : 4);
            int row = i / (isCompact ? 2 : 4);
            int btnX = this.x + 10 + col * (pageBtnWidth + 2);
            int btnY = currentY + row * (btnHeight + 2);
            if (!(mouseX >= (double)btnX) || !(mouseX < (double)(btnX + pageBtnWidth)) || !(mouseY >= (double)btnY) || !(mouseY < (double)(btnY + btnHeight))) continue;
            this.itemsPerPage = this.pageOptions[i];
            return true;
        }
        return false;
    }

    private boolean isOverButton(CustomButton button, double mouseX, double mouseY) {
        return mouseX >= (double)button.method_46426() && mouseX < (double)(button.method_46426() + button.method_25368()) && mouseY >= (double)button.method_46427() && mouseY < (double)(button.method_46427() + button.method_25364());
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height)) {
            this.scrollOffset = Math.max(0.0, Math.min(this.scrollOffset - verticalAmount * 10.0, (double)Math.max(0, this.contentHeight - (this.height - 70))));
            this.scrollBar.setScrollPercentage((float)(this.scrollOffset / (double)Math.max(1, this.contentHeight - (this.height - 70))));
            return true;
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.scrollBar.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
            this.scrollOffset = this.scrollBar.getScrollPercentage() * (double)Math.max(0, this.contentHeight - (this.height - 70));
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.scrollBar.mouseReleased(mouseX, mouseY, button);
        return false;
    }

    private void resetSettings() {
        this.selectedSort = "newest";
        this.itemsPerPage = 20;
        this.excludedVendors.clear();
        this.tagFilter = "";
        this.versionFilter = "all";
        if (this.tagTextField != null) {
            this.tagTextField.method_1852("");
        }
        for (ToggleButton toggle : this.vendorToggles) {
            toggle.setToggled(true);
        }
        this.scrollOffset = 0.0;
        this.saveSettings();
    }

    public void method_25365(boolean focused) {
        if (this.tagTextField != null && !focused) {
            this.tagTextField.method_25365(false);
        }
    }

    public boolean method_25370() {
        return this.tagTextField != null && this.tagTextField.method_25370();
    }
}

