/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui;

import com.choculaterie.config.DownloadSettings;
import com.choculaterie.gui.DirectoryPickerScreen;
import com.choculaterie.gui.widget.CustomButton;
import com.choculaterie.gui.widget.CustomTextField;
import com.choculaterie.gui.widget.ToastManager;
import com.choculaterie.gui.widget.ToggleButton;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class SettingsPage
extends class_437 {
    private static final int PADDING = 10;
    private static final int BUTTON_HEIGHT = 20;
    private static final int LABEL_HEIGHT = 20;
    private static final int TEXT_FIELD_HEIGHT = 20;
    private final class_437 parentScreen;
    private CustomButton backButton;
    private CustomTextField downloadPathField;
    private CustomButton browseButton;
    private CustomButton setPathButton;
    private ToggleButton successToastsToggle;
    private ToggleButton errorToastsToggle;
    private ToggleButton infoToastsToggle;
    private ToggleButton warningToastsToggle;
    private ToastManager toastManager;
    private String pendingToastMessage;
    private boolean pendingToastSuccess;

    public SettingsPage(class_437 parentScreen) {
        super((class_2561)class_2561.method_43470((String)"Settings"));
        this.parentScreen = parentScreen;
    }

    protected void method_25426() {
        boolean isVeryCompact;
        super.method_25426();
        if (this.field_22787 != null) {
            this.toastManager = new ToastManager(this.field_22787);
        }
        boolean isCompact = this.field_22789 < 400;
        boolean bl = isVeryCompact = this.field_22789 < 300;
        int browseButtonWidth = isVeryCompact ? 50 : (isCompact ? 70 : 90);
        String browseLabel = isVeryCompact ? "..." : "Browse...";
        this.backButton = new CustomButton(10, 10, 20, 20, (class_2561)class_2561.method_43470((String)"\u2190"), button -> this.goBack());
        this.method_37063((class_364)this.backButton);
        int contentY = 60;
        int setButtonSize = 20;
        int setButtonX = this.field_22789 - 20 - setButtonSize;
        int browseButtonX = setButtonX - 10 - browseButtonWidth;
        int fieldWidth = Math.max(100, browseButtonX - 30);
        if (this.field_22787 != null) {
            this.downloadPathField = new CustomTextField(this.field_22787, 20, contentY + 20, fieldWidth, 20, (class_2561)class_2561.method_43470((String)"Download Path"));
            this.downloadPathField.method_1852(DownloadSettings.getInstance().getDownloadPath());
            this.downloadPathField.method_47404((class_2561)class_2561.method_43470((String)"Enter download path..."));
        }
        this.browseButton = new CustomButton(browseButtonX, contentY + 20, browseButtonWidth, 20, (class_2561)class_2561.method_43470((String)browseLabel), button -> this.openFileDialog());
        this.method_37063((class_364)this.browseButton);
        this.setPathButton = new CustomButton(setButtonX, contentY + 20, setButtonSize, setButtonSize, (class_2561)class_2561.method_43470((String)"\u2713"), button -> this.saveDownloadPath());
        this.setPathButton.field_22764 = false;
        this.method_37063((class_364)this.setPathButton);
        int toastsY = contentY + 20 + 20 + 30;
        int toggleSpacing = 25;
        this.infoToastsToggle = new ToggleButton(140, toastsY + 20, DownloadSettings.getInstance().isInfoToastsEnabled(), enabled -> DownloadSettings.getInstance().setInfoToastsEnabled((boolean)enabled));
        this.method_37063((class_364)this.infoToastsToggle);
        this.successToastsToggle = new ToggleButton(140, toastsY + 20 + toggleSpacing, DownloadSettings.getInstance().isSuccessToastsEnabled(), enabled -> DownloadSettings.getInstance().setSuccessToastsEnabled((boolean)enabled));
        this.method_37063((class_364)this.successToastsToggle);
        this.warningToastsToggle = new ToggleButton(140, toastsY + 20 + toggleSpacing * 2, DownloadSettings.getInstance().isWarningToastsEnabled(), enabled -> DownloadSettings.getInstance().setWarningToastsEnabled((boolean)enabled));
        this.method_37063((class_364)this.warningToastsToggle);
        this.errorToastsToggle = new ToggleButton(140, toastsY + 20 + toggleSpacing * 3, DownloadSettings.getInstance().isErrorToastsEnabled(), enabled -> DownloadSettings.getInstance().setErrorToastsEnabled((boolean)enabled));
        this.method_37063((class_364)this.errorToastsToggle);
    }

    private void goBack() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parentScreen);
        }
    }

    private void openFileDialog() {
        if (this.field_22787 != null) {
            String startPath = DownloadSettings.getInstance().getAbsoluteDownloadPath();
            DirectoryPickerScreen picker = new DirectoryPickerScreen(this, startPath, selectedPath -> {
                if (this.downloadPathField != null) {
                    this.downloadPathField.method_1852((String)selectedPath);
                }
                if (selectedPath != null && !selectedPath.isEmpty()) {
                    DownloadSettings.getInstance().setDownloadPath((String)selectedPath);
                    System.out.println("Download path saved from directory picker: " + selectedPath);
                    this.pendingToastMessage = "Download path updated!";
                    this.pendingToastSuccess = true;
                } else {
                    this.pendingToastMessage = "Failed to select folder";
                    this.pendingToastSuccess = false;
                }
            });
            this.field_22787.method_1507((class_437)picker);
        }
    }

    private void saveDownloadPath() {
        String newPath;
        if (this.downloadPathField != null && (newPath = this.downloadPathField.method_1882()) != null && !newPath.isEmpty()) {
            DownloadSettings.getInstance().setDownloadPath(newPath);
            System.out.println("Download path saved: " + newPath);
            if (this.toastManager != null) {
                this.toastManager.showSuccess("Download path saved!");
            }
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.pendingToastMessage != null && this.toastManager != null) {
            if (this.pendingToastSuccess) {
                this.toastManager.showSuccess(this.pendingToastMessage);
            } else {
                this.toastManager.showError(this.pendingToastMessage);
            }
            this.pendingToastMessage = null;
        }
        context.method_25294(0, 0, this.field_22789, this.field_22790, -14671840);
        super.method_25394(context, mouseX, mouseY, delta);
        String title = "Settings";
        int titleWidth = this.field_22793.method_1727(title);
        context.method_25303(this.field_22793, title, (this.field_22789 - titleWidth) / 2, 40, -1);
        int contentY = 60;
        context.method_25303(this.field_22793, "Download Path (relative to game folder):", 20, contentY, -1);
        if (this.downloadPathField != null) {
            boolean pathChanged;
            this.downloadPathField.method_25394(context, mouseX, mouseY, delta);
            String currentText = this.downloadPathField.method_1882();
            String savedPath = DownloadSettings.getInstance().getDownloadPath();
            boolean bl = pathChanged = !currentText.equals(savedPath);
            if (this.setPathButton != null) {
                this.setPathButton.field_22764 = pathChanged;
            }
        }
        String absolutePath = DownloadSettings.getInstance().getAbsoluteDownloadPath();
        String previewText = "Full path: " + absolutePath;
        context.method_25303(this.field_22793, previewText, 20, contentY + 20 + 20 + 5, -5592406);
        int toastsY = contentY + 20 + 20 + 30;
        int toggleSpacing = 25;
        context.method_25303(this.field_22793, "Show Notifications:", 20, toastsY, -1);
        context.method_25303(this.field_22793, "Info:", 20, toastsY + 20 + 6, -14575885);
        context.method_25303(this.field_22793, "Success:", 20, toastsY + 20 + toggleSpacing + 6, -11751600);
        context.method_25303(this.field_22793, "Warning:", 20, toastsY + 20 + toggleSpacing * 2 + 6, -16121);
        context.method_25303(this.field_22793, "Error:", 20, toastsY + 20 + toggleSpacing * 3 + 6, -44462);
        if (this.toastManager != null) {
            this.toastManager.render(context, delta, mouseX, mouseY);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 && this.downloadPathField != null) {
            if (this.downloadPathField.method_25405(mouseX, mouseY)) {
                this.downloadPathField.method_25365(true);
                return true;
            }
            this.downloadPathField.method_25365(false);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25419() {
        this.goBack();
    }
}

