/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.widget;

import com.choculaterie.widget.CustomButton;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class Toast {
    private static final int TOAST_WIDTH = 250;
    private static final int TOAST_HEIGHT = 40;
    private static final int TOAST_HEIGHT_WITH_BUTTON = 60;
    private static final int PADDING = 10;
    private static final long SLIDE_DURATION = 300L;
    private static final long DISPLAY_DURATION = 3000L;
    private static final long ERROR_DISPLAY_DURATION = 8000L;
    private static final long FADE_DURATION = 500L;
    private final String message;
    private final Type type;
    private final long createdTime;
    private final int screenWidth;
    private int yPosition;
    private int targetYPosition;
    private long lastYPositionChange;
    private final boolean hasCopyButton;
    private final String copyText;
    private CustomButton copyButton;
    private CustomButton closeButton;
    private boolean dismissed = false;
    private boolean hovered = false;
    private long pausedTime = 0L;
    private long hoverStartTime = 0L;
    private static double mouseX = 0.0;
    private static double mouseY = 0.0;

    public Toast(String message, Type type, int screenWidth, int yPosition) {
        this(message, type, screenWidth, yPosition, false, null);
    }

    public Toast(String message, Type type, int screenWidth, int yPosition, boolean hasCopyButton, String copyText) {
        this.message = message;
        this.type = type;
        this.screenWidth = screenWidth;
        this.yPosition = yPosition;
        this.targetYPosition = yPosition;
        this.lastYPositionChange = this.createdTime = System.currentTimeMillis();
        this.hasCopyButton = hasCopyButton;
        this.copyText = copyText != null ? copyText : message;
        this.closeButton = new CustomButton(0, 0, 16, 16, class_2561.method_30163((String)"\u00d7"), btn -> {});
        if (hasCopyButton) {
            this.copyButton = new CustomButton(0, 0, 50, 18, class_2561.method_30163((String)"Copy"), btn -> {});
        }
    }

    public void setTargetYPosition(int targetY) {
        if (this.targetYPosition != targetY) {
            this.targetYPosition = targetY;
            this.lastYPositionChange = System.currentTimeMillis();
        }
    }

    public boolean render(class_332 context, class_327 textRenderer) {
        long displayDuration;
        long now = System.currentTimeMillis();
        long totalPausedTime = this.pausedTime;
        if (this.hovered && this.hoverStartTime > 0L) {
            totalPausedTime += now - this.hoverStartTime;
        }
        long elapsed = now - this.createdTime - totalPausedTime;
        long l = displayDuration = this.hasCopyButton ? 8000L : 3000L;
        if (this.dismissed || elapsed > 300L + displayDuration + 500L) {
            return true;
        }
        if (this.yPosition != this.targetYPosition) {
            long yTransitionElapsed = now - this.lastYPositionChange;
            float yTransitionProgress = Math.min(1.0f, (float)yTransitionElapsed / 400.0f);
            yTransitionProgress = (float)(1.0 - Math.pow(1.0f - yTransitionProgress, 3.0));
            this.yPosition = (int)((float)this.yPosition + (float)(this.targetYPosition - this.yPosition) * yTransitionProgress);
            if (Math.abs(this.yPosition - this.targetYPosition) < 1) {
                this.yPosition = this.targetYPosition;
            }
        }
        float slideProgress = Math.min(1.0f, (float)elapsed / 300.0f);
        float fadeProgress = 1.0f;
        if (elapsed > 300L + displayDuration) {
            long fadeElapsed = elapsed - 300L - displayDuration;
            fadeProgress = 1.0f - (float)fadeElapsed / 500.0f;
        }
        slideProgress = 1.0f - (float)Math.pow(1.0f - slideProgress, 3.0);
        int targetX = this.screenWidth - 250 - 10;
        int startX = this.screenWidth + 250;
        int currentX = (int)((float)startX + (float)(targetX - startX) * slideProgress);
        int toastHeight = this.hasCopyButton ? 60 : 40;
        int alpha = (int)(255.0f * fadeProgress);
        if (alpha <= 0) {
            return true;
        }
        int bgColorWithAlpha = alpha << 24 | 0x2A2A2A;
        context.method_25294(currentX, this.yPosition, currentX + 250, this.yPosition + toastHeight, bgColorWithAlpha);
        int borderColorWithAlpha = alpha << 24 | this.type.color & 0xFFFFFF;
        context.method_25294(currentX, this.yPosition, currentX + 4, this.yPosition + toastHeight, borderColorWithAlpha);
        int topBorderColorWithAlpha = alpha << 24 | 0x444444;
        context.method_25294(currentX, this.yPosition, currentX + 250, this.yPosition + 1, topBorderColorWithAlpha);
        context.method_25294(currentX, this.yPosition + toastHeight - 1, currentX + 250, this.yPosition + toastHeight, topBorderColorWithAlpha);
        context.method_25294(currentX + 250 - 1, this.yPosition, currentX + 250, this.yPosition + toastHeight, topBorderColorWithAlpha);
        String icon = switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "\u2713";
            case 1 -> "\u2717";
            case 3 -> "\u26a0";
            case 2 -> "\u2139";
        };
        int iconColorWithAlpha = alpha << 24 | this.type.color & 0xFFFFFF;
        context.method_51433(textRenderer, icon, currentX + 12, this.yPosition + 8, iconColorWithAlpha, false);
        int textX = currentX + 28;
        int textY = this.yPosition + 8;
        int maxTextWidth = 210;
        Object displayText = this.message;
        int textWidth = textRenderer.method_1727((String)displayText);
        if (textWidth > maxTextWidth) {
            while (textWidth > maxTextWidth - 10 && ((String)displayText).length() > 3) {
                displayText = ((String)displayText).substring(0, ((String)displayText).length() - 1);
                textWidth = textRenderer.method_1727((String)displayText + "...");
            }
            displayText = (String)displayText + "...";
        }
        int textColorWithAlpha = alpha << 24 | 0xFFFFFF;
        context.method_51433(textRenderer, (String)displayText, textX, textY, textColorWithAlpha, false);
        if (this.closeButton != null) {
            int closeButtonX = currentX + 250 - 16 - 4;
            int closeButtonY = this.yPosition + 4;
            this.closeButton.method_46421(closeButtonX);
            this.closeButton.method_46419(closeButtonY);
            this.closeButton.method_25358(16);
            this.closeButton.method_53533(16);
            this.closeButton.method_25394(context, (int)mouseX, (int)mouseY, 0.0f);
        }
        if (this.hasCopyButton && this.copyButton != null) {
            int buttonX = currentX + 250 - 50 - 8;
            int buttonY = this.yPosition + toastHeight - 18 - 6;
            this.copyButton.method_46421(buttonX);
            this.copyButton.method_46419(buttonY);
            this.copyButton.method_25358(50);
            this.copyButton.method_53533(18);
            this.copyButton.method_25394(context, (int)mouseX, (int)mouseY, 0.0f);
        }
        return false;
    }

    public boolean isHovering(double mouseX, double mouseY) {
        long displayDuration;
        long now = System.currentTimeMillis();
        long totalPausedTime = this.pausedTime;
        if (this.hovered && this.hoverStartTime > 0L) {
            totalPausedTime += now - this.hoverStartTime;
        }
        long elapsed = now - this.createdTime - totalPausedTime;
        long l = displayDuration = this.hasCopyButton ? 8000L : 3000L;
        if (this.dismissed || elapsed > 300L + displayDuration) {
            return false;
        }
        float slideProgress = Math.min(1.0f, (float)elapsed / 300.0f);
        slideProgress = 1.0f - (float)Math.pow(1.0f - slideProgress, 3.0);
        int targetX = this.screenWidth - 250 - 10;
        int startX = this.screenWidth + 250;
        int currentX = (int)((float)startX + (float)(targetX - startX) * slideProgress);
        int toastHeight = this.hasCopyButton ? 60 : 40;
        return mouseX >= (double)currentX && mouseX < (double)(currentX + 250) && mouseY >= (double)this.yPosition && mouseY < (double)(this.yPosition + toastHeight);
    }

    public boolean isCloseButtonClicked(double mouseX, double mouseY) {
        if (this.closeButton == null) {
            return false;
        }
        return mouseX >= (double)this.closeButton.method_46426() && mouseX < (double)(this.closeButton.method_46426() + this.closeButton.method_25368()) && mouseY >= (double)this.closeButton.method_46427() && mouseY < (double)(this.closeButton.method_46427() + this.closeButton.method_25364());
    }

    public static void updateMousePosition(double x, double y) {
        mouseX = x;
        mouseY = y;
    }

    public void dismiss() {
        this.dismissed = true;
    }

    public void setHovered(boolean hovered) {
        if (hovered && !this.hovered) {
            this.hoverStartTime = System.currentTimeMillis();
        } else if (!hovered && this.hovered) {
            this.pausedTime += System.currentTimeMillis() - this.hoverStartTime;
        }
        this.hovered = hovered;
    }

    public boolean isHovered() {
        return this.hovered;
    }

    public int getHeight() {
        return (this.hasCopyButton ? 60 : 40) + 5;
    }

    public boolean isCopyButtonClicked(double mouseX, double mouseY) {
        if (!this.hasCopyButton || this.copyButton == null) {
            return false;
        }
        return mouseX >= (double)this.copyButton.method_46426() && mouseX < (double)(this.copyButton.method_46426() + this.copyButton.method_25368()) && mouseY >= (double)this.copyButton.method_46427() && mouseY < (double)(this.copyButton.method_46427() + this.copyButton.method_25364());
    }

    public String getCopyText() {
        return this.copyText;
    }

    @Environment(value=EnvType.CLIENT)
    public static enum Type {
        SUCCESS(-12255420),
        ERROR(-48060),
        INFO(-12285697),
        WARNING(-21948);

        final int color;

        private Type(int color) {
            this.color = color;
        }
    }
}

