/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.widget;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_332;
import net.minecraft.class_4068;
import org.lwjgl.glfw.GLFW;

@Environment(value=EnvType.CLIENT)
public class ScrollBar
implements class_4068 {
    private static final int SCROLLBAR_WIDTH = 6;
    private static final int SCROLLBAR_COLOR = -11184811;
    private static final int SCROLLBAR_HANDLE_COLOR = -7829368;
    private static final int SCROLLBAR_HANDLE_HOVER_COLOR = -5592406;
    private final int x;
    private final int y;
    private final int height;
    private double scrollPercentage = 0.0;
    private double contentHeight = 0.0;
    private double visibleHeight = 0.0;
    private boolean isDragging = false;
    private double dragStartY = 0.0;
    private double dragStartScroll = 0.0;
    private boolean isHovered = false;
    private boolean wasMouseDown = false;

    public ScrollBar(int x, int y, int height) {
        this.x = x;
        this.y = y;
        this.height = height;
    }

    public void setScrollData(double contentHeight, double visibleHeight) {
        this.contentHeight = contentHeight;
        this.visibleHeight = visibleHeight;
    }

    public void setScrollPercentage(double percentage) {
        this.scrollPercentage = Math.max(0.0, Math.min(1.0, percentage));
    }

    public double getScrollPercentage() {
        return this.scrollPercentage;
    }

    public boolean isVisible() {
        return this.contentHeight > this.visibleHeight;
    }

    public boolean isDragging() {
        return this.isDragging;
    }

    public boolean updateAndRender(class_332 context, int mouseX, int mouseY, float delta, long windowHandle) {
        double deltaYMouse;
        double deltaScroll;
        double newPercentage;
        if (!this.isVisible()) {
            return false;
        }
        boolean isMouseDown = GLFW.glfwGetMouseButton((long)windowHandle, (int)0) == 1;
        double handleHeight = Math.max(20.0, this.visibleHeight / this.contentHeight * (double)this.height);
        double maxHandleY = (double)this.height - handleHeight;
        double handleY = (double)this.y + this.scrollPercentage * maxHandleY;
        this.isHovered = mouseX >= this.x && mouseX < this.x + 6 && (double)mouseY >= handleY && (double)mouseY < handleY + handleHeight;
        boolean isOverTrack = mouseX >= this.x && mouseX < this.x + 6 && mouseY >= this.y && mouseY < this.y + this.height;
        boolean scrollChanged = false;
        if (isMouseDown && !this.wasMouseDown) {
            if (this.isHovered) {
                this.isDragging = true;
                this.dragStartY = mouseY;
                this.dragStartScroll = this.scrollPercentage;
            } else if (isOverTrack) {
                double clickPositionInTrack = (double)(mouseY - this.y) - handleHeight / 2.0;
                double newPercentage2 = Math.max(0.0, Math.min(1.0, clickPositionInTrack / maxHandleY));
                if (newPercentage2 != this.scrollPercentage) {
                    this.scrollPercentage = newPercentage2;
                    scrollChanged = true;
                }
                this.isDragging = true;
                this.dragStartY = mouseY;
                this.dragStartScroll = this.scrollPercentage;
            }
        }
        if (this.isDragging && isMouseDown && (newPercentage = Math.max(0.0, Math.min(1.0, this.dragStartScroll + (deltaScroll = (deltaYMouse = (double)mouseY - this.dragStartY) / maxHandleY)))) != this.scrollPercentage) {
            this.scrollPercentage = newPercentage;
            scrollChanged = true;
        }
        if (!isMouseDown && this.isDragging) {
            this.isDragging = false;
        }
        this.wasMouseDown = isMouseDown;
        context.method_25294(this.x, this.y, this.x + 6, this.y + this.height, -11184811);
        handleY = (double)this.y + this.scrollPercentage * maxHandleY;
        int handleColor = this.isHovered || this.isDragging ? -5592406 : -7829368;
        context.method_25294(this.x, (int)handleY, this.x + 6, (int)(handleY + handleHeight), handleColor);
        return scrollChanged;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (!this.isVisible()) {
            return;
        }
        context.method_25294(this.x, this.y, this.x + 6, this.y + this.height, -11184811);
        double handleHeight = Math.max(20.0, this.visibleHeight / this.contentHeight * (double)this.height);
        double maxHandleY = (double)this.height - handleHeight;
        double handleY = (double)this.y + this.scrollPercentage * maxHandleY;
        this.isHovered = mouseX >= this.x && mouseX < this.x + 6 && (double)mouseY >= handleY && (double)mouseY < handleY + handleHeight;
        int handleColor = this.isHovered || this.isDragging ? -5592406 : -7829368;
        context.method_25294(this.x, (int)handleY, this.x + 6, (int)(handleY + handleHeight), handleColor);
    }

    public int getWidth() {
        return 6;
    }
}

