/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.mixin.client;

import com.choculaterie.integration.LitematicaIntegration;
import com.choculaterie.util.QuickShareClickTracker;
import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import fi.dy.masa.malilib.gui.widgets.WidgetDirectoryEntry;
import fi.dy.masa.malilib.gui.widgets.WidgetFileBrowserBase;
import java.io.File;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={WidgetDirectoryEntry.class}, remap=false)
public abstract class MixinWidgetDirectoryEntry
extends WidgetBase {
    @Shadow
    @Final
    protected WidgetFileBrowserBase.DirectoryEntry entry;
    @Unique
    private static final int BUTTON_WIDTH = 80;
    @Unique
    private int lastMouseX = 0;
    @Unique
    private int lastMouseY = 0;
    @Unique
    private int originalWidth = 0;

    protected MixinWidgetDirectoryEntry(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    @Unique
    private boolean isLitematicFile() {
        String name;
        File dir = this.entry.getDirectory();
        File file = new File(dir, name = this.entry.getDisplayName());
        return file.isFile() && name.toLowerCase().endsWith(".litematic");
    }

    @Unique
    private File getEntryFile() {
        return new File(this.entry.getDirectory(), this.entry.getDisplayName());
    }

    @Unique
    private boolean isMouseOverButton(int mouseX, int mouseY) {
        if (!this.isLitematicFile()) {
            return false;
        }
        int buttonX = this.getX() + this.originalWidth - 80;
        return mouseX >= buttonX && mouseX < buttonX + 80 && mouseY >= this.getY() && mouseY < this.getY() + this.getHeight();
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void beforeRender(int mouseX, int mouseY, boolean isActiveGui, class_332 graphics, CallbackInfo ci) {
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        this.originalWidth = this.getWidth();
        if (this.isLitematicFile()) {
            this.setWidth(this.originalWidth - 80);
        }
    }

    @ModifyVariable(method={"render"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true, name={"mouseX"})
    private int modifyMouseX(int mouseX) {
        return this.isMouseOverButton(mouseX, this.lastMouseY) ? -1 : mouseX;
    }

    @ModifyVariable(method={"render"}, at=@At(value="HEAD"), ordinal=1, argsOnly=true, name={"mouseY"})
    private int modifyMouseY(int mouseY) {
        return this.isMouseOverButton(this.lastMouseX, mouseY) ? -1 : mouseY;
    }

    @Unique
    private void drawColoredRect(class_332 graphics, int x, int y, int width, int height, int color) {
        int alpha = color >> 24 & 0xFF;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        int argbColor = alpha << 24 | red << 16 | green << 8 | blue;
        graphics.method_25296(x, y, x + width, y + height, argbColor, argbColor);
    }

    @Inject(method={"render"}, at={@At(value="RETURN")})
    private void afterRender(int mouseX, int mouseY, boolean isActiveGui, class_332 graphics, CallbackInfo ci) {
        String text;
        int borderColor;
        int bgColor;
        boolean isHovered;
        if (this.isLitematicFile()) {
            this.setWidth(this.originalWidth);
        }
        int actualMouseX = this.lastMouseX;
        int actualMouseY = this.lastMouseY;
        File file = this.getEntryFile();
        if (!file.isFile() || !file.getName().toLowerCase().endsWith(".litematic")) {
            QuickShareClickTracker.clearButtonBounds(this.entry);
            return;
        }
        LitematicaIntegration.UploadState state = LitematicaIntegration.getUploadState(file);
        if (state.showCopied && System.currentTimeMillis() - state.copiedTimestamp > 2000L) {
            state.showCopied = false;
        }
        int buttonHeight = this.getHeight();
        int buttonX = this.getX() + this.originalWidth - 80;
        int buttonY = this.getY();
        QuickShareClickTracker.updateButtonBounds(this.entry, buttonX, buttonY, 80, buttonHeight);
        boolean bl = isHovered = actualMouseX >= buttonX && actualMouseX < buttonX + 80 && actualMouseY >= buttonY && actualMouseY < buttonY + buttonHeight;
        if (state.isUploading) {
            bgColor = -11184811;
            borderColor = -11184811;
            text = "Uploading...";
        } else if (state.showCopied) {
            bgColor = -12277180;
            borderColor = -12290083;
            text = "\u2713 Copied";
        } else if (isHovered) {
            bgColor = -12285697;
            borderColor = -10048769;
            text = "\ud83d\udce4 Share";
        } else {
            bgColor = -13408564;
            borderColor = -12290083;
            text = "\ud83d\udce4 Share";
        }
        this.drawColoredRect(graphics, buttonX, buttonY, 80, buttonHeight, bgColor);
        this.drawColoredRect(graphics, buttonX, buttonY, 80, 1, borderColor);
        this.drawColoredRect(graphics, buttonX, buttonY + buttonHeight - 1, 80, 1, borderColor);
        this.drawColoredRect(graphics, buttonX, buttonY, 1, buttonHeight, borderColor);
        this.drawColoredRect(graphics, buttonX + 80 - 1, buttonY, 1, buttonHeight, borderColor);
        class_327 font = class_310.method_1551().field_1772;
        int textWidth = font.method_1727(text);
        int textX = buttonX + (80 - textWidth) / 2;
        int textY = buttonY + (buttonHeight - 8) / 2;
        graphics.method_51433(font, text, textX, textY, -1, true);
    }

    @Intrinsic(displace=true)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return this.handleButtonClick(mouseX, mouseY);
    }

    @Intrinsic(displace=true)
    public boolean onMouseClicked(int mouseX, int mouseY, int button) {
        return this.handleButtonClick(mouseX, mouseY);
    }

    @Unique
    private boolean handleButtonClick(double mouseX, double mouseY) {
        File file = this.getEntryFile();
        if (file.isFile() && file.getName().toLowerCase().endsWith(".litematic")) {
            boolean isInButton;
            int buttonX = this.getX() + this.originalWidth - 80;
            int buttonY = this.getY();
            int buttonRight = buttonX + 80;
            int buttonBottom = buttonY + this.getHeight();
            boolean bl = isInButton = mouseX >= (double)buttonX && mouseX < (double)buttonRight && mouseY >= (double)buttonY && mouseY < (double)buttonBottom;
            if (isInButton) {
                QuickShareClickTracker.markPreventSelection();
                LitematicaIntegration.shareLitematicFile(file);
                return true;
            }
        }
        return false;
    }
}

