/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.integration;

import com.choculaterie.QuickShareAddonClient;
import com.choculaterie.network.QuickShareNetwork;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class LitematicaIntegration {
    private static final Map<String, UploadState> uploadStates = new HashMap<String, UploadState>();

    public static UploadState getUploadState(File file) {
        return uploadStates.computeIfAbsent(file.getAbsolutePath(), k -> new UploadState());
    }

    public static void shareLitematicFile(File litematicFile) {
        class_310 mc = class_310.method_1551();
        UploadState state = LitematicaIntegration.getUploadState(litematicFile);
        if (state.isUploading) {
            return;
        }
        state.isUploading = true;
        state.showCopied = false;
        ((CompletableFuture)QuickShareNetwork.uploadLitematic(litematicFile).thenAccept(response -> mc.execute(() -> {
            mc.field_1774.method_1455(response.getShortUrl());
            state.isUploading = false;
            state.showCopied = true;
            state.copiedTimestamp = System.currentTimeMillis();
        }))).exceptionally(error -> {
            mc.execute(() -> {
                state.isUploading = false;
                QuickShareAddonClient.LOGGER.error("Quick-Share upload failed", error);
            });
            return null;
        });
    }

    @Environment(value=EnvType.CLIENT)
    public static class UploadState {
        public boolean isUploading = false;
        public boolean showCopied = false;
        public long copiedTimestamp = 0L;
    }
}

