/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.network;

import com.choculaterie.models.QuickShareResponse;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class QuickShareNetwork {
    private static final String BASE_URL = "https://choculaterie.com/api/LitematicDownloaderModAPI";
    private static final Gson GSON = new Gson();
    private static final int TIMEOUT = 30000;
    private static final String BOUNDARY = "----WebKitFormBoundary" + System.currentTimeMillis();

    public static CompletableFuture<QuickShareResponse> uploadLitematic(File file) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                if (file == null || !file.exists()) {
                    throw new IllegalArgumentException("File does not exist");
                }
                if (!file.getName().toLowerCase().endsWith(".litematic")) {
                    throw new IllegalArgumentException("Only .litematic files allowed");
                }
                byte[] fileBytes = Files.readAllBytes(file.toPath());
                String json = QuickShareNetwork.uploadMultipartFile(file.getName(), fileBytes);
                JsonObject root = (JsonObject)GSON.fromJson(json, JsonObject.class);
                if (!root.has("shortUrl")) {
                    throw new RuntimeException("Response missing shortUrl");
                }
                return new QuickShareResponse(root.get("shortUrl").getAsString());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to upload litematic file", e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String uploadMultipartFile(String fileName, byte[] fileBytes) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL("https://choculaterie.com/api/LitematicDownloaderModAPI/upload").openConnection();
        try {
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setConnectTimeout(30000);
            conn.setReadTimeout(30000);
            conn.setRequestProperty("User-Agent", "Quick-Share-Addon/1.0");
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
            try (DataOutputStream out = new DataOutputStream(conn.getOutputStream());){
                out.writeBytes("--" + BOUNDARY + "\r\n");
                out.writeBytes("Content-Disposition: form-data; name=\"file\"; filename=\"" + fileName + "\"\r\n");
                out.writeBytes("Content-Type: application/octet-stream\r\n\r\n");
                out.write(fileBytes);
                out.writeBytes("\r\n--" + BOUNDARY + "--\r\n");
            }
            int code = conn.getResponseCode();
            InputStream is = code >= 200 && code < 300 ? conn.getInputStream() : conn.getErrorStream();
            StringBuilder sb = new StringBuilder();
            if (is != null) {
                try (BufferedReader r = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                    String line;
                    while ((line = r.readLine()) != null) {
                        sb.append(line);
                    }
                }
            }
            if (code != 200) {
                throw new IOException("HTTP " + code + ": " + String.valueOf(sb));
            }
            String string = sb.toString();
            return string;
        }
        finally {
            conn.disconnect();
        }
    }
}

