/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.mixin.client;

import com.choculaterie.integration.LitematicaIntegration;
import com.choculaterie.util.QuickShareClickTracker;
import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import fi.dy.masa.malilib.gui.widgets.WidgetDirectoryEntry;
import fi.dy.masa.malilib.gui.widgets.WidgetFileBrowserBase;
import java.io.File;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11909;
import net.minecraft.class_332;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={WidgetDirectoryEntry.class}, remap=false)
public abstract class MixinWidgetDirectoryEntry
extends WidgetBase {
    @Shadow
    @Final
    protected WidgetFileBrowserBase.DirectoryEntry entry;
    @Unique
    private static final int BUTTON_WIDTH = 80;
    @Unique
    private int lastMouseX = 0;
    @Unique
    private int lastMouseY = 0;
    @Unique
    private int originalWidth = 0;

    protected MixinWidgetDirectoryEntry(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    @Unique
    private boolean isLitematicFile() {
        File file = this.entry.getFullPath().toFile();
        return file.isFile() && file.getName().toLowerCase().endsWith(".litematic");
    }

    @Unique
    private boolean isMouseOverButton(int mouseX, int mouseY) {
        if (!this.isLitematicFile()) {
            return false;
        }
        int buttonX = this.getX() + this.originalWidth - 80;
        return mouseX >= buttonX && mouseX < buttonX + 80 && mouseY >= this.getY() && mouseY < this.getY() + this.getHeight();
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void beforeRender(class_332 graphics, int mouseX, int mouseY, boolean isActiveGui, CallbackInfo ci) {
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        this.originalWidth = this.getWidth();
        if (this.isLitematicFile()) {
            this.setWidth(this.originalWidth - 80);
        }
    }

    @ModifyVariable(method={"render"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true, name={"mouseX"})
    private int modifyMouseX(int mouseX) {
        return this.isMouseOverButton(mouseX, this.lastMouseY) ? -1 : mouseX;
    }

    @ModifyVariable(method={"render"}, at=@At(value="HEAD"), ordinal=1, argsOnly=true, name={"mouseY"})
    private int modifyMouseY(int mouseY) {
        return this.isMouseOverButton(this.lastMouseX, mouseY) ? -1 : mouseY;
    }

    @Unique
    private void drawColoredRect(class_332 graphics, int x, int y, int width, int height, int color) {
        int alpha = color >> 24 & 0xFF;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        int argbColor = alpha << 24 | red << 16 | green << 8 | blue;
        graphics.method_25296(x, y, x + width, y + height, argbColor, argbColor);
    }

    @Inject(method={"render"}, at={@At(value="RETURN")})
    private void afterRender(class_332 graphics, int mouseX, int mouseY, boolean isActiveGui, CallbackInfo ci) {
        String text;
        int borderColor;
        int bgColor;
        boolean isHovered;
        if (this.isLitematicFile()) {
            this.setWidth(this.originalWidth);
        }
        int actualMouseX = this.lastMouseX;
        int actualMouseY = this.lastMouseY;
        File file = this.entry.getFullPath().toFile();
        if (!file.isFile() || !file.getName().toLowerCase().endsWith(".litematic")) {
            QuickShareClickTracker.clearButtonBounds(this.entry);
            return;
        }
        LitematicaIntegration.UploadState state = LitematicaIntegration.getUploadState(file);
        if (state.showCopied && System.currentTimeMillis() - state.copiedTimestamp > 2000L) {
            state.showCopied = false;
        }
        int buttonHeight = this.getHeight();
        int buttonX = this.getX() + this.originalWidth - 80;
        int buttonY = this.getY();
        QuickShareClickTracker.updateButtonBounds(this.entry, buttonX, buttonY, 80, buttonHeight);
        boolean bl = isHovered = actualMouseX >= buttonX && actualMouseX < buttonX + 80 && actualMouseY >= buttonY && actualMouseY < buttonY + buttonHeight;
        if (state.isUploading) {
            bgColor = -11184811;
            borderColor = -11184811;
            text = "Uploading...";
        } else if (state.showCopied) {
            bgColor = -12277180;
            borderColor = -12290083;
            text = "\u2713 Copied";
        } else if (isHovered) {
            bgColor = -12285697;
            borderColor = -10048769;
            text = "\ud83d\udce4 Share";
        } else {
            bgColor = -13408564;
            borderColor = -12290083;
            text = "\ud83d\udce4 Share";
        }
        this.drawColoredRect(graphics, buttonX, buttonY, 80, buttonHeight, bgColor);
        this.drawColoredRect(graphics, buttonX, buttonY, 80, 1, borderColor);
        this.drawColoredRect(graphics, buttonX, buttonY + buttonHeight - 1, 80, 1, borderColor);
        this.drawColoredRect(graphics, buttonX, buttonY, 1, buttonHeight, borderColor);
        this.drawColoredRect(graphics, buttonX + 80 - 1, buttonY, 1, buttonHeight, borderColor);
        int textWidth = this.getStringWidth(text);
        int textX = buttonX + (80 - textWidth) / 2;
        int textY = buttonY + (buttonHeight - 8) / 2;
        this.drawStringWithShadow(graphics, textX, textY, -1, text);
    }

    @Inject(method={"onMouseClickedImpl"}, at={@At(value="HEAD")}, cancellable=true)
    private void onQuickShareButtonClick(class_11909 click, boolean doubleClick, CallbackInfoReturnable<Boolean> cir) {
        boolean isInButton;
        File file = this.entry.getFullPath().toFile();
        if (!file.isFile() || !file.getName().toLowerCase().endsWith(".litematic")) {
            return;
        }
        int buttonX = this.getX() + this.originalWidth - 80;
        int buttonY = this.getY();
        int buttonRight = buttonX + 80;
        int buttonBottom = buttonY + this.getHeight();
        int clickX = (int)click.comp_4798();
        int clickY = (int)click.comp_4799();
        boolean bl = isInButton = clickX >= buttonX && clickX < buttonRight && clickY >= buttonY && clickY < buttonBottom;
        if (isInButton) {
            QuickShareClickTracker.markPreventSelection();
            LitematicaIntegration.shareLitematicFile(file);
            cir.setReturnValue((Object)false);
        }
    }
}

