/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui.widget;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import org.lwjgl.glfw.GLFW;

@Environment(value=EnvType.CLIENT)
public class CustomTextField
extends class_342 {
    private static final int FIELD_BG_COLOR = -14013910;
    private static final int FIELD_BORDER_COLOR = -11184811;
    private static final int FIELD_BORDER_FOCUSED_COLOR = -7829368;
    private static final int CLEAR_BUTTON_SIZE = 12;
    private static final int CLEAR_BUTTON_COLOR = -7829368;
    private static final int CLEAR_BUTTON_HOVER_COLOR = -5592406;
    private final class_310 client;
    private Runnable onEnterPressed;
    private Runnable onChanged;
    private boolean wasEnterDown = false;
    private boolean wasClearButtonMouseDown = false;
    private class_2561 placeholderText;
    private Runnable onClearPressed;
    private static CustomTextField activeField = null;
    private static boolean callbackInstalled = false;
    private static long installedWindowHandle = 0L;
    private boolean wasBackspacePressed = false;
    private boolean wasDeletePressed = false;
    private boolean wasLeftPressed = false;
    private boolean wasRightPressed = false;
    private boolean wasHomePressed = false;
    private boolean wasEndPressed = false;
    private long backspaceHoldStart = 0L;
    private long deleteHoldStart = 0L;
    private long lastBackspaceRepeat = 0L;
    private long lastDeleteRepeat = 0L;
    private long leftHoldStart = 0L;
    private long rightHoldStart = 0L;
    private long lastLeftRepeat = 0L;
    private long lastRightRepeat = 0L;

    public CustomTextField(class_310 client, int x, int y, int width, int height, class_2561 text) {
        super(client.field_1772, x, y, width, height, text);
        this.client = client;
        this.method_1880(256);
        this.method_1858(false);
        this.method_1856(true);
    }

    public void method_1867(String text) {
    }

    public void setOnEnterPressed(Runnable callback) {
        this.onEnterPressed = callback;
    }

    public void setOnChanged(Runnable callback) {
        this.onChanged = callback;
    }

    public void setOnClearPressed(Runnable callback) {
        this.onClearPressed = callback;
    }

    public void method_25365(boolean focused) {
        super.method_25365(focused);
        if (focused) {
            activeField = this;
            this.installCharCallback();
        } else if (activeField == this) {
            activeField = null;
        }
    }

    private void installCharCallback() {
        long windowHandle;
        long l = windowHandle = this.client.method_22683() != null ? this.client.method_22683().method_4490() : 0L;
        if (!(windowHandle == 0L || callbackInstalled && installedWindowHandle == windowHandle)) {
            GLFW.glfwSetCharCallback((long)windowHandle, (window, codepoint) -> {
                if (activeField != null && activeField.method_25370()) {
                    activeField.onCharTyped((char)codepoint);
                }
            });
            callbackInstalled = true;
            installedWindowHandle = windowHandle;
        }
    }

    private void onCharTyped(char c) {
        if (c == '\r' || c == '\n' || c < ' ') {
            return;
        }
        String currentText = this.method_1882();
        int cursorPos = this.method_1881();
        if (currentText.length() < this.getMaxLength()) {
            String newText = currentText.substring(0, cursorPos) + c + currentText.substring(cursorPos);
            this.method_1852(newText);
            this.method_1883(cursorPos + 1, false);
            if (this.onChanged != null) {
                this.onChanged.run();
            }
        }
    }

    private int getMaxLength() {
        return 256;
    }

    public void method_47404(class_2561 placeholder) {
        super.method_47404(placeholder);
        this.placeholderText = placeholder;
    }

    private boolean isOverClearButton(int mouseX, int mouseY) {
        if (this.method_1882().isEmpty()) {
            return false;
        }
        int clearX = this.method_46426() + this.method_25368() - 12 - 4;
        int clearY = this.method_46427() + (this.method_25364() - 12) / 2;
        return mouseX >= clearX && mouseX < clearX + 12 && mouseY >= clearY && mouseY < clearY + 12;
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        long windowHandle;
        long l = windowHandle = this.client.method_22683() != null ? this.client.method_22683().method_4490() : 0L;
        if (windowHandle != 0L) {
            boolean isMouseDown;
            boolean bl = isMouseDown = GLFW.glfwGetMouseButton((long)windowHandle, (int)0) == 1;
            if (!this.method_1882().isEmpty() && isMouseDown && !this.wasClearButtonMouseDown && this.isOverClearButton(mouseX, mouseY)) {
                this.method_1852("");
                if (this.onChanged != null) {
                    this.onChanged.run();
                }
                if (this.onClearPressed != null) {
                    this.onClearPressed.run();
                }
            }
            this.wasClearButtonMouseDown = isMouseDown;
        } else {
            this.wasClearButtonMouseDown = false;
        }
        if (windowHandle != 0L) {
            boolean isEnterDown;
            boolean bl = isEnterDown = GLFW.glfwGetKey((long)windowHandle, (int)257) == 1 || GLFW.glfwGetKey((long)windowHandle, (int)335) == 1;
            if (this.method_25370() && this.onEnterPressed != null && isEnterDown && !this.wasEnterDown) {
                this.wasEnterDown = true;
                this.onEnterPressed.run();
            } else if (!isEnterDown) {
                this.wasEnterDown = false;
            }
        }
        if (windowHandle != 0L && this.method_25370()) {
            this.handleSpecialKeys(windowHandle);
        }
        context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), -14013910);
        int borderColor = this.method_25370() ? -7829368 : -11184811;
        context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + 1, borderColor);
        context.method_25294(this.method_46426(), this.method_46427() + this.method_25364() - 1, this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), borderColor);
        context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + 1, this.method_46427() + this.method_25364(), borderColor);
        context.method_25294(this.method_46426() + this.method_25368() - 1, this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), borderColor);
        int textY = this.method_46427() + (this.method_25364() - 8) / 2;
        int textX = this.method_46426() + 4;
        int maxTextWidth = this.method_25368() - 8 - (this.method_1882().isEmpty() ? 0 : 16);
        String text = this.method_1882();
        if (text.isEmpty() && !this.method_25370()) {
            if (this.placeholderText != null) {
                context.method_27535(this.client.field_1772, this.placeholderText, textX, textY, -7829368);
            }
        } else {
            int color = this.method_25370() ? -1 : -2039584;
            int cursorPos = this.method_1881();
            String beforeCursor = text.substring(0, Math.min(cursorPos, text.length()));
            context.method_44379(textX, this.method_46427(), textX + maxTextWidth, this.method_46427() + this.method_25364());
            context.method_25303(this.client.field_1772, text, textX, textY, color);
            context.method_44380();
            if (this.method_25370() && this.method_20315()) {
                int cursorX = textX + this.client.field_1772.method_1727(beforeCursor);
                if (System.currentTimeMillis() / 500L % 2L == 0L) {
                    context.method_25294(cursorX, textY - 1, cursorX + 1, textY + 9, -1);
                }
            }
        }
        if (!this.method_1882().isEmpty()) {
            int clearX = this.method_46426() + this.method_25368() - 12 - 4;
            int clearY = this.method_46427() + (this.method_25364() - 12) / 2;
            boolean isHovered = this.isOverClearButton(mouseX, mouseY);
            int clearColor = isHovered ? -5592406 : -7829368;
            String xSymbol = "\u2715";
            int xWidth = this.client.field_1772.method_1727(xSymbol);
            int xX = clearX + (12 - xWidth) / 2;
            int xY = clearY + 2;
            context.method_25303(this.client.field_1772, xSymbol, xX, xY, clearColor);
        }
    }

    private void handleSpecialKeys(long windowHandle) {
        boolean isEscapeDown;
        boolean isEndDown;
        boolean isHomeDown;
        boolean isRightDown;
        boolean isLeftDown;
        boolean isDeleteDown;
        boolean isBackspaceDown;
        long currentTime = System.currentTimeMillis();
        long initialDelay = 400L;
        long repeatDelay = 50L;
        Object currentText = this.method_1882();
        int cursorPos = this.method_1881();
        boolean bl = isBackspaceDown = GLFW.glfwGetKey((long)windowHandle, (int)259) == 1;
        if (isBackspaceDown) {
            boolean shouldDelete = false;
            if (!this.wasBackspacePressed) {
                shouldDelete = true;
                this.backspaceHoldStart = currentTime;
                this.lastBackspaceRepeat = currentTime;
            } else if (currentTime - this.backspaceHoldStart > initialDelay && currentTime - this.lastBackspaceRepeat > repeatDelay) {
                shouldDelete = true;
                this.lastBackspaceRepeat = currentTime;
            }
            if (shouldDelete && cursorPos > 0) {
                String newText = ((String)currentText).substring(0, cursorPos - 1) + ((String)currentText).substring(cursorPos);
                this.method_1852(newText);
                this.method_1883(cursorPos - 1, false);
                currentText = newText;
                --cursorPos;
                if (this.onChanged != null) {
                    this.onChanged.run();
                }
            }
        }
        this.wasBackspacePressed = isBackspaceDown;
        boolean bl2 = isDeleteDown = GLFW.glfwGetKey((long)windowHandle, (int)261) == 1;
        if (isDeleteDown) {
            boolean shouldDelete = false;
            if (!this.wasDeletePressed) {
                shouldDelete = true;
                this.deleteHoldStart = currentTime;
                this.lastDeleteRepeat = currentTime;
            } else if (currentTime - this.deleteHoldStart > initialDelay && currentTime - this.lastDeleteRepeat > repeatDelay) {
                shouldDelete = true;
                this.lastDeleteRepeat = currentTime;
            }
            if (shouldDelete && cursorPos < ((String)currentText).length()) {
                String newText = ((String)currentText).substring(0, cursorPos) + ((String)currentText).substring(cursorPos + 1);
                this.method_1852(newText);
                currentText = newText;
                if (this.onChanged != null) {
                    this.onChanged.run();
                }
            }
        }
        this.wasDeletePressed = isDeleteDown;
        boolean bl3 = isLeftDown = GLFW.glfwGetKey((long)windowHandle, (int)263) == 1;
        if (isLeftDown) {
            boolean shouldMove = false;
            if (!this.wasLeftPressed) {
                shouldMove = true;
                this.leftHoldStart = currentTime;
                this.lastLeftRepeat = currentTime;
            } else if (currentTime - this.leftHoldStart > initialDelay && currentTime - this.lastLeftRepeat > repeatDelay) {
                shouldMove = true;
                this.lastLeftRepeat = currentTime;
            }
            if (shouldMove && cursorPos > 0) {
                this.method_1883(cursorPos - 1, false);
            }
        }
        this.wasLeftPressed = isLeftDown;
        boolean bl4 = isRightDown = GLFW.glfwGetKey((long)windowHandle, (int)262) == 1;
        if (isRightDown) {
            boolean shouldMove = false;
            if (!this.wasRightPressed) {
                shouldMove = true;
                this.rightHoldStart = currentTime;
                this.lastRightRepeat = currentTime;
            } else if (currentTime - this.rightHoldStart > initialDelay && currentTime - this.lastRightRepeat > repeatDelay) {
                shouldMove = true;
                this.lastRightRepeat = currentTime;
            }
            if (shouldMove && cursorPos < ((String)currentText).length()) {
                this.method_1883(cursorPos + 1, false);
            }
        }
        this.wasRightPressed = isRightDown;
        boolean bl5 = isHomeDown = GLFW.glfwGetKey((long)windowHandle, (int)268) == 1;
        if (isHomeDown && !this.wasHomePressed) {
            this.method_1883(0, false);
        }
        this.wasHomePressed = isHomeDown;
        boolean bl6 = isEndDown = GLFW.glfwGetKey((long)windowHandle, (int)269) == 1;
        if (isEndDown && !this.wasEndPressed) {
            this.method_1883(((String)currentText).length(), false);
        }
        this.wasEndPressed = isEndDown;
        boolean bl7 = isEscapeDown = GLFW.glfwGetKey((long)windowHandle, (int)256) == 1;
        if (isEscapeDown) {
            this.method_25365(false);
        }
    }
}

