/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui.widget;

import com.choculaterie.gui.widget.CustomButton;
import com.choculaterie.gui.widget.CustomTextField;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import org.lwjgl.glfw.GLFW;

@Environment(value=EnvType.CLIENT)
public class TextInputPopup
implements class_4068,
class_364 {
    private static final int POPUP_WIDTH = 300;
    private static final int POPUP_HEIGHT = 120;
    private static final int PADDING = 10;
    private static final int BUTTON_HEIGHT = 20;
    private final class_437 parent;
    private final String title;
    private final Consumer<String> onConfirm;
    private final Runnable onCancel;
    private final String confirmButtonText;
    private CustomTextField textField;
    private CustomButton confirmButton;
    private CustomButton cancelButton;
    private String errorMessage = "";
    private boolean wasEscapePressed = false;
    private final int x;
    private final int y;

    public TextInputPopup(class_437 parent, String title, Consumer<String> onConfirm, Runnable onCancel) {
        this(parent, title, "Create", onConfirm, onCancel);
    }

    public TextInputPopup(class_437 parent, String title, String confirmButtonText, Consumer<String> onConfirm, Runnable onCancel) {
        this.parent = parent;
        this.title = title;
        this.confirmButtonText = confirmButtonText;
        this.onConfirm = onConfirm;
        this.onCancel = onCancel;
        class_310 client = class_310.method_1551();
        this.x = (client.method_22683().method_4486() - 300) / 2;
        this.y = (client.method_22683().method_4502() - 120) / 2;
        this.initWidgets();
    }

    private void initWidgets() {
        class_310 client = class_310.method_1551();
        int fieldY = this.y + 30;
        this.textField = new CustomTextField(client, this.x + 10, fieldY, 280, 20, class_2561.method_30163((String)""));
        this.textField.method_47404(class_2561.method_30163((String)"Enter name..."));
        this.textField.method_25365(true);
        this.textField.setOnChanged(() -> {
            this.errorMessage = "";
        });
        this.textField.setOnEnterPressed(this::handleConfirm);
        int buttonY = this.y + 120 - 10 - 20;
        int buttonWidth = 135;
        this.cancelButton = new CustomButton(this.x + 10, buttonY, buttonWidth, 20, class_2561.method_30163((String)"Cancel"), button -> this.onCancel.run());
        this.confirmButton = new CustomButton(this.x + 20 + buttonWidth, buttonY, buttonWidth, 20, class_2561.method_30163((String)this.confirmButtonText), button -> this.handleConfirm());
    }

    public void setErrorMessage(String error) {
        this.errorMessage = error;
    }

    public void setText(String text) {
        if (this.textField != null) {
            this.textField.method_1852(text);
        }
    }

    private List<String> wrapText(String text, int maxWidth, class_310 client) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            Object testLine = currentLine.length() == 0 ? word : String.valueOf(currentLine) + " " + word;
            int width = client.field_1772.method_1727((String)testLine);
            if (width <= maxWidth) {
                if (currentLine.length() > 0) {
                    currentLine.append(" ");
                }
                currentLine.append(word);
                continue;
            }
            if (currentLine.length() > 0) {
                lines.add(currentLine.toString());
            }
            currentLine = new StringBuilder(word);
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines.isEmpty() ? List.of(text) : lines;
    }

    private void handleConfirm() {
        String text = this.textField.method_1882().trim();
        if (text.isEmpty()) {
            this.setErrorMessage("Folder name cannot be empty");
            return;
        }
        if (text.contains("/") || text.contains("\\") || text.contains(":") || text.contains("*") || text.contains("?") || text.contains("\"") || text.contains("<") || text.contains(">") || text.contains("|")) {
            this.setErrorMessage("Invalid characters in folder name");
            return;
        }
        String upperText = text.toUpperCase();
        if (upperText.equals("CON") || upperText.equals("PRN") || upperText.equals("AUX") || upperText.equals("NUL") || upperText.matches("COM[0-9]") || upperText.matches("LPT[0-9]")) {
            this.setErrorMessage("Reserved folder name");
            return;
        }
        this.onConfirm.accept(text);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        long windowHandle;
        class_310 client = class_310.method_1551();
        long l = windowHandle = client.method_22683() != null ? client.method_22683().method_4490() : 0L;
        if (windowHandle != 0L) {
            boolean escapePressed;
            boolean bl = escapePressed = GLFW.glfwGetKey((long)windowHandle, (int)256) == 1;
            if (escapePressed && !this.wasEscapePressed) {
                this.onCancel.run();
            }
            this.wasEscapePressed = escapePressed;
        }
        context.method_25294(0, 0, client.method_22683().method_4486(), client.method_22683().method_4502(), Integer.MIN_VALUE);
        context.method_25294(this.x, this.y, this.x + 300, this.y + 120, -14013910);
        context.method_25294(this.x, this.y, this.x + 300, this.y + 1, -11184811);
        context.method_25294(this.x, this.y + 120 - 1, this.x + 300, this.y + 120, -11184811);
        context.method_25294(this.x, this.y, this.x + 1, this.y + 120, -11184811);
        context.method_25294(this.x + 300 - 1, this.y, this.x + 300, this.y + 120, -11184811);
        context.method_25300(client.field_1772, this.title, this.x + 150, this.y + 10, -1);
        if (this.textField != null) {
            if (!this.textField.method_25370()) {
                this.textField.method_25365(true);
            }
            this.textField.method_25394(context, mouseX, mouseY, delta);
        }
        if (!this.errorMessage.isEmpty()) {
            List<String> wrappedError = this.wrapText(this.errorMessage, 280, client);
            int errorY = this.y + 30 + 25;
            for (String line : wrappedError) {
                context.method_25300(client.field_1772, line, this.x + 150, errorY, -43691);
                errorY += 10;
            }
        }
        if (this.cancelButton != null) {
            this.cancelButton.method_25394(context, mouseX, mouseY, delta);
        }
        if (this.confirmButton != null) {
            this.confirmButton.method_25394(context, mouseX, mouseY, delta);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (mouseX < (double)this.x || mouseX > (double)(this.x + 300) || mouseY < (double)this.y || mouseY > (double)(this.y + 120)) {
            this.onCancel.run();
            return true;
        }
        if (this.textField != null) {
            boolean isOverTextField;
            boolean bl = isOverTextField = mouseX >= (double)this.textField.method_46426() && mouseX < (double)(this.textField.method_46426() + this.textField.method_25368()) && mouseY >= (double)this.textField.method_46427() && mouseY < (double)(this.textField.method_46427() + this.textField.method_25364());
            if (isOverTextField) {
                this.textField.method_25365(true);
                return true;
            }
        }
        if (this.cancelButton != null) {
            boolean isOverCancel;
            boolean bl = isOverCancel = mouseX >= (double)this.cancelButton.method_46426() && mouseX < (double)(this.cancelButton.method_46426() + this.cancelButton.method_25368()) && mouseY >= (double)this.cancelButton.method_46427() && mouseY < (double)(this.cancelButton.method_46427() + this.cancelButton.method_25364());
            if (isOverCancel) {
                this.onCancel.run();
                return true;
            }
        }
        if (this.confirmButton != null) {
            boolean isOverConfirm;
            boolean bl = isOverConfirm = mouseX >= (double)this.confirmButton.method_46426() && mouseX < (double)(this.confirmButton.method_46426() + this.confirmButton.method_25368()) && mouseY >= (double)this.confirmButton.method_46427() && mouseY < (double)(this.confirmButton.method_46427() + this.confirmButton.method_25364());
            if (isOverConfirm) {
                this.handleConfirm();
                return true;
            }
        }
        return true;
    }

    public void method_25365(boolean focused) {
        if (this.textField != null) {
            this.textField.method_25365(focused);
        }
    }

    public boolean method_25370() {
        return this.textField != null && this.textField.method_25370();
    }
}

