/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui.widget;

import com.choculaterie.gui.widget.CustomButton;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class ImageViewerWidget {
    private final class_2960 imageTexture;
    private final int originalImageWidth;
    private final int originalImageHeight;
    private final Runnable onClose;
    private final class_310 client;
    private final int currentImageIndex;
    private final int totalImages;
    private final Runnable onPrevious;
    private final Runnable onNext;
    private int screenWidth;
    private int screenHeight;
    private CustomButton closeButton;
    private CustomButton prevButton;
    private CustomButton nextButton;
    private static final int CLOSE_BUTTON_SIZE = 20;
    private static final int CLOSE_BUTTON_MARGIN = 10;
    private static final int NAV_BUTTON_WIDTH = 25;
    private static final int NAV_BUTTON_HEIGHT = 16;
    private static final int NAV_BUTTON_SPACING = 10;
    private static final int OVERLAY_COLOR = -536870912;
    private static final int SUBTITLE_COLOR = -5592406;

    public ImageViewerWidget(class_310 client, class_2960 imageTexture, int originalImageWidth, int originalImageHeight, int currentImageIndex, int totalImages, Runnable onPrevious, Runnable onNext, Runnable onClose) {
        this.client = client;
        this.imageTexture = imageTexture;
        this.originalImageWidth = originalImageWidth;
        this.originalImageHeight = originalImageHeight;
        this.currentImageIndex = currentImageIndex;
        this.totalImages = totalImages;
        this.onPrevious = onPrevious;
        this.onNext = onNext;
        this.onClose = onClose;
        this.updateLayout(client.method_22683().method_4486(), client.method_22683().method_4502());
    }

    public void updateLayout(int screenWidth, int screenHeight) {
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        int closeX = screenWidth - 20 - 10;
        int closeY = 10;
        if (this.closeButton == null) {
            this.closeButton = new CustomButton(closeX, closeY, 20, 20, class_2561.method_30163((String)"\u00d7"), btn -> this.onClose.run());
            this.closeButton.setRenderAsXIcon(true);
        } else {
            this.closeButton.method_46421(closeX);
            this.closeButton.method_46419(closeY);
            this.closeButton.method_25358(20);
            this.closeButton.method_53533(20);
        }
        if (this.totalImages > 1) {
            String indicator = String.format("%d / %d", this.currentImageIndex + 1, this.totalImages);
            int indicatorWidth = this.client.field_1772.method_1727(indicator);
            int indicatorX = (screenWidth - indicatorWidth) / 2;
            int navY = screenHeight - 40;
            int prevX = indicatorX - 25 - 10;
            if (this.prevButton == null) {
                this.prevButton = new CustomButton(prevX, navY, 25, 16, class_2561.method_30163((String)"<"), btn -> this.onPrevious.run());
            } else {
                this.prevButton.method_46421(prevX);
                this.prevButton.method_46419(navY);
                this.prevButton.method_25358(25);
                this.prevButton.method_53533(16);
            }
            int nextX = indicatorX + indicatorWidth + 10;
            if (this.nextButton == null) {
                this.nextButton = new CustomButton(nextX, navY, 25, 16, class_2561.method_30163((String)">"), btn -> this.onNext.run());
            } else {
                this.nextButton.method_46421(nextX);
                this.nextButton.method_46419(navY);
                this.nextButton.method_25358(25);
                this.nextButton.method_53533(16);
            }
        }
    }

    private int[] getScaledImageDimensions() {
        int displayHeight;
        int displayWidth;
        if (this.originalImageWidth <= 0 || this.originalImageHeight <= 0) {
            return new int[]{this.screenWidth, this.screenHeight};
        }
        float imageAspect = (float)this.originalImageWidth / (float)this.originalImageHeight;
        int maxWidth = this.screenWidth - 40;
        int maxHeight = this.screenHeight - 40;
        float screenAspect = (float)maxWidth / (float)maxHeight;
        if (imageAspect > screenAspect) {
            displayWidth = Math.min(maxWidth, this.originalImageWidth);
            displayHeight = (int)((float)displayWidth / imageAspect);
        } else {
            displayHeight = Math.min(maxHeight, this.originalImageHeight);
            displayWidth = (int)((float)displayHeight * imageAspect);
        }
        return new int[]{displayWidth, displayHeight};
    }

    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25294(0, 0, this.screenWidth, this.screenHeight, -536870912);
        int[] dimensions = this.getScaledImageDimensions();
        int displayWidth = dimensions[0];
        int displayHeight = dimensions[1];
        int imageX = (this.screenWidth - displayWidth) / 2;
        int imageY = (this.screenHeight - displayHeight) / 2;
        if (this.imageTexture != null) {
            context.method_25290(class_10799.field_56883, this.imageTexture, imageX, imageY, 0.0f, 0.0f, displayWidth, displayHeight, displayWidth, displayHeight);
        }
        if (this.totalImages > 1) {
            String pageText = String.format("%d / %d", this.currentImageIndex + 1, this.totalImages);
            int textWidth = this.client.field_1772.method_1727(pageText);
            int textX = (this.screenWidth - textWidth) / 2;
            int textY = this.screenHeight - 40 + 4;
            int indicatorWidth = textWidth;
            int indicatorX = textX;
            int prevBtnX = indicatorX - 25 - 10;
            int nextBtnX = indicatorX + indicatorWidth + 10;
            int navY = this.screenHeight - 40;
            int bgX = prevBtnX;
            int bgWidth = nextBtnX + 25 - prevBtnX;
            int bgY = navY;
            int bgHeight = 16;
            context.method_25294(bgX, bgY, bgX + bgWidth, bgY + bgHeight, -805306368);
            context.method_25303(this.client.field_1772, pageText, textX, textY, -5592406);
            if (this.prevButton != null) {
                this.prevButton.method_25394(context, mouseX, mouseY, delta);
            }
            if (this.nextButton != null) {
                this.nextButton.method_25394(context, mouseX, mouseY, delta);
            }
        }
        if (this.closeButton != null) {
            this.closeButton.method_25394(context, mouseX, mouseY, delta);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return false;
        }
        if (this.closeButton != null) {
            boolean isOverClose;
            boolean bl = isOverClose = mouseX >= (double)this.closeButton.method_46426() && mouseX < (double)(this.closeButton.method_46426() + this.closeButton.method_25368()) && mouseY >= (double)this.closeButton.method_46427() && mouseY < (double)(this.closeButton.method_46427() + this.closeButton.method_25364());
            if (isOverClose) {
                this.onClose.run();
                return true;
            }
        }
        if (this.totalImages > 1) {
            if (this.prevButton != null) {
                boolean isOverPrev;
                boolean bl = isOverPrev = mouseX >= (double)this.prevButton.method_46426() && mouseX < (double)(this.prevButton.method_46426() + this.prevButton.method_25368()) && mouseY >= (double)this.prevButton.method_46427() && mouseY < (double)(this.prevButton.method_46427() + this.prevButton.method_25364());
                if (isOverPrev) {
                    this.onPrevious.run();
                    return true;
                }
            }
            if (this.nextButton != null) {
                boolean isOverNext;
                boolean bl = isOverNext = mouseX >= (double)this.nextButton.method_46426() && mouseX < (double)(this.nextButton.method_46426() + this.nextButton.method_25368()) && mouseY >= (double)this.nextButton.method_46427() && mouseY < (double)(this.nextButton.method_46427() + this.nextButton.method_25364());
                if (isOverNext) {
                    this.onNext.run();
                    return true;
                }
            }
        }
        this.onClose.run();
        return true;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.onClose.run();
            return true;
        }
        if (this.totalImages > 1) {
            if (keyCode == 263) {
                this.onPrevious.run();
                return true;
            }
            if (keyCode == 262) {
                this.onNext.run();
                return true;
            }
        }
        return false;
    }
}

